//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_SCOREBOARD_BASE_SV
`define MODEM_SCOREBOARD_BASE_SV

class modem_scoreboard_base extends uvm_scoreboard;

  `uvm_component_utils(modem_scoreboard_base)

  //--------------------------------------------------------------------
  // hande to wlan_config, regmodel, matlab
  //--------------------------------------------------------------------
  wlan_config            m_cfg;
  TOP_register_block     m_regmodel;
  mdm_data_model         m_modem_cfg;

  //--------------------------------------------------------------------
  // for register access
  //--------------------------------------------------------------------
  uvm_status_e           status;
  uvm_reg_data_t         rdata, wdata;

  //---------------------------------------------------------------------------
  // list of variables
  //---------------------------------------------------------------------------

  //---------------------------------------------------------------------------


  function new(string name = "modem_scoreboard_base", uvm_component parent = null);
    super.new(name, parent);

  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if (!uvm_config_db #(wlan_config)::get(null, "", "wlan_config", m_cfg))
      `uvm_fatal(get_type_name(), "WLAN configuration not set in configuration DB!!!")

    if (!uvm_config_db #(mdm_data_model)::get(null, "", "mdm_data_model", m_modem_cfg))
      `uvm_fatal(get_type_name(),"Unable to locate handle for Modem data model");

    if (!uvm_config_db #(TOP_register_block)::get(null, "", "TOP_register_block", m_regmodel))
      `uvm_fatal(get_type_name(), "WLAN configuration not set in configuration DB!!!")

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual task run_phase(uvm_phase phase);
    super.run_phase(phase);
  endtask : run_phase

  virtual function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

  //---------------------------------------------------------------------------
  // list of functions for checking
  //---------------------------------------------------------------------------
  extern function int get_mu_userpos(ref PPDU_frame ppdu);
  //---------------------------------------------------------------------------

endclass : modem_scoreboard_base

  //--------------------------------------------------------------------
  // Get User position for MU-MIMO
  //--------------------------------------------------------------------
  function int modem_scoreboard_base::get_mu_userpos(ref PPDU_frame ppdu);
    uvm_reg_data_t dec_group;
    uvm_reg_data_t staid;
    bit [1:0] userpos;

    if (ppdu.ppdu_format == VHT) begin
      if ( ppdu.preamble_header.group_id < 16) begin
        dec_group = m_regmodel.get_mirrored_reg_value("MUMIMO_USERPOSITION_TAB0");
        userpos = dec_group >> (2*ppdu.preamble_header.group_id);
      end
      else if ( ppdu.preamble_header.group_id < 32) begin
        dec_group = m_regmodel.get_mirrored_reg_value("MUMIMO_USERPOSITION_TAB1");
        userpos = dec_group >> (2*(ppdu.preamble_header.group_id - 'd16));
      end
      else if ( ppdu.preamble_header.group_id < 48) begin
        dec_group = m_regmodel.get_mirrored_reg_value("MUMIMO_USERPOSITION_TAB2");
        userpos = dec_group >> (2*(ppdu.preamble_header.group_id - 'd32));
      end
      else begin
        dec_group = m_regmodel.get_mirrored_reg_value("MUMIMO_USERPOSITION_TAB3");
        userpos = dec_group >> (2*(ppdu.preamble_header.group_id - 'd48));
      end
    end//if
    else if (ppdu.ppdu_format == HE_MU) begin
      staid = m_regmodel.get_mirrored_reg_value("HE_STAID_TAB0");
      foreach (ppdu.preamble_header.user_header_he[i]) begin
        if (staid == ppdu.preamble_header.user_header_he[i].staid_f)
          userpos = i;
      end//foreach
    end

    return userpos;
  endfunction : get_mu_userpos

`endif //MODEM_SCOREBOARD_BASE_SV
