//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 32733 $
// $Date: 2017-11-30 16:13:30 +0100 (Thu, 30 Nov 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_SCOREBOARD_SV
`define MODEM_STREAM_SCOREBOARD_SV

`uvm_analysis_imp_decl(_stream_mac_phy)

class modem_stream_scoreboard extends modem_scoreboard_base;

  `uvm_component_utils(modem_stream_scoreboard)

  uvm_analysis_imp_stream_mac_phy#(mac_phy_rx_stream_seq_item, modem_stream_scoreboard) mac_phy_export;

  // variables
  mac_phy_rx_stream_seq_item     rx_stream_q[$], rx_stream_item;
  bit [31:0]                     rx_vector_1[];
  bit [31:0]                     rx_payload[];
  format_mod_e                   formatmod;
  ppdu_frame_kind_e              kind;
  int                            err_cnt;
  bit [1:0]                      gi_type;
  bit [1:0]                      he_ltf_type;
  bit [2:0]                      nss;
  bit [3:0]                      nominal_packet_padding;
  int                            psdu_length;
  int                            stbc;
  bit                            fec_coding;

  function new(string name = "modem_stream_scoreboard", uvm_component parent = null);
    super.new(name, parent);

    mac_phy_export   = new("mac_phy_export", this);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    bit [31:0]   values[];

    super.run_phase(phase);

    forever begin
      // wait for data for comparing
      wait (rx_stream_q.size() != 0);
      rx_stream_item = rx_stream_q.pop_back();

      // get Matlab reference Rx stream data
      m_modem_cfg.get_rx_stream(rx_vector_1, rx_payload);
      // get frame format and kind
      formatmod = rx_stream_item.format_mod;
      kind      = m_modem_cfg.golden_frame.kind;
      // check in error is injected to prevent checking
      if (m_modem_cfg.sig_error_injection) continue;

      // If there is issue detected by Matlab in
      // decoding SIG fields, don't compare
      if (    m_modem_cfg.vhtsigbErrorcode == -1
          ||  m_modem_cfg.lsigErrorcode == -1
          ||  m_modem_cfg.hesigaErrorcode == -1
          ||  m_modem_cfg.hesigbErrorcode == -1
          ||  m_modem_cfg.htsigErrorcode == -1) continue;

      // If the decoding from Matlab is wrong, skip comparison
      m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
      if (signed'(values[0]) == -1) continue;

      // check RxVector1
      case (formatmod)
//-----------------------------------------------------------------------------
        NON_HT,NON_HT_DUP_OFDM: begin
//-----------------------------------------------------------------------------

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.nonht_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.nonht_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.nonht_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.nonht_rxv.common_part.ch_bw, values[0] ))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.nonht_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.nonht_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.nonht_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.nonht_rxv.common_part.leg_rate, values[0]))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          if (rx_stream_item.nonht_rxv.common_part.leg_rate > 3)
          begin
            if (rx_stream_item.nonht_rxv.common_part.preamble_type != 0)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.nonht_rxv.common_part.preamble_type, values[0]))

            m_modem_cfg.get_block_field_value(values,"RXVECTOR","DynorStaticBW");
            if (rx_stream_item.nonht_rxv.dyn_bw_in_non_ht != values[0])
              `uvm_error(get_type_name(),$sformatf("RXVECTOR: Dynamic BW in NON-HT mismatch! rcvd(%0h)/exp(%0h)",
              rx_stream_item.nonht_rxv.dyn_bw_in_non_ht, values[0]))

            //m_modem_cfg.get_block_field_value(values,"RXVECTOR","LSIGVALID");
            //if (rx_stream_item.nonht_rxv.l_sig_valid != values[0])
            //  `uvm_error(get_type_name(),$sformatf("RXVECTOR: LSIG valid mismatch! rcvd(%0h)/exp(%0h)",
            //  rx_stream_item.nonht_rxv.l_sig_valid, values[0]))
          end
          else
          begin
            m_modem_cfg.get_block_field_value(values,"RXVECTOR","PREAMBLE_TYPE");
            if (rx_stream_item.nonht_rxv.common_part.preamble_type != values[0])
              `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
              rx_stream_item.nonht_rxv.common_part.preamble_type, values[0]))
          end
        end

//-----------------------------------------------------------------------------
        HT_MF,HT_GF: begin
//-----------------------------------------------------------------------------
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.ht_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.ht_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.common_part.ch_bw, values[0]))

          if (rx_stream_item.ht_rxv.common_part.preamble_type != 0)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.common_part.preamble_type, 0))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          if (rx_stream_item.ht_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.ht_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.common_part.leg_rate, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SOUNDING");
          if (rx_stream_item.ht_rxv.sounding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Sounding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.sounding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SMOOTHING");
          if (rx_stream_item.ht_rxv.smoothing != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Smoothing mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.smoothing, values[0]))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          // Matlab returns GI in us (0.4 or 0.8).
          // RTL returns 0 for GI = 0.4 and 0 for GI = 0.8
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
          case (values[0])
            32'd400   : gi_type = 1;
            32'd800   : gi_type = 0;
          endcase

          if (rx_stream_item.ht_rxv.gi_type != gi_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: GI type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.gi_type, gi_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","AGGREGATION");
          if (rx_stream_item.ht_rxv.aggregation != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Aggregation mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.aggregation, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","STBC");
          if (rx_stream_item.ht_rxv.stbc != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: STBC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.stbc, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","numExtnSS");
          if (rx_stream_item.ht_rxv.num_ext_ss != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Ness mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.num_ext_ss, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","LSIGVALID");
          if (rx_stream_item.ht_rxv.l_sig_valid != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: LSIG valid mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.l_sig_valid, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS");
          if (rx_stream_item.ht_rxv.mcs != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.mcs, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
          if (rx_stream_item.ht_rxv.fec_coding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: FEC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.fec_coding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.ht_rxv.ht_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HT length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.ht_rxv.ht_length, values[0]))

        end
//-----------------------------------------------------------------------------
        VHT: begin
//-----------------------------------------------------------------------------
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.vht_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.vht_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.common_part.ch_bw, values[0]))

          if (rx_stream_item.vht_rxv.common_part.preamble_type != 0)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.common_part.preamble_type, 0))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          if (rx_stream_item.vht_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.vht_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.common_part.leg_rate, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SOUNDING");
          if (rx_stream_item.vht_rxv.sounding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Sounding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.sounding, values[0]))

//           m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAMFORMED");
//           if (rx_stream_item.vht_rxv.beamformed != values[0])
//             `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beamformed mismatch! rcvd(%0h)/exp(%0h)",
//             rx_stream_item.vht_rxv.beamformed, values[0]))

          // Matlab returns GI in us (0.4 or 0.8).
          // RTL returns 0 for GI = 0.4 and 0 for GI = 0.8

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
           case (values[0])
            32'd400   : gi_type = 1;
            32'd800   : gi_type = 0;
          endcase
          if (rx_stream_item.vht_rxv.gi_type != gi_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: GI type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.gi_type, gi_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","STBC");
          stbc = values[0];
          if (rx_stream_item.vht_rxv.stbc != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: STBC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.stbc, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","PARTIAL_AID");
          if (rx_stream_item.vht_rxv.partial_aid != values[0] && kind != MU_MIMO)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Partial AID mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.partial_aid, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GROUP_ID");
          if (rx_stream_item.vht_rxv.group_id != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Group ID mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.group_id, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS");
          if (rx_stream_item.vht_rxv.mcs != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.mcs, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","NUM_STS");
          // NSS = NSTS/2 if STBC
          nss = values[0]/(2**stbc)-1;
          if (rx_stream_item.vht_rxv.nss != nss)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: NSS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.nss, nss))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
          if (rx_stream_item.vht_rxv.fec_coding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: FEC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.fec_coding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","PSDU_LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.vht_rxv.ht_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HT length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.vht_rxv.ht_length, values[0]))

        end
//-----------------------------------------------------------------------------
        HE_SU,HE_EXT_SU: begin
//-----------------------------------------------------------------------------
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.he_su_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.he_su_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_part.ch_bw, values[0]))

          if (rx_stream_item.he_su_rxv.common_part.preamble_type != 0)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_part.preamble_type, 0))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          if (rx_stream_item.he_su_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.he_su_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_part.leg_rate, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SOUNDING");
          if (rx_stream_item.he_su_rxv.common_he_part.sounding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Sounding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.sounding, values[0]))

//           m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAMFORMED");
//           if (rx_stream_item.he_su_rxv.common_he_part.beamformed != values[0])
//             `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beamformed mismatch! rcvd(%0h)/exp(%0h)",
//             rx_stream_item.he_su_rxv.common_he_part.beamformed, values[0]))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          // Matlab returns GI in us (0.4 or 0.8).
          // RTL returns 0 for GI = 0.4 and 0 for GI = 0.8
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
          case(values[0])
            32'd800   : gi_type = 0;
            32'd1600  : gi_type = 1;
            32'd3200  : gi_type = 2;
          endcase

          if (rx_stream_item.he_su_rxv.common_he_part.gi_type != gi_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: GI type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.gi_type, gi_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","STBC");
          stbc = values[0];
          if (rx_stream_item.he_su_rxv.common_he_part.stbc != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: STBC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.stbc, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","UPLINK_FLAG");
          if (rx_stream_item.he_su_rxv.common_he_part.uplink_flag != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Uplink flag mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.uplink_flag, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAM_CHANGE");
          if (rx_stream_item.he_su_rxv.common_he_part.beam_change != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beam change mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.beam_change, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DCM");
          if (rx_stream_item.he_su_rxv.common_he_part.dcm != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: DCM mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.dcm, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","HE_LTF_TYPE");
          he_ltf_type = (values[0] == 1) ? 0 : (values[0]/2);
          if (rx_stream_item.he_su_rxv.common_he_part.he_ltf_type != he_ltf_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE LTF type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.he_ltf_type, he_ltf_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DOPPLER");
          if (rx_stream_item.he_su_rxv.common_he_part.doppler != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Doppler mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.doppler, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BSS_COLOR");
          if (rx_stream_item.he_su_rxv.common_he_part.bss_color != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: BSS color mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.bss_color, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","TXOP_DURATION");
          if (rx_stream_item.he_su_rxv.common_he_part.txop_duration != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: TXOP mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.common_he_part.txop_duration, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXPARAMETERS","TPE");
          nominal_packet_padding = values[0]/4;
          if (rx_stream_item.he_su_rxv.pe_duration != nominal_packet_padding)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: PE DURATION mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.pe_duration, nominal_packet_padding))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SPATIAL_REUSE");
          if (rx_stream_item.he_su_rxv.spatial_reuse != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Spatial reuse mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.spatial_reuse, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS");
          if (rx_stream_item.he_su_rxv.mcs!= values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.mcs, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","NUM_STS");
          // NSS = NSTS/2 if STBC
          nss = values[0]/(2**stbc)-1;
          if (rx_stream_item.he_su_rxv.nss != nss)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: NSS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.nss, nss))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
          if (rx_stream_item.he_su_rxv.fec_coding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: FEC coding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.fec_coding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","PSDU_LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.he_su_rxv.he_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_su_rxv.he_length, values[0]))

        end
//-----------------------------------------------------------------------------
        HE_MU: begin
//-----------------------------------------------------------------------------
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.he_mu_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.he_mu_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.ch_bw, values[0]))

          if (rx_stream_item.he_mu_rxv.common_part.preamble_type != 0)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Preamble type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.preamble_type, 0))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          if (rx_stream_item.he_mu_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.he_mu_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.leg_rate, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SOUNDING");
          if (rx_stream_item.he_mu_rxv.common_he_part.sounding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Sounding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.sounding, values[0]))

//           m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAMFORMED");
//           if (rx_stream_item.he_mu_rxv.common_he_part.beamformed != values[0])
//             `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beamformed mismatch! rcvd(%0h)/exp(%0h)",
//             rx_stream_item.he_mu_rxv.common_he_part.beamformed, values[0]))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          // Matlab returns GI in us (0.4 or 0.8).
          // RTL returns 0 for GI = 0.4 and 0 for GI = 0.8
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
          case(values[0])
            32'd800   : gi_type = 0;
            32'd1600  : gi_type = 1;
            32'd3200  : gi_type = 2;
          endcase
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
          if (rx_stream_item.he_mu_rxv.common_he_part.gi_type != gi_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: GI type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.gi_type, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","STBC");
          stbc = values[0];
          if (rx_stream_item.he_mu_rxv.common_he_part.stbc != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: STBC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.stbc, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","UPLINK_FLAG");
          if (rx_stream_item.he_mu_rxv.common_he_part.uplink_flag != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Uplink flag mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.uplink_flag, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAM_CHANGE");
          if (rx_stream_item.he_mu_rxv.common_he_part.beam_change != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beam change mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.beam_change, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DCM");
          if (rx_stream_item.he_mu_rxv.common_he_part.dcm != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: DCM mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.dcm, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","HE_LTF_TYPE");
          he_ltf_type = (values[0] == 1) ? 0 : (values[0]/2);
          if (rx_stream_item.he_mu_rxv.common_he_part.he_ltf_type != he_ltf_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE LTF type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.he_ltf_type, he_ltf_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DOPPLER");
          if (rx_stream_item.he_mu_rxv.common_he_part.doppler != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Doppler mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.doppler, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BSS_COLOR");
          if (rx_stream_item.he_mu_rxv.common_he_part.bss_color != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: BSS color mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.bss_color, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","TXOP_DURATION");
          if (rx_stream_item.he_mu_rxv.common_he_part.txop_duration != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: TXOP mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_he_part.txop_duration, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXPARAMETERS","TPE");
          nominal_packet_padding = values[0]/4;
          if (rx_stream_item.he_mu_rxv.pe_duration != nominal_packet_padding)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: PE DURATION mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.pe_duration, nominal_packet_padding))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SPATIAL_REUSE");
          if (rx_stream_item.he_mu_rxv.spatial_reuse != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Spatial reuse mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.spatial_reuse, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXPARAMETERS","sigb_compression");
          if (rx_stream_item.he_mu_rxv.sig_b_comp_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: SIGB compressed mode mismatch! rcvd(%0h)/exp(%0h)",
             rx_stream_item.he_mu_rxv.sig_b_comp_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DCM_SIG_B");
          if (rx_stream_item.he_mu_rxv.dcm_sig_b != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: DCM SIGB mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.dcm_sig_b, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS_SIG_B");
          if (rx_stream_item.he_mu_rxv.mcs_sig_b != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS SIGB mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.mcs_sig_b, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS");
          if (rx_stream_item.he_mu_rxv.mcs != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.mcs, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","NUM_STS");
          // NSS = NSTS/2 if STBC
          nss = values[0]/(2**stbc)-1;
          if (rx_stream_item.he_mu_rxv.nss != nss)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: NSS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.nss, nss))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
          if (rx_stream_item.he_mu_rxv.fec_coding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: FEC coding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.fec_coding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","PSDU_LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.he_mu_rxv.he_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.he_length, values[0]))

        end
//-----------------------------------------------------------------------------
        HE_TB: begin
//-----------------------------------------------------------------------------
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FORMAT");
          if (rx_stream_item.he_tb_ap_rxv.common_part.format_mode != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Format mode mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_part.format_mode, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","CH_BANDWIDTH");
          if (rx_stream_item.he_tb_ap_rxv.common_part.ch_bw != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Channel bandwidh mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_part.ch_bw, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_LENGTH");
          if (rx_stream_item.he_tb_ap_rxv.common_part.leg_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_part.leg_length, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","L_DATARATE");
          if (rx_stream_item.he_tb_ap_rxv.common_part.leg_rate != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Legacy rate mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_part.leg_rate, values[0]))

          // TODO: Uncomment when Matlab supports RSSI
          /*m_modem_cfg.get_block_field_value(values,"RXVECTOR","RSSI");
          if (rx_stream_item.he_mu_rxv.common_part.rssi != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: RSSI mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_mu_rxv.common_part.rssi, values[0]))*/

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","SOUNDING");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.sounding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Sounding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.sounding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAMFORMED");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.beamformed != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beamformed mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.beamformed, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","GI_TYPE");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.gi_type != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: GI type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.gi_type, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","STBC");
          stbc = values[0];
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.stbc != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: STBC mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.stbc, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","UPLINK_FLAG");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.uplink_flag != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Uplink flag mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.uplink_flag, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BEAM_CHANGE");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.beam_change != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Beam change mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.beam_change, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DCM");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.dcm != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: DCM mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.dcm, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","HE_LTF_TYPE");
          he_ltf_type =  (values[0] == 1) ? 0 : (values[0]/2);
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.he_ltf_type != he_ltf_type)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE LTF type mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.he_ltf_type, he_ltf_type))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","DOPPLER");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.doppler != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Doppler mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.doppler, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","BSS_COLOR");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.bss_color != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: BSS color mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.bss_color, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","TXOP_DURATION");
          if (rx_stream_item.he_tb_ap_rxv.common_he_part.txop_duration != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: TXOP mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.common_he_part.txop_duration, values[0]))

          // This is only applicable if HE-TB is defined as STA
         /* m_modem_cfg.get_block_field_value(values,"RXVECTOR","SPATIAL_REUSE");
          if (rx_stream_item.he_tb_ap_rxv.spatial_reuse != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: Spatial reuse mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.spatial_reuse, values[0]))*/

          //NOTE: should be per user, but N_USER param is not available from matlab
          m_modem_cfg.get_block_field_value(values,"RXVECTOR","MCS");
          if (rx_stream_item.he_tb_ap_rxv.user1.mcs != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: MCS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.user1.mcs, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","NUM_STS");
          // NSS = NSTS/2 if STBC
          nss = values[0]/(2**stbc)-1;
          if (rx_stream_item.he_tb_ap_rxv.user1.nss != nss)
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: NSS mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.user1.nss, nss))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
          if (rx_stream_item.he_tb_ap_rxv.user1.fec_coding != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: FEC coding mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.user1.fec_coding, values[0]))

          m_modem_cfg.get_block_field_value(values,"RXVECTOR","LENGTH");
          psdu_length = values[0];
          if (rx_stream_item.he_tb_ap_rxv.user1.he_length != values[0])
            `uvm_error(get_type_name(),$sformatf("RXVECTOR: HE length mismatch! rcvd(%0h)/exp(%0h)",
            rx_stream_item.he_tb_ap_rxv.user1.he_length, values[0]))

        end
      endcase

      `uvm_info(get_type_name(),$sformatf("Checking of RxVector1 OK! "),UVM_LOW)


      // check payload
      m_modem_cfg.get_block_field_value(values,"RXVECTOR","FEC_CODING");
      fec_coding = values[0];
      if (   kind != NDP
          && (   m_modem_cfg.fcsOK == 1
              || (m_cfg.m_radio_cfg.m_rui_cfg.agcBypass == 1 && m_modem_cfg.fcsOK == 0 && fec_coding == 0)
             )
         ) begin

        err_cnt = 0;
        if (psdu_length == 0)
          `uvm_error(get_type_name(),$sformatf("The PSDU length is 0, but not NDP frame!!!!!"))
        for (int i = 0; i < psdu_length; i++) begin
          if (rx_payload[i] != rx_stream_item.rx_stream[i]) begin
            err_cnt++;
            `uvm_error(get_type_name(),
            $sformatf("Payload mismatch[%0d] matlab (%0h) MPIF (%0h)",i,rx_payload[i],rx_stream_item.rx_stream[i]))
          end
          else begin
            `uvm_info(get_type_name(),
            $sformatf("Payload check ok[%0d] matlab (%0h) MPIF (%0h)",i,rx_payload[i],rx_stream_item.rx_stream[i]), UVM_DEBUG)
          end
        end//for
        if (err_cnt == 0)
          `uvm_info(get_type_name(),$sformatf("Checking of Rx Payload OK! "),UVM_LOW)
      end
      else begin
        `uvm_info(get_type_name() ,$sformatf("Frame payload not checked, %s",(kind==NDP)?"NDP frame":"no valid frames"), UVM_LOW)
      end

    end//forever
  endtask : run_phase

  virtual function void write_stream_mac_phy(mac_phy_rx_stream_seq_item i);

    mac_phy_rx_stream_seq_item it;
    it = new();
    it.copy(i);

    rx_stream_q.push_front(it);
    `uvm_info(get_type_name(), $sformatf("Received Rx stream item :\n%s", it.sprint()), UVM_HIGH)
  endfunction : write_stream_mac_phy

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : modem_stream_scoreboard

`endif //MODEM_BF_SCOREBOARD_SV
