//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef _PLATFORM_IRQ_SCOREBOARD_SV_
`define _PLATFORM_IRQ_SCOREBOARD_SV_

`uvm_analysis_imp_decl(_platf_irq_in)
`uvm_analysis_imp_decl(_platf_irq_out)

typedef struct {
  bit[63:0]  irq_masks;
  bit[63:0]  irq_stat;
  bit[63:0]  polarity;
  bit        irq;
} prev_irq_stat_s;

class platform_irq_scoreboard extends mac_scoreboard_base;

  `uvm_component_utils(platform_irq_scoreboard)

  uvm_analysis_imp_platf_irq_in  #(irq_raw_seq_item #(`PLATFORM_IN_IRQ_WIDTH), platform_irq_scoreboard)   platf_irq_in_export;
  uvm_analysis_imp_platf_irq_out #(irq_raw_seq_item #(`PLATFORM_OUT_IRQ_WIDTH), platform_irq_scoreboard)   platf_irq_out_export;

  uvm_tlm_fifo #(irq_raw_seq_item #(`PLATFORM_IN_IRQ_WIDTH)) irq_in_fifo;
  uvm_tlm_fifo #(irq_raw_seq_item #(`PLATFORM_OUT_IRQ_WIDTH)) irq_out_fifo;

  // Platform IRQ ctrl. registers
  bit[63:0] raw_irqs;                   // Individual interrupt statuses
  bit       irq_out_n = 1'b1;           // IRQ output is ACTIVE low
  bit       irq_out_n_predicted = 1'b1; // IRQ output (without output register)



prev_irq_stat_s prev_irq_stat_q[$]; // Only one location is used for the moment
prev_irq_stat_s prev_irq_stat_on_input_change_q[$];

  // Save status of interrupt controller on the change of input interrupt requests
  virtual function void save_irq_stat_on_int_in_change();
   prev_irq_stat_s prev_irq_stat_tmp;
   bit[31:0]  irq_unmask_clear1, irq_unmask_clear0;
   bit        irq_fl;

   irq_unmask_clear1 = m_regmodel.INTC.IRQ_UNMASK_CLEAR1_reg.IRQ_UNMASK_CLEAR1.get_mirrored_value();
   irq_unmask_clear0 = m_regmodel.INTC.IRQ_UNMASK_CLEAR0_reg.IRQ_UNMASK_CLEAR0.get_mirrored_value();

   // Check that IRQ can oocure
   irq_fl = |(raw_irqs & { irq_unmask_clear1[31:0], irq_unmask_clear0[31:0]});

   if(irq_fl != (!irq_out_n_predicted /*irq_out_n*/)) begin
   // Yes, current state of register(s) will provoke !!!CHANGE!!! of IRQ output
    prev_irq_stat_tmp.irq_masks = { irq_unmask_clear1[31:0], irq_unmask_clear0[31:0]};
    prev_irq_stat_tmp.irq_stat  = raw_irqs[63:0];
    prev_irq_stat_tmp.polarity ={ 32'b0, 32'b0 };
    prev_irq_stat_tmp.irq = irq_fl; // Predicted state  (Not inverted)
    prev_irq_stat_on_input_change_q.push_back(prev_irq_stat_tmp);
    `uvm_info(get_type_name(), $sformatf("Saving IRQ status on input change... Predicted irq_n value is %b.", ~irq_fl), UVM_HIGH)
    irq_out_n_predicted = ~irq_fl; // Update IRQ output status
   end
  endfunction : save_irq_stat_on_int_in_change


  // Save status of interrupt controller on AHB transfer
  //
  virtual function void save_irq_stat_on_ahb_tr();
   prev_irq_stat_s prev_irq_stat_tmp;
   bit[31:0]  irq_unmask_clear1, irq_unmask_clear0;
   bit        irq_fl;

   // Save IRQ MASK registers (AFTER update)
   irq_unmask_clear1 = m_regmodel.INTC.IRQ_UNMASK_CLEAR1_reg.IRQ_UNMASK_CLEAR1.get_mirrored_value();
   irq_unmask_clear0 = m_regmodel.INTC.IRQ_UNMASK_CLEAR0_reg.IRQ_UNMASK_CLEAR0.get_mirrored_value();

   // Check that IRQ can oocure
   irq_fl = |(raw_irqs & { irq_unmask_clear1[31:0], irq_unmask_clear0[31:0]});

   if(irq_fl != (!irq_out_n_predicted /*irq_out_n*/)) begin // irq_out_n is active low
   // Yes, current state of register(s) will provoke !!!CHANGE!!! of IRQ output
    prev_irq_stat_tmp.irq_masks = { irq_unmask_clear1[31:0], irq_unmask_clear0[31:0]};
    prev_irq_stat_tmp.irq_stat  = raw_irqs[63:0];
    prev_irq_stat_tmp.polarity ={ 32'b0, 32'b0 };
    prev_irq_stat_tmp.irq = irq_fl; // Predicted state (Not inverted)
    prev_irq_stat_q.push_back(prev_irq_stat_tmp);
    `uvm_info(get_type_name(), $sformatf("Saving IRQ status after AHB transfer... Predicted irq_n value is %b.", ~irq_fl), UVM_HIGH)
    irq_out_n_predicted = ~irq_fl; // Update IRQ output status
   end
  endfunction : save_irq_stat_on_ahb_tr

  virtual function void compare_irq_stat(irq_raw_seq_item #(`PLATFORM_OUT_IRQ_WIDTH) i);
   prev_irq_stat_s prev_irq_stat_tmp;

   if(prev_irq_stat_q.size() && prev_irq_stat_on_input_change_q.size()) begin
   `uvm_error(get_type_name(), "Suspicious Interrupt Controller State. Comparison is skipped!!!....")
    return;
   end // if(prev_irq_stat_q.size() && prev_irq_stat_on_input_change_q.size())

   if(prev_irq_stat_q.size()) begin
   `uvm_info(get_type_name(), "Transition of the output pin due to the changes of control registers...", UVM_HIGH)
    prev_irq_stat_tmp = prev_irq_stat_q.pop_front(); // Get the "previous" state
     if(prev_irq_stat_tmp.irq == !i.irq_sig[0]) begin  // Compare with "new" (updated state)
      `uvm_info(get_type_name(), $sformatf("PLATFORM IRQ comparison PASSED. Next IRQ output value is %b", !prev_irq_stat_tmp.irq), UVM_HIGH)
     end
     else begin
     `uvm_error(get_type_name(), $sformatf("PLATFORM IRQ comparison FAILED. Predicted value is %b.", !prev_irq_stat_tmp.irq))
     end
    return;
   end

   if(prev_irq_stat_on_input_change_q.size()) begin
    `uvm_info(get_type_name(), "Transition of the output pin due to the changes of interrupt inputs...", UVM_HIGH)
    prev_irq_stat_tmp = prev_irq_stat_on_input_change_q.pop_front(); // Get the "previous" state
     if(prev_irq_stat_tmp.irq == !i.irq_sig[0]) begin
      `uvm_info(get_type_name(), $sformatf("PLATFORM IRQ comparison PASSED. Next IRQ output value is %b", !prev_irq_stat_tmp.irq), UVM_HIGH)
     end
     else begin
     `uvm_error(get_type_name(), $sformatf("PLATFORM IRQ comparison FAILED. Predicted value is %b.", !prev_irq_stat_tmp.irq))
     end
    return;
   end

    prev_irq_stat_tmp = prev_irq_stat_q.pop_front(); // Get the previous state
    `uvm_error(get_type_name(), "Unexpected transition of interrupt request pin ....")

  endfunction : compare_irq_stat



  function new(string name = "platform_irq_scoreboard", uvm_component parent = null);
    super.new(name, parent);

    platf_irq_in_export   = new("platf_irq_in_export", this);
    platf_irq_out_export  = new("platf_irq_out_export", this);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
     mask_polar_regs_mon();

    join_none;
  endtask : run_phase

  virtual function void write_platf_irq_in(irq_raw_seq_item #(`PLATFORM_IN_IRQ_WIDTH) i);
   `uvm_info(get_type_name(), $sformatf("PLATFORM IRQ IN transaction is detected %b", i.irq_sig), UVM_HIGH)
   raw_irqs = i.irq_sig; // new state of RAW IRQ statuses
   save_irq_stat_on_int_in_change(); // Store previous state and precalculate ...
  endfunction : write_platf_irq_in

  virtual function void write_platf_irq_out(irq_raw_seq_item #(`PLATFORM_OUT_IRQ_WIDTH) i);
   `uvm_info(get_type_name(), $sformatf("PLATFORM IRQ OUT transaction is detected %b", i.irq_sig), UVM_HIGH)
     // Do comparison () -> It is assumed that change of Interrupt output always occures AFTER the corresponded events on interrupt inputs/AHB bus
     compare_irq_stat(i);
     // Update the state of the output interrupt request (!!! active low !!!)
     irq_out_n = i.irq_sig[0]; // !!!!!
  endfunction : write_platf_irq_out

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

  virtual function bit recalc_masked_irqs(irq_raw_seq_item #(`PLATFORM_IN_IRQ_WIDTH) i);
   bit[63:0] mask;
   mask[31:0]  = m_regmodel.INTC.IRQ_UNMASK_CLEAR0_reg.IRQ_UNMASK_CLEAR0.get_mirrored_value();
   mask[63:32] = m_regmodel.INTC.IRQ_UNMASK_CLEAR1_reg.IRQ_UNMASK_CLEAR1.get_mirrored_value();
   return (|(i.irq_sig & mask));
  endfunction : recalc_masked_irqs

 virtual task mask_polar_regs_mon();
  @(m_regmodel.INTC.IRQ_UNMASK_CLEAR0_reg.IRQ_UNMASK_CLEAR0.get_mirrored_value(),
    m_regmodel.INTC.IRQ_UNMASK_CLEAR1_reg.IRQ_UNMASK_CLEAR1.get_mirrored_value()); // Wait for register update
  save_irq_stat_on_ahb_tr();
 endtask : mask_polar_regs_mon

endclass : platform_irq_scoreboard

`endif // _PLATFORM_IRQ_SCOREBOARD_SV_
