//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_COMMON_SV
`define WLAN_COMMON_SV

`ifdef RW_NX_CHBW20
  `define NUM_OF_SKIPPED_DSSS_SAMPLES 200
`elsif RW_NX_CHBW4020
  `define NUM_OF_SKIPPED_DSSS_SAMPLES 300
`elsif RW_NX_CHBW804020
  `define NUM_OF_SKIPPED_DSSS_SAMPLES 300
`endif

  // time to wait for reponse from MAC core
  `define RX_EVENT_TIMER              17.0us
  // timeout for waiting sometnig to happen on MAC-PHY interface
  // during reception
  `define RX_MODEM_TIMEOUT            1.0ms
  // Window size for the SSN calculation in the block acknowledgement
  `define WINDOWSIZE                  64
  // Max delay between tbProtTrigger and txTBNewHead
  // For the time being it's 2us
  `define MAX_TB_RESP_DELAY           2

  // typedef for the Bitmap update
  typedef struct packed {
    bit [63:0]  bitmap;
    bit [11:0]  SSN;
    int         ksr_index;
    bit [3:0]   TID;
  } bitmap_param_s;

  typedef enum int{
    RANDOM_RX_ERROR      = 0,
    CONSECUTIVE_RX_ERROR = 1,
    CORRECT_INCORRECT    = 2
  } rx_error_type_e;

  //---------------------------------------------------------------------------
  // for mac Rx/Tx scoreboard, register field description
  //---------------------------------------------------------------------------

  typedef struct packed {
    bit        en_duplicate_detection_f;
    bit        accept_unknown_type_f;
    bit        accept_other_data_frames_f;
    bit        accept_qos_null_f;
    bit        accept_qcf_wo_data_f;
    bit        accept_qdata_f;
    bit        accept_cf_wo_data_f;
    bit        accept_data_f;
    bit        accept_other_ctrl_frames_f;
    bit        accept_cf_end_f;
    bit        accept_ack_f;
    bit        accept_cts_f;
    bit        accept_rts_f;
    bit        accept_ps_poll_f;
    bit        accept_ba_f;
    bit        accept_bar_f;
    bit        accept_other_mngm_frames_f;
    bit        accept_bfmee_frames_f;
    bit        accept_all_beacon_f;
    bit        accept_not_expected_ba_f;
    bit        accept_decrypt_err_frames_f;
    bit        accept_beacon_f;
    bit        accept_probe_resp_f;
    bit        accept_probe_req_f;
    bit        accept_my_unicast_f;
    bit        accept_unicast_f;
    bit        accept_error_frames_f;
    bit        accept_other_bssid_f;
    bit        accept_broadcast_f;
    bit        accept_multicast_f;
    bit        dont_decrypt_f;
    bit        exc_unencrypted_f;     // bit 0
  } rx_ctrl_reg_s;

  typedef struct packed {
    bit [4:0]  reserved3_f;
    bit        rx_rifs_en_f;
    bit        tsf_mgt_disable_f;
    bit        tsf_update_by_sw_f;
    bit [6:0]  reserved2_f;
    bit [2:0]  abgn_mode_f;
    bit        kay_sto_ram_rst_f;
    bit        mib_table_rst_f;
    bit        rate_controlled_mpif_f;
    bit        disable_bar_resp_f;
    bit        disable_cts_resp_f;
    bit        disable_ack_resp_f;
    bit        active_clk_gating_f;
    bit [2:0]  reserved1_f;
    bit        cfp_aware_f;
    bit        pwr_mgt_f;
    bit        ap_f;
    bit        bss_type_f;  // bit 0
  } mac_ctrl_1_reg_s;

  typedef struct packed {
    bit [3:0]  reserved_f;
    bit [9:0]  tx_chain_delay_in_mac_clk_f;
    bit [9:0]  tx_rf_delay_in_mac_clk_f;
    bit [7:0]  mac_core_clk_freq_f;  // bit 0-7
  } timings_1_s;

  typedef struct packed {
    bit [3:0]  reserved_f;
    bit [15:0] txop_limit_f;
    bit [3:0]  cw_max_f;
    bit [3:0]  cw_min_f;
    bit [3:0]  aifsn_f;  // bit 0-3
  } edca_ac_reg_s;

  typedef struct packed {
    bit [3:0]  reserved2_f;
    bit [2:0]  format_mod_f;
    bit        short_gi_f;
    bit [7:0]  mcs_f;
    bit [4:0]  reserved1_f;
    bit [2:0]  nc_f;
    bit [2:0]  nr_f;
    bit [1:0]  grouping_f;
    bit        codebook_f;
    bit        mu_support_f;
    bit        en_f;
  } bfmee_ctrl_reg_s;

  typedef struct packed {
    bit       disableRxBuffer2_f;
    bit       dataMHStoredwithPld_f;
    bit       mgtMHStoredwithPld_f;
    bit       ctrlMHStoredwithPld_f;
    bit [7:0] partialUnwrapSize_f;
    bit [1:0] reserved_f;
    bit [1:0] dataFrmWrapMode_f;
    bit [1:0] mgtFrmWrapMode_f;
    bit [1:0] ctrlFrmWrapMode_f;
  } rxcntrl2_reg_s;

//************************************************************************
//  FUNCTIONS
//************************************************************************

  //----------------------------------------------------------------------
  // function for calculating duration on air of PPDU frame
  //----------------------------------------------------------------------
  function bit [15:0] get_ppdu_duration(PPDU_frame frm, bit band5G = 0);
    bit [15:0] res;
    int        user;
    int        nsts_total;
    bit [2:0]  nss;
    bit [6:0]  mcs;
    HESIGB_s   HESIGB;

    if (frm.preamble_header.format_mod inside {HE_SU, HE_EXT_SU}) begin
      res = ComputeTimeOnAirAX ( .length_i          (frm.preamble_header.user_header_he[0].he_length_f),
                                 .preType_i         (frm.preamble_header.format_mod),
                                 .mcsIndex_i        (frm.preamble_header.user_header_he[0].mcs_f),
                                 .giType_i          (frm.preamble_header.gi_type),
                                 .ruType_i          (get_ru_type_he_su(frm.preamble_header.ch_bw)),
                                 .heLtfType_i       (frm.preamble_header.he_ltf_type),
                                 .numHeLtf_i        (frm.preamble_header.num_he_ltf),
                                 .dcm_i             (frm.preamble_header.dcm),
                                 .packetExtension_i (frm.preamble_header.user_header_he[0].pkt_ext_f),
                                 .heTbLength_i      (0),
                                 .triggerMethod_i   (0),
                                 .doppler_i         (frm.preamble_header.doppler),
                                 .mma_i             (frm.preamble_header.midamble_periodicity),
                                 .stbc_i            (frm.preamble_header.stbc),
                                 .woPreamble_i      (0),
                                 .heSigB_i          (HESIGB),
                                 .debug_i           (0)
                               );
    end
    else if (frm.preamble_header.format_mod == HE_MU) begin
      // store HESIGB struture fields
      HESIGB.mcs             = frm.preamble_header.mcs_sig_b;
      HESIGB.dcm             = frm.preamble_header.dcm_sig_b;
      HESIGB.compressed_mode = frm.preamble_header.sig_b_comp_mode;
      HESIGB.ru_allocation   = frm.preamble_header.ru_allocation;

      res = ComputeTimeOnAirAX ( .length_i          (frm.preamble_header.user_header_he[0].he_length_f),
                                 .preType_i         (frm.preamble_header.format_mod),
                                 .mcsIndex_i        (frm.preamble_header.user_header_he[0].mcs_f),
                                 .giType_i          (frm.preamble_header.gi_type),
                                 .ruType_i          (get_ru_type_from_ru_allocation(frm.preamble_header.ru_allocation,
                                                                                    frm.preamble_header.user_header_he[user].dut_location_f)),
                                 .heLtfType_i       (frm.preamble_header.he_ltf_type),
                                 .numHeLtf_i        (frm.preamble_header.num_he_ltf),
                                 .dcm_i             (frm.preamble_header.dcm),
                                 .packetExtension_i (frm.preamble_header.user_header_he[0].pkt_ext_f),
                                 .heTbLength_i      (0),
                                 .triggerMethod_i   (0),
                                 .doppler_i         (frm.preamble_header.doppler),
                                 .mma_i             (frm.preamble_header.midamble_periodicity),
                                 .stbc_i            (frm.preamble_header.stbc),
                                 .woPreamble_i      (0),
                                 .heSigB_i          (HESIGB),
                                 .debug_i           (0)
                               );
    end
    else if (frm.preamble_header.format_mod == HE_TB) begin
      res = ComputeTimeOnAirAX ( .length_i          (frm.preamble_header.user_header_he[0].he_length_f),
                                 .preType_i         (frm.preamble_header.format_mod),
                                 .mcsIndex_i        (frm.preamble_header.user_header_he[0].mcs_f),
                                 .giType_i          (frm.preamble_header.gi_type),
                                 .ruType_i          (get_ru_type(frm.preamble_header.ru_allocation)),
                                 .heLtfType_i       (frm.preamble_header.he_ltf_type),
                                 .numHeLtf_i        (frm.preamble_header.num_he_ltf),
                                 .dcm_i             (frm.preamble_header.dcm),
                                 .packetExtension_i (frm.preamble_header.user_header_he[0].pkt_ext_f),
                                 .heTbLength_i      (0),
                                 .triggerMethod_i   (0),
                                 .doppler_i         (frm.preamble_header.doppler),
                                 .mma_i             (frm.preamble_header.midamble_periodicity),
                                 .stbc_i            (frm.preamble_header.stbc),
                                 .woPreamble_i      (0),
                                 .heSigB_i          (HESIGB),
                                 .debug_i           (0)
                               );
    end
    else begin
      // calculate duration of longest frame on air
      if (frm.kind == MU_MIMO) begin
        user = frm.user_order[0];
        nsts_total = 0;
        foreach (frm.preamble_header.user_header[i])
          nsts_total += frm.preamble_header.user_header[i].num_sts_f + 1;
      end
      else begin
        user = 0;
        nsts_total = frm.preamble_header.user_header[0].num_sts_f;
      end

      if (frm.preamble_header.format_mod == VHT && frm.kind != MU_MIMO) begin
        nss = (frm.preamble_header.stbc > 0) ? (nsts_total+1)/(2*frm.preamble_header.stbc)-1 : nsts_total;
        mcs = {nss[2:0],frm.preamble_header.user_header[user].mcs_f[3:0]};
      end
      else begin
        mcs = frm.preamble_header.user_header[user].mcs_f;
      end

      `uvm_info("GET_PPDU_DURATION",
      $sformatf("Frame Format %0d. NSS=%0d,MCS=%0d,STB=%0d,NSTS=%0d",
      frm.preamble_header.format_mod,nss,mcs,frm.preamble_header.stbc,nsts_total), UVM_DEBUG)

      res =  ComputeTimeOnAirAC (.length_i     ((frm.preamble_header.format_mod inside {NON_HT, NON_HT_DUP_OFDM}) ?
                                                 frm.preamble_header.leg_length :                    // non HT mode
                                                 frm.preamble_header.user_header[user].ht_length_f), // HT mode

                                 .preType_i    ((frm.preamble_header.format_mod inside {NON_HT, NON_HT_DUP_OFDM}) ?
                                                 frm.preamble_header.preamble_type :
                                                 frm.preamble_header.format_mod),

                                 .mcsIndex_i   ((frm.preamble_header.format_mod inside {NON_HT, NON_HT_DUP_OFDM}) ?
                                                 get_mcs_from_legacy_rate(frm.preamble_header.leg_rate) : // NON_HT
                                                 mcs),            // HT/VHT mode

                                 .shortGI_i    (frm.preamble_header.gi_type[0]),
                                 .chBW_i       (frm.preamble_header.ch_bw),
                                 .stbc_i       (frm.preamble_header.stbc),
                                 .extNSS_i     (frm.preamble_header.num_extn_ss),
                                 .woPreamble_i (0),
                                 .band5G_i     (band5G),
                                 .multiUser_i  ((frm.kind == MU_MIMO) ? 1 : 0),
                                 .nSTSTotal_i  (nsts_total),
                                 .debug_i      (0)
                                );
    end

    `uvm_info("GET_PPDU_DURATION", $sformatf("Frame duration: %0d [us]", res), UVM_HIGH)

    return res;
  endfunction : get_ppdu_duration

  //----------------------------------------------------------------------
  // get SIFS value from PPDU frame setings
  //----------------------------------------------------------------------
  function int get_sifs(bit [2:0] abgn);

    if (abgn inside {MODE_802_11B, MODE_802_11G, MODE_802_11N_2_4GHZ})
      return 10; /* us */
    else
      return 16; /* us */
  endfunction : get_sifs

  //----------------------------------------------------------------------
  // get band 5G value
  //----------------------------------------------------------------------
  function bit get_band5G(bit [2:0] abgn);

    // when 802.11n and 802.11ac mode in 5GHz
    if (abgn == MODE_802_11N_5GHZ || abgn == MODE_802_11AC)
      return 1;
    else
      return 0;
  endfunction : get_band5G

  //---------------------------------------------------------------------------
  // get Block Ack Request variant
  //---------------------------------------------------------------------------
  function bar_variant_e get_bar_variant(PPDU_frame frm);
    CONTROL_WRAPPER_frame   ctrl_wrapp;
    BLOCK_ACK_REQUEST_frame bar;

    // control wrapper frame carries the real frame type which
    // MAC needs to analyze
    if (frm.ampdu_frame[0].mpdu_frame_type[0] == CONTROL_WRAPPER) begin
      // type cast frame to control wrapper
      ctrl_wrapp = CONTROL_WRAPPER_frame'(frm.ampdu_frame[0].mpdu_frame[0]);
      if (ctrl_wrapp.ctrl_frame_type == BLOCK_ACK_REQUEST) begin
        bar = BLOCK_ACK_REQUEST_frame'(ctrl_wrapp.carried_frame);
        return bar.bar_variant;
      end
    end
    else if (frm.ampdu_frame[0].mpdu_frame_type[0] == BLOCK_ACK_REQUEST) begin
      // type cast frame to BAR
      bar = BLOCK_ACK_REQUEST_frame'(frm.ampdu_frame[0].mpdu_frame[0]);
      return bar.bar_variant;
    end

    return BASIC_BAR;

  endfunction : get_bar_variant

  //---------------------------------------------------------------------------
  // get Block Ack variant
  //---------------------------------------------------------------------------
  function ba_variant_e get_ba_variant(PPDU_frame frm);
    CONTROL_WRAPPER_frame   ctrl_wrapp;
    BLOCK_ACK_frame         ba;

    // control wrapper frame carries the real frame type which
    // MAC needs to analyze
    if (frm.ampdu_frame[0].mpdu_frame_type[0] == CONTROL_WRAPPER) begin
      // type cast frame to control wrapper
      ctrl_wrapp = CONTROL_WRAPPER_frame'(frm.ampdu_frame[0].mpdu_frame[0]);
      if (ctrl_wrapp.ctrl_frame_type == BLOCK_ACK) begin
        ba = BLOCK_ACK_frame'(ctrl_wrapp.carried_frame);
        return ba.ba_variant;
      end
    end
    else if (frm.ampdu_frame[0].mpdu_frame_type[0] == BLOCK_ACK) begin
      // type cast frame to BA
      ba = BLOCK_ACK_frame'(frm.ampdu_frame[0].mpdu_frame[0]);
      return ba.ba_variant;
    end

    return BASIC_BA;

  endfunction : get_ba_variant

  //---------------------------------------------------------------------------
  // get Block Ack policy field from Block Ack Request frame
  //---------------------------------------------------------------------------
  function bit [1:0] get_block_ack_policy(PPDU_frame frm, int user = 0);
    return frm.ampdu_frame[user].get_qos_ack_policy();
  endfunction : get_block_ack_policy

  //------------------------------------------------------------
  // function get HT control
  //------------------------------------------------------------
  function ht_control_s get_ht_control(PPDU_frame frm, int user = 0);
    return frm.ampdu_frame[user].get_ht_control();
  endfunction : get_ht_control

  //------------------------------------------------------------
  // function set HT control
  //------------------------------------------------------------
  function void set_ht_control(PPDU_frame frm, ht_control_s htctrl, int user = 0);
    frm.ampdu_frame[user].set_ht_control(htctrl);
  endfunction : set_ht_control

  //---------------------------------------------------------------------------
  // get TRQ and NDP Announcement fields
  //---------------------------------------------------------------------------
  function bit get_trq_ndp_announcement(PPDU_frame frm);

    // If TRQ==1 and NDP announcment field is 0, then the response should be done using HT frame, return 1, otherwise NON_HT and return 0
    return (frm.ampdu_frame[0].mpdu_frame[0].MAC_header.ht_ctrl[0].link_adaptation_ctrl_f[`TRQ] == 1'b1 &&
            frm.ampdu_frame[0].mpdu_frame[0].MAC_header.ht_ctrl[0].ndp_announcement_f == 1'b0) ? 1'b1 : 1'b0;
  endfunction : get_trq_ndp_announcement

  //---------------------------------------------------------------------------
  // get number of preamble symbols pre format mode
  //---------------------------------------------------------------------------
  function int get_preamble_nsymb(format_mod_e mod);
    case (mod)
      NON_HT, NON_HT_DUP_OFDM: return 2;
      HT_MF    : return 5;
      HT_GF    : return 3;
      VHT      : return 5;
      HE_SU    : return 6;
      HE_MU    : return 7;
      HE_EXT_SU: return 6;
      HE_TB    : return 6;
    endcase
  endfunction : get_preamble_nsymb

  //----------------------------------------------------------------------
  // function that determines the max he_length in the HE_TB frame
  // based on the length from the Trigger frame
  //----------------------------------------------------------------------
  function int get_max_he_length(PPDU_frame ppdu);

    bit [1:0]       he_ltf_type;
    bit [1:0]       gi_type;
    int             max_he_length;
    TRIGGER_frame   trig_frm;

    trig_frm = new();
    trig_frm.copy(ppdu.ampdu_frame[0].mpdu_frame[0]);

    case(trig_frm.common_info.gi_and_ltf_type_f)
      0 : begin
            he_ltf_type = 2'b00;
            gi_type     = 2'b01;
          end
      1 : begin
            he_ltf_type = 2'b01;
            gi_type     = 2'b01;
          end
      2 : begin
            he_ltf_type = 2'b10;
            gi_type     = 2'b01;
          end
      default : `uvm_error("wlan_common",$sformatf("The value of gi_and_ltf_type is invalid"))
    endcase

    max_he_length = GetHeTbLength(.lsigLength_i           (trig_frm.common_info.length_f),
                                  .heLtfType_i            (he_ltf_type),
                                  .giType_i               (gi_type),
                                  .numHeLtf_i             (trig_frm.common_info.num_of_he_ltf_symbols_f),
                                  .ruType_i               (get_ru_type(trig_frm.user_info[0].ru_allocation_f)),
                                  .mcsIndex_i             (trig_frm.user_info[0].mcs_f),
                                  .dcm_i                  (trig_frm.user_info[0].dcm_f),
                                  .stbc_i                 (trig_frm.common_info.stbc_f),
                                  .doppler_i              (trig_frm.common_info.doppler_f),
                                  .fec_coding_i           (trig_frm.user_info[0].coding_type_f),
                                  .ldpc_extra_symbol_i    (trig_frm.common_info.ldpc_extra_symbol_segment_f),
                                  .pre_fec_padding_i      (trig_frm.common_info.pre_fec_padding_f),
                                  .midamble_periodicity_i (trig_frm.common_info.num_of_he_ltf_symbols_f < 4 ? 0 : 1),
                                  .bpe_dis_i              (trig_frm.common_info.pe_disambiguity_f),
                                  .debug_i                (0));

    return max_he_length;

  endfunction : get_max_he_length

  //----------------------------------------------------------------------
  // function that determines is PPDU priority frame and stored in priority
  // buffer. Returns 1 if frame is priority else 0
  //----------------------------------------------------------------------
  function bit is_priority_rx_frame(PPDU_frame frm);

    if (frm.kind != NDP)
      return (frm.ampdu_frame[0].mpdu_frame_type[0] inside {BLOCK_ACK, TRIGGER}) ? 1 : 0;
    else
      return 0;

  endfunction : is_priority_rx_frame

`endif// WLAN_COMMON_SV
