//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_CONFIG_SV
`define WLAN_CONFIG_SV

class wlan_config extends uvm_object;
  /************************************/
  /* environment configuration fields */
  /************************************/
  bit                has_rst_agent = 1;
  bit                has_ahb_master_agent = 1;
  bit                has_sram_agent = 1;
  bit                has_mac_phy_uvc = 1;
  bit                has_radio_uvc = 1;
  bit                has_keystorageram = 1;
  bit                has_regmodel = 1;
  bit                has_mdm_data_model = 1;
  bit                has_bf_uvc = 1;
  bit                has_axi_uvc = 1;
  bit                has_irq_raw_agent = 1;
  bit                has_irq_agent = 1;
  bit                has_sram_bus_agent = 1;
  bit                has_bus_monitor_agent = 1;
  bit                has_hdmcore_agent = 1;
  bit                has_deint_agent = 0;
  bit                has_equ_agent = 0;
  bit                has_fft_in_agent = 0;
  bit                has_fft_out_agent = 0;
  bit                has_ldpc_agent = 0;
  bit                has_ldpc_data_agent = 0;
  bit                has_viterbi_in_agent = 0;
`ifdef RW_WLAN_COEX_EN
  bit                has_coex_bt_agent = 1;
  bit                has_pta_wlan_agent = 1;
`else
  bit                has_coex_bt_agent = 0;
  bit                has_pta_wlan_agent = 0;
`endif
  // MODEM scoreboards
  bit                has_modem_tx_scoreboard = 1;
  bit                has_modem_rx_scoreboard = 1;
  bit                has_modem_bf_scoreboard = 1;
  bit                has_modem_stream_scoreboard = 0;
  bit                has_modem_timing_scoreboard = 0;
  bit                has_modem_radar_scoreboard = 0;
  // MAC scoreboards
  bit                has_mac_rx_scoreboard = 0;
  bit                has_mac_imm_resp_scoreboard = 0;
  bit                has_mac_tx_scoreboard = 0;
  bit                has_mac_dma_scoreboard = 0;
  bit                has_pta_scoreboard = 0;
  // Platform scoreboards
  bit                has_platf_irq_scoreboard = 1; // Scoreboard for platform interrupt controller
  bit                has_mac_irq_scoreboard = 1;   // Scoreboard for MAC interrupt controller
  /************************************/

  /************************************/
  /* global veriables used in seq     */
  /************************************/
  bit                mac_core_init_done = 0;
  bit                modem_init_done = 0;
  bit                check_mac_tsf_reg = 1;      // used in MAC Rx scoreboard
  bit                mac_dma_check_en = 1;       // used in MAC DMA scoreboard
  access_category_e  access_category_set;
  bitmap_param_s     TID_table[$];               // table with TID used in A-MPDU
  int                ksr_index;
  bit                bf_calib_test = 0;          // flag to indicate that BF calibration is being tested
  bit                channel_busy = 0;           // flag for indicating that the channel is busy
  event              new_frame_mdm_exe;          // indication that new PPDU frame was executed by MDM
  bit                insert_modem_rx_error = 0;  // flag to indicate error injection on Modem Rx path
  PPDU_frame         ppdu_tx_list[$];            // list of PPDU frames for modem TX testing
  bit                check_ppdu_mpif = 1;        // enable/disable checking in Modem Rx scb
  /************************************/

  /*****************************************/
  /* list of agent and UVCs configurations */
  /*****************************************/
  rst_config              m_rst_cfg;
  ahb_master_config       m_ahb_master_cfg;
  mac_phy_config          m_mac_phy_cfg;
  radio_config            m_radio_cfg;
  sram_config             m_sram_cfg;
  beamforming_config      m_bf_cfg;
  irq_raw_config          m_platform_in_irq_raw_cfg;
  irq_raw_config          m_platform_out_irq_raw_cfg;
  axi_config              m_axi_cfg;
  axi_slave_config        m_axi_read_slv_cfg;
  coex_bt_config          m_coex_bt_cfg;
  pta_wlan_config         m_pta_wlan_cfg;
  sram_bus_config         m_sram_bus_cfg;
  bus_monitor_config      m_bus_monitor_cfg;
  modem_stream_config     m_hdmcore_cfg;
  modem_stream_config     m_deint_cfg;
  modem_stream_config     m_equ_cfg;
  modem_stream_config     m_ldpc_cfg;
  modem_stream_config     m_ldpc_data_cfg;
  modem_stream_config     m_viterbi_in_cfg;
  mem_config              m_fft_in_cfg;
  mem_config              m_fft_out_cfg;
  /*****************************************/

  `uvm_object_utils_begin(wlan_config)
    `uvm_field_int(has_rst_agent, UVM_DEFAULT)
    `uvm_field_int(has_ahb_master_agent, UVM_DEFAULT)
    `uvm_field_int(has_sram_agent, UVM_DEFAULT)
    `uvm_field_int(has_mac_phy_uvc, UVM_DEFAULT)
    `uvm_field_int(has_radio_uvc, UVM_DEFAULT)
    `uvm_field_int(has_regmodel, UVM_DEFAULT)
    `uvm_field_int(has_keystorageram, UVM_DEFAULT)
    `uvm_field_int(has_mdm_data_model, UVM_DEFAULT)
    `uvm_field_int(has_bf_uvc, UVM_DEFAULT)
    `uvm_field_int(has_irq_raw_agent, UVM_DEFAULT)
    `uvm_field_int(has_irq_agent, UVM_DEFAULT)
    `uvm_field_int(has_axi_uvc, UVM_DEFAULT)
    `uvm_field_int(has_sram_bus_agent, UVM_DEFAULT)
    `uvm_field_int(has_bus_monitor_agent, UVM_DEFAULT)
    `uvm_field_int(has_hdmcore_agent, UVM_DEFAULT)
    `uvm_field_int(has_deint_agent, UVM_DEFAULT)
    `uvm_field_int(has_equ_agent, UVM_DEFAULT)
    `uvm_field_int(has_ldpc_agent, UVM_DEFAULT)
    `uvm_field_int(has_ldpc_data_agent, UVM_DEFAULT)
    `uvm_field_int(has_coex_bt_agent, UVM_DEFAULT)
    `uvm_field_int(has_pta_wlan_agent, UVM_DEFAULT)
    `uvm_field_int(has_viterbi_in_agent, UVM_DEFAULT)
    `uvm_field_int(has_modem_tx_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_modem_rx_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_modem_bf_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_modem_stream_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_modem_timing_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_modem_radar_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_mac_rx_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_platf_irq_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_mac_dma_scoreboard, UVM_DEFAULT)
    `uvm_field_int(has_pta_scoreboard, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "wlan_config");
    super.new(name);

    /******************************/
    /* create all configurations  */
    /******************************/
    m_rst_cfg         = rst_config::type_id::create("m_rst_cfg");
    m_ahb_master_cfg  = ahb_master_config::type_id::create("m_ahb_master_cfg");
    m_mac_phy_cfg     = mac_phy_config::type_id::create("m_mac_phy_cfg");
    m_radio_cfg       = radio_config::type_id::create("m_radio_cfg");
    m_sram_cfg        = sram_config::type_id::create("m_sram_cfg");
    m_bf_cfg          = beamforming_config::type_id::create("m_bf_cfg");
    m_platform_in_irq_raw_cfg  = irq_raw_config::type_id::create("m_platform_in_irq_raw_cfg");
    m_platform_out_irq_raw_cfg = irq_raw_config::type_id::create("m_platform_out_irq_raw_cfg");
    m_axi_cfg         = axi_config::type_id::create("m_axi_cfg");
    m_coex_bt_cfg     = coex_bt_config::type_id::create("m_coex_bt_cfg");
    m_sram_bus_cfg    = sram_bus_config::type_id::create("m_sram_bus_cfg");
    m_pta_wlan_cfg    = pta_wlan_config::type_id::create("m_pta_wlan_cfg");
    m_bus_monitor_cfg = bus_monitor_config::type_id::create("m_bus_monitor_cfg");
    m_deint_cfg       = modem_stream_config::type_id::create("m_deint_cfg");
    m_equ_cfg         = modem_stream_config::type_id::create("m_equ_cfg");
    m_ldpc_cfg        = modem_stream_config::type_id::create("m_ldpc_cfg");
    m_ldpc_data_cfg   = modem_stream_config::type_id::create("m_ldpc_data_cfg");
    m_viterbi_in_cfg  = modem_stream_config::type_id::create("m_viterbi_in_cfg");
    m_hdmcore_cfg     = modem_stream_config::type_id::create("m_hdmcore_cfg");
    m_fft_in_cfg      = mem_config::type_id::create("m_fft_in_cfg");
    m_fft_out_cfg     = mem_config::type_id::create("m_fft_out_cfg");

  endfunction : new

endclass : wlan_config

`endif
