//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_ENV_SV
`define WLAN_ENV_SV

//-----------------------------------

class wlan_env extends uvm_env;
  `uvm_component_utils(wlan_env)

  wlan_config                    m_cfg;
  wlan_virtual_sequencer         m_vsqr;

  /* list of agents */
  rst_agent                                m_rst_agent;
  ahb_master_agent                         m_ahb_master_agent;
  sram_agent                               m_sram_agent;
  irq_raw_agent#(`PLATFORM_IN_IRQ_WIDTH)   m_irq_raw_platf_in_agent;
  irq_raw_agent#(`PLATFORM_OUT_IRQ_WIDTH)  m_irq_raw_platf_out_agent;
  irq_raw_agent#(`MAC_IRQ_CTRL_IN_WIDTH)   m_irq_raw_mac_in_agent;
  irq_raw_agent#(`MAC_IRQ_CTRL_OUT_WIDTH)  m_irq_raw_mac_out_agent;
  coex_bt_agent                            m_coex_bt_agent;
  pta_wlan_agent                           m_pta_wlan_agent;
  sram_bus_agent                           m_sram_bus_agent;
  bus_monitor_agent                        m_bus_monitor_agent;
  modem_stream_agent#(`TXCOREDATA_WIDTH)   m_hdmcore_agent;
  modem_stream_agent#(`TXMAPDATA_WIDTH)    m_txmapper_agent;
  modem_stream_agent#(`DEINTERWIDTH)       m_deint_agent;
  modem_stream_agent#(`EQUWIDTH)           m_equ_agent;
  modem_stream_agent#(`EQUWIDTH)           m_equ1_agent;
  modem_stream_agent#(`LDPCWIDTH)          m_ldpc_agent;
  modem_stream_agent#(`LDPCDATAWIDTH)      m_ldpc_data_agent;
  modem_stream_agent#(`VITERBIWIDTH)       m_viterbi_in_agent;
  mem_agent#(`FFTIF_WIDTH)                 m_fft_in_agent;
  mem_agent#(`FFTIF_WIDTH)                 m_fft_out_agent;

  /* list of UVCs   */
  mac_phy_env                    m_mac_phy_env;
  radio_env                      m_radio_env;
  beamforming_env                m_bf_env;
  axi_env                        m_axi_env;

  /* list of scoreboards */
  modem_tx_scoreboard            m_modem_tx_scb;
  modem_rx_scoreboard            m_modem_rx_scb;
  modem_bf_scoreboard            m_modem_bf_scb;
  modem_stream_scoreboard        m_modem_stream_scb;
  mac_rx_scoreboard              m_mac_rx_scb;
  mac_immediate_resp_scoreboard  m_mac_imm_resp_scb;
  mac_tx_scoreboard              m_mac_tx_scb;
  platform_irq_scoreboard        m_platf_irq_scb; // Platform interrupt controller scoreboard
  mac_irq_scoreboard             m_mac_irq_scb;
  mac_dma_scoreboard             m_mac_dma_scb;
  mac_pta_scoreboard             m_mac_pta_scb;
  // Coverage
  frame_model_coverage           m_frame_model_cov;

  /* list of common components */
  KeyStorageRAM                  m_ksr;
  TOP_register_block             m_regmodel;
  ahb_master_reg_adapter         m_reg_adapter;
  ahb_master_reg_predictor       m_reg_predictor;
  mdm_data_model                 m_mdm_data_model;
  axi_slave_memory               m_axi_slv_mem; // AXI memory (system memory)


  function new (string name = "wlan_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get configuration
    if (!uvm_config_db #(wlan_config)::get(null, "", "wlan_config", m_cfg))
      `uvm_fatal(get_type_name(), "WLAN configuration not set in configuration DB!!!")

    // Create components
    m_vsqr = wlan_virtual_sequencer::type_id::create("m_vsqr", this);

    if (m_cfg.has_rst_agent) begin
      uvm_config_db #(rst_config)::set(this, "m_rst_agent", "cfg", m_cfg.m_rst_cfg);
      m_rst_agent = rst_agent::type_id::create("m_rst_agent", this);
    end

    if (m_cfg.has_ahb_master_agent) begin
      uvm_config_db #(ahb_master_config)::set(this, "m_ahb_master_agent", "cfg", m_cfg.m_ahb_master_cfg);
      m_ahb_master_agent = ahb_master_agent::type_id::create("m_ahb_master_agent", this);
    end

    if (m_cfg.has_sram_agent) begin
      uvm_config_db #(sram_config)::set(this, "m_sram_agent", "cfg", m_cfg.m_sram_cfg);
      m_sram_agent = sram_agent::type_id::create("m_sram_agent", this);
    end

    if (m_cfg.has_mac_phy_uvc) begin
      uvm_config_db #(mac_phy_config)::set(this, "m_mac_phy_env", "mac_phy_config", m_cfg.m_mac_phy_cfg);
      m_mac_phy_env = mac_phy_env::type_id::create("m_mac_phy_env", this);
      m_frame_model_cov = frame_model_coverage::type_id::create("m_frame_model_cov", this);
    end

    if (m_cfg.has_radio_uvc) begin
      uvm_config_db #(radio_config)::set(this, "m_radio_env", "radio_config", m_cfg.m_radio_cfg);
      m_radio_env = radio_env::type_id::create("m_radio_env", this);
    end

    if (m_cfg.has_bf_uvc) begin
      uvm_config_db #(beamforming_config)::set(this, "m_bf_env", "beamforming_config", m_cfg.m_bf_cfg);
      m_bf_env = beamforming_env::type_id::create("m_bf_env", this);
    end

    if (m_cfg.has_regmodel) begin
      m_reg_adapter = ahb_master_reg_adapter::type_id::create("m_reg_adapter");
      m_reg_predictor = ahb_master_reg_predictor::type_id::create("m_reg_predictor", this);
      m_reg_predictor.set_report_verbosity_level(UVM_LOW);

      uvm_reg::include_coverage("*", UVM_CVR_FIELD_VALS | UVM_CVR_ADDR_MAP);

      m_regmodel = TOP_register_block::type_id::create("m_regmodel");
      uvm_config_db #(TOP_register_block)::set(null, "", "TOP_register_block", m_regmodel);
      m_regmodel.build();
      m_regmodel.connect();
      add_regmodel_hdl_paths();
      m_regmodel.reset();
      m_regmodel.lock_model();
    end

    if (m_cfg.has_keystorageram) begin
      m_ksr = KeyStorageRAM::type_id::create("m_ksr");
      // put key storage RAM in global database so other components can use it
      uvm_config_db #(KeyStorageRAM)::set(null, "", "KeyStorageRAM", m_ksr);
    end

    if (m_cfg.has_mdm_data_model) begin
      m_mdm_data_model = mdm_data_model::type_id::create("m_mdm_data_model");
      // put the modem data model in global database so other components can use it
      uvm_config_db #(mdm_data_model)::set(null, "", "mdm_data_model", m_mdm_data_model);
    end

    if (m_cfg.has_modem_tx_scoreboard) begin
      m_modem_tx_scb = modem_tx_scoreboard::type_id::create("m_modem_tx_scb", this);
    end

    if (m_cfg.has_modem_rx_scoreboard) begin
      m_modem_rx_scb = modem_rx_scoreboard::type_id::create("m_modem_rx_scb", this);
    end

    if (m_cfg.has_modem_bf_scoreboard) begin
      m_modem_bf_scb = modem_bf_scoreboard::type_id::create("m_modem_bf_scb", this);
    end

    if (m_cfg.has_modem_stream_scoreboard) begin
      m_modem_stream_scb = modem_stream_scoreboard::type_id::create("m_modem_stream_scb", this);
    end

    if (m_cfg.has_mac_rx_scoreboard) begin
      m_mac_rx_scb = mac_rx_scoreboard::type_id::create("m_mac_rx_scb", this);
    end

    if (m_cfg.has_mac_tx_scoreboard) begin
      m_mac_tx_scb = mac_tx_scoreboard::type_id::create("m_mac_tx_scb", this);
    end

    if (m_cfg.has_mac_imm_resp_scoreboard) begin
      m_mac_imm_resp_scb = mac_immediate_resp_scoreboard::type_id::create("m_mac_imm_resp_scb", this);
    end

    if (m_cfg.has_pta_scoreboard) begin
      m_mac_pta_scb = mac_pta_scoreboard::type_id::create("m_mac_pta_scb", this);
    end

    if (m_cfg.has_irq_raw_agent) begin
      // Platform IRQ IN agent
      uvm_config_db #(irq_raw_config)::set(this, "m_irq_raw_platf_in_agent", "cfg", m_cfg.m_platform_in_irq_raw_cfg);
      m_irq_raw_platf_in_agent = irq_raw_agent #(`PLATFORM_IN_IRQ_WIDTH)::type_id::create("m_irq_raw_platf_in_agent", this);

      // Platform IRQ OUT agent
      uvm_config_db #(irq_raw_config)::set(this, "m_irq_raw_platf_out_agent", "cfg", m_cfg.m_platform_out_irq_raw_cfg);
      m_irq_raw_platf_out_agent = irq_raw_agent #(`PLATFORM_OUT_IRQ_WIDTH)::type_id::create("m_irq_raw_platf_out_agent", this);
    end // if (m_cfg.has_irq_raw_agent)

     // Scoreboard for platform IRQ controller
    if (m_cfg.has_platf_irq_scoreboard) begin
      m_platf_irq_scb = platform_irq_scoreboard::type_id::create("m_platf_irq_scb", this);
    end

    // MAC interrupt controller agents
    if(m_cfg.has_irq_agent) begin

    // MAC interrupt controller IN agent
      uvm_config_db #(irq_raw_config)::set(this, "m_irq_raw_mac_in_agent", "cfg", m_cfg.m_platform_in_irq_raw_cfg); // Platform CFG is used (for the purpose of debug only)
      m_irq_raw_mac_in_agent = irq_raw_agent #(`MAC_IRQ_CTRL_IN_WIDTH)::type_id::create("m_irq_raw_mac_in_agent", this);

    // MAC interrupt controller OUT agent
      uvm_config_db #(irq_raw_config)::set(this, "m_irq_raw_mac_out_agent", "cfg", m_cfg.m_platform_out_irq_raw_cfg); // Platform CFG is used (for the purpose of debug only)
      m_irq_raw_mac_out_agent = irq_raw_agent #(`MAC_IRQ_CTRL_OUT_WIDTH)::type_id::create("m_irq_raw_mac_out_agent", this);

    end // if(m_cfg.has_irq_agent)

    // MAC IRQ scoreboard
    if (m_cfg.has_mac_irq_scoreboard) begin
      m_mac_irq_scb = mac_irq_scoreboard::type_id::create("m_mac_irq_scb", this);
    end

     // AXI UVC
    if (m_cfg.has_axi_uvc) begin
      // set agent configuration
      uvm_config_db #(axi_config)::set(this, "m_axi_env", "axi_config", m_cfg.m_axi_cfg);

      m_axi_env = axi_env::type_id::create("m_axi_env", this);

      // AXI memory
      m_axi_slv_mem = axi_slave_memory::type_id::create("m_axi_slv_mem");
      uvm_config_db #(axi_slave_memory)::set(null, "", "m_axi_slv_mem", m_axi_slv_mem);
    end

     // SRAM BUS UVC
    if (m_cfg.has_sram_bus_agent) begin
      uvm_config_db #(sram_bus_config)::set(this, "m_sram_bus_agent", "cfg", m_cfg.m_sram_bus_cfg);
      m_sram_bus_agent = sram_bus_agent::type_id::create("m_sram_bus_agent", this);
    end

    // DMA scoreboard
    if (m_cfg.has_mac_dma_scoreboard) begin
      m_mac_dma_scb = mac_dma_scoreboard::type_id::create("m_mac_dma_scb", this);
    end

    // COEX agent
    if (m_cfg.has_coex_bt_agent) begin
      uvm_config_db #(coex_bt_config)::set(this, "m_coex_bt_agent", "cfg", m_cfg.m_coex_bt_cfg);
      m_coex_bt_agent = coex_bt_agent::type_id::create("m_coex_bt_agent", this);
    end

    // PTA WLAN agent
    if (m_cfg.has_pta_wlan_agent) begin
      uvm_config_db #(pta_wlan_config)::set(this, "m_pta_wlan_agent", "cfg", m_cfg.m_pta_wlan_cfg);
      m_pta_wlan_agent = pta_wlan_agent::type_id::create("m_pta_wlan_agent", this);
    end

    // bus monitor agent
    if (m_cfg.has_bus_monitor_agent) begin
      uvm_config_db #(bus_monitor_config)::set(this, "m_bus_monitor_agent", "cfg", m_cfg.m_bus_monitor_cfg);
      m_bus_monitor_agent = bus_monitor_agent::type_id::create("m_bus_monitor_agent", this);
    end

    // HDMCORE and TXMAPPER agent
    if (m_cfg.has_hdmcore_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_hdmcore_agent", "cfg", m_cfg.m_hdmcore_cfg);
      m_hdmcore_agent = modem_stream_agent#(`TXCOREDATA_WIDTH)::type_id::create("m_hdmcore_agent",this);

      uvm_config_db #(modem_stream_config)::set(this, "m_txmapper_agent", "cfg", m_cfg.m_hdmcore_cfg);
      m_txmapper_agent = modem_stream_agent#(`TXMAPDATA_WIDTH)::type_id::create("m_txmapper_agent", this);
    end

    // De-interleaver agent
    if (m_cfg.has_deint_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_deint_agent", "cfg", m_cfg.m_deint_cfg);
      m_deint_agent = modem_stream_agent#(`DEINTERWIDTH)::type_id::create("m_deint_agent",this);
    end

    // Equalizer agent
    if (m_cfg.has_equ_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_equ_agent", "cfg", m_cfg.m_equ_cfg);
      uvm_config_db #(modem_stream_config)::set(this, "m_equ1_agent", "cfg", m_cfg.m_equ_cfg);
      m_equ_agent = modem_stream_agent#(`EQUWIDTH)::type_id::create("m_equ_agent",this);;
      m_equ1_agent = modem_stream_agent#(`EQUWIDTH)::type_id::create("m_equ1_agent",this);
    end

    if (m_cfg.has_ldpc_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_ldpc_agent", "cfg", m_cfg.m_ldpc_cfg);
      m_ldpc_agent = modem_stream_agent#(`LDPCWIDTH)::type_id::create("m_ldpc_agent",this);
    end

    if (m_cfg.has_ldpc_data_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_ldpc_data_agent", "cfg", m_cfg.m_ldpc_data_cfg);
      m_ldpc_data_agent = modem_stream_agent#(`LDPCDATAWIDTH)::type_id::create("m_ldpc_data_agent",this);
    end

    if (m_cfg.has_viterbi_in_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_viterbi_in_agent", "cfg", m_cfg.m_viterbi_in_cfg);
      m_viterbi_in_agent = modem_stream_agent#(`VITERBIWIDTH)::type_id::create("m_viterbi_in_agent",this);
    end

    // FFT input agent
    if (m_cfg.has_fft_in_agent) begin
      uvm_config_db #(mem_config)::set(this, "m_fft_in_agent", "cfg", m_cfg.m_fft_in_cfg);
      m_fft_in_agent = mem_agent#(`FFTIF_WIDTH)::type_id::create("m_fft_in_agent",this);
    end

    // FFT out agent
    if (m_cfg.has_fft_out_agent) begin
      uvm_config_db #(mem_config)::set(this, "m_fft_out_agent", "cfg", m_cfg.m_fft_out_cfg);
      m_fft_out_agent = mem_agent#(`FFTIF_WIDTH)::type_id::create("m_fft_out_agent",this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    /**********************************************/
    /* connect environment components and handles */
    /**********************************************/

    //---------------------------------------------
    // push down register model to MDM
    //---------------------------------------------
    if (m_cfg.has_mdm_data_model && m_cfg.has_regmodel) begin
      m_mdm_data_model.m_regmodel = m_regmodel;
    end

    //---------------------------------------------
    // RST agent
    //---------------------------------------------
    if (m_cfg.has_rst_agent) begin
      if (m_cfg.m_rst_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_rst_sqr = m_rst_agent.sequencer;
    end // has_rst_agent

    //---------------------------------------------
    // SRAM agent
    //---------------------------------------------
    if (m_cfg.has_sram_agent) begin
      if (m_cfg.m_sram_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_sram_sqr = m_sram_agent.sequencer;
    end // has_sram_agent

    //---------------------------------------------
    // REGISTER MODEL
    //---------------------------------------------
    if (m_cfg.has_regmodel) begin
      m_reg_predictor.map     = m_regmodel.REGMODEL_register_map;
      m_reg_predictor.adapter = m_reg_adapter;
    end // has_regmodel

    //---------------------------------------------
    // AHB MASTER AGENT
    //---------------------------------------------
    if (m_cfg.has_ahb_master_agent) begin
      if (m_cfg.m_ahb_master_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_ahb_master_sqr = m_ahb_master_agent.sequencer;

      if (m_cfg.has_regmodel) begin
        if (m_cfg.m_ahb_master_cfg.is_active == UVM_ACTIVE)
          m_regmodel.REGMODEL_register_map.set_sequencer(m_ahb_master_agent.sequencer, m_reg_adapter);

        m_ahb_master_agent.monitor.ap.connect(m_reg_predictor.bus_in);
      end // has_regmodel
    end // has_ahb_master_agent

    //---------------------------------------------
    // MAC-PHY UVC
    //---------------------------------------------
    if (m_cfg.has_mac_phy_uvc) begin

      if (m_cfg.m_mac_phy_cfg.is_active == UVM_ACTIVE) begin
        m_vsqr.m_mac_phy_vsqr = m_mac_phy_env.m_vsqr;
      end

      // modem_tx_scb
      if (m_cfg.has_modem_tx_scoreboard) begin
        m_mac_phy_env.m_monitor.ap.connect(m_modem_tx_scb.mac_phy_export);
        // push down environment configuration
        m_modem_tx_scb.m_cfg = m_cfg;
      end

      // modem_rx_scb
      if (m_cfg.has_modem_rx_scoreboard) begin
        m_mac_phy_env.m_monitor.ap.connect(m_modem_rx_scb.mac_phy_export);
      end

      // modem_stream_scb
      if (m_cfg.has_modem_stream_scoreboard) begin
        m_mac_phy_env.m_monitor.ap_rx_stream.connect(m_modem_stream_scb.mac_phy_export);
      end

      // mac_rx_scb
      if (m_cfg.has_mac_rx_scoreboard) begin
        m_sram_agent.driver.ap.connect(m_mac_rx_scb.sram_export);
        m_mac_phy_env.m_monitor.ap.connect(m_mac_rx_scb.mac_phy_export);
      end

      // mac_imm_resp_scb
      if (m_cfg.has_mac_imm_resp_scoreboard) begin
        m_mac_phy_env.m_monitor.ap.connect(m_mac_imm_resp_scb.mac_phy_export);
        m_sram_agent.driver.ap.connect(m_mac_imm_resp_scb.sram_fifo.analysis_export);
        // connect beamforming PHY agent
        if (m_cfg.m_bf_cfg.has_phy_bf_agent)
          m_bf_env.m_phy_bf_agent.monitor.ap.connect(m_mac_imm_resp_scb.phy_bf_export);
      end

      // mac_tx_scb
      if (m_cfg.has_mac_tx_scoreboard) begin
        m_sram_agent.driver.ap.connect(m_mac_tx_scb.sram_export);
        m_mac_phy_env.m_monitor.ap.connect(m_mac_tx_scb.mac_phy_export);
      end

      // frame model coverage
      m_mac_phy_env.m_monitor.ap_frame.connect(m_frame_model_cov.analysis_export);

    end// has_mac_phy_uvc

    //---------------------------------------------
    // RADIO UVC
    //---------------------------------------------
    if (m_cfg.has_radio_uvc) begin

      if (m_cfg.m_radio_cfg.has_modem_stream_dac_agent) begin
        if (m_cfg.has_modem_tx_scoreboard) begin
          m_radio_env.m_modem_stream_dac_agent.monitor.ap.connect(m_modem_tx_scb.dac_export);
        end// has_modem_tx_scoreboard
      end

      if (m_cfg.m_radio_cfg.has_modem_stream_adc_agent) begin
        if (m_cfg.m_radio_cfg.m_modem_stream_adc_cfg.is_active == UVM_ACTIVE)
          m_vsqr.m_adc_sqr = m_radio_env.m_modem_stream_adc_agent.sequencer;
      end// has_modem_stream_adc_agent


      if (m_cfg.m_radio_cfg.has_rui_agent) begin
        if (m_cfg.m_radio_cfg.m_rui_cfg.is_active == UVM_ACTIVE)
          m_vsqr.m_rui_sqr =  m_radio_env.m_rui_agent.sequencer;
      end// has_modem_stream_adc_agent

    end// has_radio_uvc

    //---------------------------------------------
    // BEAMFORMING UVC
    //---------------------------------------------
    if (m_cfg.has_bf_uvc) begin

      if (m_cfg.m_bf_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_bf_vsqr = m_bf_env.m_vsqr;

      if (m_cfg.has_modem_bf_scoreboard) begin
        if (m_cfg.m_bf_cfg.has_mac_bf_agent)
          m_bf_env.m_mac_bf_agent.monitor.ap.connect(m_modem_bf_scb.mac_bf_export);

        if (m_cfg.m_bf_cfg.has_h_mem_agent)
          m_bf_env.m_h_mem_agent.monitor.ap.connect(m_modem_bf_scb.h_mem_fifo.analysis_export);

        if (m_cfg.has_mac_phy_uvc)
          m_mac_phy_env.m_monitor.ap.connect(m_modem_bf_scb.mac_phy_if_bf_export);
      end// has_modem_bf_scoreboard
    end // has_bf_uvc

    //---------------------------------------------
    // IRQ AGENT
    //---------------------------------------------
    // Scoreboard for platform IRQ controller. Ports are connected only if scbd, IN  and OUT agent are used
    if (m_cfg.has_irq_raw_agent && m_cfg.has_platf_irq_scoreboard) begin
      m_irq_raw_platf_in_agent.monitor.ap.connect(m_platf_irq_scb.platf_irq_in_export);
      m_irq_raw_platf_out_agent.monitor.ap.connect(m_platf_irq_scb.platf_irq_out_export);
    end // if (m_cfg.has_irq_raw_agent && m_cfg.has_platf_irq_scoreboard)

     // Scoreboard for MAC IRQ controller. Ports are connected only if scbd, IN  and OUT agent are used
    if (m_cfg.has_irq_agent && m_cfg.has_mac_irq_scoreboard) begin
      m_irq_raw_mac_in_agent.monitor.ap.connect(m_mac_irq_scb.mac_irq_in_fifo.analysis_export);
      m_irq_raw_mac_out_agent.monitor.ap.connect(m_mac_irq_scb.mac_irq_out_fifo.analysis_export);
    end // if (m_cfg.has_irq_raw_agent && m_cfg.has_platf_irq_scoreboard)*/

    //---------------------------------------------
    // AXI ENV
    //---------------------------------------------
    if (m_cfg.has_axi_uvc) begin
      if (m_cfg.m_axi_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_axi_vsqr = m_axi_env.m_axi_vsqr;
    end // if (m_cfg.has_axi_uvc)

    //---------------------------------------------
    // SRAM BUS AGENT/SCOREBOARD
    //---------------------------------------------
    if (m_cfg.has_sram_bus_agent && m_cfg.has_axi_uvc && m_cfg.has_mac_dma_scoreboard) begin
      m_axi_env.m_axi_slave_write_agent.write_monitor.ap_wd.connect(m_mac_dma_scb.axi_write_slave_fifo.analysis_export);
      m_axi_env.m_axi_slave_read_agent.read_monitor.ap.connect(m_mac_dma_scb.axi_read_slave_fifo.analysis_export);
      m_sram_bus_agent.monitor.ap.connect(m_mac_dma_scb.sram_bus_write_fifo.analysis_export);
    end

    //---------------------------------------------
    // COEX BT AGENT
    //---------------------------------------------
    if (m_cfg.has_coex_bt_agent) begin
      if (m_cfg.m_coex_bt_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_coex_bt_sqr = m_coex_bt_agent.sequencer;
    end

    //---------------------------------------------
    // PTA WLAN AGENT/SCOREBOARD
    //---------------------------------------------
    if (m_cfg.has_pta_scoreboard) begin
      if (m_cfg.has_pta_wlan_agent) begin
        m_pta_wlan_agent.monitor.ap.connect(m_mac_pta_scb.wlan_export);
      end
      if (m_cfg.has_coex_bt_agent) begin
        m_coex_bt_agent.monitor.ap.connect(m_mac_pta_scb.bt_export);
      end
    end

    //---------------------------------------------
    // HDMCORE and TXMAPPER connection to
    // modem_tx_scoreboard
    //---------------------------------------------
    if (m_cfg.has_hdmcore_agent && m_cfg.has_modem_tx_scoreboard) begin
      m_hdmcore_agent.monitor.ap.connect(m_modem_tx_scb.txcore_export);
      m_txmapper_agent.monitor.ap.connect(m_modem_tx_scb.txmap_export);
    end

    //---------------------------------------------
    // BUS monitor connection to modem_stream_agent
    //---------------------------------------------
    if (m_cfg.has_bus_monitor_agent && m_cfg.has_modem_tx_scoreboard) begin
      m_bus_monitor_agent.monitor.ap.connect(m_modem_tx_scb.sig_export);
    end

    //---------------------------------------------
    // Modem RX scoreboard and deinterleaver agent
    // connection
    //---------------------------------------------
    if (m_cfg.has_deint_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_deint_agent.monitor.ap.connect(m_modem_rx_scb.deint_fifo.analysis_export);
    end

    if (m_cfg.has_equ_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_equ_agent.monitor.ap.connect(m_modem_rx_scb.equ_fifo.analysis_export);
      m_equ1_agent.monitor.ap.connect(m_modem_rx_scb.equ1_fifo.analysis_export);
    end

    if (m_cfg.has_ldpc_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_ldpc_agent.monitor.ap.connect(m_modem_rx_scb.ldpc_fifo.analysis_export);
    end

    if (m_cfg.has_ldpc_data_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_ldpc_data_agent.monitor.ap.connect(m_modem_rx_scb.ldpc_data_fifo.analysis_export);
    end

    //---------------------------------------------
    // Modem RX scoreboard and Viterbi in agent
    // connection
    //---------------------------------------------

    if (m_cfg.has_viterbi_in_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_viterbi_in_agent.monitor.ap.connect(m_modem_rx_scb.viterbi_in_fifo.analysis_export);
    end

    //---------------------------------------------
    // Modem RX scoreboard and FFT in memory agent
    // connection
    //---------------------------------------------
    if (   m_cfg.has_fft_in_agent
        && m_cfg.has_modem_rx_scoreboard
        && m_cfg.m_fft_in_cfg.is_active == UVM_PASSIVE) begin
      m_fft_in_agent.monitor.ap.connect(m_modem_rx_scb.fftin_fifo.analysis_export);
    end

    if (m_cfg.has_fft_in_agent && m_cfg.m_fft_in_cfg.is_active == UVM_ACTIVE) begin
      m_vsqr.m_fft_in_sqr = m_fft_in_agent.sequencer;
    end
    //---------------------------------------------
    // Modem RX scoreboard and FFT out memory agent
    // connection
    //---------------------------------------------
    if (m_cfg.has_fft_out_agent && m_cfg.has_modem_rx_scoreboard) begin
      m_fft_out_agent.monitor.ap.connect(m_modem_rx_scb.fftout_fifo.analysis_export);
    end

    if (m_cfg.has_fft_out_agent && m_cfg.m_fft_out_cfg.is_active == UVM_ACTIVE) begin
      m_vsqr.m_fft_out_sqr = m_fft_out_agent.sequencer;
    end

  endfunction : connect_phase

  //---------------------------------------------
  // adding HDL paths for register model backdoor
  // access read and write
  //---------------------------------------------
  function void add_regmodel_hdl_paths();
    m_regmodel.add_hdl_path(`DUT_STRING, "RTL"); // set DUT HDL path
    m_regmodel.MACPL.TSFLOREG_reg.add_hdl_path_slice({`MAC_DUT_REG_STRING,".tsfTimerLow" }, 0, 32);
    m_regmodel.MACPL.TSFHIREG_reg.add_hdl_path_slice({`MAC_DUT_REG_STRING,".tsfTimerHigh"},0, 32);
  endfunction : add_regmodel_hdl_paths

endclass : wlan_env

`endif //WLAN_ENV_SV
