//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_PKG_SV
`define WLAN_PKG_SV

package wlan_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

  //--------------------------
  // import all packages
  //--------------------------
  import frame_model_pkg::*;
  import KeyStorageRAM_pkg::*;
  import descriptors_pkg::*;
  import misc_pkg::*;
  import rst_pkg::*;
  import REGMODEL_pkg::*;
  import callbacks_pkg::*;
  import ahb_master_pkg::*;
  import mdm_data_model_pkg::*;
  import mac_phy_pkg::*;
  import mac_pkg::*;
  import phy_pkg::*;
  import radio_pkg::*;
  import radio_ctrl_pkg::*;
  import modem_stream_pkg::*;
  import rui_pkg::*;
  import sram_pkg::*;
  import beamforming_pkg::*;
  import mac_bf_pkg::*;
  import phy_bf_pkg::*;
  import h_mem_pkg::*;
  import irq_raw_pkg::*;
  import axi_pkg::*;
  import axi_slave_pkg::*;
  import coex_bt_pkg::*;
  import sram_bus_pkg::*;
  import pta_wlan_pkg::*;
  import bus_monitor_pkg::*;
  import mem_pkg::*;

  //--------------------------
  // end of import packages
  //--------------------------

  `include "wlan_common.sv"
  `include "wlan_config.sv"
  `include "wlan_virtual_sequencer.sv"
  `include "../seq_lib/wlan_seq_list.sv"
  `include "../seq_lib/modem_seq_list.sv"
  `include "../seq_lib/mac_core_seq_list.sv"

  // MODEM scoreboards
  `include "modem_scoreboard_base.sv"
  `include "modem_bf_scoreboard.sv"
//   `include "modem_radar_scoreboard.sv"
  `include "modem_rx_scoreboard.sv"
  `include "modem_stream_scoreboard.sv"
//   `include "modem_timing_scoreboard.sv"
  `include "modem_tx_scoreboard.sv"

  // MAC core scoreboards
  `include "mac_scoreboard_base.sv"
  `include "mac_rx_scoreboard.sv"
  `include "mac_immediate_resp_scoreboard.sv"
  `include "mac_tx_scoreboard.sv"
  `include "mac_irq_scoreboard.sv"
  `include "mac_dma_scoreboard.sv"
  `include "mac_pta_scoreboard.sv"

  `include "platform_irq_scoreboard.sv"

  `include "wlan_env.sv"


endpackage : wlan_pkg

`endif// WLAN_PKG_SV
