//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_VIRTUAL_SEQUENCER_SV
`define WLAN_VIRTUAL_SEQUENCER_SV

class wlan_virtual_sequencer extends uvm_sequencer;

  `uvm_component_utils(wlan_virtual_sequencer)

  /* list of all active sequencers handles */
  /*****************************************/
  rst_sequencer                  m_rst_sqr;
  ahb_master_sequencer           m_ahb_master_sqr;
  mac_phy_virtual_sequencer      m_mac_phy_vsqr;
  modem_stream_sequencer#(`ADCWIDTH) m_adc_sqr;
  rui_sequencer                  m_rui_sqr;
  sram_sequencer                 m_sram_sqr;
  beamforming_virtual_sequencer  m_bf_vsqr;
  axi_virtual_sequencer          m_axi_vsqr;
  coex_bt_sequencer              m_coex_bt_sqr;
  mem_sequencer                  m_fft_out_sqr;
  mem_sequencer                  m_fft_in_sqr;
  /*****************************************/

  function new (string name = "wlan_virtual_sequencer", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

endclass : wlan_virtual_sequencer

`endif //WLAN_VIRTUAL_SEQUENCER_SV
