#!/bin/bash
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthournout $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 35312 $
#/ $Date: 2018-09-21 17:49:07 +0200 (Fri, 21 Sep 2018) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Compilation list file generation script
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/bin/create_comp_file.pl $
#/
#/////////////////////////////////////////////////////////////////////////////

eval 'exec perl -x -S "$0" ${1+"$@"}'
if 0;
#!perl

#use strict;
my ($mode);
my ($blockname);
my ($pathtolist);
my ($part);
# Arguments assigment 
#########################
if ($ARGV[1] =~ /\.list$/)
{
  $mode = 1;
  $blockname = $ARGV[0] || &errord("Blockname not specified");
  $pathtolist = $ARGV[1]
} else {  
  $mode = 0;
  $blockname = $ARGV[0] || &errord("Blockname not specified");
  $part  = $ARGV[1] || &errord("Part not specified");
}
my ($outputfilename)  = $ARGV[2] || &errord("Filename not specified");
my ($debug) = 0;


if ($ARGV[3] eq "-debug")
{
  $debug = 1;
} elsif ($ARGV[3] != "") {
  &errord("$ARGV[3]: unknown argument");
}  

my (%duplicationht) ={};

# Error Display procedure
#########################
sub errord {
  print "ERROR: $_[0]\n";
  print "create_comp_file.pl <blockname> <part or path_to_listfile> <outputfile> [-debug]\n";
  print "For example:\
         create_comp_file.pl block1 rtl block1_rtl_files.list
         create_comp_file.pl block1 ../../listfile.list block1_rtl_files.list\n";
  exit 1;
}


# Parse Listfile procedure
#########################
sub parselistfile {

  my ($includedblockpath)=$_[0];
  my ($includedblockname)=$_[0];

  $includedblockpath=~ s/\/[a-zA-Z0-9]+.list//g;

  my ($filename)=$_[1];
    $includedblockname=~ s/.*\///g;
  my ($listfile);
  
  # replace env variable
  my ($field);
  my (@fields);
  my ($env);
  
  if ($debug) {print "\nparselistfile detected : $includedblockpath $filename\n"}
  @fields = split(/\//,$includedblockpath);
  $includedblockpath="";
  foreach $field (@fields) {
    if ( $field =~ /\$.+/ ) {
      $field =~ s/\$//g;
      $field = $ENV { $field};
      #print "field : $field\n";
    }
    $includedblockpath .= "$field/";
  }
  chop($includedblockpath);
  # duplicate detection
#  if ($duplicationht{"$includedblockpath/$filename"})
  if ($duplicationht{"$filename"})
  {
#    if ($debug) {print "duplicate detected : $includedblockpath/$filename\n"}
    if ($debug) {print "duplicate detected : $filename\n"}
  } else {
    if ($debug) {print " ~ Parse $includedblockname/$filename\n"};
#    $duplicationht{"$includedblockpath/$filename"}=1;
    $duplicationht{"$filename"}=1;
    unless (open($listfile,"$includedblockpath/$filename"))
    {
      print "ERROR : Filename  $includedblockpath/$filename does not exist!\n";
      exit 1;
    }
    my($line);
    until (eof ($listfile))
    {
      $line=<$listfile>;
      chop($line);
      if ($line =~ /^\#|^\--|^\/\//)
      {
        
      } else {
        if ($line =~ /^INCLUDE +(.+)/) 
        {
          my $dpath = $1;
          my ($ifilename) = $1;
          $ifilename =~ s/.*\///g;
          $dpath =~ s/\/$ifilename$//;
          if ($debug) {print "Path = $dpath, ifilename = $ifilename\n";}
          &parselistfile("$dpath","$ifilename");
        } 
        elsif ($line =~ /^(.+\.s*v)/)
        {
          my $f = $1;  
          if ($debug) {print " ~ FILE FOUND $includedblockpath/$f ($f)\n"};
          if ($f =~ /\$([A-Z0-9-_]+)\/(.*.v)/)
          {
            #print "$1 - $2\n";
            my $fa;
            $fa = $ENV { $1};
            print fulllistfile "$fa/$2\n";
          } else {
            print fulllistfile "$includedblockpath/$f\n";
          }  
        }
      }
    }
    close (listfile);
  }
}

# Main
#########################


if($debug) {print "Generation of $outputfilename file which lists all the $part files required for $blockname compilation\n"};
open (fulllistfile,">$outputfilename");

my($path) = `cd ..;pwd`;
chop ($path);



while ($path !~ /.*\/$blockname$/)
{

  $path = `cd $path;cd ..;pwd`;
  chop ($path);
  if ($path eq "/")
  {
    close(fulllistfile);
    print "ERROR:$blockname not found\n";
    exit 1;
  }
}  


if ($mode eq 1)
{
  my($listname) = $pathtolist;
  $listname =~ s/^.*\///g;
  my($pathname) = $pathtolist;
  $pathname =~ s/\/$listname//g;
  
  print "input file : $pathname/$listname\n";
  &parselistfile ("$pathname","$listname");
} else {
  print "input file : $path/verilog/$part/$blockname\_$part.list\n";
  &parselistfile ("$path/verilog/$part","$blockname\_$part.list");
}

close(fulllistfile);
print "$outputfilename generation completed\n";

#-------------------------------------------------------------------------------
#- End of file
#-------------------------------------------------------------------------------
