#!/usr/bin/perl
#
# /space/home/oringot/svnroot/rw_wlan_nx/trunk/Projects/WLAN_NX_REF_IP/HW/SB/rw_nx_top/verilog/rtl/rw_nx_top_rtl.list
#
use strict;
no strict 'refs';

my %path_table={}; # table of already parsed .list files
my $global_tag="HEAD";

parse_list(@ARGV[0],0);

################################################################################
# parse_list
################################################################################
sub parse_list
{
  my $file_list = @_[0];
  my $level     = @_[1];
  my $file;
  my $fpath;
  my $cdir="";
  
  $cdir=$1 if($file_list =~ /(.+)\//);

  $file=open_file($file_list);
  die "error: can't open $file_list !\n" if($file==0);
  
  while(<$file>)
  {
    if($_ =~ /^[ \t]*INCLUDE[ \t]+([a-zA-Z0-9_\.\$\/]+)/)
    {
      $fpath=resolve_path($1);
      if($path_table{$fpath}==1)
      {
        # already parsed, skipped
        next;
      }
      else
      {
        # new INCLUDE
        $path_table{$fpath}=1; 
      }
      parse_list(resolve_path($1),$level+1);
    }
    elsif($_ =~ /^[ \t]*([a-zA-Z0-9_\.\$\/]+[a-zA-Z0-9_\-\.\$\/]+)/)
    {
      # new file
      $fpath=resolve_path($1);
      if($fpath =~ /https:\/\// or $fpath =~ /^\//)
      {
         # Absolute Path
         printf "%s\n",$fpath;
      }
      else
      {
         # Relative Path
         printf "%s/",$cdir if($cdir ne "");
         printf "%s\n",$fpath;
      }
    }
    else
    {
      # ignored
      next;
    }
  }
  
  close_file($file);
}

################################################################################
# resolve_path
################################################################################
sub resolve_path
{
  my $s = @_[0];
  my @varlist=();
  
  # extract all path variables
  #printf "resolve_path: in  %s\n",$s;
  while($s =~ m/\$([0-9a-zA-Z_\.]+)/g)
  {
    push @varlist,$1;  
  }
  
  # resolve all path variables
  foreach my $v (@varlist)
  {
    die "error: environment variable $v not defined !" if($ENV{$v} eq "");
    $s =~ s/\$$v/$ENV{$v}/g;
  }
  #printf "resolve_path: out %s\n",$s;
  return $s;
}

################################################################################
# open_file
################################################################################
sub open_file
{
  my $fname=@_[0];
  my $fh;
  my $tfname;
  my $status;
  my $tag=$global_tag;
  
  if($fname =~ /^(([r0-9]+),)?(http|https):/)
  {
    if($2 ne "")
    {
      $tag   = $2;
      $fname =~ s/^[r0-9]+,//g;
    }
    
    # url
    $tfname=`mktemp`;
    die "error: can't create temporary file !\n" if($?!=0);
    
    #print "svn export -r $tag $fname\@$tag $tfname\n";
    $status=`svn export -r $tag $fname\@$tag $tfname`;
    die "error:problem while exporting $fname from svn !\n" if($?!=0);
    open($fh,$tfname) or die "error: can't open $fname !\n";
    return $fh;
  }
  else
  {
    # file
    open($fh,$fname) or die "error: can't open $fname !\n";
    return $fh;
  }
}

################################################################################
# close_file
################################################################################
sub close_file
{
  my $fh=@_[0];
  close($fh);
}
