#!/bin/bash
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthournout $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 35564 $
#/ $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Automatic register extraction script
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/////////////////////////////////////////////////////////////////////////////

REGMODEL_DIR="../../../tb_env/sv/wlan_env/common/regmodel/src/"
MEMMAP_OFFSET="\`MEMMAP_OFFSET"

if [ ! -d tmp_reg ]
then
  mkdir tmp_reg
fi

cd tmp_reg

# Clean old files
rm *.xls *.xml *.sv ahb_base_addresses.txt

# Export last revision of each xls register description file

if [ -e $SOURCESLIB/Documents/Specifications_HE/HW ]
then
  ln -s $SOURCESLIB/Documents/Specifications_HE/HW/MAC/Registers/*.xls .
  ln -s $SOURCESLIB/Documents/Specifications_HE/HW/Modem/Registers/*.xls .
  ln -s $SOURCESLIB/Documents/Specifications_HE/HW/Platform/Registers/*.xls .
else
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/MAC/Registers/RW-WLAN-nX-MAC-HW-Reg-Core.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/MAC/Registers/RW-WLAN-nX-MAC-HW-Reg-Pl.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Modem/Registers/RW-WLAN-nX-MDMCore-ConfigREG.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Modem/Registers/RW-WLAN-nX-RC-KARST-HW-REG.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Modem/Registers/RW-WLAN-nX-RIUKARST-HW-REG.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Modem/Registers/RW-WLAN-nX-MACBYPASS-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-PTA-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-SYSCTRL-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-LA-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-IPC-EMB-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-IPC-APP-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-INTC-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-DMA-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-HSU-Reg.xls
  svn export https://svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/Documents/Specifications_HE/HW/Platform/Registers/RW-WLAN-nX-CRM-Reg.xls
fi

# Call macro generation script for each xls register description file
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name MACCORE -xls RW-WLAN-nX-MAC-HW-Reg-Core.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name MACPL -xls RW-WLAN-nX-MAC-HW-Reg-Pl.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name PHYCONFIG -xls RW-WLAN-nX-MDMCore-ConfigREG.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name RCKARST -xls RW-WLAN-nX-RC-KARST-HW-REG.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name RIUKARST -xls RW-WLAN-nX-RIUKARST-HW-REG.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name PTA -xls RW-PTA-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name SYSCTRL -xls RW-WLAN-nX-SYSCTRL-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name LA -xls RW-WLAN-nX-LA-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name IPCEMB  -xls RW-WLAN-nX-IPC-EMB-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name IPCAPP -xls RW-WLAN-nX-IPC-APP-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name INTC -xls RW-WLAN-nX-INTC-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name DMA -xls RW-WLAN-nX-DMA-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name HSU -xls RW-WLAN-nX-HSU-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name MACBYPASS -xls RW-WLAN-nX-MACBYPASS-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v
$SOURCESLIB/bin/gen_reg/gen_reg_model.sh -name CRM -xls RW-WLAN-nX-CRM-Reg.xls -basea $SOURCESLIB/SIMS_UVM/defines/tbDefines.v

# Generate the top level register model
/usr/bin/python $SOURCESLIB/bin/gen_reg/raltop.py -b UVM_CVR_ADDR_MAP -r UVM_CVR_FIELD_VALS -n UVM_LITTLE_ENDIAN -t REGMODEL -o ${MEMMAP_OFFSET}

# Move generated verilog macros files to regmodel directory
mv MACCORE_reg_block.sv     ${REGMODEL_DIR}
mv MACCORE_reg_block_pkg.sv     ${REGMODEL_DIR}
mv MACPL_reg_block.sv     ${REGMODEL_DIR}
mv MACPL_reg_block_pkg.sv     ${REGMODEL_DIR}
mv PHYCONFIG_reg_block.sv ${REGMODEL_DIR}
mv PHYCONFIG_reg_block_pkg.sv ${REGMODEL_DIR}
mv RCKARST_reg_block.sv   ${REGMODEL_DIR}
mv RCKARST_reg_block_pkg.sv   ${REGMODEL_DIR}
mv RIUKARST_reg_block.sv  ${REGMODEL_DIR}
mv RIUKARST_reg_block_pkg.sv  ${REGMODEL_DIR}
mv PTA_reg_block.sv       ${REGMODEL_DIR}
mv PTA_reg_block_pkg.sv       ${REGMODEL_DIR}
mv SYSCTRL_reg_block.sv ${REGMODEL_DIR}
mv SYSCTRL_reg_block_pkg.sv ${REGMODEL_DIR}
mv LA_reg_block.sv ${REGMODEL_DIR}
mv LA_reg_block_pkg.sv ${REGMODEL_DIR}
mv IPCEMB_reg_block.sv ${REGMODEL_DIR}
mv IPCEMB_reg_block_pkg.sv ${REGMODEL_DIR}
mv IPCAPP_reg_block.sv ${REGMODEL_DIR}
mv IPCAPP_reg_block_pkg.sv ${REGMODEL_DIR}
mv INTC_reg_block.sv ${REGMODEL_DIR}
mv INTC_reg_block_pkg.sv ${REGMODEL_DIR}
mv DMA_reg_block.sv ${REGMODEL_DIR}
mv DMA_reg_block_pkg.sv ${REGMODEL_DIR}
mv HSU_reg_block.sv ${REGMODEL_DIR}
mv HSU_reg_block_pkg.sv ${REGMODEL_DIR}
mv MACBYPASS_reg_block.sv ${REGMODEL_DIR}
mv MACBYPASS_reg_block_pkg.sv ${REGMODEL_DIR}
mv CRM_reg_block.sv ${REGMODEL_DIR}
mv CRM_reg_block_pkg.sv ${REGMODEL_DIR}

# make sure the top level register block file name matches the one passed to raltop.py!
mv REGMODEL_reg_block.sv ${REGMODEL_DIR}
mv REGMODEL_pkg.sv ${REGMODEL_DIR}
cd ..
