#!/bin/bash
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthou $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 31589 $
#/ $Date: 2017-08-30 17:54:33 +0200 (Wed, 30 Aug 2017) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Automatic register extraction script
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/////////////////////////////////////////////////////////////////////////////


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Display Help                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
DisplayHelp()
{
  echo "
    This script creates the register module based on the XLS register definition.
    It also generates a second file (called <blockname>_macros_tb.v) with GET and SET macros
    
    Options:
      -xls   <xls filename>     : Excel file with the register definition

      -name  <blockname>        : Name of the block

      -h | -help                : Display this message

    Usage :
      gen_reg.sh -xls <xls filename> -name <block name>

  "
}

#--------------------------------------------------------------------#
#--- PrintErrorWarning <message>                                  ---#
#--------------------------------------------------------------------#
PrintErrorWarning ()
{
  echo "ERROR: $*"
  echo ""
  exit 2
}


NAME=0
XLS=0

while test $# != 0
do

  arg="$1"
  OPTION=`echo $arg | sed 's/^-//'`
  shift
  case ${OPTION}
  in
    name)  
      NAME="$1"
      shift
    ;;
    xls)  
      XLS="$1"
      shift
    ;;
    h | help)  
      #------------------------------------------------------------------------#
      #--- Display Help                                                     ---#
      #------------------------------------------------------------------------#
      DisplayHelp
      exit 1
    ;;
    *)  
      #------------------------------------------------------------------------#
      #--- Unknown Option                                                   ---#
      #------------------------------------------------------------------------#
      echo "Unknown Option ${OPTION}"
      DisplayHelp
      exit 1
    ;;
  esac
done


if [ ! -f $XLS ]
then
  PrintErrorWarning "$XLS filename not found"
fi

if [ $NAME == "0" ]
then
  PrintErrorWarning "The block name has not been set"
fi

XML=`echo $XLS | sed 's/.*\///g' | sed 's/.xls/.xml/'`
echo "Generate Registers for $NAME using register definition from $XLS"
$SOURCESLIB/bin/gen_reg/reg_xls2xml.pl $XLS

if [ ! -f $XML ]
then
  PrintErrorWarning "$XML filename not found"
fi


/usr/bin/python $SOURCESLIB/bin/gen_reg/xml2verilog.py -x $XML -e $NAME -t $SOURCESLIB/bin/gen_reg/task_ref.v


