#!/usr/bin/perl
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthou $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 30649 $
#/ $Date: 2017-06-06 11:33:55 +0200 (Tue, 06 Jun 2017) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Generates a Word document with the 
#/			register definition
#/			defined into a XML file
#/ Application Note : 
#/      printreg.pl <input XML file> <output Ms Word XML file>
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/bin/gen_reg/printreg.pl $
#/
#/////////////////////////////////////////////////////////////////////////////

use XML::Simple;
use Data::Dumper;



$inputname = $ARGV[0];
$outputname = $ARGV[1];
$debug = $ARGV[2];
$print_verif = 0;



sub headerofwordfile {

print fileoutput '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?mso-application progid="Word.Document"?>
<w:wordDocument xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" w:macrosPresent="no" w:embeddedObjPresent="no" w:ocxPresent="no" xml:space="preserve">
<w:fonts><w:defaultFonts w:ascii="Calibri" w:fareast="Calibri" w:h-ansi="Calibri" w:cs="Calibri"/></w:fonts>
<w:lists><w:listDef w:listDefId="0"><w:lsid w:val="2E221C24"/><w:plt w:val="Multilevel"/><w:tmpl w:val="92EA9D3E"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:pStyle w:val="Titre1"/><w:lvlText w:val="%1"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="432"/></w:tabs><w:ind w:left="432" w:hanging="432"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:pStyle w:val="Titre2"/><w:lvlText w:val="%1.%2"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="576"/></w:tabs><w:ind w:left="576" w:hanging="576"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:pStyle w:val="Titre3"/><w:lvlText w:val="%1.%2.%3"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1713"/></w:tabs><w:ind w:left="1713" w:hanging="720"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:pStyle w:val="Titre4"/><w:lvlText w:val="%1.%2.%3.%4"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="864"/></w:tabs><w:ind w:left="864" w:hanging="864"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:pStyle w:val="Titre5"/><w:lvlText w:val="%1.%2.%3.%4.%5"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1008"/></w:tabs><w:ind w:left="1008" w:hanging="1008"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:pStyle w:val="Titre6"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1152"/></w:tabs><w:ind w:left="1152" w:hanging="1152"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:pStyle w:val="Titre7"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1296"/></w:tabs><w:ind w:left="1296" w:hanging="1296"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:pStyle w:val="Titre8"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1440"/></w:tabs><w:ind w:left="1440" w:hanging="1440"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:pStyle w:val="Titre9"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8.%9"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1584"/></w:tabs><w:ind w:left="1584" w:hanging="1584"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl></w:listDef><w:list w:ilfo="1"><w:ilst w:val="0"/></w:list></w:lists>
<w:styles><w:versionOfBuiltInStylenames w:val="4"/><w:latentStyles w:defLockedState="off" w:latentStyleCount="156"/>
<w:style w:type="paragraph" w:default="on" w:styleId="Normal"><w:name w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:spacing w:after="240"/><w:jc w:val="both"/></w:pPr><w:rPr><w:rFonts w:ascii="Calibri" w:h-ansi="Calibri"/><wx:font wx:val="Calibri"/><w:lang w:val="EN-US" w:fareast="FR" w:bidi="AR-SA"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Code"><w:name w:val="Code" /><w:basedOn w:val="Normal" /><w:rsid w:val="00E80E07" />- <w:pPr><w:pStyle w:val="Code" /><w:jc w:val="left" /></w:pPr>- <w:rPr><w:rFonts w:ascii="Courier New" w:h-ansi="Courier New" /><wx:font wx:val="Courier New" /><w:i /><w:sz w:val="18" /></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Info"><w:name w:val="Info"/><w:basedOn w:val="Normal"/><w:rsid w:val="00926326"/><w:pPr><w:pStyle w:val="Info"/><w:jc w:val="left"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:color w:val="FF0000"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre1"><w:name w:val="heading 1"/><wx:uiName wx:val="Titre 1"/><w:basedOn w:val="Normal"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre1"/><w:keepNext/><w:pageBreakBefore/><w:listPr><w:ilfo w:val="1"/></w:listPr><w:shd w:val="solid" w:color="E6F5F5" w:fill="FFFFFF" wx:bgcolor="E6F5F5"/><w:outlineLvl w:val="0"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:kern w:val="28"/><w:sz w:val="28"/><w:sz-cs w:val="28"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre2"><w:name w:val="heading 2"/><wx:uiName wx:val="Titre 2"/><w:basedOn w:val="Titre1"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre2"/><w:pageBreakBefore w:val="off"/><w:listPr><w:ilvl w:val="1"/></w:listPr><w:tabs><w:tab w:val="left" w:pos="763"/></w:tabs><w:spacing w:after="120"/><w:outlineLvl w:val="1"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:sz w:val="24"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre3"><w:name w:val="heading 3"/><wx:uiName wx:val="Titre 3"/><w:basedOn w:val="Titre2"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre3"/><w:listPr><w:ilvl w:val="2"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="763"/><w:tab w:val="left" w:pos="950"/></w:tabs><w:ind w:left="0" w:first-line="0"/><w:outlineLvl w:val="2"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:sz w:val="20"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre4"><w:name w:val="heading 4"/><wx:uiName wx:val="Titre 4"/><w:basedOn w:val="Titre3"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre4"/><w:listPr><w:ilvl w:val="3"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="950"/><w:tab w:val="left" w:pos="1152"/></w:tabs><w:outlineLvl w:val="3"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre5"><w:name w:val="heading 5"/><wx:uiName wx:val="Titre 5"/><w:basedOn w:val="Titre4"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre5"/><w:listPr><w:ilvl w:val="4"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1152"/><w:tab w:val="left" w:pos="1339"/></w:tabs><w:outlineLvl w:val="4"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre6"><w:name w:val="heading 6"/><wx:uiName wx:val="Titre 6"/><w:basedOn w:val="Titre5"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre6"/><w:listPr><w:ilvl w:val="5"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1339"/><w:tab w:val="left" w:pos="1526"/></w:tabs><w:outlineLvl w:val="5"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre7"><w:name w:val="heading 7"/><wx:uiName wx:val="Titre 7"/><w:basedOn w:val="Titre6"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre7"/><w:listPr><w:ilvl w:val="6"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1526"/><w:tab w:val="left" w:pos="1728"/></w:tabs><w:outlineLvl w:val="6"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre8"><w:name w:val="heading 8"/><wx:uiName wx:val="Titre 8"/><w:basedOn w:val="Titre7"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre8"/><w:listPr><w:ilvl w:val="7"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1728"/><w:tab w:val="left" w:pos="1915"/></w:tabs><w:outlineLvl w:val="7"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre9"><w:name w:val="heading 9"/><wx:uiName wx:val="Titre 9"/><w:basedOn w:val="Titre8"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre9"/><w:listPr><w:ilvl w:val="8"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1915"/><w:tab w:val="left" w:pos="2102"/></w:tabs><w:outlineLvl w:val="8"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="character" w:default="on" w:styleId="Policepardfaut"><w:name w:val="Default Paragraph Font"/><wx:uiName wx:val="Police par defaut"/><w:semiHidden/></w:style>
<w:style w:type="table" w:default="on" w:styleId="TableauNormal"><w:name w:val="Normal Table"/><wx:uiName wx:val="Tableau Normal"/><w:semiHidden/><w:rPr><wx:font wx:val="Calibri"/></w:rPr><w:tblPr><w:tblInd w:w="0" w:type="dxa"/><w:tblCellMar><w:top w:w="0" w:type="dxa"/><w:left w:w="108" w:type="dxa"/><w:bottom w:w="0" w:type="dxa"/><w:right w:w="108" w:type="dxa"/></w:tblCellMar></w:tblPr></w:style>
<w:style w:type="list" w:default="on" w:styleId="Aucuneliste"><w:name w:val="No List"/><wx:uiName wx:val="Aucune liste"/><w:semiHidden/></w:style>
<w:style w:type="paragraph" w:styleId="CustomTableTitle"><w:name w:val="CustomTableTitle"/><w:basedOn w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableTitle"/><w:spacing w:before="20" w:after="20"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:sz w:val="18"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="CustomTableBody"><w:name w:val="CustomTableBody"/><w:basedOn w:val="CustomTableTitle"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableBody"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b w:val="off"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Lgende"><w:name w:val="caption"/><wx:uiName wx:val="Legende"/><w:basedOn w:val="Normal"/><w:next w:val="Normal"/><w:autoRedefine/><w:semiHidden/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Lgende"/><w:jc w:val="center"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:sz w:val="16"/></w:rPr></w:style>
</w:styles>
<w:docPr><w:view w:val="print"/><w:zoom w:percent="100"/><w:doNotEmbedSystemFonts/><w:proofState w:spelling="clean" w:grammar="clean"/><w:attachedTemplate w:val=""/><w:defaultTabStop w:val="708"/><w:hyphenationZone w:val="425"/><w:punctuationKerning/><w:characterSpacingControl w:val="DontCompress"/><w:optimizeForBrowser/><w:validateAgainstSchema/><w:saveInvalidXML w:val="off"/><w:ignoreMixedContent w:val="off"/><w:alwaysShowPlaceholderText w:val="off"/><w:compat><w:breakWrappedTables/><w:snapToGridInCell/><w:wrapTextWithPunct/><w:useAsianBreakRules/><w:dontGrowAutofit/></w:compat></w:docPr>
<w:body><wx:sect><aml:annotation aml:id="0" w:type="Word.Bookmark.Start" w:name="_Toc140379585"/>
<wx:sub-section>';
}



sub headerofwordfile2 {

print fileoutput '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?mso-application progid="Word.Document"?>
<w:wordDocument xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml" xmlns:wsp="http://schemas.microsoft.com/office/word/2003/wordml/sp2" xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" w:macrosPresent="no" w:embeddedObjPresent="no" w:ocxPresent="no" xml:space="preserve"><w:ignoreSubtree w:val="http://schemas.microsoft.com/office/word/2003/wordml/sp2"/><o:DocumentProperties><o:Author>Jerome Vanthournout</o:Author><o:LastAuthor>Jerome Vanthournout</o:LastAuthor><o:Revision>2</o:Revision><o:TotalTime>1</o:TotalTime><o:Created>2016-09-07T08:30:00Z</o:Created><o:LastSaved>2016-09-07T08:30:00Z</o:LastSaved><o:Pages>1</o:Pages><o:Words>234</o:Words><o:Characters>1339</o:Characters><o:Lines>11</o:Lines><o:Paragraphs>3</o:Paragraphs><o:CharactersWithSpaces>1570</o:CharactersWithSpaces><o:Version>14</o:Version></o:DocumentProperties>
<w:fonts><w:defaultFonts w:ascii="Calibri" w:fareast="Calibri" w:h-ansi="Calibri" w:cs="Calibri"/></w:fonts>
<w:lists><w:listDef w:listDefId="0"><w:lsid w:val="2E221C24"/><w:plt w:val="Multilevel"/><w:tmpl w:val="92EA9D3E"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:pStyle w:val="Titre1"/><w:lvlText w:val="%1"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="432"/></w:tabs><w:ind w:left="432" w:hanging="432"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:pStyle w:val="Titre2"/><w:lvlText w:val="%1.%2"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="576"/></w:tabs><w:ind w:left="576" w:hanging="576"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:pStyle w:val="Titre3"/><w:lvlText w:val="%1.%2.%3"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1713"/></w:tabs><w:ind w:left="1713" w:hanging="720"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:pStyle w:val="Titre4"/><w:lvlText w:val="%1.%2.%3.%4"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="864"/></w:tabs><w:ind w:left="864" w:hanging="864"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:pStyle w:val="Titre5"/><w:lvlText w:val="%1.%2.%3.%4.%5"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1008"/></w:tabs><w:ind w:left="1008" w:hanging="1008"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:pStyle w:val="Titre6"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1152"/></w:tabs><w:ind w:left="1152" w:hanging="1152"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:pStyle w:val="Titre7"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1296"/></w:tabs><w:ind w:left="1296" w:hanging="1296"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:pStyle w:val="Titre8"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1440"/></w:tabs><w:ind w:left="1440" w:hanging="1440"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:pStyle w:val="Titre9"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8.%9"/><w:lvlJc w:val="left"/><w:pPr><w:tabs><w:tab w:val="list" w:pos="1584"/></w:tabs><w:ind w:left="1584" w:hanging="1584"/></w:pPr><w:rPr><w:rFonts w:hint="default"/></w:rPr></w:lvl></w:listDef><w:list w:ilfo="1"><w:ilst w:val="0"/></w:list></w:lists>
<w:styles><w:versionOfBuiltInStylenames w:val="4"/><w:latentStyles w:defLockedState="off" w:latentStyleCount="156"/>
<w:style w:type="paragraph" w:default="on" w:styleId="Normal"><w:name w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:spacing w:after="240"/><w:jc w:val="both"/></w:pPr><w:rPr><w:rFonts w:ascii="Calibri" w:h-ansi="Calibri"/><wx:font wx:val="Calibri"/><w:lang w:val="EN-US" w:fareast="FR" w:bidi="AR-SA"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Code"><w:name w:val="Code" /><w:basedOn w:val="Normal" /><w:rsid w:val="00E80E07" />- <w:pPr><w:pStyle w:val="Code" /><w:jc w:val="left" /></w:pPr>- <w:rPr><w:rFonts w:ascii="Courier New" w:h-ansi="Courier New" /><wx:font wx:val="Courier New" /><w:i /><w:sz w:val="18" /></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Info"><w:name w:val="Info"/><w:basedOn w:val="Normal"/><w:rsid w:val="00926326"/><w:pPr><w:pStyle w:val="Info"/><w:jc w:val="left"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:color w:val="FF0000"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre1"><w:name w:val="heading 1"/><wx:uiName wx:val="Titre 1"/><w:basedOn w:val="Normal"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre1"/><w:keepNext/><w:pageBreakBefore/><w:listPr><w:ilfo w:val="1"/></w:listPr><w:shd w:val="solid" w:color="E6F5F5" w:fill="FFFFFF" wx:bgcolor="E6F5F5"/><w:outlineLvl w:val="0"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:kern w:val="28"/><w:sz w:val="28"/><w:sz-cs w:val="28"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre2"><w:name w:val="heading 2"/><wx:uiName wx:val="Titre 2"/><w:basedOn w:val="Titre1"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre2"/><w:pageBreakBefore w:val="off"/><w:listPr><w:ilvl w:val="1"/></w:listPr><w:tabs><w:tab w:val="left" w:pos="763"/></w:tabs><w:spacing w:after="120"/><w:outlineLvl w:val="1"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:sz w:val="24"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre3"><w:name w:val="heading 3"/><wx:uiName wx:val="Titre 3"/><w:basedOn w:val="Titre2"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre3"/><w:listPr><w:ilvl w:val="2"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="763"/><w:tab w:val="left" w:pos="950"/></w:tabs><w:ind w:left="0" w:first-line="0"/><w:outlineLvl w:val="2"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:sz w:val="20"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre4"><w:name w:val="heading 4"/><wx:uiName wx:val="Titre 4"/><w:basedOn w:val="Titre3"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre4"/><w:listPr><w:ilvl w:val="3"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="950"/><w:tab w:val="left" w:pos="1152"/></w:tabs><w:outlineLvl w:val="3"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre5"><w:name w:val="heading 5"/><wx:uiName wx:val="Titre 5"/><w:basedOn w:val="Titre4"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre5"/><w:listPr><w:ilvl w:val="4"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1152"/><w:tab w:val="left" w:pos="1339"/></w:tabs><w:outlineLvl w:val="4"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre6"><w:name w:val="heading 6"/><wx:uiName wx:val="Titre 6"/><w:basedOn w:val="Titre5"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre6"/><w:listPr><w:ilvl w:val="5"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1339"/><w:tab w:val="left" w:pos="1526"/></w:tabs><w:outlineLvl w:val="5"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre7"><w:name w:val="heading 7"/><wx:uiName wx:val="Titre 7"/><w:basedOn w:val="Titre6"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre7"/><w:listPr><w:ilvl w:val="6"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1526"/><w:tab w:val="left" w:pos="1728"/></w:tabs><w:outlineLvl w:val="6"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre8"><w:name w:val="heading 8"/><wx:uiName wx:val="Titre 8"/><w:basedOn w:val="Titre7"/><w:next w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre8"/><w:listPr><w:ilvl w:val="7"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1728"/><w:tab w:val="left" w:pos="1915"/></w:tabs><w:outlineLvl w:val="7"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Titre9"><w:name w:val="heading 9"/><wx:uiName wx:val="Titre 9"/><w:basedOn w:val="Titre8"/><w:next w:val="Normal"/><w:autoRedefine/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Titre9"/><w:listPr><w:ilvl w:val="8"/></w:listPr><w:tabs><w:tab w:val="clear" w:pos="1915"/><w:tab w:val="left" w:pos="2102"/></w:tabs><w:outlineLvl w:val="8"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/></w:rPr></w:style>
<w:style w:type="character" w:default="on" w:styleId="Policepardfaut"><w:name w:val="Default Paragraph Font"/><wx:uiName wx:val="Police par defaut"/><w:semiHidden/></w:style>
<w:style w:type="table" w:default="on" w:styleId="TableauNormal"><w:name w:val="Normal Table"/><wx:uiName wx:val="Tableau Normal"/><w:semiHidden/><w:rPr><wx:font wx:val="Calibri"/></w:rPr><w:tblPr><w:tblInd w:w="0" w:type="dxa"/><w:tblCellMar><w:top w:w="0" w:type="dxa"/><w:left w:w="0" w:type="dxa"/><w:bottom w:w="0" w:type="dxa"/><w:right w:w="0" w:type="dxa"/></w:tblCellMar></w:tblPr></w:style>
<w:style w:type="list" w:default="on" w:styleId="Aucuneliste"><w:name w:val="No List"/><wx:uiName wx:val="Aucune liste"/><w:semiHidden/></w:style>
<w:style w:type="paragraph" w:styleId="Code"><w:name w:val="Code"/><w:basedOn w:val="Normal"/><w:rsid w:val="00E80E07"/><w:pPr><w:jc w:val="left"/></w:pPr><w:rPr><w:rFonts w:ascii="Courier New" w:h-ansi="Courier New"/><wx:font wx:val="Courier New"/><w:i/><w:sz w:val="18"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Info"><w:name w:val="Info"/><w:basedOn w:val="Normal"/><w:rsid w:val="00926326"/><w:pPr><w:jc w:val="left"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:color w:val="FF0000"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="CustomTableTitle"><w:name w:val="CustomTableTitle"/><w:basedOn w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableTitle"/><w:spacing w:before="20" w:after="20"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:sz w:val="18"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="CustomTableBody"><w:name w:val="CustomTableBody"/><w:basedOn w:val="CustomTableTitle"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableBody"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b w:val="off"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="RegCustomTableTitle"><w:name w:val="CustomTableTitle"/><w:basedOn w:val="Normal"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableTitle"/><w:spacing w:before="20" w:after="20"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:sz w:val="18"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="RegCustomTableBody"><w:name w:val="CustomTableBody"/><w:basedOn w:val="CustomTableTitle"/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="CustomTableBody"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b w:val="off"/></w:rPr></w:style>
<w:style w:type="paragraph" w:styleId="Lgende"><w:name w:val="caption"/><wx:uiName wx:val="Legende"/><w:basedOn w:val="Normal"/><w:next w:val="Normal"/><w:autoRedefine/><w:semiHidden/><w:rsid w:val="000B4EE7"/><w:pPr><w:pStyle w:val="Lgende"/><w:jc w:val="center"/></w:pPr><w:rPr><wx:font wx:val="Calibri"/><w:b/><w:sz w:val="16"/></w:rPr></w:style>
</w:styles>
<w:divs><w:div w:id="505940925"><w:bodyDiv w:val="on"/><w:marLeft w:val="0"/><w:marRight w:val="0"/><w:marTop w:val="0"/><w:marBottom w:val="0"/><w:divBdr><w:top w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:left w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:bottom w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:right w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/></w:divBdr></w:div><w:div w:id="1309673466"><w:bodyDiv w:val="on"/><w:marLeft w:val="0"/><w:marRight w:val="0"/><w:marTop w:val="0"/><w:marBottom w:val="0"/><w:divBdr><w:top w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:left w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:bottom w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/><w:right w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/></w:divBdr></w:div></w:divs>
<w:shapeDefaults><o:shapedefaults v:ext="edit" spidmax="1026"/><o:shapelayout v:ext="edit"><o:idmap v:ext="edit" data="1"/></o:shapelayout></w:shapeDefaults>
<w:docPr><w:view w:val="print"/><w:zoom w:percent="100"/><w:doNotEmbedSystemFonts/><w:proofState w:spelling="clean" w:grammar="clean"/><w:defaultTabStop w:val="708"/><w:hyphenationZone w:val="425"/><w:punctuationKerning/><w:characterSpacingControl w:val="DontCompress"/><w:optimizeForBrowser/><w:validateAgainstSchema/><w:saveInvalidXML w:val="off"/><w:ignoreMixedContent w:val="off"/><w:alwaysShowPlaceholderText w:val="off"/><w:compat><w:breakWrappedTables/><w:snapToGridInCell/><w:wrapTextWithPunct/><w:useAsianBreakRules/><w:dontGrowAutofit/></w:compat>
<wsp:rsids><wsp:rsidRoot wsp:val="005F08D4"/><wsp:rsid wsp:val="000F272E"/><wsp:rsid wsp:val="005F08D4"/><wsp:rsid wsp:val="00D5033B"/></wsp:rsids></w:docPr>
<w:body><wx:sect><aml:annotation aml:id="0" w:type="Word.Bookmark.Start" w:name="_Toc140379585"/>
<wx:sub-section>';
}



sub newtitle {
	my $level = $_[0];
	my $name = replace_special_char($_[1]);
	print fileoutput '<w:p>
		<w:pPr><w:pStyle w:val="Titre'.$level.'"/><w:listPr>
		<wx:t wx:val="1.1" wx:wTabBefore="0" wx:wTabAfter="240"/>
		<wx:font wx:val="Calibri"/></w:listPr>
		</w:pPr>
		<w:r><w:t>'.$name.'</w:t></w:r>
		<aml:annotation aml:id="'.$currentID.'" w:type="Word.Bookmark.End"/>
		</w:p>';
	$currentID++;
}

sub newparagraph {
	my $text = $_[0];
	print fileoutput '<w:p><w:r><w:t>'.$text.'</w:t></w:r></w:p>';
}

sub newcolumn {
	my $text = replace_special_char($_[0]);
	my $size = $_[1];
	my $mergesize = $_[2];

	print fileoutput '<w:tc>
	<w:tcPr>
	<w:shd w:val="solid" w:color="'.$bgcolor.'" w:fill="auto" wx:bgcolor="'.$bgcolor.'"/>
	<w:tcW w:w="'.$size.'" w:type="dxa"/>
	<w:gridSpan w:val="'.$mergesize.'"/>
	<w:tcMar><w:left w:w="57" w:type="dxa"/><w:right w:w="57" w:type="dxa"/></w:tcMar>
	</w:tcPr>
	<w:p>
	<w:pPr><w:pStyle w:val="'.$font.'"/><w:jc w:val="'.$align.'"/></w:pPr>
	<w:r><w:t>'.$text.'</w:t></w:r>
	</w:p>
	</w:tc>';
}
sub newrow {
	my $text1 = $_[0];
	my $text2 = $_[1];
	my $text3 = $_[2];
	my $text4 = $_[3];
	
	print fileoutput '<w:tr>
	<w:tblPrEx><w:tblCellMar><w:top w:w="0" w:type="dxa"/><w:bottom w:w="0" w:type="dxa"/></w:tblCellMar></w:tblPrEx>
	<w:trPr><w:jc w:val="center"/></w:trPr>';
	
	$align = "left";
	newcolumn($text1,2400,1);
	$align = "center";
	newcolumn($text2,500,1);
	newcolumn($text3,500,1);
	$align = "left";
	newcolumn($text4,6000,1);
	
	print fileoutput '</w:tr>';
}
sub newrowmerged {
	my $text1 = $_[0];
	my $text2 = $_[1];
	my $text3 = $_[2];
	my $text4 = $_[3];
	
	print fileoutput '<w:tr>
	<w:tblPrEx><w:tblCellMar><w:top w:w="0" w:type="dxa"/><w:bottom w:w="0" w:type="dxa"/></w:tblCellMar></w:tblPrEx>
	<w:trPr><w:jc w:val="center"/></w:trPr>';
	
	newcolumn($text1,9400,4);
	
	print fileoutput '</w:tr>';
}


sub newtable {
	print fileoutput '<w:tbl>
	<w:tblPr>
	<w:tblW w:w="0" w:type="auto"/>
	<w:jc w:val="center"/>
	<w:tblBorders>
	<w:top w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	<w:right w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	<w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	<w:insideH w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	<w:insideV w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
	</w:tblBorders>
	<w:tblLayout w:type="Fixed"/>
	<w:tblCellMar><w:left w:w="0" w:type="dxa"/><w:right w:w="0" w:type="dxa"/>
	</w:tblCellMar>
	</w:tblPr>
	<w:tblGrid><w:gridCol w:w="1529"/><w:gridCol w:w="2438"/></w:tblGrid>';
}
	
sub endoftable {
	my $text = $_[0];
	
	print fileoutput '</w:tbl>';

	print fileoutput '
	<aml:annotation aml:id="B1'.$currentID.'" w:type="Word.Bookmark.Start" w:name="_Ref466861695"/>
	<aml:annotation aml:id="B2'.$currentID.'" w:type="Word.Bookmark.Start" w:name="_Toc139863224"/>
	<w:proofErr w:type="gramStart"/>
	<w:p>
	<w:pPr><w:pStyle w:val="Lgende"/></w:pPr>
	<w:r>
	<w:t>Table </w:t>
	</w:r>
	<w:r><w:fldChar w:fldCharType="begin"/></w:r>
	<w:r><w:instrText> STYLEREF 1 \s </w:instrText></w:r>
	<w:r><w:fldChar w:fldCharType="separate"/></w:r>
	<w:r>
	<w:rPr><w:noProof/></w:rPr>
	<w:t>5</w:t>
	</w:r>
	<w:r><w:fldChar w:fldCharType="end"/></w:r>
	<w:r>
	<w:t>.</w:t>
	</w:r>
	<w:proofErr w:type="gramEnd"/>
	<w:r><w:fldChar w:fldCharType="begin"/></w:r>
	<w:r><w:instrText> SEQ Table \* ARABIC \s 1 </w:instrText></w:r>
	<w:r><w:fldChar w:fldCharType="separate"/></w:r>
	<w:r><w:rPr><w:noProof/></w:rPr><w:t>1</w:t></w:r>
	<w:r><w:fldChar w:fldCharType="end"/></w:r>
	<aml:annotation aml:id="B1'.$currentID.'" w:type="Word.Bookmark.End"/><w:r><w:t> - '.$text.'</w:t></w:r>
	<aml:annotation aml:id="B2'.$currentID.'2" w:type="Word.Bookmark.End"/>
	</w:p>';
	
	$currentID++;	
	
}



sub endofwordfile {
	print fileoutput '</wx:sub-section>
	</wx:sect>
	</w:body>
	</w:wordDocument>';

	close(fileoutput);

}

# Print a cell in the register table
sub regtable_cell {

 my $size_col = $_[0];
 my $text = replace_special_char($_[1]);
 my $merge = $_[2];
 my $bold = $_[3];
 my $fontsize = $_[4];
 my $vertical = $_[5];
 my $bordertop = $_[6];
 my $borderright = $_[7];
 my $borderbottom = $_[8];
 my $borderleft = $_[9];

 my $optionrPr = "";
 my $optionshd = "";
 my $cellalign="center";
 
 
 if ($bold eq 1) {$optionrPr="$optionrPr<w:b/><w:b-cs/>"}
 if ($vertical eq 1) {$optionshd="$optionshd<w:textFlow w:val=\"bt-lr\"/>";$cellalign="left";}

  print fileoutput '<w:tc>
  <w:tcPr><w:tcW w:w="'.$size_col.'" w:type="dxa"/><w:gridSpan w:val="'.$merge.'"/>
  <w:tcBorders>';

  if ($bordertop) {
    print fileoutput '<w:top w:val="single" w:sz="12" wx:bdrwidth="30" w:space="0" w:color="auto"/>';
  } else {
    print fileoutput '<w:top w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>';
  }
  if ($borderright) {
    print fileoutput '<w:right w:val="single" w:sz="12" wx:bdrwidth="30" w:space="0" w:color="auto"/>';
  } else {
    print fileoutput '<w:right w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>';
  }
  if ($borderbottom) {
    print fileoutput '<w:bottom w:val="single" w:sz="12" wx:bdrwidth="30" w:space="0" w:color="auto"/>';
  } else {
    print fileoutput '<w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>';
  }
  if ($borderleft) {
    print fileoutput '<w:left w:val="single" w:sz="12" wx:bdrwidth="30" w:space="0" w:color="auto"/>';
  } else {
    print fileoutput '<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>';
  }

  print fileoutput '</w:tcBorders><w:shd w:val="clear" w:color="auto" w:fill="'.$bgcolor.'"/><w:noWrap/>'.$optionshd.'
  <w:tcMar><w:left w:w="0" w:type="dxa"/>
  <w:right w:w="0" w:type="dxa"/>
  <w:bottom w:w="0" w:type="dxa"/>
  <w:top w:w="0" w:type="dxa"/></w:tcMar>
  <w:vAlign w:val="center"/><w:hAlign w:val="center"/></w:tcPr>
  <w:p>
  <w:pPr><w:spacing w:after="0"/><w:jc w:val="'.$cellalign.'"/><w:noWrap/></w:pPr>
  <w:r>
  <w:rPr><wx:font wx:val="Arial"/>'.$optionrPr.'<w:sz w:val="'.$fontsize.'"/><w:noWrap/></w:rPr>
  <w:t>'.$text.'</w:t>
  </w:r>
  </w:p>
  </w:tc>';


}

# Print the register table
sub print_reg_table {
  my $reg = $_[0];


  $font = "CustomTableTitle";


  $size_col=250;
  $size_colbis=350;
  #$size_col=300;
  $size_col2=$size_colbis*2;
  $size_col32=$size_col*32;
  $size_col36=$size_col32+4*$size_colbis;
  if ($debug) {print " In $reg->{name} table generation\n";}

  $bgcolor="auto";

  for (my $i = 31; $i >= 0; $i--) {
    $arrfieldname[$i]="";
    $arrfieldreset[$i]="";
    $arrfieldtype[$i]="";
    $arrfieldhw[$i]="";
    $arrfieldsw[$i]="";
    $arrfieldverif[$i]="";
  }


  $resetval=$reg->{reset};
  $resetval=~s/0x//;
  $resetvalbin=unpack("B32", pack("N", hex $resetval));
  #print "resetval=$resetval  resetvalbin=$resetvalbin\n";
  @arrresetval=split("",$resetvalbin);

  $ncharfieldmax=0;

  foreach my $field_tab  (@{$reg->{field}}){
    #$modulename = $modulename_tab->{ID};
    #<field name="FIELD20" description="Here is description of the field2" position="0" width="32" reset="0" type="U" hw="R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R " sw="RWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRW" test="RWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRWRW"/>
	  if ($debug) {print "   Create row for field ".$field_tab->{name}."\n";}

    if (length($field_tab->{name}) > $ncharfieldmax) {$ncharfieldmax=length($field_tab->{name});}
    
    $hwacc=$field_tab->{hw};
    $hwacc=~s/RW/RW /g;
    @arrhwacc=split(" ",$hwacc);
    $swacc=$field_tab->{sw};
    $swacc=~s/RW/RW /g;
    @arrswacc=split(" ",$swacc);
    $verifacc=$field_tab->{test};
    $verifacc=~s/RW/RW /g;
    @arrverifacc=split(" ",$verifacc);
    
    if ($field_tab->{width} != 1)
    {
      $cnt=0;
      for (my $i = $field_tab->{position}; $i < $field_tab->{position}+$field_tab->{width}; $i++) {
        $arrfieldname[$i]=$field_tab->{name}."[$cnt]";
        $arrfieldtype[$i]=$field_tab->{type};
        $arrfieldhw[$i]=$arrhwacc[$cnt];
        $arrfieldsw[$i]=$arrswacc[$cnt];
        $arrfieldverif[$i]=$arrverifacc[$cnt];
        $cnt++;
      }
    } else {
      $arrfieldname[$field_tab->{position}]=$field_tab->{name};
      $arrfieldtype[$field_tab->{position}]="U";
      $arrfieldhw[$field_tab->{position}]=$field_tab->{hw};
      $arrfieldsw[$field_tab->{position}]=$field_tab->{sw};
      $arrfieldverif[$field_tab->{position}]=$field_tab->{test};
    }
  }


  # Top
  print fileoutput '<w:tbl>
  <w:tblPr>
  <w:tblW w:w="'.$size_col36.'" w:type="dxa"/>
  <w:jc w:val="center"/>
  <w:tblInd w:w="103" w:type="dxa"/>
  <w:tblLook w:val="04A0"/></w:tblPr>
  <w:tblGrid><w:gridCol w:w="'.$size_col2.'"/><w:gridCol w:w="'.$size_colbis.'"/><w:gridCol w:w="'.$size_colbis.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/><w:gridCol w:w="'.$size_col.'"/></w:tblGrid>';
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="255"/><w:jc w:val="center"/></w:trPr>
  <w:tc>
  <w:tcPr><w:tcW w:w="'.$size_col2.'" w:type="dxa"/><w:vmerge w:val="restart"/><w:tcBorders><w:top w:val="single" w:sz="0" wx:bdrwidth="10" w:space="0" w:color="auto"/><w:left w:val="single" w:sz="0" wx:bdrwidth="10" w:space="0" w:color="auto"/><w:bottom w:val="single" w:sz="0" wx:bdrwidth="10" w:space="0" w:color="000000"/><w:right w:val="single" w:sz="0" wx:bdrwidth="10" w:space="0" w:color="auto"/></w:tcBorders><w:shd w:val="clear" w:color="auto" w:fill="auto"/><w:noWrap/><w:tcMar><w:left w:w="0" w:type="dxa"/><w:right w:w="0" w:type="dxa"/></w:tcMar><w:vAlign w:val="center"/></w:tcPr>
  <w:p>
  <w:pPr><w:spacing w:after="0"/><w:jc w:val="center"/></w:pPr>
  <w:r>
  <w:rPr><wx:font wx:val="Arial"/><w:b/><w:b-cs/><w:sz w:val="18"/></w:rPr>
  <w:t>Address</w:t>
  </w:r>
  </w:p>
  </w:tc>';
  regtable_cell($size_colbis,"Access",2,1,18,0,0,0,0,0);
  regtable_cell($size_col32,"$reg->{name}",32,1,18,0,0,0,0,0);
  print fileoutput '</w:tr>';

  # Field Number
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>
  <w:tc><w:tcPr><w:tcW w:w="'.$size_col2.'" w:type="dxa"/><w:vmerge/><w:tcBorders><w:top w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/><w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/><w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="000000"/><w:right w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/></w:tcBorders><w:vAlign w:val="center"/></w:tcPr><w:p><w:pPr><w:spacing w:after="0"/><w:jc w:val="left"/><w:rPr><w:rFonts w:ascii="Arial" w:fareast="Times New Roman" w:h-ansi="Arial" w:cs="Arial"/><wx:font wx:val="Arial"/><w:b/><w:b-cs/><w:lang w:fareast="EN-US"/></w:rPr></w:pPr></w:p></w:tc>';

  regtable_cell($size_colbis,"HW",1,1,18,0,0,0,0,0);
  regtable_cell($size_colbis,"SW",1,1,18,0,0,1,0,0);
  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    regtable_cell($size_col,$i,1,1,18,0,0,$borderright,0,0);
  
  }
  print fileoutput '</w:tr>';
  
  
  # Field Name
  $trHeight = $ncharfieldmax*80+270;
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="'.$trHeight.'"/><w:jc w:val="center"/></w:trPr>';
  
  $address="$reg->{offset}";
  $address=~s/0x//;
  regtable_cell($size_col2,"+$address\'H",1,1,18,0,0,0,0,0);
  regtable_cell($size_colbis,"$reg->{hw}",1,0,14,0,0,0,0,0);
  regtable_cell($size_colbis,"$reg->{sw}",1,0,14,0,0,1,0,0);
  

  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    if (length($arrfieldname[$i])) {
      regtable_cell($size_col,$arrfieldname[$i],1,0,14,1,0,$borderright,0,0);
    } else {
      $bgcolor="f0f0f0";
      regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
      $bgcolor="auto";
    }
  }
  print fileoutput '</w:tr>';

  # Reset Value
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>';
  regtable_cell($size_colbis,"Reset Value",3,1,18,0,0,1,0,0);
  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    if (length($arrfieldname[$i])) {
      regtable_cell($size_col,$arrresetval[31-$i],1,0,14,0,0,$borderright,0,0);
    } else {
      $bgcolor="f0f0f0";
      regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
      $bgcolor="auto";
    }
  }
  print fileoutput '</w:tr>';

  $bgcolor="CCFFFF";
  $bgcolor="E6F5F5";

  # Type
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>';
  regtable_cell($size_colbis,"Type",3,1,18,0,0,1,0,0);
  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    if (length($arrfieldname[$i])) {
      regtable_cell($size_col,$arrfieldtype[$i],1,0,14,0,0,$borderright,0,0);
    } else {
      $bgcolor="f0f0f0";
      regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
      $bgcolor="E6F5F5";
    }
  }
  print fileoutput '</w:tr>';

  # HW Access
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>';
  regtable_cell($size_colbis,"HW Access",3,1,18,0,0,1,0,0);
  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    if (length($arrfieldname[$i])) {
      regtable_cell($size_col,$arrfieldhw[$i],1,0,14,0,0,$borderright,0,0);
    } else {
      $bgcolor="f0f0f0";
      regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
      $bgcolor="E6F5F5";
    }
  }
  print fileoutput '</w:tr>';

  # SW Access
  print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>';
  regtable_cell($size_colbis,"SW Access",3,1,18,0,0,1,0,0);
  for (my $i = 31; $i >= 0; $i--) {
    $borderright=0;
    if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
    if (length($arrfieldname[$i])) {
      regtable_cell($size_col,$arrfieldsw[$i],1,0,14,0,0,$borderright,0,0);
    } else {
      $bgcolor="f0f0f0";
      regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
      $bgcolor="E6F5F5";
    }
  }
  print fileoutput '</w:tr>';

  # Verification
  if ($print_verif) {
    print fileoutput '<w:tr><w:trPr><w:trHeight w:val="270"/><w:jc w:val="center"/></w:trPr>';
    regtable_cell($size_colbis,"Verification",3,1,18,0,0,1,0,0);
    for (my $i = 31; $i >= 0; $i--) {
      $borderright=0;
      if (($i%4 eq 0) and ($i != 0)) {$borderright=1}
      if (length($arrfieldname[$i])) {
        regtable_cell($size_col,$arrfieldverif[$i],1,0,14,0,0,$borderright,0,0);
      } else {
        $bgcolor="f0f0f0";
        regtable_cell($size_col,"",1,0,14,0,0,$borderright,0,0);
        $bgcolor="E6F5F5";
      }
    }
    print fileoutput '</w:tr>';
  }

  endoftable("Register $reg->{name}");




}

sub replace_special_char {
  my $result = $_[0];
  $result=~ s/^ *//g;
  my @spec_char=(
                 ["&",  "&#38;"],
                 ["",  "\'"],
                 ["<",  "&#60;"],
                 [">",  "&#62;"],
                 ["=",  "&#61;"],
                 ["\r", "&#13;"],
                 ["\n", "</w:t></w:r></w:p><w:p><w:r><w:t>"],
                );
  foreach $elem(@spec_char)
  {
      @arr = @$elem;
      $result=~ s/$arr[0]/$arr[1]/g;
  }
  return $result;
}

# Print field description table
sub print_desc_table {
  my $reg = $_[0];
  newtable();

  $font = "CustomTableTitle";
  $bgcolor ="E6F5F5";
  $align = "left";
  newrow("Name","Type","Size","Description");

  $font = "CustomTableBody";
  $bgcolor ="FFFFFF";
  
    
  my $reg = $_[0];



  if ($debug) {print " In field desc of $reg->{name}\n";}

  foreach my $field_tab  (@{$reg->{field}}){
  	if ($debug) {print "   Create description for field = ".$field_tab->{name}."\n";}
  	#print "   ".$field_tab->{description}."\n";
    #newrow($field_tab->{name},$field_tab->{type},$field_tab->{width},$field_tab->{description});
    if ($field_tab->{width} != 1)
    {
      $s=$field_tab->{width}-1;
      $name=$field_tab->{name}."[$s:0]";
      newrow($name,$field_tab->{type},$field_tab->{width},$field_tab->{description});
    } else {
      newrow($field_tab->{name},"U",$field_tab->{width},$field_tab->{description});
    }




  }
  endoftable("Register $reg->{name} fields description");
  newparagraph(""); 
  

}

sub parse_register_list {
  my $reg_tab = $_[0];
  #$modulename = $modulename_tab->{ID};
  print "\nCreate register ".$reg_tab->{name}." (".$reg_tab->{display_type}.")\n";
  newtitle(3,"Register $reg_tab->{name}");
  newparagraph("$reg_tab->{description}");
  if (length($reg_tab->{define})) {
    newparagraph("Note: This register is available if macro ".$reg_tab->{define}." is defined");
    if ($debug) {print "The register ".$reg_tab->{name}." is available under ".$reg_tab->{define}." define\n";}
  }  
  print_reg_table($reg_tab);
  newparagraph("");
  print_desc_table($reg_tab);
  newparagraph("");
}

open(fileoutput,">$outputname");

headerofwordfile2();


my $xml = new XML::Simple;

my $data = $xml->XMLin("$inputname",KeyAttr => [], ForceContent => 1, ForceArray => [qw(root CSREG register field)]);


foreach my $modulename_tab  (@{$data->{CSREG}}){
	#$modulename = $modulename_tab->{ID};
	#print "     Create Word register table of the module = ".$modulename_tab->{name}."\n";
  newtitle(1,"$modulename_tab->{name}");

  newtitle(2,"Public Register List");

  foreach my $reg_tab  (@{$modulename_tab->{register}}) {
	  
    if ($reg_tab->{display_type} ne "private") {
      parse_register_list($reg_tab);
    }
  }  
  
  newtitle(2,"Private Registers List");
  
  foreach my $reg_tab  (@{$modulename_tab->{register}}) {
	  
    if ($reg_tab->{display_type} eq "private") {
      parse_register_list($reg_tab);
    }
  }  
  
}

endofwordfile();
