//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : REG_TAG registers
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module REG_TAG (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    input wire            ahb_nrst,  // AHB Hard Reset
    input wire            ahb_clk,   // AHB clock

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    PORT_IN_TAG
    //
    PORT_OUT_TAG

    ////////////////////////////////////////////
    //$port_g Bus interface
    ////////////////////////////////////////////
    input  wire            hready_in,
    input  wire            hsel,
    HADDR_TAG
    input  wire [ 1:0]     htrans,
    input  wire            hwrite,
    input  wire [31:0]     hwdata,
    output wire [31:0]     hrdata,
    output wire [ 1:0]     hresp,
    output wire            hready
    );
  
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Constants for registers addresses
  //////////////////////////////////////////////////////////////////////////////
  // Register configuration
  
  CONSTANT_TAG
 
  //////////////////////////////////////////////////////////////////////////////
  // Signals
  //////////////////////////////////////////////////////////////////////////////
  reg  [31: 0] int_reg_dr;
  wire [31: 0] int_reg_dw;
  reg          int_reg_rdy;
  reg          pending_write;
  reg          pending_read;
  PADDR1_TAG

  SIG_TAG


  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
  LINKAGE_TAG


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge ahb_clk or negedge ahb_nrst)
  begin
    if (!ahb_nrst) 
    begin
      pending_write             <= 1'b0;
      pending_read              <= 1'b0;
      PADDR2_TAG
      int_reg_dr                <= 32'b0;
      int_reg_rdy               <= 1'b1;
      RESET_TAG
    end
    else
    begin
      int_reg_rdy <= 1'b1;

      if (pending_write==1'b1)
      begin
        
        pending_write <= 1'b0;
        
        case(pending_addr)
          WRITE_TAG
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : 
          begin
          end
          // pragma coverage block = on 

        endcase
      end

      if (pending_read==1'b1)
      begin
        
        pending_read <= 1'b0;
        int_reg_dr   <= 32'b0;
        
        case(pending_addr)
          READ_TAG
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : int_reg_dr <= 32'b0;
          // pragma coverage block = on 

        endcase
      end

      // Pulse generation
      PULSE_TAG      
      // Hardware update
      UPDATE_TAG

      if(hready_in==1'b1 && hsel==1'b1 && htrans[1]==1'b1)
      begin
        if(hwrite==1'b1)
        begin
          PADDR3_TAG
          pending_write <= 1'b1;
        end
        else
        begin
          PADDR3_TAG
          pending_read  <= 1'b1;
          int_reg_rdy   <= 1'b0;
        end
      end
    end
  end




  //////////////////////////////////////////////////////////////////////////////
  // Read data 
  //////////////////////////////////////////////////////////////////////////////
  assign  hrdata     = int_reg_dr;

  //////////////////////////////////////////////////////////////////////////////
  // Write data 
  //////////////////////////////////////////////////////////////////////////////
  assign  int_reg_dw = hwdata;

  assign  hready = int_reg_rdy;
  assign  hresp  = 2'b0;

`ifdef RW_ASSERT_ON

`endif // RW_ASSERT_ON
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

