#!/bin/bash
eval 'exec perl -x "$0" ${1+"$@"}'
if 0;
#!perl
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthournout $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 34003 $
#/ $Date: 2018-05-18 10:07:23 +0200 (Fri, 18 May 2018) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Converter Xls to Xml file used to generate xml file 
#/                    with the registers definition from an Excel sheet.
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/////////////////////////////////////////////////////////////////////////////

use Spreadsheet::ParseExcel;


#-------------------------------------------------------------------------------
#- open .xls file for reading
#-------------------------------------------------------------------------------

sub open_excel {
    my $filename = $_[0];
    if (! -r $filename) {
        die "Error: $filename file not found \n";
    }
    return Spreadsheet::ParseExcel::Workbook->Parse($filename);
}



#-------------------------------------------------------------------------------
#- get cell content or return ""   !!Use global variale!!
#-------------------------------------------------------------------------------

sub get_cell {

    my ($cell) = $current_ws->{Cells}[$_[0]][$_[1]];

    if ($cell) { return $cell->Value; }
    else { return ""; }
}


#-------------------------------------------------------------------------------
#- check if paramater is address of the form +hhh'H with hhh hexa number
#-------------------------------------------------------------------------------
sub check_addr {
    my @input = @_;

    #The '+' at beginning doesn't apper in some files!

    #if ( grep(  /^\+?([0-9a-fA-F]+)\.?([0-9a-fA-F]*) *\'H$/, @input) == $#input+1 ) { return 1; }
    #else { return 0; }
    return scalar( grep(/^\s*\+?([0-9a-fA-F]+)\.?([0-9a-fA-F]*)\s*\'?\s*H\s*$/, @input) )

}

#-------------------------------------------------------------------------------
#- convert address of the form described above to scalar
#-------------------------------------------------------------------------------
sub parse_addr {
    my @input = @_;
    my @output = ();

    @input = grep( s/^\+?([0-9a-fA-F]+)\.?([0-9a-fA-F]*) *\'H$/$1$2/g, @input);
    foreach $val (@input) {
        push (@output, hex($val));
    }
    return wantarray ? @output : $output[0];
}


#-------------------------------------------------------------------------------
#- Replace special characters
#-------------------------------------------------------------------------------
sub replace_special_char {
  my $result = $_[0];
  $result=~ s/^ *//g;
  my @spec_char=(
                 ["&",  "&#38;"],
                 ["",  "\'"],
                 ["<",  "&#60;"],
                 [">",  "&#62;"],
                );
  foreach $elem(@spec_char)
  {
      @arr = @$elem;
      $result=~ s/$arr[0]/$arr[1]/g;
  }
  return $result;
}

#-------------------------------------------------------------------------------
#- Parse one flag from a field info line (ex: Type, HW access...)
#-------------------------------------------------------------------------------
sub parse_field_info {
    my $header = $_[0];     #header target
    my $row = $_[1];        #row of the flag
    my $col = $_[2];        #col of the flag
    my $list_flag = $_[3];  #ref on list of flags to be appended
    my $prev_flag = $_[4];  #ref on previous flag except 0/1
    my $allowed   = $_[5];  #allowed flags (regexp form)
    my $proc_reg = $_[6];   #processing register? (bool)
    my $default_flag = $_[7];   #default value for the flag

    my $error = 0;

    #check if header cell is the header target
    my $cell = &get_cell($row, 0);
    $cell =~ s/\s*$//g;
    if ($cell ne $header) { return 0; }

    my $flag = &get_cell($row, $col);

    $flag =~ s/\///; #remove /

    # if flag is empty while defining reg
    if ($proc_reg && (!$flag || length($flag) == 0))
    {
        $flag = $default_flag;
    }

    # if we are processing a register or if the flag is equal to F
    if ($proc_reg || $flag eq "F")
    {
        if (length($flag) == 0 ) { $flag = "  ";}   #put an empty line
        if (length($flag) == 1 ) { $flag .= " ";}   #add space if one char
        if (length($flag) != 2 ) { $error = 1;}     #should be 2 char!

        if ($flag !~ /$allowed/) {$error = 2;}  #check allowed flags

        if ($flag !~ /[01F] /) {
            #check if this flag is the same than the previous one of the same field
            if ($$prev_flag && ($flag ne $$prev_flag)) { $error = 0; }
            $$prev_flag = $flag;
        }

        #concat new flag
        $$list_flag .= $flag;

    }
    elsif (!$proc_reg && length($flag) == 0)
    {
        $$list_flag .= "  ";
    } #no field && empty flag
    else
    {
        $error = 4;
    }

    if ($error) {
        die "\n\nError ($error) with field info flag \"$flag\" at line \"$header\" ($row, $col zero-based!) at register \"$reg_name_brut\"\n";
    }
    return 1;
}

#-------------------------------------------------------------------------------
#- Extract field info substring from register info string
#-------------------------------------------------------------------------------

sub extract_info {
    my $info_register = $_[0];
    my $position = $_[1];
    my $width = $_[2];

    my $output = substr($info_register, ($reg_size - ($position+$width))*2, $width*2);

    if ($width == 1) { $output =~ s/ //; }

    return $output;
}

#-------------------------------------------------------------------------------
#- Process register. Take first row as a parameter, return last row
#-------------------------------------------------------------------------------

sub check_field_description {

    my $field_row = $_[0];
    my $curr_field_name = $_[1];
    my $type = $_[2];
    my $row = $field_row + 5;
    my $run = 1;
    my $description="";
    while ($run eq 1) 
    {
      $reg_name_brut = &get_cell($row,1);
      $name=$reg_name_brut;
      $name=~s/\[.*//g;
      #print "$reg_name_brut\n";
      if ($curr_field_name eq $name)  
      {
        #print "Description found for $type $name $row \n";   
        $description=&get_cell($row,11); 
        $description=&replace_special_char($description);                 
        #print " $description\n\n";   
        $run = 0;
      }
      if ($curr_field_name eq "Access") 
      {
        print "Description not found for $type $curr_field_name\n";                     
        $run = 0;
      }
      if ($row >= ($field_row  + 43))
      {
        print "Description not found for $type $curr_field_name\n";                     
        $run = 0;                     
      }
      $row++;
    };
        
    return "$description"
}

#-------------------------------------------------------------------------------
#- Process register. Take first row as a parameter, return last row
#-------------------------------------------------------------------------------

sub process_register {

    my $row = $_[0];
    $reg_name_brut = &get_cell($row,3);

    if ($reg_name_brut eq "REGNAME" || $reg_name_brut =~ /NOREGISTER/ || $reg_name_brut =~ /NO_REGISTER/) {
        #print "        Empty register at ($row,0 zero based)\n";
        #skip the register block
        $row +=3;
        while (&get_cell($row, 0)) { $row++; };
        return $row;
    }

    #print "        Processing register \"$reg_name_brut\"\n";

    #get and process register name
    $reg_name_uc   = uc($reg_name_brut);

    #get and process register address
    my $reg_addr_brut = &get_cell($row+2,0);

    my $regtype=0;
    my $field_reset="";
    my @reg_name = ();
    my @reg_type = ();
    my @reg_description = ();
    my @reg_define = ();
    my @reg_addr = ();
    my @reg_suffix = ();
    my $reg_array_step = 0;
    my $table_name = "";

    my $current_define = &get_cell($row-1,1);
    my $current_type = &get_cell($row+1,38);
    
    #-------------------------------------------------------------------------------
    #- Test if register name is a "array [xx-yy]"
    #-------------------------------------------------------------------------------
    if ($reg_name_brut =~ /^\w* *\[.*\]$/) {

        my $reg_name_idx = $reg_name_brut;
        $reg_name_idx =~ s/^\w* *\[(.*)\]$/$1/;

        my $reg_name_base = $reg_name_brut;
        $reg_name_base =~ s/ *\[.*\]//;

        if ( ($reg_name_base =~ /^.*_(TABLE|FIFO_.*)$/ && !$opt_table_expand )
             || $opt_force_table ) {
            $table_name = $reg_name_base;
        } else {
            #print "        Array register!\n";
        }

        #array of the form [x-y] or [x0 x1 x2 x3] ?
        if ( $reg_name_idx =~ /([0-9a-fA-F]+) *\- *([0-9a-fA-F]+)/ ) {

            if (($1 eq "") || ($2 eq "") ) {
                die "\nError with register array \"$reg_name_brut\" name $1:$2",
            }

            $curr_reg = $1;
            $last_reg = $2;

            do {
                push( @reg_name, $reg_name_base . $curr_reg);
                push (@reg_description, &check_field_description($row,$reg_name_base,"reg"));
                push( @reg_suffix, $curr_reg);
                push( @reg_define, $current_define);
                push( @reg_type, $current_type);
                $curr_reg = $curr_reg+1;
            } while ($curr_reg <= $last_reg);
        } else {
            # build a list of the indexes
            @reg_suffix = split(' ',$reg_name_idx);
            # add the basename of the register before all the indexes of the list
            @reg_name = grep(s/^(.*)$/$reg_name_base$1/, @reg_suffix);
            @reg_define = ($current_define);
            @reg_type = ($current_type);
        }

        #generate register names

        #Get list of addresses and generate offsets (to the start of the array)
        my @reg_addr_tmp = split(' ', $reg_addr_brut);
        #adresses of the form "+x0'H +x1'H +x2'H ..."
        if ( $#reg_name + 1 == &check_addr(@reg_addr_tmp)) {
            #generate list of offsets
            @reg_addr = &parse_addr(@reg_addr_tmp);

            if ($table_name) {
                $reg_array_step = $reg_addr [1] - $reg_addr [0];
                for ( my $reg_idx = 1; $reg_idx < $#reg_name && $table_name; $reg_idx++ ) {
                    if ($reg_array_step != $reg_addr [$reg_idx] - $reg_addr [$reg_idx-1]) {
                        die "\nError with register table $reg_name_brut addresses:",
                        " offset between each address must be constant\n";
                    }
                }
            }

        #adresses of the form "+x0'H ++off'H"
        } elsif ($#reg_addr_tmp >= 1
                && &check_addr($reg_addr_tmp[0])
                && $reg_addr_tmp[1] =~ /^\+\+[0-9a-fA-F]+\'H$/ ) {
            $reg_addr_tmp[0] = &parse_addr($reg_addr_tmp[0]);
            $reg_array_step = $reg_addr_tmp[1];
            $reg_array_step =~ s/^\+\+([0-9a-fA-F]+)\'H$/$1/;
            for ( my $reg_idx = 0; $reg_idx <= $#reg_name; $reg_idx++ ) {
                push (@reg_addr, $reg_addr_tmp[0] + $reg_idx * hex($reg_array_step));
            }
        #adresses of the form "+x0'H to +xn'H"
        } elsif ($#reg_addr_tmp >= 2
                && &check_addr($reg_addr_tmp[0])
                && ($reg_addr_tmp[1] eq "to")
                && &check_addr($reg_addr_tmp[2])
                ) {
            $reg_addr_tmp[0] = &parse_addr($reg_addr_tmp[0]);
            $reg_array_step = 4* $module_regalign / $module_elementsize;
            $reg_addr_tmp[2] = &parse_addr($reg_addr_tmp[2]);

            for ( my $curr_addr = $reg_addr_tmp[0]; $curr_addr<=$reg_addr_tmp[2] ; $curr_addr += $reg_array_step) {
                push (@reg_addr, $curr_addr);
            }
            #die "\n\n ADDR1 to ADDR2 in array not yet supported ...";

        #unknown address format
        } else {
            print " $#reg_addr_tmp <$reg_addr_brut> ";
            die "\nError with register array $reg_name_brut address field:",
            " syntax or number of adresses and registers don't match\n";
        }
        #print " $#reg_name:@reg_name:@reg_addr )\n";

    } elsif (!$reg_name_brut || ($reg_name_brut =~ /[^\w]/ )) {
        die "\nError with register \"$reg_name_brut\": empty or invalid characters in name\n";

    } else {
        #No array, just simple register

        #remove bank name in RW register file
        $reg_addr_brut =~ s/\n.*$//gs;
        if (! &check_addr($reg_addr_brut)) {
            die "\nError with address \"$reg_addr_brut\" in register \"$reg_name_brut\"\n";
        }

        @reg_name = ($reg_name_brut);
        @reg_addr = (&parse_addr($reg_addr_brut));
        @reg_define = ($current_define);
        @reg_type = ($current_type);
        push (@reg_description, &check_field_description($row,$reg_name_brut,"reg"));
        
    }

    #find register size
    if (&get_cell($row+1,10) eq "0") { $reg_size=8; }
    elsif (&get_cell($row+1,18) eq "0") { $reg_size=16; }
    elsif (&get_cell($row+1,34) eq "0") { $reg_size=32; }
    else {
        die "\nError with register $reg_name_brut size\n";
    }

    # retrieve the register HW access type
    my $reg_hw_access = &get_cell($row+2,1);
    #  remove all second line of the cell and all /'s
    $reg_hw_access =~ s/(\n.*$)|\///gs;
    $reg_hw_access =~ s/Fixed/H/gs;
    # check that the format of the HW access type is OK
    if ($reg_hw_access !~ m/^(R|W|(RW)|H)$/gs)
    {
        die "\nError with register $reg_name_brut HW access type not supported \"$reg_hw_access\"\n";
    }

    # retrieve the register SW access type
    my $reg_sw_access = &get_cell($row+2,2);
    #  remove all second line of the cell and all /'s
    $reg_sw_access =~ s/(\n.*$)|\///gs;
    # check that the format of the SW access type is OK
    if ($reg_sw_access !~ m/^(R|W|(RW)|X|C|S)$/gs)
    {
        die "\nError with register $reg_name_brut SW access type not supported \"$reg_sw_access\"\n";
    }




    my $curr_field_name;
    my $prev_field_name = "";
    my $field_msb_offset;
    my $field_lsb_offset;
    my $col;

    my $info_reset_single  = 0;
    my $field_info_reset_single  = 0;
    my @info_reset         = ();
    my $info_type          = "";
    my $info_hw_access     = "";
    my $info_sw_access     = "";
    my $info_verification  = "";

    my $prev_flag_type         = "";
    my $prev_flag_hw_access    = "";
    my $prev_flag_sw_access    = "";
    my $prev_flag_verification = "";

    my @field_name = ();
    my @field_description = ();
    my @field_pos = ();
    my @field_width = ();
    my @fieldreset = ();

    my $same_field = 0;
    my $field_index=0;

    #-------------------------------------------------------------------------------
    #- Parse fields (one more empty column is processed to save the last field)
    #-------------------------------------------------------------------------------
    for ($col = 3;  ; $col++) 
    {
      #parse field name
      $curr_field_name = &get_cell($row+2,$col);
      #print " Current Field $curr_field_name \n";
	
      $curr_field_name =~ s/\[[0-9]*\]//g;    #trim field bit index
	
      $curr_field_name =~ s/^Reserved$//g;    #skip "Reserved" fields

      if ($curr_field_name =~ /[^\w]/) {
	      print "\nERROR : $curr_field_name \n";
        die "\n\nError with field \"$curr_field_name\" in register \"$reg_name_brut\": invalid characters in name\n";
      }

      #different from the last one!
      if ($curr_field_name ne $prev_field_name) {
        $same_field = 0;
        #previous field to save
        if ($prev_field_name) 
        {
          $field_lsb_offset = $reg_size + 3 - $col;

          if ( $opt_double_field || !exists ($parsed_fields {$prev_field_name} )) 
          {
            push (@fieldreset, $field_info_reset_single);                                
            #print "new field $curr_field_name, $field_index, $field_info_reset_single, $fieldreset[$field_index] \n";
            $field_index+=1;                                                        
            $field_info_reset_single  = 0;
            
            #print "          Processing field: \"$prev_field_name\" $field_msb_offset:$field_lsb_offset\n";
            #save field data if we accept doubles or first time
            push (@field_name, $prev_field_name);
            push (@field_pos, $field_lsb_offset);
            push (@field_width, $field_msb_offset-$field_lsb_offset);

            @ {$parsed_fields {$prev_field_name}} = ( $field_msb_offset, $field_lsb_offset );
          } 
          else 
          {
            #print "          Skipping field: \"$prev_field_name\"\n";
            #this field has already been parsed! check if it's at same psoition
            my ($msb_offset, $lsb_offset) = @ {$parsed_fields {$prev_field_name}};

            if ($field_msb_offset != $msb_offset || $field_lsb_offset != $lsb_offset ) {
                die "Error: Two fields with same name \"$prev_field_name\" ",
                    "and different positions (option NO_DOUBLE_FIELD is set)\n";
            }
          }
        }
        #new field to init
        if ($curr_field_name) 
        {
            #print "          Processing field: \"$curr_field_name\" ($row)\n";
            
            push (@field_description, &check_field_description($row,$curr_field_name,"field"));
            
            #reinit fo new field
            $prev_field_name = $curr_field_name;
            $field_msb_offset = $reg_size + 3 - $col;

            $prev_flag_type          = "";
            $prev_flag_hw_access     = "";
            $prev_flag_sw_access     = "";
            $prev_flag_verification  = "";

        } 
        else 
        {
            #no new field, so discard previous one
            $prev_field_name = "";
        }
      } elsif ($prev_field_name) {
        $same_field = 1;
        #nothing to do here? may be we should check the index of the field
      }

      # We get out of the loop here when needed!!!
      if ($col >= 3 + $reg_size) {last;}

      #-------------------------------------------------------------------------------
      #- Parse field info flags
      #-------------------------------------------------------------------------------
      for ( my $info_row = $row+3; ;$info_row++) {
          my $flag;
          my $info_header = &get_cell($info_row, 0);
          if (!$info_header) { last; }

          if ($info_header eq "Reset value" ) { # single reset value
              $flag = &get_cell($info_row, $col);
              $info_reset_single *= 2;
              $field_info_reset_single *= 2;
              # load into reset the DEFINE
              
              if ($flag =~ /`/) 
              {
                $info_reset_single = $flag;
                $field_info_reset_single = $flag;
              } elsif ( $flag eq "1" )  
              { 
                $info_reset_single++;
                $field_info_reset_single++;
              
              }
              #print "reset $flag, $info_reset_single\n";


          } elsif ($info_header =~ "Reset val\." ) { #multiple reset value (only in arrays!)

              #print "Warning Multiple reset values in array not yet supported ...\n";
              my $idx_header = $info_header;
              $idx_header =~ s/Reset val\. *//;
              #print "C'est tipar w/ $idx_header \n";
              if (&check_addr($idx_header)) {
                  $idx_header = &parse_addr($idx_header);
                  for ( my $sa_mere=0 ; $sa_mere <= $#reg_addr; $sa_mere++) {
                      #print "Sa reum $sa_mere $reg_addr[$sa_mere] == $idx_header :: $info_reset[$sa_mere]\n";
                      if ($reg_addr[$sa_mere] == $idx_header) {
                          $info_reset[$sa_mere] *= 2;
                          $flag = &get_cell($info_row, $col);
                          if ($flag eq "1") { $info_reset[$sa_mere]++; }
                          goto reset_val_ok;                        
                      }
                  }
              }
              die "Error: Problem with reset value \"$idx_header\" at ($row,0 zero-based) in register \"$reg_name_brut\"\n";
              reset_val_ok:

          } elsif ( &parse_field_info ("Type", $info_row, $col, \$info_type, \$prev_flag_type,
                      "[USCE] ", $curr_field_name ne "" , "")) {

          } elsif ( &parse_field_info ("HW Access", $info_row, $col, \$info_hw_access, \$prev_flag_hw_access,
                      "(RW)|([RW01XHF] )", $curr_field_name ne "" , "")) {

          } elsif ( &parse_field_info ("SW Access", $info_row, $col, \$info_sw_access, \$prev_flag_sw_access,
                      "(RW)|(RS)|(RC)|([RW01XSC] )", $curr_field_name ne "" , $reg_sw_access)) {

          } elsif ( &parse_field_info ("Verification", $info_row, $col, \$info_verification, \$prev_flag_verification,
                      "(RW)|(DT)|([RWS] )|( *)", $curr_field_name ne "" , "")) {

          } elsif ( &parse_field_info ("Info", $info_row, $col, \$info_verification, \$prev_flag_verification,
                      "(RW)|(DT)|([RWSF01] )", $curr_field_name ne "" , "")) {

          } else {
              print "\n\nWarning with header \"$info_header\" in register \"$reg_name_brut\": unknown field info type\n";
          }
      } #for each info header
      
    } #for each bits

    my $info_diff_reset    = 0;
    if ($#info_reset != $#reg_name ) {
        #if single reset value, multiply it for each register
        for ( my $reg_idx = 0; $reg_idx <= $#reg_name; $reg_idx++ ) {
            push (@info_reset, $info_reset_single);
        }
    } elsif ($table_name) {
        #if multiple reset values and table name, check if at least two differents
        for ( my $reg_idx = 1; $reg_idx <= $#reg_name; $reg_idx++ ) {
            if ($info_reset [$reg_idx] != $info_reset [$reg_idx-1]) {
                $info_diff_reset = 1;
                last;
            }
        }
    }


    # Skip info fields
    $row += 3;
    while (&get_cell($row, 0)) { $row++; };


    #print "End of process $row\n";
    my %enum_name = ();
    my %enum_value = ();

    #End of file?
    if ( $row <= $mod_ws->{MaxRow} ) {
        # Skip blank fields
        while (!&get_cell($row, 0) && $row <= $mod_ws->{MaxRow}) { $row++; };

        # Enum or new register block?
        if ( &get_cell($row, 0) eq "Enum" ) {

            #-------------------------------------------------------------------------------
            #- parse Enum block
            #-------------------------------------------------------------------------------
            $row++;
            my $field_name;
            #process each field
            for (;;) {
                $field_name = &get_cell($row, 0);
                if (!$field_name) {last};
                my @value = ();
                my @name = ();
                #process each value
                for (;;) {
                    #bug if hexa value!!!
                    push ( @name, &get_cell($row, 6) );
                    push ( @value, &get_cell($row, 3) );
                    $row++;
                    if (&get_cell($row, 0) || !&get_cell($row, 3)) {last};
                }
                #add enum values
                @ {$enum_name {$field_name}} = @name;
                @ {$enum_value {$field_name}} = @value;
            }
        } elsif ( &get_cell($row, 0) && &get_cell($row, 0) ne "Address" ) {
            print "Warning at cell ($row, 0 zero based) \"Address\" expected instead of \"", &get_cell($row, 0), "\"\n";
        }
    } else {
        #print "Last entry!\n";
    }

    #-------------------------------------------------------------------------------
    #- print xml register entry
    #-------------------------------------------------------------------------------
    for ( my $reg_idx = 0; $reg_idx <= $#reg_name && $opt_no_check ; $reg_idx++ ) {


        if ( exists ($parsed_registers {$reg_name[$reg_idx]} )
            && $parsed_registers {$reg_name[$reg_idx]} != $reg_addr[$reg_idx] ) {
            die "Error: Two registers with same name \"$reg_name[$reg_idx]\" but different addresses\n";
        }
        @ {$parsed_registers {$reg_name[$reg_idx]}} = $reg_addr[$reg_idx];


        if ($table_name) {
            print mod_xml_file $indent, "<register name=\"$table_name\" offset=\"0x",  sprintf("%X",$reg_addr[$reg_idx]), "\" ",
                    "count=\"", $#reg_name+1, "\" step=\"0x",  sprintf("%X",$reg_array_step), "\" ",
                    "hw=\"$reg_hw_access\" sw=\"$reg_sw_access\" display_type=\"$reg_type[$reg_idx]\" define=\"$reg_define[$reg_idx]\"";
            if (!$info_diff_reset) {
                print mod_xml_file " reset=\"", sprintf("0x%X",$info_reset[$reg_idx]), "\"";
            }
            print mod_xml_file  ">\n";
        } else {
            #print register entry
            $reg_short_description=$reg_description[$field_idx];
            $reg_short_description=~s/\n.*//g;
            print mod_xml_file $indent, "<register name=\"$reg_name[$reg_idx]\" description=\"$reg_description[$reg_idx]\" short_description=\"$reg_short_description\" offset=\"0x",  sprintf("%X",$reg_addr[$reg_idx]),
                    "\" hw=\"$reg_hw_access\" sw=\"$reg_sw_access\" reset=\"", sprintf("0x%X",$info_reset[$reg_idx]), "\" display_type=\"$reg_type[$reg_idx]\" define=\"$reg_define[$reg_idx]\">\n";
        }

        if (length($reg_sw_access) == 1 ) { $reg_sw_access .= " ";}   #add space if one char


        if ($opt_double_field || $reg_idx == 0) {

            for ( my $field_idx = 0; $field_idx <= $#field_name; $field_idx++ ) {


                #print field entry
                if ($#reg_name && $opt_double_field) {
                    print mod_xml_file $indent, "    <field name=\"$field_name[$field_idx]$reg_suffix[$reg_idx]\"";
                } else {
                    print mod_xml_file $indent, "    <field name=\"$field_name[$field_idx]\"";
                }
                $field_short_description=$field_description[$field_idx];
                $field_short_description=~s/\n.*//g;
                print mod_xml_file " description=\"$field_description[$field_idx]\" short_description=\"$field_short_description\" position=\"$field_pos[$field_idx]\" width=\"$field_width[$field_idx]\"";
                
                if (!$info_diff_reset) {
                    #compte reset value for current field
                    my $flag_rst = $info_reset[$reg_idx];
                    if ( $flag_rst !~ /`/ )
                    {
                      $flag_rst >>= $field_pos[$field_idx];
                      $flag_rst &= (1 << $field_width[$field_idx]) - 1;
                    }
                    #print "reset write field $field_idx, $fieldreset[$field_idx] \n";
                    print mod_xml_file " reset=\"$fieldreset[$field_idx]\"";
                }

                #print field info entry

                if ($info_type && $field_width[$field_idx] > 1) {
                    print mod_xml_file " type=\"", &extract_info($info_type, $field_pos[$field_idx], 1), "\"";
                }
                if ($info_hw_access) {
                    print mod_xml_file " hw=\"", &extract_info($info_hw_access, $field_pos[$field_idx], $field_width[$field_idx]), "\"";
                }
                if ($info_sw_access) {
                    print mod_xml_file " sw=\"", &extract_info($info_sw_access, $field_pos[$field_idx], $field_width[$field_idx]), "\"";
                } else {
                    print mod_xml_file " sw=\"", $reg_sw_access x $field_width[$field_idx], "\"";
                }


                if ($info_verification) {
                    print mod_xml_file " test=\"", &extract_info($info_verification, $field_pos[$field_idx], $field_width[$field_idx]), "\"";
                }


                if (exists( $enum_name { $field_name[$field_idx] } ) ) {
                    #print enum value entry
                    print mod_xml_file " >\n"; #close current field

                    @name = @ { $enum_name { $field_name[$field_idx] } };
                    @value = @ { $enum_value { $field_name[$field_idx] } };

                    for (my $enum_idx = 0; $enum_idx <= $#name; $enum_idx++ ) {
                        print mod_xml_file $indent, "        <$name[$enum_idx] value=\"$value[$enum_idx]\" />\n";
                    }
                    print mod_xml_file $indent, "    </field>\n";

                } else {
                    print mod_xml_file "/>\n"; #close current field
                }
            }
        }

        #close current register
        if ($table_name) {
            $reg_idx = $#reg_name;
            print mod_xml_file $indent, "<\/register>\n";
        } else {
            print mod_xml_file $indent, "<\/register>\n";
        }
    }
    return $row - 1;
}

#-------------------------------------------------------------------------------
#- process module
#-------------------------------------------------------------------------------

sub process_module {
    print "    Processing module \"$module_name\" ($module_filename)\n";

    #open input excel module file
    $mod_book = &open_excel($in_path . $module_path . $module_filename);

    $module_shortname =~ s/\s/_/g;
    $module_shortname = uc($module_shortname);
    if ($module_shortname =~ /[^\w]/) {
        die "\n\nError with module \"$module_shortname\": invalid characters in name\n";
    }

    if ($opt_no_check) {
        #open output xml module file
        my $mod_xml_filename = $module_filename;
        $mod_xml_filename =~ s/\.xls/\.xml/;
        open (mod_xml_file, "> " . $out_path . $mod_xml_filename) or die "Error: unable to open $out_path:$mod_xml_filename";

        print mod_xml_file "<root>\n";

        #print configuration part
        print mod_xml_file "    <configuration name=\"$module_shortname\">\n";
        print mod_xml_file "        <width register=\"$module_regalign\" memory=\"$module_elementsize\" />\n";
        for (my $i=0; $i<= $#module_instances; $i++ ){
            print mod_xml_file "        <instance name=\"$module_instances[$i]\" address=\"",
                     sprintf("0x%0*X",$module_addsize, $module_addresses[$i]), "\" />\n";
        }
        if ($module_prefix) {
            print mod_xml_file "        <prefix field=\"$module_prefix\"  />\n";
        }

        print mod_xml_file "    </configuration>\n";

        print mod_xml_file "    <$module_shortname name=\"$module_name\">\n";
        $indent = "        ";
    }

    # global inits for module
    %parsed_fields = {};
    %parsed_registers = {};

    if ( $mod_book->{SheetCount} != 1 ) {
        #print "Warning: Several worksheets in module \"$module_shortname\": only first one processed\n";

        for (my $i=0; $i<=$mod_book->{SheetCount}; $i++) {
            $mod_ws = ${$mod_book->{Worksheet}}[$i];
            goto sheet_choosed if ($mod_ws->{Name} eq "Registers");
        }

        die "Error: file \"$module_filename\" has several sheets and none is named \"Registers\"";

    } else {
        $mod_ws = ${$mod_book->{Worksheet}}[0];
    }
    sheet_choosed:

    #foreach my $mod_ws (@ {$mod_book->{Worksheet}}) {
    #    print "      Processing sheet: ", $mod_ws->{Name}, "\n";

        #$current_ws is used by &get_cell
        $current_ws = $mod_ws;
        $bank_name = "";

        for (my $row = $mod_ws->{MinRow} ; defined $mod_ws->{MaxRow} && $row <= $mod_ws->{MaxRow} ; $row++) {
            my $current_cell = &get_cell($row,0);

            if (&check_addr($current_cell)) {
                if ($bank_name && $opt_no_check) {
                    $indent =~ s/    $//;
                    print mod_xml_file $indent, "</$bank_shortname>\n";
                }

                $bank_name = &get_cell($row,3);
                $bank_shortname = uc($bank_name);
                $bank_shortname =~ s/ ?REGISTERS?( BANK)? ?//g;
                $bank_shortname =~ s/\W/_/g;
                $bank_idx = &parse_addr($current_cell) >> (7*4);

                if ($opt_no_check) {
                    print mod_xml_file $indent, "<$bank_shortname name=\"$bank_name\" bank=\"$bank_idx\">\n";
                    $indent .= "    ";
                }
                #print "      Processing bank \"$bank_name\" ($current_cell)\n";

            } elsif ($current_cell =~ /^Address/) {

                #print "$row\n";
                $row = &process_register ($row);

            }
        }

        if ($bank_name && $opt_no_check) {
            $indent =~ s/    $//;
            print mod_xml_file $indent, "</$bank_shortname>\n";
        }

#   }

    #we should close the file here!!!
    if ($opt_no_check) {
        print mod_xml_file "    <\/$module_shortname>\n";
        print mod_xml_file "<\/root>\n";

        close (mod_xml_file);
    }
}



#-------------------------------------------------------------------------------
#- process list
#-------------------------------------------------------------------------------

sub process_list {

    print "Processing file: $list_filename\n";
    $list_book = &open_excel($in_path . $list_filename);

    if ($opt_no_check) {
        #open output xml module file
        my $list_xml_filename = $list_filename;
        $list_xml_filename =~ s/\.xls/\.xml/;
        open (list_xml_file, "> " . $out_path . $list_xml_filename) or die "Error: unable to open $out_path:$list_xml_filename";
        print list_xml_file "<root>\n";
    }

    foreach my $list_ws (@ {$list_book->{Worksheet}}) {
        print "  Processing sheet: ", $list_ws->{Name}, "\n";

        #field to start processing modules list
        my ($process_list) = 0;

        for (my $row = $list_ws->{MinRow} ; defined $list_ws->{MaxRow} && $row <= $list_ws->{MaxRow} ; $row++) {

            #$current_ws is used by &get_cell
            $current_ws = $list_ws;

            my ($current_cell) = &get_cell($row,0);
            #$current_cell = $list_ws->{Cells}[$row][0]->Value;

            if ($current_cell eq "Module name") {
                $process_list = 1;
                next;
            }

            if ($process_list == 1 && $current_cell) {
                $module_name = $current_cell;
                $module_shortname = get_cell($row,1);

                $module_path = get_cell($row,2);
                $module_path =~ s/\\/\//g;
                $module_path =~ s/[^\/]*$//;  #remove filename
                $module_filename = get_cell($row,2);
                #print $module_filename, "\n";
                $module_filename =~ s/^.*\\//; #remove path until last '/'
                $module_filename =~ s/^.*\///; #remove path until last '\'
                #print $module_filename, "\n";

                @module_instances = ();
                @module_addresses = ();
                my $tmp_add;
                my @tmp_instances = split('\n', get_cell($row,3));
                for (my $i=0; $i<= $#tmp_instances; $i++ )
                {
                    print STDOUT "instance: ".$tmp_instances[$i]."\n";

                    if ($tmp_instances[$i] =~ /^\s*(\w+)\s*\@\s*(.*)\s*$/ && &check_addr($2)) {
                        push (@module_instances, $1);
                        push (@module_addresses, &parse_addr($2));
                        $tmp_add = $2;
                    } elsif ( &check_addr($tmp_instances[$i])) {
                        push (@module_instances, $module_shortname);
                        push (@module_addresses, &parse_addr($tmp_instances[$i]));
                        $tmp_add = $tmp_instances[$i];
                    } else {
                        die "Error with instance \"$tmp_instances[$i]\"in file \"$list_filename\"";
                    }
                }
                $tmp_add =~ s/[ +.\'H]//g;

                $module_addsize = length ($tmp_add);

                $module_regalign = get_cell($row,4);
                $module_elementsize = get_cell($row,5);
                $module_prefix = get_cell($row,6);

                &process_module ();

                if ( $module_filename !~ s/\.xls/\.xml/ ) {
                    die "Error: \".xls\" file expected in file \"$list_filename\" at row $row";
                }
                if ($opt_no_check) {
                    print list_xml_file "    <$module_shortname file=\"$module_filename\" />\n";
                }
            }

            if ($current_cell eq "Options") {
                $process_list = 2;
                next;
            }

            if ($process_list == 2) {
                if ($current_cell eq "NO_TABLE_EXPAND") { $opt_table_expand = 0;}
                elsif ($current_cell eq "FORCE_TABLE") { $opt_force_table = 1; $opt_table_expand = 0;}
                elsif ($current_cell eq "NO_DOUBLE_FIELD") { $opt_double_field = 0;}
                elsif ($current_cell =~ /^[^#]\w*$/ ) {
                    print "Warning: unknown option \"$current_cell\"\n";
                }
            }
        } # foreach row
    } # foreach worksheet

    if ($opt_no_check) {
        print list_xml_file "</root>\n";
        close (list_xml_file);
    }
}



##########################################################################################
# Main part
##########################################################################################

my ($row, $iC);

my $error = 0;

$in_filename = "";
$in_path = "";
$out_path = "";

#options
$opt_force_table = 0;   #force a multi register to be a table even if
                        #its name do not contain _TABLE or _FIFO
$opt_table_expand = 1;
$opt_double_field = 1;
$opt_no_check = 1;

# flush STDOUT after each print
select(STDOUT);
$| = 1;

for (my $i=0; $i<=$#ARGV; $i++ ) {

    $ARGV[$i] =~ s/\\/\//g;

    if ($ARGV[$i] eq "-d" || $ARGV[$i] eq "--no-double-field") {
        $opt_double_field = 0;

    } elsif ($ARGV[$i] eq "-t" || $ARGV[$i] eq "--no-table-expand") {
        $opt_table_expand = 0;

    } elsif ($ARGV[$i] eq "-T" || $ARGV[$i] eq "--force-table") {
        $opt_table_expand = 0;
        $opt_force_table = 1;

    } elsif ($ARGV[$i] eq "-c" || $ARGV[$i] eq "--check") {
        $opt_no_check = 0;
        $opt_double_field = 0;

    } elsif (!$in_path) {

        $in_path = $ARGV[$i];
        $in_path =~ s/[^\/]*$//;  #remove filename

        $in_filename = $ARGV[$i];
        $in_filename =~ s/^.*\///; #remove path until last '/'

        if ($ARGV[$i] !~ /\.xls$/ ) {
            die "Error: \".xls\" file expected";
        }

        if (!$in_path)  { $in_path="./"; }

    } elsif (!$out_path) {
        $out_path = $ARGV[$i] . "/";

    } else {
        die "Error: too much arguments";
    }
}

    $module_name = $in_filename;
    $module_name =~ s/.xls//;
    $module_shortname = "CSReg";
    @module_instances = ("CSReg");
    @module_addresses = (0);
    $module_regalign = 32;
    $module_elementsize = 32;
    $module_path = "./";
    $module_filename = $in_filename;
    &process_module ();




