#/////////////////////////////////////////////////////////////////////////////
#/ Copyright (C) by RivieraWaves.
#/ This module is a confidential and proprietary property of RivieraWaves
#/ and a possession or use of this module requires written permission
#/ from RivieraWaves.
#/----------------------------------------------------------------------------
#/$Author          : rblanc
#/Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/$Revision: 35564 $
#/$Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
#/---------------------------------------------------------------------------
#/Dependencies     : None
#/Description      : This file defines code snippets used in generating the UVM
#                    register model
#/Simulation Notes :
#/Synthesis Notes  :
#/Application Note :
#/Simulator        :
#/Parameters       :
#/Terms & concepts :
#/Bugs             :
#/Open issues and future enhancements :
#/References       :
#/Revision History :
#/---------------------------------------------------------------------------
#/
#/////////////////////////////////////////////////////////////////////////////

import string
from string import Template

# ---------------------------------------------------------
# Header placed at the beginning of every generated file
# ---------------------------------------------------------
header = Template("""//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $$Author          : $AUTHOR
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $$Revision: 35564 $$
// $$Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $$
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for $ENTITY
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __${ENTITY}_REG_BLOCK_SV__
`define __${ENTITY}_REG_BLOCK_SV__

""")

# ---------------------------------------------------------
# Beginning of each register block
# ---------------------------------------------------------
reg_block = Template("""//--------------------------------------------------------------------
// $NAME_OF_REGISTER
//--------------------------------------------------------------------
class $NAME_OF_REGISTER extends uvm_reg;
    `uvm_object_utils($NAME_OF_REGISTER)
""")


# ---------------------------------------------------------
# Register field definition
# ---------------------------------------------------------
reg_field = Template ("""    rand uvm_reg_field $FIELD_NAME;
""")


# ---------------------------------------------------------
# Build function definition
# ---------------------------------------------------------
build_func = """
    //---build------------------------------------------------------------
    virtual function void build();
"""

# ---------------------------------------------------------
# Build field definition
# ---------------------------------------------------------
build_field = Template ("""        $FIELD_NAME = uvm_reg_field::type_id::create("$FIELD_NAME");""")

# ---------------------------------------------------------
# Configure field definition
# ---------------------------------------------------------
config_field = Template ('''        $FIELD_NAME.configure(this, $FIELD_SIZE, $FIELD_OFFSET, "${FIELD_ACCESS}", $VOLATILE, $RESET_VALUE, $HAS_RESET, $IS_RAND, 1);''')


# ---------------------------------------------------------
# Write 'endfunction'
# ---------------------------------------------------------
endfunction = '''    endfunction
'''

# ---------------------------------------------------------
# Write 'endgroup'
# ---------------------------------------------------------
endgroup = '''    endgroup
'''

# ---------------------------------------------------------
# Write access covergroup function definition
# ---------------------------------------------------------
cov_wr_func = Template ('''
    covergroup wr_cg;
        option.per_instance=1;
        option.name="${ENTITY}_${NAME_OF_REGISTER}_wr_cg";
''')

# ---------------------------------------------------------
# Write coverpoint definition
# ---------------------------------------------------------
cov_wr = Template ("""        ${FIELD_NAME}_wr : coverpoint $FIELD_NAME.value[$FIELD_LEFT_BOUNDARY:0];""")

# ---------------------------------------------------------
# Read access covergroup function definition
# ---------------------------------------------------------
cov_rd_func = Template ('''
    covergroup rd_cg;
        option.per_instance=1;
        option.name="${ENTITY}_${NAME_OF_REGISTER}_rd_cg";
''')

# ---------------------------------------------------------
# Read coverpoint definition
# ---------------------------------------------------------
cov_rd = Template ("""        ${FIELD_NAME}_rd : coverpoint $FIELD_NAME.value[$FIELD_LEFT_BOUNDARY:0];""")

# ---------------------------------------------------------
# Sample function and register constructor - RW register
# ---------------------------------------------------------
sample_new_func_rw = Template ("""

    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "$NAME_OF_REGISTER");
        super.new(name, $WIDTH_OF_REGISTER, build_coverage($HAS_COVERAGE));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

""")


# ---------------------------------------------------------
# Sample function and register constructor - RO register
# ---------------------------------------------------------
sample_new_func_ro = Template ("""

    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "$NAME_OF_REGISTER");
        super.new(name, $WIDTH_OF_REGISTER, build_coverage($HAS_COVERAGE));
        rd_cg=new;
    endfunction
endclass

""")

# ---------------------------------------------------------
# Sample function and register constructor - WO register
# ---------------------------------------------------------
sample_new_func_wo = Template ("""

    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "$NAME_OF_REGISTER");
        super.new(name, $WIDTH_OF_REGISTER, build_coverage($HAS_COVERAGE));
        wr_cg=new;
    endfunction
endclass

""")




































# ---------------------------------------------------------
# Access wrapper class definition
# ---------------------------------------------------------
access_wrap = Template("""/* ACCESS WRAPPER CLASS */
class ${ENTITY}_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(${ENTITY}_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
""")

# ---------------------------------------------------------
# Coverage bins
# ---------------------------------------------------------
cov_bins = Template ("""        bins $NAME_OF_REGISTER              = {$REGISTER_OFFSET};""")

# ---------------------------------------------------------
# Access wrapper class constructor and sample
# ---------------------------------------------------------
access_wrap_con = Template("""      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "${ENTITY}_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: ${ENTITY}_reg_access_wrapper
""")

# ---------------------------------------------------------
# Register block definition start
# ---------------------------------------------------------
regblock_start = Template("""
//-------------------------------------------------------------------
// ${ENTITY}_register_block
//--------------------------------------------------------------------
class ${ENTITY}_register_block extends uvm_reg_block;
    `uvm_object_utils(${ENTITY}_register_block)

""")


# ---------------------------------------------------------
# List of registers inside register block
# ---------------------------------------------------------
regs_in_block = Template("""    rand $NAME_OF_REGISTER ${NAME_OF_REGISTER}_reg;""")

# ---------------------------------------------------------
# Register map and register block constructor
# ---------------------------------------------------------
reg_block_new = Template("""

    uvm_reg_map ${ENTITY}_register_map; // Block map
    ${ENTITY}_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "${ENTITY}_register_block");
        super.new(name, build_coverage($REGS_COVERAGE));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage($REGS_COVERAGE)) begin
             access_cg = ${ENTITY}_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage($REGS_COVERAGE));
        end
""")

# ---------------------------------------------------------
# Create and build each registers in a block
# ---------------------------------------------------------
regs_create_build = Template("""
        ${NAME_OF_REGISTER}_reg = $NAME_OF_REGISTER::type_id::create("$UVM_NAME_OF_REGISTER");
        ${NAME_OF_REGISTER}_reg.configure(this);
        ${NAME_OF_REGISTER}_reg.build();""")

# ---------------------------------------------------------
# Create map
# ---------------------------------------------------------
regs_create_map = Template("""

        // Map name, Offset, Number of bytes, Endianess)
        ${ENTITY}_register_map = create_map("${ENTITY}_register_map", $BASE_REG_MAP_ADDR, $REG_MAP_WIDTH_BYTES, $REG_MAP_ENDIAN);

""")

# ---------------------------------------------------------
# Add registers to map
# ---------------------------------------------------------
regs_add_map = Template ('''        ${ENTITY}_register_map.add_reg(${NAME_OF_REGISTER}_reg, $OFFSET, "${ACCESS}");''')

# ---------------------------------------------------------
# Finalize register block
# ---------------------------------------------------------
reg_block_end = Template("""

        // Lock the register model and build the map
        lock_model();
        ${ENTITY}_register_map.set_check_on_read();
    endfunction

    protected function void sample(uvm_reg_addr_t offset, bit is_read, uvm_reg_map map);
        if(get_coverage($REGS_COVERAGE)) begin
            if(map.get_name() == "${ENTITY}_register_map") begin
                access_cg.sample(offset, is_read);
            end
        end
    endfunction: sample

endclass
`endif // __${ENTITY}_REG_BLOCK_SV__

""")


# =========================================================
# Templates for top-level register block
# =========================================================

# ---------------------------------------------------------
# List of all sub register blocks
# ---------------------------------------------------------
top_list_sub_blocks = Template("""    ${ENTITY}_register_block $ENTITY;""")

# ---------------------------------------------------------
# Create and build each register block
# ---------------------------------------------------------
top_reg_block_create_build = Template("""
        $ENTITY = ${ENTITY}_register_block::type_id::create("$ENTITY");
        $ENTITY.configure(this);
        $ENTITY.build();""")

# ---------------------------------------------------------
# Top level build
# ---------------------------------------------------------
top_reg_block_new = Template("""

    uvm_reg_map ${ENTITY}_register_map; // Top level map

    //---new--------------------------------------------------------------
    function new(string name = "${ENTITY}_register_block");
        super.new(name, build_coverage($REGS_COVERAGE));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
""")

# ---------------------------------------------------------
# Add register block maps
# ---------------------------------------------------------
top_regs_add_submap = Template ("""        ${TOP}_register_map.add_submap(${ENTITY}.${ENTITY}_register_map, $OFFSET);""")

# ---------------------------------------------------------
# Finalize top register block
# ---------------------------------------------------------
reg_block_end = Template("""

        // Lock the register model and build the map
        lock_model();
        ${ENTITY}_register_map.set_check_on_read();
    endfunction

endclass
`endif // __${ENTITY}_REG_BLOCK_SV__
""")
# ---------------------------------------------------------
# PKG file of one register block
# ---------------------------------------------------------
regblock_pkg = Template("""//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $$Author          : $AUTHOR
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $$Revision: 35564 $$
// $$Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $$
// ---------------------------------------------------------------------------
// Dependencies     : ${ENTITY}_reg_block.sv
// Description      : Systemverilog package file for the register model
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __${ENTITY}_REG_BLOCK_PKG_SV__
`define __${ENTITY}_REG_BLOCK_PKG_SV__

package ${ENTITY}_reg_block_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

  `include "${ENTITY}_reg_block.sv"

endpackage :  ${ENTITY}_reg_block_pkg

`endif // __${ENTITY}_REG_BLOCK_PKG_SV__
""")

# =========================================================
# Templates for Register model package file
# =========================================================

# ---------------------------------------------------------
# Header placed at the beginning of the PKG file
# ---------------------------------------------------------
pkg_header = Template("""//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $$Author          : $AUTHOR
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $$Revision: 35564 $$
// $$Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $$
// ---------------------------------------------------------------------------
// Dependencies     : *_reg_block.sv
// Description      : Systemverilog package file for the register model
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __REGMODEL_PKG_SV__
`define __REGMODEL_PKG_SV__

package REGMODEL_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

""")

# ---------------------------------------------------------
# Include register blocks
# ---------------------------------------------------------
pkg_include= Template("""  import ${ENTITY}_reg_block_pkg::*;""")

# ---------------------------------------------------------
# Footer placed at the end of the PKG file
# ---------------------------------------------------------
pkg_footer = Template("""
  import callbacks_pkg::*;

  `include "${TOP}_reg_block.sv"
  `include "TOP_reg_block.sv"

endpackage : REGMODEL_pkg

`endif // __REGMODEL_PKG_SV__
""")
