#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: lvalla $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 37809 $
#/ $Date: 2019-02-27 14:32:37 +0100 (Wed, 27 Feb 2019) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Script to create a verilog file describing AHB registers 
#/                    from an XML description. Type xml2verilog -h for help.
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/////////////////////////////////////////////////////////////////////////////

#Parse XML register file and create a verilog file implementing the registers

import os, sys, getopt, re, string
import xml.dom.minidom
from string import *
from re import *

# Register class (register info)
class register_class:
  def __init__(self, name=None, description=None, add_offset=None, hw_access=None, sw_access=None, reset=None, define=None, verilog_addr=None, shortname=None):
    self.name = name
    self.description = description
    self.add_offset = add_offset
    self.hw_access = hw_access
    self.sw_access = sw_access
    self.reset = reset
    self.define = define
    self.verilog_addr = verilog_addr
    self.shortname = shortname


# Field class (register field info)
class field_class:
  def __init__(self, name=None, position=None, description=None,  short_description=None, width=None, reset=None, typ=None, hw=None, sw=None,
               msb_position=None, msb=None, verilogrange=None, fixed_msb=None, str_binreset=None):
    self.name = name
    self.position = position
    self.description = description
    self.short_description = short_description
    self.width = width
    self.reset = reset
    self.typ = typ
    self.hw = hw
    self.sw = sw
    self.msb_position = msb_position
    self.msb = msb
    self.verilogrange = verilogrange
    self.fixed_msb = fixed_msb
    self.str_binreset = str_binreset
  

# Integer to Binary string conversion
def dec_2_bin(n10, size, ntype):

  if n10 <0:
      n10 +=  1 << (size+1)
  
  size = size -1
  lsb = '0'
  if n10 < 0:
    lsb = '1'
    n10 +=  1 << (size+1)
    
  i = 0
  dl=[]
  s=''
  while n10>=2:
    x = n10 % 2
    n10 = (n10-x) / 2
    dl.append(x)
    i = i + 1
  dl.append(n10)
  for j in range(size-i):
    if lsb == '0':
      dl.append(lsb)
  
  dl.reverse()
  for i in range(0,len(dl)):
    s=s+str(dl[i])
  return s


# Integer to Binary string conversion
def hex_2_bin(my_str, size):
  hex2 = dec_2_bin(atoi(my_str,0),size,0)
  return hex2
  
def translate(name):
    # by default, just uppercase
    result = name.upper()

# Patch the entity name and add reg_add, reg_dw and reg_dr ports from the reference verilog file into the new verilog file
# named entity_name.verilog
def patch_name(entity_name, paddr_high, data_high, referencefile_name, taskfile_name):
  addr_high_p1=str(paddr_high+1)
  addr_high=str(paddr_high)
  addr_high_m1=str(paddr_high-1)
#  r_verilog_file=open('reg_ref.v','r')
  r_verilog_file=open(referencefile_name,'r')
  w_verilog_file=open(entity_name+'.v','w')
  haddr_line = "input  wire ["+ addr_high_p1 +":0]     haddr,"
  paddr_line1 = "reg   ["+ addr_high_m1 +":0]  pending_addr;"
  paddr_line2 = "pending_addr              <= "+ addr_high +"'b0;"
  paddr_line3 = "pending_addr  <= haddr["+ addr_high_p1 + ":2];"

  for line in r_verilog_file.xreadlines():
    line2=sub('REG_TAG',entity_name + '_reg',line)
    line3=sub('HADDR_TAG',haddr_line,line2)
    line4=sub('PADDR1_TAG',paddr_line1,line3)
    line5=sub('PADDR2_TAG',paddr_line2,line4)
    line6=sub('PADDR3_TAG',paddr_line3,line5)
    w_verilog_file.write(line6)
  r_verilog_file.close()
  w_verilog_file.close()

  command = "cp " + taskfile_name + ' ' + entity_name + '_macros_tb.v'
  os.system(command)

# This function patches the 'entity_name.verilog' file, by replacing
# the line containing 'tag' with the lines contained in 'patch_array'
def update_file(entity_name,patch_array,tag):
  r_verilog_file=open(entity_name+'.v','r')
  w_verilog_file=open(entity_name+'_new.v','w')
  for line in r_verilog_file.xreadlines():
    if match(tag,line):
      for i in range(0,len(patch_array)):
        w_verilog_file.write(patch_array[i]+'\n')
    else:
      w_verilog_file.write(line)
  r_verilog_file.close()
  w_verilog_file.close()
  command = "mv " + entity_name + '_new.v ' + entity_name + '.v'
  os.system(command)
  

# This function parses the XML file to create the verilog file
def create_registers(doc,entity_name,referencefile_name,taskfile_name):

  # Get max lengths for indentation, and max address for paddr width
  len_max = 0
  addr_max = 0
  addr_len_max = 0
  patch_msb = 0
  for root_node in doc.getElementsByTagName("root"):
    for bank_node in root_node.childNodes:
      # Get register data width from configuration data
      if bank_node.nodeName == "configuration":
        for configuration_node in bank_node.childNodes:
          if configuration_node.nodeName == "width":
            data_high = int(configuration_node.getAttribute('register')) - 1

      else: # bank_node.nodeName != "__configuration__": 
        for register_node in bank_node.childNodes:
          if register_node.nodeType == register_node.ELEMENT_NODE:
            # get max constant name length
            register=register_class()
            register.name = str(register_node.getAttribute('name'))


            if register.name is not None:
              register.add_offset = register_node.getAttribute('offset')
              #print "Name " + str(register.name)
              #print "Address offset " + str(register.add_offset)
              addr_max = max(addr_max,(atoi(register.add_offset,0)/4))
              register.verilog_addr = 'RW_HSU_' + str(register.name).upper() + '_ADDR_CT'
              addr_len_max = max(addr_len_max,len(register.verilog_addr))
          for field_node in register_node.childNodes:
            if field_node.nodeType == field_node.ELEMENT_NODE:
              # get max field name length
              field=field_class()
              field.name = lower(str(field_node.getAttribute('name')))
              len_max = max(len_max,len(field.name))

  # Add 1 for nice indentation
  len_max = len_max + 1
  addr_len_max = addr_len_max + 1
  # Compute bus width to reach max address
  paddr_high = 0
  while pow(2,paddr_high) < addr_max:
    paddr_high = paddr_high + 1
#  print "Addr high " + str(paddr_high)
#  print "Address length " + str(addr_len_max)

  # Patch ports width and entity name in verilog file
  patch_name(entity_name,paddr_high,str(data_high),referencefile_name, taskfile_name)
  
  # Arrays of strings to patch specific parts of the template:
  # Patch address constants definitions
  constant_array=[]
 # Patch address constants definitions
  addr_array=[]
  # Patch signal declaration
  sig_array=[]
  # Patch output assignment
  out_array=[]
  # Patch registers reset
  reset_array=[]
  # Patch registers write
  write_array=[]
  # Patch registers write
  pulse_array=[]
  # Patch registers read
  read_array=[]
  # Patch read process sensitivity list
  sensitivity_array=[]
  # Patch input ports
  portin_array=[]
  # Patch output ports
  portout_array=[]
  # Patch update ports
  update_array=[]

  # Declare input ports
  portin_declare_array=[]
  # Declare output ports
  portout_declare_array=[]
  
  #outpout linkage
  linkage_array=[]

  #macro 
  macros_array=[]
  task_array=[]
  

  constant_array.append('\n  // Constants for register addresses.')
  current_define = ''
  # Parse XML file and fill patch arraies
  for root_node in doc.getElementsByTagName("root"):
    # Register bank
    for bank_node in root_node.childNodes:
      if bank_node.nodeName != "configuration":      
        if (bank_node.nodeType == bank_node.ELEMENT_NODE):
          # get bank register name
          bank_name = bank_node.tagName
          print 'Registers bank : ' + str(bank_name)

          # Register
          for register_node in bank_node.childNodes:
            if register_node.nodeType == register_node.ELEMENT_NODE:
              # get all register info
              register=register_class()
              #register.name = register_node.tagName
              register.name = str(register_node.getAttribute('name'))
              
              if register.name is not None:
                register.verilog_addr = upper(entity_name) + '_' + str(register.name).upper() + '_ADDR_CT'
                register.description = register_node.getAttribute('description')
                register.add_offset = register_node.getAttribute('offset')
                register.hw_access = register_node.getAttribute('hw')
                register.sw_access = register_node.getAttribute('sw')
                register.reset = register_node.getAttribute('reset')
                register.define = register_node.getAttribute('define')

                if (str(register.define) != ''):
                  print 'Current define = ' + str(current_define) + ' read defined for ' + register.name + ' is ' + str(register.define)
                if (str(register.define) != str(current_define) and (str(current_define) != '')):
                  print 'patch endif ' + str(current_define)
                  constant_line='`endif // ' + str(current_define).ljust(addr_len_max)
                  constant_array.append(constant_line)
                  portin_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  portin_array.append(portin_line)
                  portout_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  portout_array.append(portout_line)
                  update_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  update_array.append(update_line)
                  linkage_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  linkage_array.append(linkage_line)
                  reset_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  reset_array.append(reset_line)
                  sig_line ='`endif // ' + str(current_define).ljust(addr_len_max)
                  sig_array.append(sig_line)
                  write_line='`endif // ' + str(current_define).ljust(addr_len_max)
                  write_array.append(write_line)
                  pulse_line='`endif // ' + str(current_define).ljust(addr_len_max)
                  pulse_array.append(pulse_line)
                  read_line='`endif // ' + str(current_define).ljust(addr_len_max)
                  read_array.append(write_line)
                  current_define = ''


                # Fill array with address constants
                #print "Address offset " + str(register.add_offset)
                #print "Address bin " + hex_2_bin(str(register.add_offset), paddr_high)
                if (str(register.define) != str(current_define)):
                  print '  ifdef ' + str(register.define) + ' found'
                  constant_line='`ifdef ' + str(register.define).ljust(addr_len_max)
                  constant_array.append(constant_line)
                  portin_line ='`ifdef ' + str(register.define).ljust(addr_len_max)
                  portin_array.append(portin_line)
                  portout_line ='`ifdef ' + str(register.define).ljust(addr_len_max)
                  portout_array.append(portout_line)
                  update_line ='`ifdef ' + str(register.define).ljust(addr_len_max)
                  update_array.append(update_line)
                  linkage_line ='`ifdef ' + str(register.define).ljust(addr_len_max)
                  linkage_array.append(linkage_line)
                  reset_line='`ifdef ' + str(register.define).ljust(addr_len_max)
                  reset_array.append(reset_line)
                  sig_line='`ifdef ' + str(register.define).ljust(addr_len_max)
                  sig_array.append(sig_line)
                  write_line='`ifdef ' + str(register.define).ljust(addr_len_max)
                  write_array.append(write_line)
                  pulse_line='`ifdef ' + str(register.define).ljust(addr_len_max)
                  pulse_array.append(pulse_line)
                  read_line ='`ifdef ' + str(register.define).ljust(addr_len_max)
                  read_array.append(read_line)
                  
                constant_line='  localparam ' + str(register.verilog_addr).ljust(addr_len_max) + ' = ' + str(paddr_high) + "'b" + hex_2_bin((str(atoi(register.add_offset,0)/4)), paddr_high) + ";"
                constant_array.append(constant_line)
                current_define = str(register.define)


                register.shortname = re.sub("REG$", '', str(register.name).upper())
                #register.shortname = translate(register.shortname).lower()
                macros_array.append('\n\n// Macros definition for register ' + str(register.shortname) + ' (' + str(register.sw_access) + ')')
                macros_array.append('// Register Description : ' + register.description)
                macros_array.append('`define ' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR 32\'h' + re.sub("0x","",str(register.add_offset)))
                #macros_array.append('`define ' + upper(entity_name) + '_' + str(register.shortname).upper() + '_def 32\'h' + re.sub("0x","",str(register.reset)))
                
                # register written by SW: use register name in write process (+comment) and reset comment.
                if register.sw_access.find('W') >= 0:
                  write_line='\n          // Write ' + str(register.name) + ' register.'
                  write_array.append(write_line)
                  write_line='          '+ str(register.verilog_addr) + ' :\n          begin'
                  write_array.append(write_line)
                  reset_line='      // ' + str(register.name) + ' register.'
                  reset_array.append(reset_line)


                  # Add write reg macro
                  macros_line='`define set_' + lower(entity_name) + '_' + lower(register.shortname) + '(val) `' + entity_name + '_write(`' + upper(entity_name) + '_' + upper(register.shortname)+ '_ADDR,val,"' + str(register.shortname) + '")'
                  macros_array.append(macros_line)
                  # register also read by SW: declare signal and assign output port.
                  if register.sw_access.find('R') >= 0:
                    sig_line='  // ' + str(register.name) + ' register.'
                    sig_array.append(sig_line)

                # register set or clear by SW: use register name in write process (+comment) and reset comment.
                if (register.sw_access.find('S') >= 0) or (register.sw_access.find('C') >= 0):
                  write_line='\n          // Write ' + str(register.name) + ' register.'
                  write_array.append(write_line)
                  write_line='          '+ str(register.verilog_addr) + ' :\n          begin'
                  write_array.append(write_line)
                  if (register.sw_access.find('S') >= 0):
                    read_line='\n        // Read ' + str(register.name) + ' register.'
                    read_array.append(read_line)
                    read_line='        '+ str(register.verilog_addr) + ' :\n       begin'
                    read_array.append(read_line)
                  reset_line='      // ' + str(register.name) + ' register.'
                  reset_array.append(reset_line)
                  # Add write reg macro(str(atoi(register.add_offset,0)/4))
                  macros_line='`define set_' + lower(entity_name) + '_' + lower(register.shortname) + '(val) `' + entity_name + '_write(`' + upper(entity_name) + '_' + upper(register.shortname) + '_ADDR,val,"' + str(register.shortname) + '")'
                  macros_array.append(macros_line)
                
                if (register.sw_access.find('S') >= 0):
                  portin_line='    //$port_g ' + str(register.name) + ' register.'
                  portin_array.append(portin_line)
                  
                # register read by HW: use register name in output port (+comment).
                if (register.hw_access.find('R') >= 0):
                  portout_line='    //$port_g ' + str(register.name) + ' register.'
                  portout_array.append(portout_line)

                # register write by HW: use register name in input port (+comment).
                if (register.hw_access.find('W') >= 0):
                  portin_line='    //$port_g ' + str(register.name) + ' register.'
                  portin_array.append(portin_line)

                # register read by SW: patch read process
                if register.sw_access.find('R') >= 0:
                  read_line='\n        // Read ' + str(register.name) + ' register.'
                  read_array.append(read_line)
                  read_line='        '+ str(register.verilog_addr) + ' :\n        begin'
                  read_array.append(read_line)

                  # Add read reg macro
                  macros_line='`define get_' + lower(entity_name) + '_' + lower(register.shortname)  + '(val) `' + entity_name + '_read(`' + upper(entity_name) + '_' + upper(register.shortname) + '_ADDR,val,"' + str(register.shortname) + '")'
                  macros_array.append(macros_line)


                # Register Field
                for field_node in register_node.childNodes:
                  if field_node.nodeType == field_node.ELEMENT_NODE:
                    # get all register field info
                    field=field_class()
                    field.name = lower(str(field_node.getAttribute('name')))
                    field.description = str(field_node.getAttribute('description'))
                    field.short_description = str(field_node.getAttribute('short_description'))
                    field.width = int(field_node.getAttribute('width'))
                    field.typ = field_node.getAttribute('type')
                    field.hw = field_node.getAttribute('hw')
                    field.sw = field_node.getAttribute('sw')
                    field.position = field_node.getAttribute('position')
                    field.fixed_msb = 0

                    field.msb = int(field.width)-1
                    field.msb_position = field.msb + int(field.position)
                    
                    field.reset = field_node.getAttribute('reset')
                    macros_array.append('   // Macros definition for field ' + str(field.name))
                    #description=field.description
                    macros_array.append('   // Field Description : ' + field.short_description)

                    if field.reset[0] != "`" :
                      field.str_binreset = dec_2_bin(int(field.reset),field.width,str(field.typ))
                    else:
                      field.str_binreset = field.reset  

                    # Find registers with read-only MSB.
                    if (field.sw[0] == '1') or (field.sw[0] == '0'):
                      print "Found MSB read register " + field.name
                      # In case of SW written registers with fixed MSB, this MSB is not implemented with a FF.
                      if (field.sw.count('RW') > 0):
                        field.msb = field.msb-1
                      field.fixed_msb = 1

                    if field.width > 1:
                      field.verilogrange = '[' + str(field.msb) + ' : 0]'
                      field.verilogapbrange = '[' + str(field.msb_position) + ' : ' + str(int(field.position)) + ']'
                      #field.verilogtype = 'reg'
                      field.verilogtype = ''
                    else:
                      field.verilogrange = '       '
                      field.verilogapbrange = '[' + str(field.msb_position) + ']'
                      field.verilogtype = ''

                    # Set only by SW, add _in and _in_valid inputs.
                    if (field.sw.find('S') >= 0):
                      update_line = '        if (' + field.name + '_in_valid)'
                      update_array.append(update_line)
                      update_line = '          int_' + field.name.ljust(len_max) + ' <= ' + field.name + '_in;'
                      update_array.append(update_line)

                      fieldname = field.name +'_in'
                      portin_line = '    input wire ' + field.verilogrange.ljust(11) + fieldname.ljust(len_max+9) + ', // ' + field.short_description + 'In'
                      fieldname = field.name +'_in_valid'
                      portin_array.append(portin_line)
                      portin_line = '    input wire ' + str().ljust(11)              + fieldname.ljust(len_max+9) + ', // ' + field.short_description + 'In Valid'
                      portin_array.append(portin_line)
                      
                      portout_line = '    output wire ' + field.verilogrange.ljust(11) + field.name.ljust(len_max+8) + ', // ' + field.short_description
                      portout_array.append(portout_line)
                      sig_line='  reg ' + field.verilogrange + ' int_' + field.name.ljust(len_max)+ ';'
                      sig_array.append(sig_line)
                      linkage_line = '  assign '+ field.name.ljust(len_max) + '= int_'+field.name.ljust(len_max)+';'
                      linkage_array.append(linkage_line)
                      # Write process
                      if field.width > 1:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= ' + str(field.msb+1) + '\'b' + field.str_binreset[field.fixed_msb:] + ';'
                        reset_array.append(reset_line)
                      else:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= 1\'b' + str(field.reset) + ';'
                        reset_array.append(reset_line)
                      if field.fixed_msb == 0:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ' || int_' + field.name + ';'
                        write_array.append(write_line)
                      else:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ' || int_' + field.name + ';'
                        write_array.append(write_line)
                      # Read process
                      if (field.fixed_msb == 0):
                        read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + ' = ' + field.name + ';'
                        read_array.append(read_line)
                      else:
                        read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + " = '" + field.str_binreset[0] + "' & "+ field.name + ';'
                        read_array.append(read_line)
                      sensitivity_array.append('       or  ' + field.name)

                    # Clear only by SW, add status input.
                    elif (field.sw.find('C') >= 0):
                      pulse_line ='        int_' + field.name.ljust(len_max) + ' <= ' + str(field.msb+1) + "'b" + field.str_binreset[field.fixed_msb:] + ';'
                      pulse_array.append(pulse_line)

                      portout_line = '    output wire ' + field.verilogrange.ljust(11) + field.name.ljust(len_max+8) + ', // ' + field.short_description
                      portout_array.append(portout_line)

                      sig_line='  reg ' + field.verilogrange + ' int_' + field.name.ljust(len_max)+ ';'
                      sig_array.append(sig_line)
                      linkage_line = '  assign '+ field.name.ljust(len_max) + '= int_'+field.name.ljust(len_max)+';'
                      linkage_array.append(linkage_line)
                      # Write process
                      if field.width > 1:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= ' + str(field.msb+1) + '\'b' + field.str_binreset[field.fixed_msb:] + ';'
                        reset_array.append(reset_line)
                      else:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= 1\'b' + str(field.reset) + ';'
                        reset_array.append(reset_line)
                      if field.fixed_msb == 0:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                        write_array.append(write_line)
                      else:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                        write_array.append(write_line)

                    # Fixed register: read only by SW, no input port, defined using constants.
                    elif (field.hw.find('F') >= 0):

                      #print "\nfound fixed register " + field.name + ' ' + field.hw
                      field.name = upper(entity_name) + '_' + upper(field.name) + '_CT'
                      constant_array.insert(0, '  localparam ' + field.name.ljust(addr_len_max) + " <= " + str(field.width) + "'b" + field.str_binreset + ";")
                      read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + ' <= ' + field.name + ';'
                      read_array.append(read_line)


                    # SW Read only registers: patch input port, read process (reg_dr and sensitivity list). No output port
                    elif (field.sw.count('W') == 0):
                      portin_line='    //$port_g ' + str(register.name) + ' register.'
                      # Write comment line only once.
                      if portin_line not in portin_array:
                        portin_array.append(portin_line)

                      portin_line = '    input wire ' + field.verilogrange.ljust(11) + field.name.ljust(len_max+9) + ', // ' + field.short_description
                      portin_array.append(portin_line)

                      sensitivity_array.append('       or  ' + field.name)
                      read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + ' <= ' + field.name + ';'
                      read_array.append(read_line)

                      macros_line='`define getf_' + lower(entity_name) + '_' + field.name + '(val) begin' + ' \\\n' \
                        + '                         reg [31:0] tmp_val; \\\n' \
                        + '                         `' + entity_name + '_read(`' + upper(entity_name) + '_' + upper(register.shortname) + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                         val = ( (tmp_val&32\'b' + dec_2_bin((2**int(field.msb_position+1) - 2**int(field.position)),32,str(field.typ)) + ' )>> ' + str(field.position) + '); \\\n' \
                        + '                       end'
                      macros_array.append(macros_line)

                    # SW Write only registers: patch write process (reset and reg_dw), signal declaration,
                    # output port (declaration and assignment)
                    elif (field.sw.count('R') == 0):
                      #print "\nfound register " + field.name + ' ' + field.info
                      # Reset value: use ' or " depending on field width.
                      if field.width > 1:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= ' + str(field.msb+1) + '\'b' + str(field.reset) + ';'
                        reset_array.append(reset_line)
                      else:
                        reset_line = '      int_' + field.name.ljust(len_max) + ' <= 1\'b' + str(field.reset) + ';'
                        reset_array.append(reset_line)
                      # Write declaration
                      write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                      write_array.append(write_line)
                      # Ports out declaration

                      portout_line = '    output wire ' + field.verilogrange.ljust(11) + field.name.ljust(len_max+9) + ', // ' + field.short_description
                      portout_array.append(portout_line)

                      # Linkage declaration
                      linkage_line = '  assign ' + field.name.ljust(len_max) + '= int_' + field.name.ljust(len_max) + ';'
                      linkage_array.append(linkage_line)

                      # Signal declaration
                      sig_line = '  reg ' + field.verilogrange + ' int_' + field.name.ljust(len_max) + ';'
                      sig_array.append(sig_line)

                      macros_line='`define setf_' + lower(entity_name) + '_' + field.name + '(val) begin' + ' \\\n' \
                        + '                         reg [31:0] tmp_val; \\\n' \
                        + '                         `' + entity_name + '_read(`' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                         tmp_val' + field.verilogapbrange + ' = val; \\\n' \
                        + '                         `' + entity_name + '_write(`' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                       end'
                      macros_array.append(macros_line)

                      if (field.hw.find('W') >= 0):
                        update_line = '        if (' + field.name + '_in_valid)'
                        update_array.append(update_line)
                        update_line = '          int_' + field.name.ljust(len_max) + ' <= ' + field.name + '_in;'
                        update_array.append(update_line)
                        field.name=field.name +'_in'
                        portin_line = '    input wire ' + field.verilogrange.ljust(11) + fieldname.ljust(len_max+9) + ', // ' + field.short_description + ' In'
                        portin_array.append(portin_line)
                        field.name=field.name +'_in_valid'
                        portin_line = '    input wire ' + str().ljust(11)              + fieldname.ljust(len_max+9) + ', // ' + field.short_description + 'In Valid'
                        portin_array.append(portin_line)



                    # register read and written by SW: patch write process (reset and reg_dw), signal declaration,
                    # output port (declaration and assignment), and read process (reg_dr and sensitivity list)
                    else:
                      #print field.name.ljust(len_max)  + "   " + str(field.str_binreset)
                      # Reset value: use ' or " depending on field width.
                      if field.str_binreset[0] == "`":
                        reset_line = '      int_' + field.name.ljust(len_max) + " <= " + field.str_binreset[field.fixed_msb:] + ';'
                        reset_array.append(reset_line)

                      elif field.width > 1:

                        reset_line = '      int_' + field.name.ljust(len_max) + " <= " + str(field.msb+1) + "'b" + field.str_binreset[field.fixed_msb:] + ';'
                        reset_array.append(reset_line)

                      else:

                        reset_line = '      int_' + field.name.ljust(len_max) + " <= 1'b" + str(field.reset) + ";"
                        reset_array.append(reset_line)

                      macros_line='`define getf_' + entity_name + '_' + field.name + '(val) begin' + ' \\\n' \
                        + '                         reg [31:0] tmp_val; \\\n' \
                        + '                         `' + entity_name + '_read(`' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                         val = ( (tmp_val&32\'b' + dec_2_bin((2**int(field.msb_position+1) - 2**int(field.position)),32,str(field.typ)) + ' )>> ' + str(field.position) + '); \\\n' \
                        + '                       end'
                      macros_array.append(macros_line)

                      macros_line='`define setf_' + entity_name + '_' + field.name + '(val) begin' + ' \\\n' \
                        + '                         reg [31:0] tmp_val; \\\n' \
                        + '                         `' + entity_name + '_read(`' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                         tmp_val' + field.verilogapbrange + ' = val; \\\n' \
                        + '                         `' + entity_name + '_write(`' + upper(entity_name) + '_' + str(register.shortname).upper() + '_ADDR,tmp_val,"' + register.name + '/' + field.name + '")' + '; \\\n' \
                        + '                       end'
                      macros_array.append(macros_line)

                      #print "field HW " + field.name + "      " +  field.hw + " register access " + register.sw_access
                      if ((field.hw.find('W') >= 0) and not(field.sw.find('S') >= 0) and not(field.sw.find('C') >= 0)):

                        update_line = '        if (' + field.name + '_in_valid)'
                        update_array.append(update_line)
                        update_line = '          int_' + field.name.ljust(len_max) + ' <= ' + field.name + '_in;'
                        update_array.append(update_line)
                        fieldname=field.name +'_in'
                        portin_line = '    input wire ' + field.verilogrange.ljust(11) + fieldname.ljust(len_max+9) + ', // ' + field.short_description + ' In'
                        portin_array.append(portin_line)
                        fieldname=field.name +'_in_valid'
                        portin_line = '    input wire ' + str().ljust(11)              + fieldname.ljust(len_max+9) + ', // ' + field.short_description + ' In Valid'
                        portin_array.append(portin_line)

                                              
                      # In case of read-only MSB, do not write MSB in APB write process but in output port assignment
                      if field.fixed_msb == 0:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                        write_array.append(write_line)

                        portout_line = '    output wire ' + field.verilogrange.ljust(11) + field.name.ljust(len_max+8) + ', // ' + field.short_description
                        portout_array.append(portout_line)


                        sig_line='  reg ' + field.verilogrange + ' int_' + field.name.ljust(len_max) + ';'
                        sig_array.append(sig_line)

                      else:
                        write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                        write_array.append(write_line)
                        portout_line = '    ' + field.name.ljust(len_max) + ' : out ' + field.verilogtype +'(' + str(field.msb+1) + ' downto 0);'
                        portout_array.append(portout_line)
                      
                      if (field.sw.find('S') >= 0) or (field.sw.find('C') >= 0):
                        pulse_line ='        int_' + field.name.ljust(len_max) + ' <= ' + str(field.msb+1) + "'b" + field.str_binreset[field.fixed_msb:] + ';'
                        pulse_array.append(pulse_line)
                        
                      
                      linkage_line = '  assign '+ field.name.ljust(len_max) + "= int_"+field.name.ljust(len_max)+';'
                      linkage_array.append(linkage_line)
                      
                      # Read process
                      if (field.sw.find('S') >= 0):
                        read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + ' <= ' + 'status' + field.name  + ';'
                        portin_line = '    input wire ' + field.verilogrange + ' '+ 'status' + field.name.ljust(len_max+8) + ', // ' + field.short_description
                        portin_array.append(portin_line)
                        sensitivity_array.append('       or  ' + 'status' + field.name)

                      elif field.fixed_msb == 0:
                        read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + ' <= ' + field.name + ';'
                        sensitivity_array.append('       or  ' + field.name)
                      else:
                        read_line='          int_reg_dr' + field.verilogapbrange.ljust(15) + " <= '" + field.str_binreset[0] + "' & "+ field.name + ';'
                        sensitivity_array.append('       or  ' + field.name)
                      read_array.append(read_line)
                
                if (register.sw_access.find('R') >= 0):
                  read_line='        end'
                  read_array.append(read_line)
               
                if (register.sw_access.find('W') >= 0):
                  
                  # Update LSB write data for 16-bit access
                  for field_node in register_node.childNodes:
                    if field_node.nodeType == field_node.ELEMENT_NODE:
                      # get all register field info
                      field=field_class()
                      field.name = lower(str(field_node.tagName))
                      field.width = int(field_node.getAttribute('width'))
                      field.typ = field_node.getAttribute('type')
                      field.hw = field_node.getAttribute('hw')
                      field.sw = field_node.getAttribute('sw')
                      field.position = field_node.getAttribute('position')
                      field.fixed_msb = 0

                      field.msb = int(field.width)-1
                      field.msb_position = field.msb + int(field.position)
                      
                      field.reset = field_node.getAttribute('reset')
                      if field.reset[0] != "`" :
                        field.str_binreset = dec_2_bin(int(field.reset),field.width,str(field.typ))
                      else:
                        field.str_binreset = field.reset  

                      # Find registers with read-only MSB.
                      if (field.sw[0] == '1') or (field.sw[0] == '0'):
                        print "Found MSB read register " + field.name
                        # In case of SW written registers with fixed MSB, this MSB is not implemented with a FF.
                        if (field.sw.count('RW') > 0):
                          field.msb = field.msb-1
                        field.fixed_msb = 1

                      if field.width > 1:
                        field.verilogrange = '[' + str(field.msb) + ' : 0]'
                        field.verilogapbrange = '[' + str(field.msb_position) + ' : ' + str(int(field.position)) + ']'
                        field.verilogtype = ''
                      else:
                        field.verilogrange = ''
                        field.verilogapbrange = '[' + str(field.msb_position) + ']'
                        field.verilogtype = ''
                      
                      if ((int(field.msb_position) > 15) and (patch_msb == 0)):
                        patch_msb = 1
                        #print "MSB patch " + str(register.name)
                      
                      if (field.width > 1) and (int(field.msb_position) > 15) and (int(field.position) < 16):
                        #print str(field.name) + ' msb_position ' + str(field.msb_position) + ' position ' + str(field.position)
                        field.verilogapbrange = '[15' + ' : ' + str(int(field.position)) + ']'
                        field.msb_position = 15
                        field.name = field.name + '[' + str(int(field.msb_position)-int(field.position)) + ' : 0]'
                      
                     
                  patch_msb = 0
                  #print "MSB patch clear " + str(register.name)
                  write_line='          end'
                  write_array.append(write_line)

                if ((register.sw_access.find('S') >= 0) or (register.sw_access.find('C') >= 0)):
                  
                  # Update LSB write data for 16-bit access
                  for field_node in register_node.childNodes:
                    if field_node.nodeType == field_node.ELEMENT_NODE:
                      # get all register field info
                      field=field_class()
                      field.name = lower(str(field_node.tagName))
                      field.width = int(field_node.getAttribute('width'))
                      field.typ = field_node.getAttribute('type')
                      field.hw = field_node.getAttribute('hw')
                      field.sw = field_node.getAttribute('sw')
                      field.position = field_node.getAttribute('position')
                      field.fixed_msb = 0

                      field.msb = int(field.width)-1
                      field.msb_position = field.msb + int(field.position)
                      
                      field.reset = field_node.getAttribute('reset')
                      if field.reset[0] != "`" :
                        field.str_binreset = dec_2_bin(int(field.reset),field.width,str(field.typ))
                      else:
                        field.str_binreset = field.reset  

                      # Find registers with read-only MSB.
                      if (field.sw[0] == '1') or (field.sw[0] == '0'):
                        print "Found MSB read register " + field.name
                        # In case of SW written registers with fixed MSB, this MSB is not implemented with a FF.
                        if (field.sw.count('RW') > 0):
                          field.msb = field.msb-1
                        field.fixed_msb = 1

                      if field.width > 1:
                        field.verilogrange = '[' + str(field.msb) + ' : 0]'
                        field.verilogapbrange = '[' + str(field.msb_position) + ' : ' + str(int(field.position)) + ']'
                        field.verilogtype = ''
                      else:
                        field.verilogrange = ''
                        field.verilogapbrange = '[' + str(field.msb_position) + ']'
                        field.verilogtype = ''
                      
                      if ((int(field.msb_position) > 15) and (patch_msb == 0)):
                        patch_msb = 1
                        #print "MSB patch " + str(register.name)
                      
                      if (field.width > 1) and (int(field.msb_position) > 15) and (int(field.position) < 16):
                        #print str(field.name) + ' msb_position ' + str(field.msb_position) + ' position ' + str(field.position)
                        field.verilogapbrange = '[15' + ' : ' + str(int(field.position)) + ']'
                        field.msb_position = 15
                        field.name = field.name + '[' + str(int(field.msb_position)-int(field.position)) + ' : 0]'
                      
                      if (field.msb_position < 16):
                        # Set only by SW, add status input.
                        if (field.sw.find('S') >= 0):
                          if field.fixed_msb == 0:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ' || int_' + field.name + ';'
                            write_array.append(write_line)
                          else:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ' || int_' + field.name + ';'
                            write_array.append(write_line)
                        # Clear only by SW, add status input.
                        elif  (field.sw.find('C') >= 0):
                          if field.fixed_msb == 0:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                            write_array.append(write_line)
                          else:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                            write_array.append(write_line)
                        # SW Write only registers: patch write process (reset and reg_dw), signal declaration,
                        # output port (declaration and assignment)
                        elif (field.sw.count('R') == 0):
                          # Write declaration
                          write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                          write_array.append(write_line)

                        # register read and written by SW: patch write process (reset and reg_dw), signal declaration,
                        # output port (declaration and assignment), and read process (reg_dr and sensitivity list)
                        elif (field.sw.find('W') >= 0):
                          # In case of read-only MSB, do not write MSB in APB write process but in output port assignment
                          if field.fixed_msb == 0:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                            write_array.append(write_line)
                          else:
                            write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                            write_array.append(write_line)
                     
                  if (patch_msb == 1):


                     # Update MSB write data for 16-bit access
                     for field_node in register_node.childNodes:
                       if field_node.nodeType == field_node.ELEMENT_NODE:
                         # get all register field info
                         field=field_class()
                         field.name = lower(str(field_node.tagName))
                         field.width = int(field_node.getAttribute('width'))
                         field.typ = field_node.getAttribute('type')
                         field.hw = field_node.getAttribute('hw')
                         field.sw = field_node.getAttribute('sw')
                         field.position = field_node.getAttribute('position')
                         field.fixed_msb = 0

                         field.msb = int(field.width)-1
                         field.msb_position = field.msb + int(field.position)
                         
                         field.reset = field_node.getAttribute('reset')
                         if field.reset[0] != "`" :
                           field.str_binreset = dec_2_bin(int(field.reset),field.width,str(field.typ))
                         else:
                           field.str_binreset = field.reset  

                         # Find registers with read-only MSB.
                         if (field.sw[0] == '1') or (field.sw[0] == '0'):
                           print "Found MSB read register " + field.name
                           # In case of SW written registers with fixed MSB, this MSB is not implemented with a FF.
                           if (field.sw.count('RW') > 0):
                             field.msb = field.msb-1
                           field.fixed_msb = 1

                         if field.width > 1:
                           field.verilogrange = '[' + str(field.msb) + ' : 0]'
                           field.verilogapbrange = '[' + str(field.msb_position) + ' : ' + str(int(field.position)) + ']'
                           field.verilogtype = ''
                         else:
                           field.verilogrange = ''
                           field.verilogapbrange = '[' + str(field.msb_position) + ']'
                           field.verilogtype = ''

                         if (field.width > 1) and (int(field.msb_position) > 15) and (int(field.position) < 16):
                           #print str(field.name) + ' msb_position ' + str(field.msb_position) + ' position ' + str(field.position) + ' width ' + str(field.width)
                           field.verilogapbrange = '[' + str(int(field.msb_position)) + ' : 16]'
                           field.position = 16
                           field.name = field.name + '[' + str(int(field.width)-1) + ' : ' + str(int(field.width)-int(field.msb_position)+15) + ']'

                         if (field.msb_position > 15):
                           # Set only by SW, add status input.
                           if (field.sw.find('S') >= 0):
                             if field.fixed_msb == 0:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ' || int_' + field.name + ';'
                               write_array.append(write_line)
                             else:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ' || int_' + field.name + ';'
                               write_array.append(write_line)
                           # Clear only by SW, add status input.
                           elif  (field.sw.find('C') >= 0):
                             if field.fixed_msb == 0:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                               write_array.append(write_line)
                             else:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                               write_array.append(write_line)
                           # SW Write only registers: patch write process (reset and reg_dw), signal declaration,
                           # output port (declaration and assignment)
                           elif (field.sw.count('R') == 0):
                             # Write declaration
                             write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                             write_array.append(write_line)

                           # register read and written by SW: patch write process (reset and reg_dw), signal declaration,
                           # output port (declaration and assignment), and read process (reg_dr and sensitivity list)
                           elif (field.sw.find('W') >= 0):
                             # In case of read-only MSB, do not write MSB in APB write process but in output port assignment
                             if field.fixed_msb == 0:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + field.verilogapbrange + ';'
                               write_array.append(write_line)
                             else:
                               write_line='              int_' + field.name.ljust(len_max) + ' <= int_reg_dw' + '[' + str(field.msb_position-1) + ' : ' + str(int(field.position)) + ']' + ';'
                               write_array.append(write_line)

                  patch_msb = 0
                  #print "MSB patch clear " + str(register.name)
                  write_line='          end'
                  write_array.append(write_line)
                  # Close ifdef register
                  if (register.sw_access.find('S') >= 0):
                    read_line='        end'
                    read_array.append(read_line)

                # Constant for fixed register
                if (register.hw_access == 'F'):
                  constant_array.insert(0, '\n  // Constants needed for ' + str(register.name) + ' register.')
          
  print 'Current define = ' + str(current_define) + ' read defined for ' + register.name + ' is ' + str(register.define)
  if (str(current_define) != ''):
    print 'patch endif 2 ' + str(current_define)
    constant_line='`endif // ' + str(current_define).ljust(addr_len_max)
    constant_array.append(constant_line)
    portin_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    portin_array.append(portin_line)
    portout_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    portout_array.append(portout_line)
    update_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    update_array.append(update_line)
    linkage_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    linkage_array.append(linkage_line)
    reset_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    reset_array.append(reset_line)
    sig_line ='`endif // ' + str(current_define).ljust(addr_len_max)
    sig_array.append(sig_line)
    write_line='`endif // ' + str(current_define).ljust(addr_len_max)
    write_array.append(write_line)
    pulse_line='`endif // ' + str(current_define).ljust(addr_len_max)
    pulse_array.append(pulse_line)
    read_line='`endif // ' + str(current_define).ljust(addr_len_max)
    read_array.append(write_line)
    current_define = ''
  # defines macros for apb tasks
  task_line='//// Macros definitions for ahb tasks'
  task_array.append(task_line)
  task_line='`define ' + entity_name  + '_read(addr,val,str) ' + 'ahb_read(addr,val,str)'
  task_array.append(task_line)
  task_line='`define ' + entity_name + '_write(addr,val,str) ' + 'ahb_write(addr,val,str)'
  task_array.append(task_line)
  # Add paddr to the sensitivity list
  sensitivity_array.append('                     or  haddr')
  return (addr_array,sig_array,out_array,reset_array,write_array,pulse_array,read_array,sensitivity_array,portin_array,portout_array,portin_declare_array,constant_array,linkage_array,update_array,macros_array,task_array)
        

def display_help():
    print "\n    Usage:"
    print "       xml2verilog.py -x|--xml <xml_source_file> -e|--entity <verilog_entity_name> [-b|--block]"
    print "       xml2verilog.py -h|--help"
    print "    Creates a verilog APB registers file named 'entity.verilog' from the 'xml_source_file' XML\n"
    print "    register description file."
    print "    If optionnal '-b' option is used, creates the block hierarchy for 'entity'"
    print "       Example: python -i xml2verilog.py -x reg.xml -e phy_registers\n"


def main(argv):
  
  # Get arguments from command line
  short = 'x:e:r:t:bh'
  long = ('help', 'xml', 'entity', 'block', 'reference','task')
  try:
    opts, args = getopt.getopt(sys.argv[1:], short, long)
  except getopt.GetoptError, exc:
     print exc
     display_help()
     return 1

  # Error in arguments
  if args:
    display_help()
    return 1

  # Check received arguments
  xmlfile=None
  entity_name=None
  referencefile_name = "reg_ref.v"
  command=None
  taskfile_name = "task_ref.v"

  for opt,val in opts:
    if opt in ('-h', '--help'):
      display_help()
      return 0
    elif opt in ('-x', '--xml'):
      xmlfile = val
    elif opt in ('-e', '--entity'):
      entity_name = val
    elif opt in ('-r', '--reference'):
      referencefile_name = val
    elif opt in ('-t', '--task'):
      taskfile_name = val
      
      
      
  # print command
  command = 'mv ' + entity_name + '.v ' + '../verilog/rtl/' + entity_name + '_reg.v '
  if xmlfile is None or entity_name is None:
    display_help()
    return 1

  # Parse XML registers file
  doc = xml.dom.minidom.parse(xmlfile)
  (addr_array,sig_array,out_array,reset_array,write_array,pulse_array,
  read_array,sensitivity_array,portin_array,portout_array,
  portin_declare_array,constant_array,linkage_array,update_array,macros_array,task_array)=create_registers(doc,entity_name,referencefile_name, taskfile_name)

  # Update verilog file
  update_file(entity_name,constant_array,'.*CONSTANT_TAG.*')
  update_file(entity_name,addr_array,'.*ADDR_TAG.*')
  update_file(entity_name,sig_array,'.*SIG_TAG.*')
  update_file(entity_name,out_array,'.*OUTPUT_TAG.*')
  update_file(entity_name,reset_array,'.*RESET_TAG.*')
  update_file(entity_name,write_array,'.*WRITE_TAG.*')
  update_file(entity_name,pulse_array,'.*PULSE_TAG.*')
  update_file(entity_name,read_array,'.*READ_TAG.*')
  update_file(entity_name,sensitivity_array,'.*SENS_TAG.*')
  update_file(entity_name,portin_array,'.*PORT_IN_TAG.*')
  update_file(entity_name,portout_array,'.*PORT_OUT_TAG.*')
  update_file(entity_name,update_array,'.*UPDATE_TAG.*')
  update_file(entity_name,linkage_array,'.*LINKAGE_TAG.*')

  update_file(entity_name + '_macros_tb',macros_array,'.*MACROS_TAG.*')
  update_file(entity_name + '_macros_tb',task_array,'.*TASKS_TAG*.')
  r_verilog_file=open(referencefile_name,'r')
  
  


  # Create verilog block.
  if command is not None:
    os.system(command)
    
  return 0




# Execute main and exit
if __name__ == '__main__':
  status = main(sys.argv)
  os._exit(status)
