package paracom;
use strict;
no strict 'refs';

sub proc_ncw_lldpc
{
  my $npld    = @_[0];
  my $navbits = @_[1];
  my $crd     = @_[2];
  
  my ($ncw,$lldpc,$q,$r);

  # step b)
  #   ncw
  #   lldpc
  #
  # remarks:
  #  because lldpc = x*648 and
  #          648*(1-cr) =  648*[ 1/2 1/3 1/4 1/6] = [324   216   162   108]
  #          648*cr     =  648*[ 1/2 2/3 3/4 5/6] = [324   432   486   540]
  #          so lldpc*(1-cr) is always an integer
  #
  # also cr/(1-cr) is always an integer [ 1 2 3 5]

  if($navbits<=648)
  {
    $ncw = 1;
    # 912*(1-R): 912-912./[ 2 3 4 6].*[ 1 2 3 5] = [456   304   228   152]
    $r=456 if($crd==2);  # CR_12
    $r=304 if($crd==3);  # CR_23
    $r=228 if($crd==4);  # CR_34
    $r=152 if($crd==6);  # CR_56
    $r=$r+$npld;
    $lldpc=648;
    $lldpc=1296 if($navbits>=$r);
  }
  elsif($navbits<=1296)
  {
    $ncw = 1;
    # 1464*(1-R): 1464-1464./[ 2 3 4 6].*[ 1 2 3 5] = [732   488   366   244]
    $r=732 if($crd==2);  # CR_12
    $r=488 if($crd==3);  # CR_23
    $r=366 if($crd==4);  # CR_34
    $r=244 if($crd==6);  # CR_56
    $r=$r+$npld;
    $lldpc=1296;
    $lldpc=1944 if($navbits>=$r) ;
  }
  elsif($navbits<=1944)
  {
    $ncw = 1;
    $lldpc=1944;
  }
  elsif($navbits<=2592)
  {
    $ncw = 2;
    # 2916*(1-R): 2916-2916./[ 2 3 4 6].*[ 1 2 3 5] = [1458    972    729    486]
    $r=1458 if($crd==2);  # CR_12
    $r=972  if($crd==3);  # CR_23
    $r=729  if($crd==4);  # CR_34
    $r=486  if($crd==6);  # CR_56
    $r=$r+$npld;
    $lldpc=1296;
    $lldpc=1944 if($navbits>=$r) ;
  }
  else
  {
    #1944./[ 2 3 4 6].*[ 1 2 3 5] = [   972   1296   1458   1620]
    $r=972  if($crd==2);  # CR_12
    $r=1296 if($crd==3);  # CR_23
    $r=1458 if($crd==4);  # CR_34
    $r=1620 if($crd==6);  # CR_56
    ($ncw,$r) = div($npld,$r);
    $ncw++ if($r!=0);
    $lldpc = 1944;
  }
  return ($ncw,$lldpc);
}

sub proc_nshrt
{
  my $npld  = @_[0];
  my $ncw   = @_[1];
  my $lldpc = @_[2];
  my $crn   = @_[3];
  my $crd   = @_[4];
  
  my ($nshrt,$r);
  
  # step c)
  #   nshrt
  $nshrt = ($ncw*$lldpc*$crn)/$crd;
  $nshrt = $nshrt-$npld;
  $nshrt =0 if($nshrt<0);
  return $nshrt;
}

sub proc_npunc
{
  my $navbits = @_[0];
  my $ncw     = @_[1];
  my $lldpc   = @_[2];
  my $nshrt   = @_[3];
  
  # step d) npunc
 
  my $npunc;
  $npunc = $ncw*$lldpc-$navbits-$nshrt;
  $npunc = 0 if($npunc<0);
  return $npunc;
}

sub proc_extrasym
{
  my $ncw   = @_[0];
  my $lldpc = @_[1]; 
  my $nshrt = @_[2]; 
  my $npunc = @_[3]; 
  my $crn   = @_[4]; 
  my $crd   = @_[5]; 

  # step d) extra
  my $extra;
  $extra = 0;
  $extra = 1 if( (10*$npunc > $ncw*$lldpc/$crd) && (5*$nshrt < 6*$npunc*$crn) ||
                 (10*$npunc > 3*$ncw*$lldpc/$crd));
  return $extra;
}  
  
sub proc_nrep
{
  my $npld    = @_[0];
  my $navbits = @_[1];
  my $ncw     = @_[2];
  my $lldpc   = @_[3];
  my $crd     = @_[4];

  my $nrep;
  $nrep = $navbits - $ncw*$lldpc/$crd - $npld;
  $nrep = 0 if($nrep<0);
  return $nrep;
}

sub div
{
  my $dividend = int($_[0]);
  my $divisor  = int($_[1]);
  my $quotient = 0;
  my $reminder = 0;
  
  die "error: division by zero dividend=$dividend\n" if($divisor==0);
  
  $quotient = int($dividend/$divisor);
  $reminder = $dividend -$quotient*$divisor;
  #printf "div:  %d / %d  = (%d,%d)\n",$dividend,$divisor,$quotient,$reminder;
  return (int($quotient),int($reminder));
}
1;
