// BW
// --
// Choose max supported BW with one of the three following defines
//`define RW_NX_CHBW20
`define RW_NX_CHBW4020
//`define RW_NX_CHBW804020

// ANTENNA
// -------
// Choose antenna configuration with one of the two following defines
`define RW_TXRX_1X1
//`define RW_TXRX_2X2

// RADAR
// -----
// Include or not RADAR by commenting or not the following define
//`define RW_RADAR_EN

// VHT support
// -----
// Enable or not VHT support for 20/40MHz by commenting or not the following define
`define RW_NX_VHT_EN

// 256QAM support for 20 MHz HE
`define RW_NX_256QAM_EN

// LDPC
// ----
// Include or not LDPC by commenting or not the following defines
// LDPC must be enabled for BW >= 40 MHz.
// Temporary enable it in the 20 MHz config for test
// LDPC support in transmit
`define RW_NX_LDPC_ENC
// LDPC support in receive
`define RW_NX_LDPC_DEC

// BEAMFORMER
// ----------
// Include or not Beamformer support by commenting or not the following define
// If RW_MUMIMO_AP_EN is defined, RW_BFMER_EN is automatically defined.
//`define RW_BFMER_EN

// Size of the Beamforming Report Memory
// Only one of these define shall be un-commented.
//`define RW_BFMER_RAM_2KB
//`define RW_BFMER_RAM_4KB
//`define RW_BFMER_RAM_8KB
//`define RW_BFMER_RAM_16KB

// BEAMFORMEE
// ----------
// Include or not Beamformee support by commenting or not the following define
// If RW_MUMIMO_RX_EN is defined, RW_BFMER_EN is automatically defined.
`define RW_BFMEE_EN

// MU MIMO RX
// ----------
// Include or not MU-MIMO support by commenting or not the following defines
// Enable MU-MIMO reception as a STA
//`define RW_MUMIMO_RX_EN 

// MU MIMO TX
// ----------
// To enable the support of MU-MIMO transmission, one of these three following shall be uncommented depending on the number of supported users.
// Enable the MU-MIMO TX with two users
//`define RW_MUMIMO_TX_2_USERS
// Enable the MU-MIMO TX with three users
//`define RW_MUMIMO_TX_3_USERS
// Enable the MU-MIMO TX with four users
//`define RW_MUMIMO_TX_4_USERS

// NUMBER OF STA
// -------------
// Number of supported STA (6 VAPs and 40 STAs)
`define RW_CONFIG_6VAP_40STA
// Number of supported STA (6 VAPs and 104 STAs)
//`define RW_CONFIG_6VAP_104STA

// ENCRYPTION
// ----------
// Include or not GCMP support by commenting or not the following define
//`define RW_GCMP_EN
// Include or not WAPI support by commenting or not the following define
//`define RW_WAPI_EN

// COEXISTANCE
// -----------
// To enable the support of Bluetooth coexistence, the following define can be set.
//`define RW_WLAN_COEX_EN 

// CLOCKING
// --------
// Configure the macCore Clock frequency. This is used to configure all the internal timers. The value is given in MHz
`define MAC_FREQ 60
//Configure the mac Platform Clock frequency.The value is given in MHz
`define MACPI_CLK_FREQ 80

// Clock ratio for wep/tkip clock
`define WEP_2_BB_CLK_RATIO 1
//Depending on macCoreClk frequency, the WEP/TKIP clock frequency shall be defined. This clock frequency must be at least 60MHz, and an equal or a multiple of macCoreClk. 
//If the WTClk is equal to macCoreClk, WEP_2_BB_CLK_RATIO must be defined to 1 and NO_PRNG_FASTER_CLK must be defined.
//If the WTClk is a multiple (n) of macCoreClk, WEP_2_BB_CLK_RATIO must be defined to (n) and PRNG_FASTER_CLK must be defined.
