#include "stdio.h"
#include "math.h"
#include <svdpi.h>
#include <signal.h>
#include "libhwmdm.h"
#include "libhwmdmAX.h"

//static struct sigaction my_sv_illvec;
//static struct sigaction my_sv_fpevec;
//static struct sigaction my_sv_busvec;
static struct sigaction my_sv_segvec;
//static struct sigaction my_sv_usr1vec;
//static struct sigaction my_sv_usr2vec;

// Globals
mxArray *rxRF  = NULL;
mxArray *wRF   = NULL;
bool    txcore_only = false;
int     observation_ax = 1; // default observation to 1

void set_handler() {
  //printf("    [MATLAB_DEBUG] Enter in set_handler\n");fflush(stdout);
//         if (sigaction (SIGILL, NULL, &my_sv_illvec) == -1) {
//             printf("SIGILL - set_handler \n");fflush(stdout);
//         }
//         if (sigaction (SIGFPE, NULL, &my_sv_fpevec) == -1) {
//             printf("SIGFPE - set_handler \n");fflush(stdout);
//         }
//         if (sigaction (SIGBUS, NULL, &my_sv_busvec) == -1) {
//             printf("SIGBUS - set_handler \n");fflush(stdout);
//         }
        if (sigaction (SIGSEGV, NULL, &my_sv_segvec) == -1) {
            printf("SIGSEGV - set_handler \n");fflush(stdout);
        }
//        if (sigaction (SIGUSR1, NULL, &my_sv_usr1vec) == -1) {
//            printf("SIGUSR1 - set_handler \n");fflush(stdout);
//        }
//        if (sigaction (SIGUSR2, NULL, &my_sv_usr2vec) == -1) {
//            printf("SIGUSR2 - set_handler \n");fflush(stdout);
//        }
  //printf("    [MATLAB_DEBUG] Leave set_handler\n");fflush(stdout);
}

void reset_handler() {
  //printf("    [MATLAB_DEBUG] Enter in reset_handler\n");fflush(stdout);
//         if (sigaction (SIGILL, &my_sv_illvec, NULL) == -1) {
//             printf("SIGILL - reset_handler \n");fflush(stdout);
//         }
//         if (sigaction (SIGFPE, &my_sv_fpevec, NULL) == -1) {
//             printf("SIGFPE - reset_handler \n");fflush(stdout);
//         }
//         if (sigaction (SIGBUS, &my_sv_busvec, NULL) == -1) {
//             printf("SIGBUS - reset_handler \n");fflush(stdout);
//         }
        if (sigaction (SIGSEGV, &my_sv_segvec, NULL) == -1) {
            printf("SIGSEGV - reset_handler \n");fflush(stdout);
        }
//        if (sigaction (SIGUSR1, &my_sv_usr1vec, NULL) == -1) {
//            printf("SIGUSR1 - reset_handler \n");fflush(stdout);
//        }
//        if (sigaction (SIGUSR2, &my_sv_usr2vec, NULL) == -1) {
//            printf("SIGUSR2 - reset_handler \n");fflush(stdout);
//        }
  //printf("    [MATLAB_DEBUG] Leave reset_handler\n");fflush(stdout);
}


int init_sim(void){
  const char *options[]={"-nojvm","-debug","-nojit","-singleCompThread"};
  //printf("    [MATLAB_DEBUG] Enter in init_sim\n");fflush(stdout);
  set_handler();
  if( !mclInitializeApplication(options,4) )
  {
    fprintf(stderr,
    "    [MATLAB] Could not initialize the application.\n");fflush(stdout);
    reset_handler();
    return -1;
  }

  //  Initialize matlab functions
  //  mclInitializeApplication(NULL,0);
  if (!libhwmdmAXInitialize())
  {
     printf("    [MATLAB] could not initialize the libhwmdmAX library properly\n");fflush(stdout);
     reset_handler();
     return -1;
  }
  printf("    [MATLAB] Running Init sim ... libhwmdmAXInitialize!\n");fflush(stdout);

  reset_handler();
  //printf("    [MATLAB_DEBUG] Leave init_sim\n");fflush(stdout);
  return 0;
}

void close_sim(void){
  //printf("    [MATLAB_DEBUG] Enter in close_sim\n");fflush(stdout);
  set_handler();
  libhwmdmAXTerminate();
  printf("    [MATLAB] Running Close sim ... libhwmdmAXTerminate!\n");fflush(stdout);

  mclTerminateApplication();
  reset_handler();
  //printf("    [MATLAB_DEBUG] Leave close_sim\n");fflush(stdout);
}

int getRevision(){
  //printf("    [MATLAB_DEBUG] Enter in getRevision\n");fflush(stdout);
  mxArray *mxVectorDataOut = NULL;

  double *pr;
  int size, i, current_data;

  set_handler();

  // Matlab function to access an internal variable of
  // structure Revision
  mlfM_revision_give(1, &mxVectorDataOut);

  // Size of the data
  size = (int)mxGetNumberOfElements(mxVectorDataOut);

  // Pointer to first real data on REAL array of the variable
  pr = (double *)mxGetPr(mxVectorDataOut);


  // Build the data output vector with Matlab data
  for (i= 0; i < size; i++)
  {
     current_data = (int)floor(*pr);
     pr++;
  }

  //mxDestroyArray(mxVectorDataOut);

  reset_handler();

  //printf("    [MATLAB_DEBUG] Leave getRevision\n");fflush(stdout);
  return current_data;
}

void setup_testcase(char *TestCasePath){

    //printf("    [MATLAB_DEBUG] Enter in setup_testcase\n");fflush(stdout);
    mxArray *mxTestCasePath;
    mxArray *txDac = NULL;

    set_handler();

    printf("    [MATLAB] Setting up the testcase env. .. \n");fflush(stdout);
    printf("    [MATLAB] Current testcase config: %s \n", TestCasePath);fflush(stdout);

    //printf("    [MATLAB_DEBUG] Matlab Run mxCreateString... \n");fflush(stdout);
    mxTestCasePath = mxCreateString(TestCasePath);

    // Parsing (hopefully) the input param
    //printf("    [MATLAB_DEBUG] Matlab Run mlfM_param_read... \n");fflush(stdout);
    mlfM_param_read(mxTestCasePath);
    // Takes the global variable SysParameter and configure
    //printf("    [MATLAB_DEBUG] Matlab Run mlfM_param_get... \n");fflush(stdout);
    mlfM_param_get();
    // This generates the data samples
    //printf("    [MATLAB_DEBUG] Matlab Run mlfM_mumimo_tx_rx_do... \n");fflush(stdout);
    printf("    [MATLAB] Matlab Run mlfM_mumimo_tx_rx_do... \n");fflush(stdout);
    mlfM_mumimo_tx_rx_do(3, &txDac, &rxRF, &wRF);

    //printf("    [MATLAB_DEBUG] Matlab Run mxDestroyArray... \n");fflush(stdout);
    mxDestroyArray(mxTestCasePath);
    //printf("    [MATLAB_DEBUG] Matlab Run mxDestroyArray... \n");fflush(stdout);
    //mxDestroyArray(txDac);

    printf("    [MATLAB] Matlab Run complete... \n");fflush(stdout);
    reset_handler();
    //printf("    [MATLAB_DEBUG] Leave setup_testcase\n");fflush(stdout);
}

int setGain (svOpenArrayHandle rxADC_re, svOpenArrayHandle rxADC_im, svOpenArrayHandle rx_rssi, int simu_time[0], svOpenArrayHandle rx_gainInd, svOpenArrayHandle vgaInd){
 // Note : vgaInd not used, was for Elma RF
  mxArray *rxADC = NULL;
  mxArray *rssi = NULL;
  mxArray *gainInd;
  mxArray *mxtime;

  int *pgain, *ptime;
  double *pr, *pi, *prssi;
  int i, j, k;
  int size_adc, size_rssi;
  int current_data_re, current_data_im, current_rssi;

  //printf("    [MATLAB_DEBUG] Enter in setGain\n");fflush(stdout);
  set_handler();

  /* Create an m-by-n mxArray; you will copy existing data into it */
  gainInd = mxCreateNumericMatrix(svHigh(rx_gainInd, 1)+1, 1, mxINT32_CLASS, mxREAL);
  mxtime = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);

  pgain  = (int *)mxGetData(gainInd);
  ptime = (int *)mxGetData(mxtime);

  /* Copy data into the mxArray - SV to C */
  printf("    [MATLAB] Array Low %d, Array High %d \n", svLow(rx_gainInd,1), svHigh(rx_gainInd, 1) );fflush(stdout);
  for (j= svLow(rx_gainInd,1); j <= svHigh(rx_gainInd,1); j++)
    {
    pgain[j] = *(int *)svGetArrElemPtr1(rx_gainInd, j);
    }

  ptime[0] = simu_time[0];

  printf("    [MATLAB] Set RF gain @ %d... \n",ptime[0]);fflush(stdout);
  printf("    [MATLAB] Set pgain = %d %d %d %d ... \n",pgain[0],pgain[1],pgain[2],pgain[3]);fflush(stdout);
  printf("    [MATLAB] Set ptime = %d ... \n",ptime[0]);fflush(stdout);

  // This generates the ADC data samples
  mlfM_rf_do(2, &rxADC,&rssi,rxRF,wRF,mxtime,gainInd);
  printf("    [MATLAB] RF samples are generated... \n");fflush(stdout);


  // Size of the data
  // Not used because "result" is already allocated
  // previously with GetSize
  size_adc = (int)mxGetNumberOfElements(rxADC);
  size_rssi = (int)mxGetNumberOfElements(rssi);
  // printf("size_adc  : %d \n", size_adc);fflush(stdout);
  // printf("size_rssi : %d \n", size_rssi);fflush(stdout);

  // Pointer to first real data on REAL array of the variable
  pr = (double *)mxGetData(rxADC);
  pi = (double *)mxGetImagData(rxADC);

  // Build the data output vector with Matlab data
  for (i= 0; i < size_adc; i++)
  {
     current_data_re = (int)floor(*pr);
     current_data_im = (int)floor(*pi);
     *(unsigned int *)svGetArrElemPtr1(rxADC_re, i)=current_data_re;
     *(unsigned int *)svGetArrElemPtr1(rxADC_im, i)=current_data_im;
     pr++;
     pi++;
  }

  // Pointer to first real data on REAL array of the variable
  prssi = (double *)mxGetData(rssi);

  // Build the data output vector with Matlab data
  for (k= 0; k < size_rssi; k++)
  {
     current_rssi = (int)floor(*prssi);
     *(unsigned int *)svGetArrElemPtr1(rx_rssi, k)=current_rssi;
     prssi++;
  }

  printf("    [MATLAB] Set RF gain complete... \n");fflush(stdout);

  //mxDestroyArray(rssi);
  mxDestroyArray(gainInd);
  mxDestroyArray(mxtime);
  int result =(int)mxGetNumberOfElements(rxADC);
  reset_handler();

  // Size return
  //printf("    [MATLAB_DEBUG] Leave setGain\n");fflush(stdout);
  return result;
}


int getEvm (int nrx[0],
            svOpenArrayHandle rx20_re,svOpenArrayHandle rx20_im,
            svOpenArrayHandle rx20s_re,svOpenArrayHandle rx20s_im,
            svOpenArrayHandle rx40_re,svOpenArrayHandle rx40_im,
            svOpenArrayHandle rx80_re,svOpenArrayHandle rx80_im,
            svOpenArrayHandle agcLock,
            svOpenArrayHandle agcHTSTF,
            svOpenArrayHandle gainInd,
            svOpenArrayHandle digGain20_db,svOpenArrayHandle digGain40_db,svOpenArrayHandle digGain80_db,
            svOpenArrayHandle inbdPow_qdBm){

  mxArray *m_rx20;
  mxArray *m_rx20s;
  mxArray *m_rx40;
  mxArray *m_rx80;
  mxArray *m_agcLockOFDM;
  mxArray *m_agcHTSTF;
  mxArray *m_gainInd;
  mxArray *m_digGain20;
  mxArray *m_digGain40;
  mxArray *m_digGain80;
  mxArray *m_inbdPow_qdBm;

  mxArray *gen_evm = NULL;

  double *pr_rx20, *pr_rx20s, *pr_rx40, *pr_rx80;
  double *pi_rx20, *pi_rx20s, *pi_rx40, *pi_rx80;
  double *pgen_evm;

  int *pagcLockOFDM,*pagcHTSTF, *pgainInd;

  double *pdigGain20, *pdigGain40, *pdigGain80;
  double *pinbdPow_qdBm;

  int current_gen_evm;
  int j;

  //printf("    [MATLAB_DEBUG] Enter in getEvm\n");fflush(stdout);
  set_handler();

  /* Create an m-by-n mxArray; you will copy existing data into it */
  m_rx20         = mxCreateNumericMatrix((svHigh(rx20_re,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxCOMPLEX);
  m_rx20s        = mxCreateNumericMatrix((svHigh(rx20s_re,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxCOMPLEX);
  m_rx40         = mxCreateNumericMatrix((svHigh(rx40_re,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxCOMPLEX);
  m_rx80         = mxCreateNumericMatrix((svHigh(rx80_re,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxCOMPLEX);

  m_agcLockOFDM  = mxCreateNumericMatrix(svHigh(agcLock,1)+1,               1, mxINT32_CLASS, mxREAL);
  m_agcHTSTF     = mxCreateNumericMatrix(svHigh(agcHTSTF,1)+1,              1, mxINT32_CLASS, mxREAL);
  m_gainInd      = mxCreateNumericMatrix((svHigh(gainInd,1)+1)/nrx[0],  nrx[0], mxINT32_CLASS, mxREAL);

  m_digGain20    = mxCreateNumericMatrix((svHigh(digGain20_db,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxREAL);
  m_digGain40    = mxCreateNumericMatrix((svHigh(digGain40_db,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxREAL);
  m_digGain80    = mxCreateNumericMatrix((svHigh(digGain80_db,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxREAL);
  m_inbdPow_qdBm = mxCreateNumericMatrix((svHigh(inbdPow_qdBm,1)+1)/nrx[0], nrx[0], mxDOUBLE_CLASS, mxREAL);

  pr_rx20        = (double *)mxGetData(m_rx20);
  pi_rx20        = (double *)mxGetImagData(m_rx20);
  pr_rx20s       = (double *)mxGetData(m_rx20s);
  pi_rx20s       = (double *)mxGetImagData(m_rx20s);
  pr_rx40        = (double *)mxGetData(m_rx40);
  pi_rx40        = (double *)mxGetImagData(m_rx40);
  pr_rx80        = (double *)mxGetData(m_rx80);
  pi_rx80        = (double *)mxGetImagData(m_rx80);

  printf("    [MATLAB] Start EVM calculation... \n");fflush(stdout);

  pagcLockOFDM  = (int *)mxGetData(m_agcLockOFDM);
  pagcHTSTF     = (int *)mxGetData(m_agcHTSTF);
  pgainInd      = (int *)mxGetData(m_gainInd);

  pdigGain20    = (double *)mxGetData(m_digGain20);
  pdigGain40    = (double *)mxGetData(m_digGain40);
  pdigGain80    = (double *)mxGetData(m_digGain80);
  pinbdPow_qdBm = (double *)mxGetData(m_inbdPow_qdBm);

  /* Copy 20MHz data into the mxArray - SV to C */
  for (j= svLow(rx20_re,1); j <= svHigh(rx20_re,1); j++)
    {
    pr_rx20[j] = (double) *(int *)svGetArrElemPtr1(rx20_re, j);
    pi_rx20[j] = (double) *(int *)svGetArrElemPtr1(rx20_im, j);
    }
//   for(j=0;j<70;j++)
//   {
//     printf("rx20_i0[%d]=%f rx20_q0[%d]=%f\n",j,pr_rx20[j],j,pi_rx20[j]);fflush(stdout);
//     printf("rx20_i1[%d]=%f rx20_q1[%d]=%f\n",j+((svHigh(rx20_re,1)+1)/4),pr_rx20[j+((svHigh(rx20_re,1)+1)/4)],j+((svHigh(rx20_re,1)+1)/4),pi_rx20[j+((svHigh(rx20_re,1)+1)/4)]);fflush(stdout);
//     printf("rx20_i2[%d]=%f rx20_q2[%d]=%f\n",j+2*((svHigh(rx20_re,1)+1)/4),pr_rx20[j+2*((svHigh(rx20_re,1)+1)/4)],j+2*((svHigh(rx20_re,1)+1)/4),pi_rx20[j+2*((svHigh(rx20_re,1)+1)/4)]);fflush(stdout);
//     printf("rx20_i3[%d]=%f rx20_q3[%d]=%f\n",j+3*((svHigh(rx20_re,1)+1)/4),pr_rx20[j+3*((svHigh(rx20_re,1)+1)/4)],j+3*((svHigh(rx20_re,1)+1)/4),pi_rx20[j+3*((svHigh(rx20_re,1)+1)/4)]);fflush(stdout);
//   }

  /* Copy 20MHz sec data into the mxArray - SV to C */
  for (j= svLow(rx20s_re,1); j <= svHigh(rx20s_re,1); j++)
    {
    pr_rx20s[j] = (double) *(int *)svGetArrElemPtr1(rx20s_re, j);
    pi_rx20s[j] = (double) *(int *)svGetArrElemPtr1(rx20s_im, j);
    }

      /* Copy 40MHz data into the mxArray - SV to C */
  for (j= svLow(rx40_re,1); j <= svHigh(rx40_re,1); j++)
    {
    pr_rx40[j] = (double) *(int *)svGetArrElemPtr1(rx40_re, j);
    pi_rx40[j] = (double) *(int *)svGetArrElemPtr1(rx40_im, j);
    }

  /* Copy 80MHz data into the mxArray - SV to C */
  for (j= svLow(rx80_re,1); j <= svHigh(rx80_re,1); j++)
    {
    pr_rx80[j] = (double) *(int *)svGetArrElemPtr1(rx80_re, j);
    pi_rx80[j] = (double) *(int *)svGetArrElemPtr1(rx80_im, j);
    }

  /* Copy others data into the mxArray - SV to C */
//   printf("agcLock      : Array Low %d, Array High %d \n", svLow(agcLock,1),  svHigh(agcLock, 1) );fflush(stdout);
//   printf("agcHTSTF     : Array Low %d, Array High %d \n", svLow(agcHTSTF,1), svHigh(agcHTSTF, 1) );fflush(stdout);
//   printf("gainInd      : Array Low %d, Array High %d \n", svLow(gainInd,1),  svHigh(gainInd, 1) );fflush(stdout);
  for (j= svLow(agcLock,1); j <= svHigh(agcLock,1); j++)
    {
    pagcLockOFDM[j] = *(int *)svGetArrElemPtr1(agcLock, j);
    }
  for (j= svLow(agcHTSTF,1); j <= svHigh(agcHTSTF,1); j++)
    {
    pagcHTSTF[j] = *(int *)svGetArrElemPtr1(agcHTSTF, j);
    }
  for (j= svLow(gainInd,1); j <= svHigh(gainInd,1); j++)
    {
    pgainInd[j] = *(int *)svGetArrElemPtr1(gainInd, j);
    }

//   printf("digGain20_db : Array Low %d, Array High %d \n", svLow(digGain20_db,1), svHigh(digGain20_db, 1) );fflush(stdout);
  for (j= svLow(digGain20_db,1); j <= svHigh(digGain20_db,1); j++)
    {
    pdigGain20[j] = (double) *(int *)svGetArrElemPtr1(digGain20_db, j);
    }
  for (j= svLow(digGain40_db,1); j <= svHigh(digGain40_db,1); j++)
    {
    pdigGain40[j] = (double) *(int *)svGetArrElemPtr1(digGain40_db, j);
    }
  for (j= svLow(digGain80_db,1); j <= svHigh(digGain80_db,1); j++)
    {
    pdigGain80[j] = (double) *(int *)svGetArrElemPtr1(digGain80_db, j);
    }
  for (j= svLow(inbdPow_qdBm,1); j <= svHigh(inbdPow_qdBm,1); j++)
    {
    pinbdPow_qdBm[j] = (double) *(int *)svGetArrElemPtr1(inbdPow_qdBm, j);
    }
//   for(j=4445;j<4455;j++)
//   {
//     printf("pdigGain20_i0[%d]=%f \n",j,pdigGain20[j]);fflush(stdout);
//     printf("pdigGain20_i1[%d]=%f \n",j+1*((svHigh(digGain20_db,1)+1)/4),pdigGain20[j+1*((svHigh(digGain20_db,1)+1)/4)]);fflush(stdout);
//     printf("pdigGain20_i2[%d]=%f \n",j+2*((svHigh(digGain20_db,1)+1)/4),pdigGain20[j+2*((svHigh(digGain20_db,1)+1)/4)]);fflush(stdout);
//     printf("pdigGain20_i3[%d]=%f \n",j+3*((svHigh(digGain20_db,1)+1)/4),pdigGain20[j+3*((svHigh(digGain20_db,1)+1)/4)]);fflush(stdout);
//   }

  // This generates the evm from inputs
  mlfM_evm_eval(1, &gen_evm, m_rx20, m_rx20s, m_rx40, m_rx80, m_agcLockOFDM, m_agcHTSTF, m_gainInd, m_digGain20, m_digGain40, m_digGain80, m_inbdPow_qdBm);

  // Pointer to first real data on REAL array of the variable
  pgen_evm = (double *)mxGetData(gen_evm);
  current_gen_evm = (int)floor(*pgen_evm);

  printf("    [MATLAB] EVM is generated : %d dB\n",current_gen_evm);fflush(stdout);

  mxDestroyArray(m_rx20);
  mxDestroyArray(m_rx20s);
  mxDestroyArray(m_rx40);
  mxDestroyArray(m_rx80);
  mxDestroyArray(m_agcLockOFDM);
  mxDestroyArray(m_agcHTSTF);
  mxDestroyArray(m_gainInd);
  mxDestroyArray(m_digGain20);
  mxDestroyArray(m_digGain40);
  mxDestroyArray(m_digGain80);
  mxDestroyArray(m_inbdPow_qdBm);
  //mxDestroyArray(gen_evm);

  reset_handler();

  //printf("    [MATLAB_DEBUG] Leave getEvm\n");fflush(stdout);
    // Evm return
  return (int)current_gen_evm;
}

void getBlockList(char* BlockName){
  mxArray *mxBlockName = NULL;

  //printf("    [MATLAB_DEBUG] Enter in getBlockList\n");fflush(stdout);
  set_handler();

//   printf("Calling getBlockList function with param : %s \n", BlockName);fflush(stdout);
  mxBlockName      =  mxCreateString(BlockName);

  // Matlab function to access an internal variable of
  // structure BlockName, variable name: SignalName
  mlfM_list_tv(mxBlockName);

  mxDestroyArray(mxBlockName);

  reset_handler();
  //printf("    [MATLAB_DEBUG] Leave getBlockList\n");fflush(stdout);
}


int getDataSize(char* BlockName , char* SignalName){

    mxArray *mxBlockName = NULL;
    mxArray *mxSignalName = NULL;
    mxArray *mxVectorDataOut = NULL;

    double *pr;
    int    result;

    //-------------------------------------------------------------
    // set observation parameter
    //-------------------------------------------------------------
    mxArray *ObsSetInd;
    int *observation;

    ObsSetInd = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);
    observation = (int*)mxGetData(ObsSetInd);
    observation[0] = observation_ax;
    //-------------------------------------------------------------

    //printf("    [MATLAB_DEBUG] Enter in getDataSize\n");fflush(stdout);
    set_handler();

    //printf("    [MATLAB] Calling getDataSize function with param : %s .. %s\n", BlockName, SignalName);fflush(stdout);
    mxBlockName      =  mxCreateString(BlockName);
    mxSignalName     =  mxCreateString(SignalName);

    // Matlab function to access an internal variable of
    // structure BlockName, variable name: SignalName
    mlfM_get_size(1, &mxVectorDataOut, mxBlockName, mxSignalName, ObsSetInd);
    pr = (double *)mxGetPr(mxVectorDataOut);
    result = (int)floor(*pr);

    mxDestroyArray(mxBlockName);
    mxDestroyArray(mxSignalName);
    mxDestroyArray(ObsSetInd);
    //mxDestroyArray(mxVectorDataOut);

    reset_handler();

    // Size
    //printf("    [MATLAB_DEBUG] Leave getDataSize (%0d)\n",result);fflush(stdout);
    return result ;
}

int getColumnSize(char* BlockName , char* SignalName){

    mxArray *mxBlockName = NULL;
    mxArray *mxSignalName = NULL;
    mxArray *mxVectorDataOut = NULL;

    //printf("    [MATLAB_DEBUG] Enter in getDataSize\n");fflush(stdout);
    set_handler();

    //printf("    [MATLAB] Calling getColumnSize function with param : %s .. %s\n", BlockName, SignalName);fflush(stdout);
    mxBlockName      =  mxCreateString(BlockName);
    mxSignalName     =  mxCreateString(SignalName);

    // Matlab function to access an internal variable of
    // structure BlockName, variable name: SignalName
    mlfM_dump_give(1, &mxVectorDataOut, mxBlockName, mxSignalName);

    mxDestroyArray(mxBlockName);
    mxDestroyArray(mxSignalName);

    int result = (int)mxGetN(mxVectorDataOut);
    reset_handler();

    // Size
    //printf("    [MATLAB_DEBUG] Leave getDataSize\n");fflush(stdout);
    return result ;
}

int getRowSize(char* BlockName , char* SignalName){

    mxArray *mxBlockName = NULL;
    mxArray *mxSignalName = NULL;
    mxArray *mxVectorDataOut = NULL;

    //printf("    [MATLAB_DEBUG] Enter in getDataSize\n");fflush(stdout);
    set_handler();

    //printf("    [MATLAB] Calling getRowSize function with param : %s .. %s\n", BlockName, SignalName);fflush(stdout);
    mxBlockName      =  mxCreateString(BlockName);
    mxSignalName     =  mxCreateString(SignalName);

    // Matlab function to access an internal variable of
    // structure BlockName, variable name: SignalName
    mlfM_dump_give(1, &mxVectorDataOut, mxBlockName, mxSignalName);

    mxDestroyArray(mxBlockName);
    mxDestroyArray(mxSignalName);

    int result = (int)mxGetM(mxVectorDataOut);
    reset_handler();

    // Size
    //printf("    [MATLAB_DEBUG] Leave getDataSize\n");fflush(stdout);
    return result ;
}

void getData( svOpenArrayHandle result, char* BlockName , char* SignalName, char *ElementName){

  mxArray *mxBlockName = NULL;
  mxArray *mxSignalName = NULL;
  mxArray *mxElementName = NULL;
  mxArray *mxVectorDataOut = NULL;

  double *pr;
  int size, i, current_data;
  //printf("    [MATLAB_DEBUG] Enter in getData\n");fflush(stdout);

  //-------------------------------------------------------------
  // set observation parameter
  //-------------------------------------------------------------
  mxArray *ObsSetInd;
  int *observation;

  ObsSetInd = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);
  observation = (int*)mxGetData(ObsSetInd);
  observation[0] = observation_ax;
  //-------------------------------------------------------------

  // For complex number and accessing the imaginary data
  //double *pi; // Used if Imaginary will be need it
  //pi = (double *)mxGetPi(mxVectorDataOut);
  set_handler();

  //printf("    [MATLAB] Calling getData function with param : %s .. %s .. %s\n", BlockName, SignalName, ElementName);fflush(stdout);
  mxBlockName      =  mxCreateString(BlockName);
  mxSignalName     =  mxCreateString(SignalName);
  mxElementName    =  mxCreateString(ElementName);
  reset_handler();

  //
  // Matlab function to access an internal variable of
  // structure BlockName, variable name: SignalName
  //
  set_handler();
  //printf("    [MATLAB_DEBUG] Before mlfM_get_tv\n");fflush(stdout);
  mlfM_get_tv(1, &mxVectorDataOut, mxBlockName, mxSignalName, ObsSetInd, mxElementName);
  //printf("    [MATLAB_DEBUG] After mlfM_get_tv\n");fflush(stdout);
  reset_handler();

  // Size of the data
  // Not used because "result" is already allocated
  // previously with GetSize
  set_handler();
  size = (int)mxGetNumberOfElements(mxVectorDataOut);

  // Pointer to first real data on REAL array of the variable
  pr = (double *)mxGetPr(mxVectorDataOut);


  // Build the data output vector with Matlab data
  //printf("    [MATLAB_DEBUG] Build the data output vector with Matlab data (size %0d)\n",size);fflush(stdout);
  for (i= 0; i < size; i++)
  {
     current_data = (int)floor(*pr);
     *(unsigned int *)svGetArrElemPtr1(result, i)=current_data;
     pr++;
  }

  //printf("    [MATLAB_DEBUG] mxDestroyArray\n");fflush(stdout);

  mxDestroyArray(mxBlockName);
  mxDestroyArray(mxSignalName);
  //mxDestroyArray(mxVectorDataOut);
  mxDestroyArray(mxElementName);
  mxDestroyArray(ObsSetInd);

  reset_handler();
  //printf("    [MATLAB_DEBUG] Leave getData\n");fflush(stdout);
}

void getComplexData( svOpenArrayHandle result_re, svOpenArrayHandle result_im, char* BlockName , char* SignalName){

  mxArray *mxBlockName = NULL;
  mxArray *mxSignalName = NULL;
  mxArray *mxVectorDataRe = NULL;
  mxArray *mxVectorDataIm = NULL;

  double *pr, *pi;
  int size, i, current_data_re, current_data_im;

  //-------------------------------------------------------------
  // set observation parameter
  //-------------------------------------------------------------
  mxArray *ObsSetInd;
  int *observation;

  ObsSetInd = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);
  observation = (int*)mxGetData(ObsSetInd);
  observation[0] = observation_ax;
  //-------------------------------------------------------------

  //printf("    [MATLAB_DEBUG] Enter in getComplexData\n");fflush(stdout);
  // For complex number and accessing the imaginary data
  set_handler();

//   printf("\nCalling getComplexData function with param : %s .. %s\n\n", BlockName, SignalName);fflush(stdout);
  mxBlockName      =  mxCreateString(BlockName);
  mxSignalName     =  mxCreateString(SignalName);

  //
  // Matlab function to access an internal variable of
  // structure BlockName, variable name: SignalName
  //
  mlfM_get_tv(1, &mxVectorDataRe, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("REAL"));
  mlfM_get_tv(1, &mxVectorDataIm, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("IMAG"));

  size = (int)mxGetNumberOfElements(mxVectorDataRe);
  pr = (double *)mxGetData(mxVectorDataRe);
  pi = (double *)mxGetData(mxVectorDataIm);

  // Build the data output vector with Matlab data
  for (i= 0; i < size; i++)
  {
     current_data_re = (int)floor(*pr);
     *(unsigned int *)svGetArrElemPtr1(result_re, i)=current_data_re;
     pr++;
     if (pi!=NULL)
     {
       current_data_im = (int)floor(*pi);
       *(unsigned int *)svGetArrElemPtr1(result_im, i)=current_data_im;
       pi++;
     }
  }

  mxDestroyArray(mxBlockName);
  mxDestroyArray(mxSignalName);
  mxDestroyArray(ObsSetInd);
  //mxDestroyArray(mxVectorDataRe);
  //mxDestroyArray(mxVectorDataIm);

  reset_handler();
  //printf("    [MATLAB_DEBUG] Leave getComplexData\n");fflush(stdout);
}

//-----------------------------------------------------------------------------
// new API functions to support AX standard
//-----------------------------------------------------------------------------

// function that sets RF data provided by libdump
void set_rx_rf_data(){

  mxArray *mxBlockName = NULL;
  mxArray *mxSignalName = NULL;
  mxArray *mxVectorDataOutRe = NULL;
  mxArray *mxVectorDataOutIm = NULL;
  mxArray *mxVectorDataOutAnt = NULL;

  double *pr_re, *pr_im, *ant;
  int size, i;
  double *rxrf_pr, *rxrf_pi, *wrf_pr, *wrf_pi;
  int antenna_num;

  //-------------------------------------------------------------
  // set observation parameter
  //-------------------------------------------------------------
  mxArray *ObsSetInd;
  int *observation;

  ObsSetInd = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);
  observation = (int*)mxGetData(ObsSetInd);
  observation[0] = observation_ax;
  //-------------------------------------------------------------

  printf("    [MATLAB] Set rxRF and wRF...\n");fflush(stdout);
  set_handler();

  mxBlockName    = mxCreateString("RXRF");
  mlfM_list_tv(mxBlockName);

  // setup rxRF data from matlab
  mxSignalName   = mxCreateString("rxRF");

  mlfM_get_tv(1, &mxVectorDataOutRe, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("REAL"));
  mlfM_get_tv(1, &mxVectorDataOutIm, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("IMAG"));
  mlfM_get_tv(1, &mxVectorDataOutAnt,mxBlockName, mxSignalName, ObsSetInd, mxCreateString("ANT"));

  //---------------------------------------------------------------
  // determine number of antennas
  //---------------------------------------------------------------
  double *ptr_ant = (double *)mxGetData(mxVectorDataOutAnt);
  antenna_num = 1; // start from one antenna
  for (i=0; i<mxGetNumberOfElements(mxVectorDataOutAnt); i++) {
    if (antenna_num != (*ptr_ant)) antenna_num++;
    ptr_ant++;
  }
  printf("    [MATLAB] Antenna number: %0d\n",antenna_num);fflush(stdout);
  //---------------------------------------------------------------

  // Size of the data
  size = (int)mxGetNumberOfElements(mxVectorDataOutRe);

  rxRF = mxCreateNumericMatrix(antenna_num, size/antenna_num, mxDOUBLE_CLASS, mxCOMPLEX);
  rxrf_pr = (double *)mxGetData(rxRF);     // get pointer to first real element
  rxrf_pi = (double *)mxGetImagData(rxRF); // get pointer to first imag element

  // Pointer to first real data on REAL/IMAG array of the variable
  pr_re = (double *)mxGetPr(mxVectorDataOutRe);
  pr_im = (double *)mxGetPr(mxVectorDataOutIm);
  ant   = (double *)mxGetPr(mxVectorDataOutAnt);

  //printf("  [MATLAB_DEBUG] Build the data output vector with Matlab data\n");fflush(stdout);
  // Build the data output vector with Matlab data
  for (i=0; i < size; i++) {
    rxrf_pr[i] = (double)(*pr_re);
    rxrf_pi[i] = (double)(*pr_im);
    //printf("rxRF[%0d]: RE (%0f) IM (%0f) ANT (%0d)\n",i,(double)(*pr_re),(double)(*pr_im),(int)(*ant));fflush(stdout);
    pr_re++;
    pr_im++;
    ant++;
  }

  // setup wRF data from matlab
  //printf("    [MATLAB_DEBUG] setup wRF data from matlab\n");fflush(stdout);
  mxSignalName   = mxCreateString("wRF");

  mlfM_get_tv(1, &mxVectorDataOutRe, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("REAL"));
  mlfM_get_tv(1, &mxVectorDataOutIm, mxBlockName, mxSignalName, ObsSetInd, mxCreateString("IMAG"));
  mlfM_get_tv(1, &mxVectorDataOutAnt,mxBlockName, mxSignalName, ObsSetInd, mxCreateString("ANT"));

  // Size of the data
  size = (int)mxGetNumberOfElements(mxVectorDataOutRe);

  wRF = mxCreateNumericMatrix(antenna_num, size/antenna_num, mxDOUBLE_CLASS, mxCOMPLEX);
  wrf_pr = (double *)mxGetData(wRF);     // get pointer to first real element
  wrf_pi = (double *)mxGetImagData(wRF); // get pointer to first imag element

  // Pointer to first real data on REAL/IMAG array of the variable
  pr_re = (double *)mxGetPr(mxVectorDataOutRe);
  pr_im = (double *)mxGetPr(mxVectorDataOutIm);
  ant   = (double *)mxGetPr(mxVectorDataOutAnt);

  // Build the data output vector with Matlab data
  //printf("  [MATLAB_DEBUG] Build the data output vector with Matlab data\n");fflush(stdout);
  for (i=0; i < size; i++) {
    wrf_pr[i] = (double)(*pr_re);
    wrf_pi[i] = (double)(*pr_im);
    //printf("wRF[%0d]: RE (%0f) IM (%0f) ANT (%0d)\n",i,(double)(*pr_re),(double)(*pr_im),(int)(*ant));fflush(stdout);
    pr_re++;
    pr_im++;
  }

  //printf("    [MATLAB_DEBUG] mxDestroyArray\n");fflush(stdout);
  mxDestroyArray(mxBlockName);
  mxDestroyArray(mxSignalName);
  mxDestroyArray(ObsSetInd);
  //mxDestroyArray(mxVectorDataOutRe);
  //mxDestroyArray(mxVectorDataOutIm);
  //mxDestroyArray(mxVectorDataOutAnt);

  //printf("    [MATLAB] Done set_rx_rf_data\n");fflush(stdout);
  reset_handler();
}

void set_STAs(char *DefSTAPath, char *DefBSSPath){

  mxArray *mxSTAName = NULL;
  mxArray *mxBSSName = NULL;

  printf("    [MATLAB] Set STAs and BSS parameters\n");fflush(stdout);
  set_handler();

  mxSTAName   =  mxCreateString(DefSTAPath);
  mxBSSName   =  mxCreateString(DefBSSPath);

  // Matlab function to set default parameters for STAs and BSS
  mlfM_set_STAs(mxSTAName, mxBSSName);

  mxDestroyArray(mxSTAName);
  mxDestroyArray(mxBSSName);

  reset_handler();
}

void exe_case(char *TestCasePath, char *PayloadPath){

  mxArray *mxTestName    = NULL;
  mxArray *mxPayloadName = NULL;
  mxArray *mxInterfName  = NULL;
  char    *interfPath    = '\0';

  printf("    [MATLAB] Setting up the testcase execution. .. \n");fflush(stdout);
  printf("    [MATLAB] Current testcase config: %s \n", TestCasePath);fflush(stdout);
  printf("    [MATLAB] Current testcase payload: %s \n", PayloadPath);fflush(stdout);
  set_handler();

  mxTestName    =  mxCreateString(TestCasePath);
  mxPayloadName =  mxCreateString(PayloadPath);
  mxInterfName  =  mxCreateString(interfPath);

  // Matlab function to execute test case with setup payload
  mlfM_exe_case(mxTestName, mxInterfName, mxPayloadName);
  // setup rxRF and wRF needed in set gain call
  if (txcore_only == false) set_rx_rf_data();

  mxDestroyArray(mxTestName);
  mxDestroyArray(mxPayloadName);
  mxDestroyArray(mxInterfName);

  reset_handler();
}

// function to set observation value from test case
void set_observation_ax(int i[0]){
  printf("    [MATLAB] Set observation to %0d\n",i[0]);fflush(stdout);
  observation_ax = i[0];
}

void set_txcore_only(int yes[0]){
  printf("    [MATLAB] TXCORE only:  %0d\n",yes[0]);fflush(stdout);
  if (yes[0])
    txcore_only = true;
  else
    txcore_only = false;
}

int exe_viterbi (svOpenArrayHandle decoded_bits_out, svOpenArrayHandle soft_bit_in,int traceback_in[0]){

  mxArray *decodedBits_mxA = NULL;
  mxArray *softBit_mxA;
  mxArray *traceBack_mxA;

  double *psoftbit;
  double *ptraceback;

  double *decoded_bits_ptr;

  int i, j;
  int size_decoded_bits;
  int current_decoded_bits;

  set_handler();

  /* Create an m-by-n mxArray; you will copy existing data into it */
  softBit_mxA   = mxCreateNumericMatrix(svHigh(soft_bit_in, 1)+1, 1, mxDOUBLE_CLASS, mxREAL);
  traceBack_mxA = mxCreateNumericMatrix(1, 1, mxDOUBLE_CLASS, mxREAL);

  /* Create pointer to the created mxArray */
  psoftbit   = (double *)mxGetData(softBit_mxA);
  ptraceback = (double *)mxGetData(traceBack_mxA);


  /* Copy data into the mxArray - SV to C */
  for (j= svLow(soft_bit_in,1); j <= svHigh(soft_bit_in,1); j++)
    {
    psoftbit[j] = (double) *(int *)svGetArrElemPtr1(soft_bit_in, j);
//    printf("    [MATLAB] softbit[%d] = %f\n",j,psoftbit[j]);fflush(stdout);
    }

  ptraceback[0] = (double)traceback_in[0];
//  printf("    [MATLAB] traceback = %f ... \n",ptraceback[0]);fflush(stdout);


  // Execute m_bcc_decoder function from Matlab libdumpAX
  mlfM_bccdecoder(1, &decodedBits_mxA, softBit_mxA, traceBack_mxA );

  size_decoded_bits = (int)mxGetNumberOfElements(decodedBits_mxA);

  // Pointer to first real data on REAL array of the variable
  decoded_bits_ptr = (double *)mxGetData(decodedBits_mxA);

  // Build the data output vector with Matlab data
  for (i= 0; i < size_decoded_bits; i++)
  {
     current_decoded_bits = (int)floor(*decoded_bits_ptr);
//    printf("    [MATLAB] dec bit[%d] = %d\n",i,current_decoded_bits);fflush(stdout);
//    printf("    [MATLAB] dec bit_out_a[%d] = %d\n",i,*(unsigned int *)svGetArrElemPtr1(decoded_bits_out, i));fflush(stdout);
     *(unsigned int *)svGetArrElemPtr1(decoded_bits_out, i)=current_decoded_bits;
//    printf("    [MATLAB] dec bit_out_b[%d] = %d\n",i,*(unsigned int *)svGetArrElemPtr1(decoded_bits_out, i));fflush(stdout);
     decoded_bits_ptr++;
  }

  // Free the memory used by mxArrays
  mxDestroyArray(softBit_mxA);
  mxDestroyArray(traceBack_mxA);
  //mxDestroyArray(decodedBits_mxA);

  int result =(int)mxGetNumberOfElements(decodedBits_mxA);

  reset_handler();

  // Size return
  return result;
}

