################################################################################
# Regression List
# The following regression goals will be available with this methodology.
################################################################################

########################################
# default list of recommend goals to run for sign-off
########################################
set regression_mandatory_list { lint/lint_rtl
				adv_lint/adv_lint_verify
				constraints/sdc_audit
				constraints/sdc_check
				constraints/sdc_redundancy
				constraints/sdc_exception_struct
				cdc/clock_reset_integrity
				cdc/cdc_verify   
				dft/dft_scan_ready
				dft/dft_best_practice
				dft/dft_dsm_clocks
				dft/dft_dsm_best_practice
				power/power_gated_clock
				power/power_est_average
				power_verification/power_verif_noninstr
				txv_verification/fp_mcp_verification
                              }

########################################
# additional goals to run for sign-off
########################################
set regression_optional_list  { lint/lint_abstract
				constraints/sdc_abstract
				constraints/sdc_equiv
				constraints/sdc_hier_equiv
				cdc/cdc_abstract 
				dft/dft_abstract
				dft/dft_test_points
				power/power_audit
				power/power_reduction
				power_verification/power_verif_audit
                              }


########################################
# define/register the actual regression sets
########################################
define_regression mandatory  -goals "$regression_mandatory_list"

define_regression optional   -goals "$regression_optional_list"

# note this goal is a superset of the mandatory and optional goals
define_regression all        -goals "$regression_mandatory_list $regression_optional_list"

