#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Library Setup file used for Synthesis and Power 
#/                    Estimation
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: $
#/
#/////////////////////////////////////////////////////////////////////////////

if {![info exists TECHNO]} {
	set TECHNO "40nmLP"
}

#==============================================================================
#-- Specifying the libraries
#==============================================================================
if { $TECHNO == "28nmHM" } {
  if { [file isdirectory /projects/libraries/TSMC/28nm/CLN28HM] } {
    set TECHLIBPATH /projects/libraries/TSMC/28nm/CLN28HM/TSMCHOME/digital/Front_End/timing_power_noise/NLDM/tcbn28hpmbwp35_111a
  } else {
    set TECHLIBPATH /share/hw_libs/28NM/TSMC/CLN28HM/TSMCHOME/digital/Front_End/timing_power_noise/NLDM/tcbn28hpmbwp35_111a
  }
  set TARGETTECH tcbn28hpmbwp35tt0p9v25c
  set TARGETTECHTYP tcbn28hpmbwp35tt0p9v25c
  set WIRELOADMODEL ZeroWireload
  set CLKBUF CKBD1BWP35
  set NAND2X2_NAME ND2D2
  set NAND2X2_AREA 0.6075
  set NAND2X1_NAME ND2D1
  set NAND2X1_AREA 0.3645
  set INVX2_NAME INVD2
  set SDFF_NAME SDF*
  set DFF_NAME  DF*

}

if { $TECHNO == "16nmFF" } {
  if { [file isdirectory /projects/libraries/TSMC/16nm/CLN16FF] } {
    set TECHLIBPATH /projects/libraries/TSMC/16nm/CLN16FF/arm/arm/tsmc/cln16fpll001/sc9mc_base_svt_c18/r1p0/db/
  } else {
    set TECHLIBPATH /share/hw_libs/16NM/TSMC/CLN16FF/ARM/cln16fpll001/sc9mc_base_svt_c18/db/
  }
  set TARGETTECH sc9mc_cln16fpll001_base_svt_c18_ssgnp_cworstccworstt_max_0p72v_125c
  set TARGETTECHTYP sc9mc_cln16fpll001_base_svt_c18_tt_typical_max_0p80v_25c
  set WIRELOADMODEL Zero
  set CLKBUF BUF_X1N_A9TS_C18
  set NAND2X2_NAME NAND2_X2F_A9TS_C18
  set NAND2X2_AREA 0.31104
  set NAND2X1_NAME NAND2_X1F_A9TS_C18
  set NAND2X1_AREA 0.20736
  set INVX2_NAME INV_X1F_A9TS_C18
  set SDFF_NAME SDF*
  set DFF_NAME  DF*

}

if {$TECHNO == "40nmLP" } {
  if { [file isdirectory /projects/libraries/TSMC/40nm/CLN40LP] } {
    set TECHLIBPATH /projects/libraries/TSMC/40nm/CLN40LP/tsmc/tcbn40lpbwp12tm1p/TSMCHOME/digital/Front_End/timing_power_noise/NLDM/tcbn40lpbwp12tm1p_132a
    set TARGETTECH tcbn40lpbwp12tm1pwc
    set TARGETTECHTYP tcbn40lpbwp12tm1ptc
  } else {
    set TECHLIBPATH /share/hw_libs/40NM/TSMC/40LP/TSMCHOME/digital/Front_End/timing_power_noise/NLDM/tcbn40lpbwp12t40m1p_131a/
    set TARGETTECH tcbn40lpbwp12t40m1pwc
    set TARGETTECHTYP tcbn40lpbwp12t40m1ptc
  }  
  set WIRELOADMODEL TSMC32K_Lowk_Conservative
  set CLKBUF CKBD1
  set NAND2X2_NAME ND2D2
  set NAND2X2_AREA 1.6464
  set NAND2X1_NAME ND2D1
  set NAND2X1_AREA 0.9408
  set INVX2_NAME INVD2
  set SDFF_NAME SDF*
  set DFF_NAME  DF*
}

if {$TECHNO == "65nm" } {
  if { [file isdirectory /projects/libraries/TSMC/65nm/CLN65LP] } {
    set TECHLIBPATH /projects/libraries/TSMC/65nm/CLN65LP/tsmc/tcbn65lp/TSMCHOME/digital/Front_End/timing_power_noise/NLDM/tcbn65lp_200a
    set TARGETTECH tcbn65lpwc
    set TARGETTECHTYP tcbn65lptc
  } else { 
    set TECHLIBPATH /share/hw_libs/65NM/TSMC/65LP/tcbn65lp_200a/TSMCHOME/digital/Front_End/timing_power_noise/CCS/tcbn65lp_200a/
    set TARGETTECH tcbn65lpwc_ccs
    set TARGETTECHTYP tcbn65lptc_ccs
  }  
  set WIRELOADMODEL TSMC32K_Lowk_Conservative
  set CLKBUF CKBD1
  set NAND2X2_NAME ND2D2
  set NAND2X2_AREA 2.52
  set NAND2X1_NAME ND2D1
  set NAND2X1_AREA 1.44
  set INVX2_NAME INVD2
  set SDFF_NAME SDF*
  set DFF_NAME  DF*
}

if {$TECHNO == "90nmLP"} {
  if { [file isdirectory /projects/libraries/TSMC/90nm/CLN90LP] } {
    set TECHLIBPATH /projects/libraries/TSMC/90nm/CLN90LP/tsmc/tcbn90lphphvt/TSMCHOME/digital/Front_End/timing_power/tcbn90lphphvt_150c
  } else {
    set TECHLIBPATH /share/hw_libs/90NM/TSMC/90LP/tcbn90lphphvt_150j/TSMCHOME/digital/Front_End/timing_power/tcbn90lphphvt_150c
  }  
  set TARGETTECH tcbn90lphphvtwc
  set TARGETTECHTYP tcbn90lphphvttc
  set WIRELOADMODEL TSMC32K_Lowk_Conservative
  set CLKBUF CKBNVTD1
  set NAND2X2_NAME ND2HVTD2
  set NAND2X2_AREA 4.2336
  set NAND2X1_NAME ND2HVTD1
  set NAND2X1_AREA 2.8224
  set INVX2_NAME INVHVTD2
  set SDFF_NAME SDF*
  set DFF_NAME  DF*
}


set search_path [list . SYNOPSYS_ROOT/libraries/syn SYNOPSYS_ROOT/dw/sim_ver $TECHLIBPATH ]

set link_library [list * [format "%s%s"  $TARGETTECH .db] standard.sldb dw_foundation.sldb]
set target_library [format "%s%s"  $TARGETTECH .db]
set synthetic_library [list dw_foundation.sldb]

if {![file exist $TECHLIBPATH]} {
  puts "FATAL: $TECHLIBPATH does not exist"
  exec ls $TECHLIBPATH
}

