#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Set the environment variables of the WLAN HE REF IP Project
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: $
#/
#/////////////////////////////////////////////////////////////////////////////
export SVNPATH="https://svn.frso.rivierawaves.com/svn/rw_wlan_nx"

export PROJECT=WLAN_HE_REF_IP
export PROJECTS=`pwd`


export PROJECTSLIB=${PROJECTS}
export SOURCESLIB=${PROJECTS}
export SPACESOURCESLIB=${PROJECTS}
export LOCALSOURCESLIB=${PROJECTS}

export TOP11AXDIR=$SOURCESLIB/IPs/HW/TOP11ax
export HDMCOREDIR=$TOP11AXDIR/PHYSUBSYS/HDMCORE
export MODEM80211BCOREDIR=$TOP11AXDIR/PHYSUBSYS/MODEM80211BCORE
export HWCOMMONDIR=$TOP11AXDIR/HWCOMMON
export MDMCOMMONDIR=$TOP11AXDIR/PHYSUBSYS/MDMCOMMON
export RIUCOREDIR=$MDMCOMMONDIR/RIUCORE
export MACSUBSYSDIR=$TOP11AXDIR/MACSUBSYS
export MACCOREDIR=$TOP11AXDIR/MACSUBSYS/MACCORE
export NDBDIR=$SOURCESLIB/IPs/HW/NDB
export CPUSUBSYSDIR=$SOURCESLIB/IPs/HW/CPUSUBSYS
export PHYSUBSYSDIR=$TOP11AXDIR/PHYSUBSYS
export PROJECTS=${SOURCESLIB}

export LOCALPHYSUBSYSDIR=${HOME}/svnroot/rw_wlan_nx/trunk/IPs/HW/TOP11ax/PHYSUBSYS

export BINDIR=${SOURCESLIB}/bin

export RW_MODELDIR=$PROJECTS/model/block
export RW_PROJECTS=$PROJECTS
export RW_TEMPLATEDIR=$PROJECTS/model/template
export RW_VERIFDB=1
export RW_SIMDIR="dev"
export RW_SYNDIR="dev"

export LIBDUMPROOT=$SOURCESLIB/env/MATLAB/libdump

BINPATH="$SOURCESLIB/bin:$SOURCESLIB/legacy/bin"
export PATH=${PATH/:$BINPATH/}:${BINPATH}

#echo -e "Source TL4 environment variables for RTL"
export RELEASE=1
export TL4_ROOT="$NDBDIR/ceva/TL4/cevaTL410_V2.0.0"
export CEVATL410_SIM_LOCAL_ROOT=$TL4_ROOT/simulation
export ASM_TESTS_PATH=.
# Simulation Script configuration
export CEVA_LOCAL_SCRIPTS=$TL4_ROOT/scripts
export SIM_MODULE=Simulation::Asm
export SIM_CONF_FILE=cevaTL410.cf
export PATH=${CEVA_LOCAL_SCRIPTS}:${PATH}
export PERL5LIB="${PERL5LIB}:${SOURCESLIB}/bin:${SOURCESLIB}/bin/docgen:${SOURCESLIB}/bin/perlLib"

# CEVA APS3 environment variable
export APS3_ROOT="$NDBDIR/cortus"

# CEVA X1 environment variable
export X1_ROOT="$NDBDIR/ceva/X1/cevaX1_V1.3.2.F"

# RISC-V environment variable
export RI5CY_ROOT="$NDBDIR/riscv/ri5cy/"
export ZERORISCY_ROOT="$NDBDIR/riscv/zero-riscy"


list_var="LD_LIBRARY_PATH LM_LICENSE_FILE PATH"

for v in $list_var
do
  echo -e "\n$v:"
  for p in $(eval "echo \$$v | sed -e 's/:/ /g'")
  do 
    echo "  o $p"
  done
done
