################################################################################
# setup simulation tools
#
#  o synopsys/vcs-mx/vcs-mx_vJ-2014.12-1_64bits
#  o atrenta/spyglass/SpyGlass-5.5.0.4
#  o xilinx/ise/14.4
#  o synopsys/fpga/fpga_vJ-2015.03-1
#  o cadence/ius/INCISIV14.10
#  o synopsys/syn/syn_vJ-2014.09-SP4
#  o cortus/aps/20120816
#  o ceva/CEVA-TL4_SDT.v1001
#  o java/jdk/1.7.0_02
#  o eclipse/hw/3.7.1
#  o matlab/simulink-R2013a
#  o arm/rvds/3.1_wrapper
#  o python/25_ref
#
################################################################################
# Cadence install directory
CDS_INST_DIR=/net/rwhw-srv1/space/eda/cadence/XCELIUMMAIN18.03.011
export CDS_INST_DIR

###################################################################
# ensure that PROJECT variable is correctly initialized
###################################################################
if [ "$PROJECT" == "WLAN_HE_REF_IP" ] ;
then

  echo "$PROJECT setup done"

else

  echo "ERROR: PROJECT environment variable is not correctly initialized"

fi

# licenses path <EDIT THIS LINE>
# LM_LICENSE_FILE=27000@icdesign
# export LM_LICENSE_FILE in ~/.bashrc

# shared libraries path <EDIT THIS LINE>
# LD_LIBRARY_PATH=${LD_LIBRARY_PATH}":/share/eda/python/python25_x86_64/lib"
# export LD_LIBRARY_PATH in ~/.bashrc


# installation path <EDIT THIS LINE>
export RW_INSTALL_PATH=`pwd`

# project root 
export SOURCESLIB=$RW_INSTALL_PATH/$PROJECT/HW
# project root 
export TOP11AXDIR=$SOURCESLIB/IPs/HW/TOP11ax
export HDMCOREDIR=$TOP11AXDIR/PHYSUBSYS/HDMCORE
export MODEM80211BCOREDIR=$TOP11AXDIR/PHYSUBSYS/MODEM80211BCORE
export HWCOMMONDIR=$TOP11AXDIR/HWCOMMON
export MDMCOMMONDIR=$TOP11AXDIR/PHYSUBSYS/MDMCOMMON
export RIUCOREDIR=$MDMCOMMONDIR/RIUCORE
export MACSUBSYSDIR=$TOP11AXDIR/MACSUBSYS
export MACCOREDIR=$TOP11AXDIR/MACSUBSYS/MACCORE
export NDBDIR=$SOURCESLIB/IPs/HW/NDB
export CPUSUBSYSDIR=$SOURCESLIB/IPs/HW/CPUSUBSYS
export PHYSUBSYSDIR=$TOP11AXDIR/PHYSUBSYS
export PROJECTS=${SOURCESLIB}

# RISC-V environment variable
export RI5CY_ROOT="$NDBDIR/riscv/ri5cy/"
export ZERORISCY_ROOT="$NDBDIR/riscv/zero-riscy"

# Simulation Script configuration                   
export PERL5LIB="${PERL5LIB}:${SOURCESLIB}/bin:${SOURCESLIB}/bin/docgen:${SOURCESLIB}/bin/perlLib"

# MATLAB compiler runtime library <EDIT THIS LINE> (R2013a)
#export MCR_ROOT=/share/eda/mathworks/matlab-simulink-R2013a
#export MCRROOT=/share/eda/mathworks/matlab-simulink-R2013a
export LIBDUMPROOT=${SOURCESLIB}/env/MATLAB/libdump
#export XAPPLRESDIR=${MCR_ROOT}/X11/app-defaults

# executables path <EDIT THESE LINES> 
#PATH="/bin:/usr/bin:/usr/local/bin"
PATH=${PATH}":$SOURCESLIB/bin"
#PATH=${PATH}":$CDS_INST_DIR/tools/bin"
#PATH=${PATH}":$CDS_INST_DIR/tools/dfII/bin"
#PATH=${PATH}":/share/eda/synopsys/syn_vJ-2014.09-SP4/bin"
#PATH=${PATH}":/space/eda/synopsys/fpga_vM-2017.03-SP1/bin"
#PATH=${PATH}":/share/eda/xilinx/ise14.4/14.4/ISE_DS/common/bin/lin64"
#PATH=${PATH}":/share/eda/xilinx/ise14.4/14.4/ISE_DS/EDK/bin/lin64"
#PATH=${PATH}":/share/eda/xilinx/ise14.4/14.4/ISE_DS/PlanAhead/bin"
#PATH=${PATH}":/share/eda/xilinx/ise14.4/14.4/ISE_DS/ISE/bin/lin64"
#PATH=${PATH}":/share/eda/python/python25_x86_64/bin"
#PATH=${PATH}":/share/eda/xilinx/vivado2018.3/Vivado/2018.3/bin"
#export PATH

# shared libraries path <EDIT THIS LINE>
#export MCRJRE=${MCR_ROOT}/sys/java/jre/glnxa64/jre/lib/amd64

#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCR_ROOT}/runtime/glnxa64
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCR_ROOT}/bin/glnxa64
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCR_ROOT}/sys/os/glnxa64
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/native_threads
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/server
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/client
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${LIBDUMPROOT}/distrib
#export LD_LIBRARY_PATH

# projects variables
export RW_VERIFDB=0
export RUNID=0
export RW_SIMDIR="dev"
export RW_SYNDIR="dev"
export NOVERIFDB=0
