#!/usr/bin/perl

use generatedocword;

if ($#ARGV != 6)
{
 die "usage ./genlog.pl [LMAC|FMAC] <src path> <old revision fw> <old revision drv> <new revision> <rel version> <output path>\n"
}

$type               = uc $ARGV[0];
$srcPath            = $ARGV[1];
$svnOldRevisionFW   = $ARGV[2];
$svnOldRevisionDRV  = $ARGV[3];
$svnNewRevision     = $ARGV[4];
$version            = $ARGV[5];
$output_path        = $ARGV[6];

@targetfilelist = create_file_list("$srcPath/macsw", $svnOldRevisionFW);
push @targetfilelist, create_file_list("$srcPath/rwnx_drv", $svnOldRevisionDRV);

$outputfile         = "RW-WLAN-nX-$type-SW-RN-$version";

$prjname=$ENV{'PROJECT'};
open($fileoutput,">$output_path/$outputfile.doc");
generatedocword::init(1);
generatedocword::headerofRWwordfile($fileoutput,$outputfile,"Release Note");

my %bugID2Rev = {};
my %bugID2File = {};

status("* Extract bug list according to SVN log of modified files\n");

foreach $targetfile (@targetfilelist)
{
#  print("  ~ $targetfile");
  `rm -f svnlog`;
  `touch svnlog`;
  open(tmp_file, '>', "svnlog") or die "cannot open svnlog\n";
  if ($targetfile =~ /$srcPath\/macsw/) {
    $oldrev = $svnOldRevisionFW;
  } else {
    $oldrev = $svnOldRevisionDRV;
  }
  print tmp_file `svn log -r $oldrev:$svnNewRevision $targetfile`;
  close(tmp_file);

  @svnLogResult = `cat svnlog`;
  @revision = "";
  @bugId = "";
  @bugID2Revision = "";
  $counter = 0;
  $nbrev = 0;
  foreach $line (@svnLogResult) {
    $tmp = $line;
    chomp($tmp);
    if($tmp =~ / \| /) {
      $tmp =~ s/(^r)([0-9]*) (.*)/$2/;
      $bugID2Revision[$counter] = $tmp;
      $nbrev++;
      $rev = $tmp;
      $log = "";
    } elsif($tmp =~ /refs/) {
      if ($bugID2Revision[$counter] eq "") {
          $bugID2Revision[$counter] = $rev;
          $nbrev++;
      }
      $tmp =~ s/(^.* *refs *[ |:])[ |#]*([0-9]*) *(.*)/$2/;
      
      $bugID2Rev{ $tmp } .= $bugID2Revision[$counter]." ";
      
      $bugID2Revision[$counter] = $tmp.":".$bugID2Revision[$counter];
      $counter++;
    } elsif (($tmp !~ /^ *$/) && ($tmp !~ /----------------/) && 1) {
      $log .= $tmp;
    }  
  }
  
  if($counter > 0) {
    @bugID2Revision = sort @bugID2Revision;

    $currentBugID ="";
    $lastBugID = "";
    $currentRevision= "";
    @currentCode = "";

    foreach $line (@bugID2Revision){
      ($currentBugID,$currentRevision) = split (':',$line);
      chomp($currentBugID);
      chomp($currentRevision);
      if($currentBugID ne $lastBugID){
        $lastBugID = $currentBugID;
        $bugID2File{ $currentBugID } .= $targetfile." ";
      }
    }
  }
}
`rm -f svnlog`;

#print "* Start bugID => Revision mapping\n";
foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    #print "  $bugID  => ".$bugID2Rev{$bugID}."\n";
  }  
}
$prevbugtracker="";
$prevmisctracker="";

status("* Extract information from Redmine\n");
foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    @filelist=split ('\n',$bugID2File{$bugID});
    @filelist=sort @filelist;
    @spec_char=(
                ["&",  "&#38;"],
                ["<",  "&#60;"],
                [">",  "&#62;"],
                ["=",  "&#61;"],
                ["\r", "&#13;"],
                ["\x92", "&#146;"],
                ["\x96", "&#150;"],
                ["\n", "</w:t></w:r></w:p><w:p><w:r><w:t>"],
                );
    
#    print "Process $bugID\n";
    $bugtrackerid=`echo "select tracker_id from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v tracker_id`;
    chop($bugtrackerid);
    $bugtracker=`echo "select name from trackers where id=\"$bugtrackerid\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v name`;
    chop($bugtracker);
    #print "DEBUG:$prevbugtracker != $bugtracker\n";
    if ($prevbugtracker eq "NONE")
    { 
#      print "";
    } else {  
      $title="Bugs and Features";
      generatedocword::newtitle(1,"$title");
      #print "DEBUG:generatedocword::newtitle(1,\"$bugtracker\");\n";
    }  
    $prevbugtracker = "NONE";

    $buginfo="$bugtracker #$bugID\n\n";
  
    $bugsummary=`echo "select subject  from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v subject`;
    foreach $elem(@spec_char)
    {
        @arr = @$elem;
        $bugsummary=~ s/$arr[0]/$arr[1]/g;
    }
    
#    print "  #$bugID $bugtracker : $bugsummary";
    generatedocword::newtitle(2,"$bugtracker (#$bugID): $bugsummary");
    generatedocword::newtitle(3,"Description");

    $buginfo.="Summary:\n--------\n$bugsummary\n";
    $bugdescription=`echo "select description from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v description`;
    $bugdescription=~ s/\r//g;
    $bugdescription=~ s/\\n/\n/g;
    foreach $elem(@spec_char)
    {
        @arr = @$elem;
        $bugdescription=~ s/$arr[0]/$arr[1]/g;
    }
    
    generatedocword::newparagraph("Normal","$bugdescription\n"); 
    generatedocword::newtitle(3,"SW impacts");
    generatedocword::newparagraph("Normal","Modified files:"); 
    $buginfo.="$bugdescription\n";
    #print "$buginfo\n\n";
      
    $tt=$bugID2Rev{$bugID};
    $tt =~ s/ /|/g;
    chop($tt);
    foreach $file (@filelist){
      $file =~ s/ //g;
      $filepath = $file;
      $filepath =~ s/$srcPath/SW/;
      if (length($file))
      {
        generatedocword::newparagraph("Normal","\t$filepath"); 
        #$res=`svn annotate $file | egrep -n \"$tt\" | sed 's/: *[0-9]* *[a-z]*/:/'`;
      }  
      
    }
    generatedocword::newparagraph("Normal","\n"); 
  }  
}

generatedocword::endofwordfile();	

status("* The file $outputfile.doc has been successfully generated.\n");

# Accepts one argument: the full path to a SVN working directory.
# Returns: A list of files that reside in that path and that changed between the
# two SVN revisions that are considered.
sub create_file_list {
    my $path = shift;
    my $oldrev = shift;
    my @filelst;

    status("* Check files modified in $path between r$oldrev and r$svnNewRevision\n");
    open(tmp_file, '>', "svndiff") or die "cannot open svndiff\n";
    print tmp_file `svn diff -r $oldrev:$svnNewRevision --summarize $path | grep -v "D " | cut -d " " -f3- | sed 's: ::g'`;
    close(tmp_file);
    @svndiff = `cat svndiff`;
    foreach $line (@svndiff) {
        chomp $line;
        if (-d $line) {
            # Do nothing if this is a directory
        } else {
            push @filelst, $line."\n";
        }
    }
    `rm -f svndiff`;
    
    return @filelst;
}

# Print the string passed as parameter (in Bold)
sub status {
    my $str = shift;
    
    print "\033[1m$str\033[0m";
}

