#!/usr/bin/perl

# usage ./track_change.pl <filelist> <blockname> <old revision> <new revision>

if ($#ARGV != 5)
{
 die "usage ./track_change_doc.pl [SOFT|FULL] <macsw path> <rwnx_drv path> <old revision> <new revision> <rel version>\n"
}


$svnOldRevision = "13824";

$numArgs = $#ARGV + 1;
print "thanks, you gave me $numArgs command-line arguments.\n";

foreach $argnum (0 .. $#ARGV) {

   print "$ARGV[$argnum]\n";

}
$type = $ARGV[0];
@targetfilelist = create_file_list($ARGV[1]."/config");
push @targetfilelist, create_file_list($ARGV[1]."/ip/lmac");
if ($type eq "FULL") {
    push @targetfilelist, create_file_list($ARGV[1]."/ip/umac");
}
push @targetfilelist, create_file_list($ARGV[1]."/modules");
push @targetfilelist, create_file_list($ARGV[1]."/plf/refip");
push @targetfilelist, create_file_list_no_rec($ARGV[2]);
push @targetfilelist, create_file_list($ARGV[2]."/softmac");
if ($type eq "FULL") {
    push @targetfilelist, create_file_list($ARGV[2]."/fullmac");
}

$svnOldRevision     = $ARGV[3];
$svnNewRevision     = $ARGV[4];
if ($type eq "FULL") {
    $outputfile      = "RW-WLAN-nX-FMAC-SW-RN-v$ARGV[5]";
} else {
    $outputfile      = "RW-WLAN-nX-LMAC-SW-RN-v$ARGV[5]";
}


`rm -rf $outputfile`;
`touch $outputfile`;
open(output_file,'>',"$outputfile\.log") or die "Cannot open for write $outputfile.log\n";
open(output_file_perbug,'>',"$outputfile\_modification.log") or die "Cannot open for write $outputfile\_modification.log\n";
open(output_file_perbug_fileonly,'>',"$outputfile\_modification_short.log") or die "Cannot open for write $outputfile\_modification_short.log\n";
open(output_file_buginfo,'>',"$outputfile\_bugsummary.log") or die "Cannot open for write $outputfile\_bugsummary.log\n";
open(modified_file_list,'>',"$outputfile\_modified_files.list") or die "Cannot open for write $outputfile\_modified_files.list\n";
open(unmodified_file_list,'>',"$outputfile\_unmodified_files.list") or die "Cannot open for write $outputfile\_unmodified_files.list\n";

print "Start of processing\n";



my %bugID2Rev = {};
my %bugID2File = {};

foreach $targetfile (@targetfilelist)
{

  print("targetfile $targetfile");
  `rm -f annotate`;
  `touch annotate`;
  open(tmp_file, '>', "annotate") or die "cannot open annotate\n";
  print tmp_file `svn annotate $targetfile`;
  close(tmp_file);

  `rm -f svnlog`;
  `touch svnlog`;
  open(tmp_file, '>', "svnlog") or die "cannot open svnlog\n";
  print tmp_file `svn log -r $svnOldRevision:$svnNewRevision $targetfile`;
  close(tmp_file);

  @svnLogResult = `cat svnlog`;
#  print @svnLogResult;
  @revision = "";
  @bugId = "";
  @bugID2Revision = "";
  $counter = 0;
  $nbrev = 0;
  foreach $line (@svnLogResult) {
    $tmp = $line;
    chomp($tmp);
    if($tmp =~ /\|/) {
      $tmp =~ s/(^r)([0-9]*) (.*)/$2/;
      $bugID2Revision[$counter] = $tmp;
      $nbrev++;
      $log = "";
    } elsif($tmp =~ /refs/) {
      #print $tmp;
      $tmp =~ s/(^.* *refs *[ |:])[ |#]*([0-9]*) *(.*)/$2/;
      
      $bugID2Rev{ $tmp } .= $bugID2Revision[$counter]." ";
      
      $bugID2Revision[$counter] = $tmp.":".$bugID2Revision[$counter];
      $counter++;
    } elsif (($nbrev != $counter) && ($tmp =~ /----------------/) && 1) {
      #print $tmp;
      $tmp = 100000 + $bugID2Revision[$counter];
      $bugID2Rev{ $tmp } .= $bugID2Revision[$counter]." ";
      $bugID2Revision[$counter] = "$tmp:".$bugID2Revision[$counter];
      $bugID2Log{ $tmp } = $log;
      $counter++;
      
    } elsif (($tmp !~ /^ *$/) && ($tmp !~ /----------------/) && 1) {
      $log .= $tmp;
    }  
  }
  
  if($counter > 0) {
    print modified_file_list "$targetfile";

    @bugID2Revision = sort @bugID2Revision;
    #print "bugID2Revision\n@bugID2Revision\n";

    $currentBugID ="";
    $lastBugID = "";
    $currentRevision= "";
    @currentCode = "";

    print "\nFound newer version of:\n$targetfile\n";

    print output_file "\n\n\n$targetfile\n";
    foreach $line (@bugID2Revision){
      ($currentBugID,$currentRevision) = split (':',$line);
      print ("LINE : $line\n");
      chomp($currentBugID);
      chomp($currentRevision);
#      print "split $currentRevision $currentBugID\n";
      if($currentBugID ne $lastBugID){
        $lastBugID = $currentBugID;
        print output_file "\n\nRelated bug $currentBugID:\n";
        print output_file "Related code:\n";
        $bugID2File{ $currentBugID } .= $targetfile." ";
      }

      #print "grep -n $currentRevision annotate\n";
      @currentCode = `grep -n $currentRevision annotate`; 
      print output_file @currentCode;
    }
  } elsif ($nbrev > 0) {
    print modified_file_list "$targetfile";
    print "\nFound newer version of:\n$targetfile\n";

    print output_file "\n\n\n$targetfile\n";
  
  } else {
    print unmodified_file_list "$targetfile";
  
  }
}

print "bugID => Revision\n";
foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    print "$bugID  => ".$bugID2Rev{$bugID}."\n";
  }  
}

foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    @filelist=split ('\n',$bugID2File{$bugID});
    @filelist=sort @filelist;
    print output_file_perbug "\n--------------------------------------------------------------------------------\n";
    print output_file_perbug_fileonly "\n--------------------------------------------------------------------------------\n";
    
    print "Process $bugID\n";
    if ($bugID < 100000) {
      $bugtrackerid=`echo "select tracker_id from issues where id=\"$bugID\"" | mysql -h 10.10.10.35 -P 3306 -u redmine --password=my_password -D redmine | grep -v tracker_id`;
      chop($bugtrackerid);
      $bugtracker=`echo "select name from trackers where id=\"$bugtrackerid\"" | mysql -h 10.10.10.35 -P 3306 -u redmine --password=my_password -D redmine | grep -v name`;
      chop($bugtracker);

      $buginfo="$bugtracker #$bugID\n\n";
      print $buginfo;
    
      $bugsummary=`echo "select subject  from issues where id=\"$bugID\"" | mysql -h 10.10.10.35 -P 3306 -u redmine --password=my_password -D redmine | grep -v subject`;
      $buginfo.="Summary:\n--------\n$bugsummary\n";
      $bugdescription=`echo "select description from issues where id=\"$bugID\"" | mysql -h 10.10.10.35 -P 3306 -u redmine --password=my_password -D redmine | grep -v description`;
      $bugdescription=~ s/\r//g;
      $bugdescription=~ s/\\n/\n/g;
      $buginfo.="$bugdescription\n";
      #print "$buginfo\n\n";
      print output_file_buginfo "$buginfo\n\n";
      print output_file_perbug "$buginfo\n";
      print output_file_perbug_fileonly "$buginfo\n";
    } else {
      $bugsummary=$bugID2Log{$bugID};
      $buginfo="Summary:\n--------\n$bugsummary\n";
      print output_file_buginfo "$buginfo\n\n";
      print output_file_perbug "$buginfo\n";
      print output_file_perbug_fileonly "$buginfo\n";
    
    }
    $tt=$bugID2Rev{$bugID};
    $tt =~ s/ /|/g;
    chop($tt);
    foreach $file (@filelist){
      $file =~ s/ //g;
      if (length($file))
      {
        print output_file_perbug "\n\nImpacted file : $file\n\n";
        print output_file_perbug_fileonly "Impacted file : $file\n";
        print "  $file\n";
        $res=`svn annotate $file | egrep -n \"$tt\" | sed 's/: *[0-9]* *[a-z]*/:/'`;
        print output_file_perbug "$res\n";
      }  
      
    }
  }  
}

close(output_file);
close(output_file_perbug);
close(output_file_perbug_fileonly);
close(output_file_buginfo);
close(modified_file_list);
close(unmodified_file_list);
`rm -rf annotate`;
#`rm -rf svnlog`;

# Accepts one argument: the full path to a directory.
# Returns: A list of files that reside in that path.
sub create_file_list {
    my $path = shift;
    my @filelst;

    opendir (DIR, $path)
        or die "Unable to open $path: $!";

    # We are just chaining the grep and map from
    # the previous example.
    # You'll see this often, so pay attention ;)
    # This is the same as:
    # LIST = map(EXP, grep(EXP, readdir()))
    my @files =
        # Third: Prepend the full path
        map { $path . '/' . $_ }
        # Second: take out '.' and '..'
        grep { !/^\.{1,2}$/ }
        # First: get all files
        readdir (DIR);

    closedir (DIR);

    for (@files) {
        if (-d $_) {
            if ($_ !~ /.svn/) {
                # Add all of the new files from this directory
                # (and its subdirectories, and so on... if any)
                push @filelst, create_file_list ($_);
            }
        } else {
            # Do whatever you want here =) .. if anything.
            push @filelst, $_."\n";
        }
    }
    
    return @filelst;
}

# Accepts one argument: the full path to a directory.
# Returns: A list of files that reside in that path.
sub create_file_list_no_rec {
    my $path = shift;
    my @filelst;

    opendir (DIR, $path)
        or die "Unable to open $path: $!";

    # We are just chaining the grep and map from
    # the previous example.
    # You'll see this often, so pay attention ;)
    # This is the same as:
    # LIST = map(EXP, grep(EXP, readdir()))
    my @files =
        # Third: Prepend the full path
        map { $path . '/' . $_ }
        # Second: take out '.' and '..'
        grep { !/^\.{1,2}$/ }
        # First: get all files
        readdir (DIR);

    closedir (DIR);

    for (@files) {
        if (-d $_) {
            # Do nothing if this is a directory
        } else {
            # Do whatever you want here =) .. if anything.
            push @filelst, $_."\n";
        }
    }
    
    return @filelst;
}
