#!/usr/bin/perl

# usage ./track_change.pl <filelist> <blockname> <old revision> <new revision>



use generatedocword;




if ($#ARGV != 5)
{
 die "usage ./track_change_doc.pl [SOFT|FULL] <macsw path> <rwnx_drv path> <old revision> <new revision> <rel version>\n"
}

$svnOldRevision = "13824";


$numArgs = $#ARGV + 1;
print "thanks, you gave me $numArgs command-line arguments.\n";

foreach $argnum (0 .. $#ARGV) {

   print "$ARGV[$argnum]\n";

}
$type = $ARGV[0];
@targetfilelist = create_file_list($ARGV[1]."/config");
push @targetfilelist, create_file_list($ARGV[1]."/ip/lmac");
if ($type eq "FULL") {
    push @targetfilelist, create_file_list($ARGV[1]."/ip/umac");
}
push @targetfilelist, create_file_list($ARGV[1]."/modules");
push @targetfilelist, create_file_list($ARGV[1]."/plf/refip");
push @targetfilelist, create_file_list_no_rec($ARGV[2]);
push @targetfilelist, create_file_list($ARGV[2]."/softmac");
if ($type eq "FULL") {
    push @targetfilelist, create_file_list($ARGV[2]."/fullmac");
}

$svnOldRevision     = $ARGV[3];
$svnNewRevision     = $ARGV[4];
if ($type eq "FULL") {
    $outputfile      = "RW-WLAN-nX-FMAC-SW-RN-v$ARGV[5]";
} else {
    $outputfile      = "RW-WLAN-nX-LMAC-SW-RN-v$ARGV[5]";
}

$prjname=$ENV{'PROJECT'};
open($fileoutput,">$outputfile.doc");
generatedocword::init(1);
generatedocword::headerofRWwordfile($fileoutput,$outputfile,"Release Note");

print "Compare $svnNewRevision with $svnOldRevision\n";


`rm -rf $outputfile`;
`touch $outputfile`;
open(output_file,'>',"$outputfile\.log") or die "Cannot open for write $outputfile.log\n";
open(output_file_perbug,'>',"$outputfile\_modification.log") or die "Cannot open for write $outputfile\_modification.log\n";
open(output_file_perbug_fileonly,'>',"$outputfile\_modification_short.log") or die "Cannot open for write $outputfile\_modification_short.log\n";
open(output_file_buginfo,'>',"$outputfile\_bugsummary.log") or die "Cannot open for write $outputfile\_bugsummary.log\n";
open(modified_file_list,'>',"$outputfile\_modified_files.list") or die "Cannot open for write $outputfile\_modified_files.list\n";
open(unmodified_file_list,'>',"$outputfile\_unmodified_files.list") or die "Cannot open for write $outputfile\_unmodified_files.list\n";




print "Start processing of $ARGV[0]\n";

my %bugID2Rev = {};
my %bugID2File = {};

foreach $targetfile (@targetfilelist)
{
  print("  ~ $targetfile");
  `rm -f annotate`;
  `touch annotate`;
  open(tmp_file, '>', "annotate") or die "cannot open annotate\n";
  print tmp_file `svn annotate $targetfile`;
  close(tmp_file);

  `rm -f svnlog`;
  `touch svnlog`;
  open(tmp_file, '>', "svnlog") or die "cannot open svnlog\n";
  print tmp_file `svn log -r $svnOldRevision:$svnNewRevision $targetfile`;
  close(tmp_file);

  @svnLogResult = `cat svnlog`;
#  print @svnLogResult;
  @revision = "";
  @bugId = "";
  @bugID2Revision = "";
  $counter = 0;
  $nbrev = 0;
  foreach $line (@svnLogResult) {
    $tmp = $line;
#    print "$tmp\n";
    chomp($tmp);
    if($tmp =~ / \| /) {
      $tmp =~ s/(^r)([0-9]*) (.*)/$2/;
      $bugID2Revision[$counter] = $tmp;
      $nbrev++;
      $rev = $tmp;
      $log = "";
    } elsif($tmp =~ /refs/) {
      if ($bugID2Revision[$counter] eq "") {
          $bugID2Revision[$counter] = $rev;
          $nbrev++;
      }
      $tmp =~ s/(^.* *refs *[ |:])[ |#]*([0-9]*) *(.*)/$2/;
      
      $bugID2Rev{ $tmp } .= $bugID2Revision[$counter]." ";
      
      $bugID2Revision[$counter] = $tmp.":".$bugID2Revision[$counter];
      $counter++;
    } elsif (($nbrev != $counter) && ($tmp =~ /----------------/) && 1) {
      $tmp = 100000 + $bugID2Revision[$counter];
      $bugID2Rev{ $tmp } .= $bugID2Revision[$counter]." ";
      $bugID2Revision[$counter] = "$tmp:".$bugID2Revision[$counter];
      $bugID2Log{ $tmp } = $log;
      $counter++;
      
    } elsif (($tmp !~ /^ *$/) && ($tmp !~ /----------------/) && 1) {
      $log .= $tmp;
    }  
  }
  
  if($counter > 0) {
    print modified_file_list "$targetfile";

    @bugID2Revision = sort @bugID2Revision;

    $currentBugID ="";
    $lastBugID = "";
    $currentRevision= "";
    @currentCode = "";

    print "    !! New version found !!\n";

    print output_file "\n\n\n$targetfile\n";
    foreach $line (@bugID2Revision){
      ($currentBugID,$currentRevision) = split (':',$line);
      chomp($currentBugID);
      chomp($currentRevision);
#      print "split $currentRevision $currentBugID\n";
      if($currentBugID ne $lastBugID){
        $lastBugID = $currentBugID;
        print output_file "\n\nRelated bug $currentBugID:\n";
        print output_file "Related code:\n";
        $bugID2File{ $currentBugID } .= $targetfile." ";
      }

      #print "grep -n $currentRevision annotate\n";
      @currentCode = `grep -n $currentRevision annotate`; 
      print output_file @currentCode;
    }
  } elsif ($nbrev > 0) {
    print modified_file_list "$targetfile";
    print "    !! New version found !!\n";

    print output_file "\n\n\n$targetfile\n";
  
  } else {
    print unmodified_file_list "$targetfile";
  
  }
}

print "All files checked.\n";
print "Start bugID => Revision mapping\n";
foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    print "  $bugID  => ".$bugID2Rev{$bugID}."\n";
  }  
}
$prevbugtracker="";
$prevmisctracker="";

print "\nExtract information from Redmine\n";
foreach $bugID (sort keys %bugID2Rev){
  if (length($bugID2File{$bugID}))
  {
    @filelist=split ('\n',$bugID2File{$bugID});
    @filelist=sort @filelist;
    @spec_char=(
                ["&",  "&#38;"],
                ["<",  "&#60;"],
                [">",  "&#62;"],
                ["=",  "&#61;"],
                ["\r", "&#13;"],
                ["\n", "</w:t></w:r></w:p><w:p><w:r><w:t>"],
                );
    
    print output_file_perbug "\n--------------------------------------------------------------------------------\n";
    print output_file_perbug_fileonly "\n--------------------------------------------------------------------------------\n";
    
    print "Process $bugID\n";
    if ($bugID < 100000) {
      $bugtrackerid=`echo "select tracker_id from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v tracker_id`;
      chop($bugtrackerid);
      $bugtracker=`echo "select name from trackers where id=\"$bugtrackerid\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v name`;
      chop($bugtracker);
      #print "DEBUG:$prevbugtracker != $bugtracker\n";
      if ($prevbugtracker eq "NONE")
      { 
        print "";
      } else {  
        $title="Bugs and Features";
        generatedocword::newtitle(1,"$title");
        #print "DEBUG:generatedocword::newtitle(1,\"$bugtracker\");\n";
      }  
      $prevbugtracker = "NONE";

      $buginfo="$bugtracker #$bugID\n\n";
    
      $bugsummary=`echo "select subject  from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v subject`;
      print "  #$bugID $bugtracker : $bugsummary";
      generatedocword::newtitle(2,"$bugtracker (#$bugID): $bugsummary");
      generatedocword::newtitle(3,"Description");

      $buginfo.="Summary:\n--------\n$bugsummary\n";
      $bugdescription=`echo "select description from issues where id=\"$bugID\"" | mysql -h 192.168.140.40 -P 3306 -u redmine --password=my_password -D redmine | grep -v description`;
      $bugdescription=~ s/\r//g;
      $bugdescription=~ s/\\n/\n/g;
      foreach $elem(@spec_char)
      {
          @arr = @$elem;
          $bugdescription=~ s/$arr[0]/$arr[1]/g;
      }
      
      generatedocword::newparagraph("Normal","$bugdescription\n"); 
      generatedocword::newtitle(3,"SW impacts");
      generatedocword::newparagraph("Normal","Modified files:"); 
      $buginfo.="$bugdescription\n";
      #print "$buginfo\n\n";
      print output_file_buginfo "$buginfo\n\n";
      print output_file_perbug "$buginfo\n";
      print output_file_perbug_fileonly "$buginfo\n";
      
    } else {
      if ($prevmisctracker eq "NONE")
      { 
        print "";
      } else {  
        $bugtracker="Miscellaneous changes";
        generatedocword::newtitle(1,"$bugtracker");
        #print "DEBUG:generatedocword::newtitle(1,\"$bugtracker\");\n";
      }  
      $prevmisctracker="NONE";
      $bugsummary=$bugID2Log{$bugID};
      print "  rev$bugID NONE : $bugsummary\n";
      $buginfo="Summary:\n--------\n$bugsummary\n";
      generatedocword::newtitle(2,"$bugsummary");
      generatedocword::newtitle(3,"Description");
      generatedocword::newparagraph("Normal","\n"); 
      generatedocword::newtitle(3,"SW impacts");
      generatedocword::newparagraph("Normal","Modified files:"); 
      print output_file_buginfo "$buginfo\n\n";
      print output_file_perbug "$buginfo\n";
      print output_file_perbug_fileonly "$buginfo\n";
    
    }
    $tt=$bugID2Rev{$bugID};
    $tt =~ s/ /|/g;
    chop($tt);
    foreach $file (@filelist){
      $file =~ s/ //g;
      $filepath = $file;
      $filepath =~ s/.*\/$prjname\/HW\///;
      if (length($file))
      {
        generatedocword::newparagraph("Normal","\t$filepath"); 
        print output_file_perbug "\n\nImpacted file : $filepath\n\n";
        print output_file_perbug_fileonly "Impacted file : $filepath\n";
        #print "  $file\n";
        $res=`svn annotate $file | egrep -n \"$tt\" | sed 's/: *[0-9]* *[a-z]*/:/'`;
        print output_file_perbug "$res\n";
      }  
      
    }
    generatedocword::newparagraph("Normal","\n"); 
  }  
}

close(output_file);
close(output_file_perbug);
close(output_file_perbug_fileonly);
close(output_file_buginfo);
close(modified_file_list);
close(unmodified_file_list);
`rm -rf annotate`;
#`rm -rf svnlog`;
generatedocword::endofwordfile();	

print "\nThe file $outputfile.doc and all the additional text files have been successfully generated.\n";

# Accepts one argument: the full path to a directory.
# Returns: A list of files that reside in that path.
sub create_file_list {
    my $path = shift;
    my @filelst;

    opendir (DIR, $path)
        or die "Unable to open $path: $!";

    # We are just chaining the grep and map from
    # the previous example.
    # You'll see this often, so pay attention ;)
    # This is the same as:
    # LIST = map(EXP, grep(EXP, readdir()))
    my @files =
        # Third: Prepend the full path
        map { $path . '/' . $_ }
        # Second: take out '.' and '..'
        grep { !/^\.{1,2}$/ }
        # First: get all files
        readdir (DIR);

    closedir (DIR);

    for (@files) {
        if (-d $_) {
            if ($_ !~ /.svn/) {
                # Add all of the new files from this directory
                # (and its subdirectories, and so on... if any)
                push @filelst, create_file_list ($_);
            }
        } else {
            # Do whatever you want here =) .. if anything.
            push @filelst, $_."\n";
        }
    }
    
    return @filelst;
}

# Accepts one argument: the full path to a directory.
# Returns: A list of files that reside in that path.
sub create_file_list_no_rec {
    my $path = shift;
    my @filelst;

    opendir (DIR, $path)
        or die "Unable to open $path: $!";

    # We are just chaining the grep and map from
    # the previous example.
    # You'll see this often, so pay attention ;)
    # This is the same as:
    # LIST = map(EXP, grep(EXP, readdir()))
    my @files =
        # Third: Prepend the full path
        map { $path . '/' . $_ }
        # Second: take out '.' and '..'
        grep { !/^\.{1,2}$/ }
        # First: get all files
        readdir (DIR);

    closedir (DIR);

    for (@files) {
        if (-d $_) {
            # Do nothing if this is a directory
        } else {
            # Do whatever you want here =) .. if anything.
            push @filelst, $_."\n";
        }
    }
    
    return @filelst;
}

