/**
 ****************************************************************************************
 *
 * @file hal_desc.c
 *
 * @brief File containing the definition of HW descriptors.
 *
 * File containing the definition of the structure and API function used to initialize
 * the pool.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 *****************************************************************************************
 * @addtogroup HWDESC
 * @{
 *****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "hal_desc.h"
#include "tx_swdesc.h"
#include "hal_machw_mib.h"
#include "compiler.h"

/*
 * GLOBAL VARIABLES
 ****************************************************************************************
 */
#if NX_RADAR_DETECT
struct radar_event_desc radar_event_desc_array[RADAR_EVENT_MAX] __SHAREDRAM;
#endif

#if NX_UF_EN
struct unsup_rx_vector_desc rx_vector_desc_array[UNSUP_RX_VECT_MAX] __SHAREDRAM;
#endif

#if !NX_FULLY_HOSTED
struct tx_hw_desc       tx_hw_desc0[RW_USER_MAX * NX_TXDESC_CNT0] __SHAREDRAM;
struct tx_hw_desc       tx_hw_desc1[RW_USER_MAX * NX_TXDESC_CNT1] __SHAREDRAM;
struct tx_hw_desc       tx_hw_desc2[RW_USER_MAX * NX_TXDESC_CNT2] __SHAREDRAM;
struct tx_hw_desc       tx_hw_desc3[RW_USER_MAX * NX_TXDESC_CNT3] __SHAREDRAM;
#if (NX_BEACONING)
struct tx_hw_desc       tx_hw_desc4[NX_TXDESC_CNT4] __SHAREDRAM;
#endif
#endif

#if NX_BCN_AUTONOMOUS_TX
/// IPC DMA control structure for beacon download
struct dma_desc bcn_dwnld_desc __SHAREDRAM;
#endif

#if NX_DEBUG_DUMP
struct debug_info_tag   debug_info __SHAREDRAM;
#endif

/// @}  // end of group
