/**
 ****************************************************************************************
 *
 * @file rwnx.h
 *
 * @brief Main nX MAC definitions.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @mainpage RW-WLAN-nX MAC SW project index page
 *
 * @section intro_sec Introduction
 *
 * RW-WLAN-nX is the RivieraWaves 802.11a/b/g/n/ac IP.\n
 * This document presents the Low Level Design of the RW-WLAN-nX MAC SW.\n
 * A good entry point to this document is the @ref MACSW "MACSW" module page.
 ****************************************************************************************
 */

#ifndef _RWNXL_H_
#define _RWNXL_H_

#include "co_bool.h"

/**
 ****************************************************************************************
 * @defgroup MACSW MACSW
 * @brief RW-WLAN-nX root module.
 * @{
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @brief This function performs all the initializations of the MAC SW.
 *
 ****************************************************************************************
 */
void rwnxl_init(void);

/**
 ****************************************************************************************
 * @brief Start the MAC SW.
 *
 * Start processing wifi event in an endless loop (or the RTOS scheduler).
 * It doesn't returns.
 ****************************************************************************************
 */
void rwnxl_start(void);

/**
 ****************************************************************************************
 * @brief NX reset event handler.
 * This function is part of the recovery mechanism invoked upon an error detection in the
 * LMAC. It performs the full LMAC reset, and restarts the operation.
 *
 * @param[in] dummy Parameter not used but required to follow the kernel event callback
 * format
 ****************************************************************************************
 */
void rwnxl_reset_evt(int dummy);

/**
 ****************************************************************************************
 * @brief This function checks if any kernel event is pending in the MAC SW.
 * If no event is pending, the CPU clock could be gated.
 *
 * @return true if the CPU can be put in sleep, false otherwise.
 ****************************************************************************************
 */
bool rwnxl_cpu_can_sleep(void);

/**
 ****************************************************************************************
 * @brief This function performs the required checks prior to go to DOZE mode.
 * If all these checks pass, then the MAC HW is put in DOZE mode.
 *
 ****************************************************************************************
 */
void rwnxl_sleep(void);

/**
 ****************************************************************************************
 * @brief This function performs the wake up from DOZE mode.
 *
 ****************************************************************************************
 */
void rwnxl_wakeup(void);

/// @}

#endif // _RWNXL_H_
