/**
 ****************************************************************************************
 *
 * @file tx_swdesc.c
 *
 * @brief Implementation of Tx SW descriptors functions
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup TX_SWDESC
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "co_int.h"
#include "co_bool.h"

#include "co_list.h"
#include "tx_swdesc.h"
#include "ke_event.h"
#include "co_utils.h"

/*
 * GLOBAL VARIABLES
 ****************************************************************************************
 */
#if !NX_FULLY_HOSTED
/// Descriptors for the BK queue
struct txdesc       txdesc_array0[RW_USER_MAX * NX_TXDESC_CNT0];
/// Descriptors for the BE queue
struct txdesc       txdesc_array1[RW_USER_MAX * NX_TXDESC_CNT1];
/// Descriptors for the VI queue
struct txdesc       txdesc_array2[RW_USER_MAX * NX_TXDESC_CNT2];
/// Descriptors for the VO queue
struct txdesc       txdesc_array3[RW_USER_MAX * NX_TXDESC_CNT3];
#if (NX_BEACONING)
/// Descriptors for the BCN queue
struct txdesc       txdesc_array4[NX_TXDESC_CNT4];
#endif

/// Array of pointer to the different TX descriptor pools
const struct txdesc * const txdesc_array_per_q[NX_TXQ_CNT] =
{
    txdesc_array0,
    txdesc_array1,
    txdesc_array2,
    txdesc_array3,
    #if (NX_BEACONING)
    txdesc_array4,
    #endif
};

/// Array of pointer to the different TX descriptor pools
struct txdesc *txdesc_array[NX_TXQ_CNT][RW_USER_MAX];

/// Array of pointer to the different TX HW descriptor pools
const struct tx_hw_desc * const tx_hw_desc[NX_TXQ_CNT] =
{
    tx_hw_desc0,
    tx_hw_desc1,
    tx_hw_desc2,
    tx_hw_desc3,
    #if (NX_BEACONING)
    tx_hw_desc4,
    #endif
};
#endif //!NX_FULLY_HOSTED

const int nx_txdesc_cnt[] =
{
    NX_TXDESC_CNT0,
    NX_TXDESC_CNT1,
    NX_TXDESC_CNT2,
    NX_TXDESC_CNT3,
    #if (NX_BEACONING)
    NX_TXDESC_CNT4,
    #endif
};

const int nx_txuser_cnt[] =
{
    RW_USER_MAX,
    RW_USER_MAX,
    RW_USER_MAX,
    RW_USER_MAX,
    #if (NX_BEACONING)
    1,
    #endif
};

/*
 * INTERNAL FUNCTION PROTOTYPES
 ****************************************************************************************
 */
void tx_txdesc_init(void)
{
    #if !NX_FULLY_HOSTED
    // Attach the TX confirmation descriptors to the TX descriptors
    for (int i = 0; i < NX_TXQ_CNT; i++)
    {
        for (int j = 0; j < nx_txuser_cnt[i]; j++)
        {
            txdesc_array[i][j] = (struct txdesc *)&txdesc_array_per_q[i][j * nx_txdesc_cnt[i]];

            memset((void *)txdesc_array[i][j], 0, nx_txdesc_cnt[i] * sizeof(struct txdesc));
            for (int k = 0; k < nx_txdesc_cnt[i]; k++)
            {
                struct txdesc *txdesc = &txdesc_array[i][j][k];
                struct lmacdesc *desc = &txdesc->lmac;
                struct tx_hw_desc *hw_desc = (struct tx_hw_desc *)&tx_hw_desc[i][j * nx_txdesc_cnt[i] + k];

                // Attach the TX confirmation descriptor
                desc->hw_desc = hw_desc;

                // Initialize some fields of the TX confirmation descriptor
                hw_desc->dma_desc.src = CPU2HW(&hw_desc->cfm);
                hw_desc->dma_desc.length = sizeof_b(hw_desc->cfm);
            }
        }
    }
    #endif
}

/// @} // end of group TX_SWDESC

