/**
 ****************************************************************************************
 *
 * @file txl_buffer_shared.c
 *
 * @brief Definition of the Tx buffer area that has to be shared with MAC HW
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup TX_BUFFER
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "txl_buffer.h"
#include "compiler.h"

/*
 * GLOBAL VARIABLES
 ****************************************************************************************
 */
#if !NX_FULLY_HOSTED
uint32_t txl_buffer_pool[TX_BUFFER_POOL_MAX][TX_BUFFER_POOL_SIZE] __SHAREDRAM;

struct txl_buffer_hw_desc_tag txl_buffer_hw_desc[TX_BUFFER_POOL_MAX] __SHAREDRAM;
#endif //!NX_FULLY_HOSTED

#if NX_UMAC_PRESENT
struct txl_buffer_control txl_buffer_control_desc[NX_REMOTE_STA_MAX] __SHAREDRAM;

struct txl_buffer_control txl_buffer_control_desc_bcmc[NX_VIRT_DEV_MAX] __SHAREDRAM;
#endif

/// @}
