/**
 ****************************************************************************************
 * @file uf.c
 *
 * @brief Declarations of unsupported HT frame logger.
 *
 * Copyright (C) RivieraWaves 2011-2019
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup UF
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
// For Unsupported frames
#include "uf.h"
#if NX_UF_EN
#include "co_int.h"
// For bool
#include "co_bool.h"
// For INLINE
#include "compiler.h"
// GP DMA descriptor allocation
#include "hal_dma.h"
// IPC host buffer allocation
#include "ipc_emb.h"
// For debug functions
#include "dbg.h"
// For HW/CPU buffer pointer manipulations
#include "co_utils.h"

#include "macif.h"

// For rx vector definitions
#include "reg_macbypass.h"

/*
 * MACROS
 ****************************************************************************************
 */

/*
 * FUNCTION DEFINITIONS
 ****************************************************************************************
 */

void uf_event_ind(void)
{
    uint8_t rx_format;
    struct rx_vector_desc vect;

    //Read Rx vector 1
    vect.rx_vec_1.recvec1a = macbyp_int_rxv0_get();
    vect.rx_vec_1.recvec1b = macbyp_int_rxv4_get();
    vect.rx_vec_1.recvec1c = macbyp_int_rxv8_get();
    vect.rx_vec_1.recvec1d = macbyp_rxv12_get();

    // Get the information on the current channel from the PHY driver
    phy_get_channel(&vect.phy_info, PHY_PRIM);
    // Read format
    rx_format = hal_desc_get_rx_format(&vect.rx_vec_1);

    // Check if the received format is HT
    if (rx_format != FORMATMOD_HT_MF)
        return;

    macif_uf_ind(&vect);
}

#endif // NX_UF_EN

/// @}
