/**
 ****************************************************************************************
 *
 * @file llc.c
 *
 * @brief LLC module interface source file
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */

#include "llc.h"

/**
 * @addtogroup LLC
 * @{
 */

/*
 * CONSTANTS
 ****************************************************************************************
 */
/// RFC1042 LLC/SNAP Header
const struct llc_snap_short llc_rfc1042_hdr = {
                                                  0xAAAA, // DSAP LSAP
                                                  0x0003, // Control/Prot0
                                                  0x0000, // Prot1 and 2
                                              };

/// Bridge-Tunnel LLC/SNAP Header
const struct llc_snap_short llc_bridge_tunnel_hdr = {
                                                        0xAAAA, // DSAP LSAP
                                                        0x0003, // Control/Prot0
                                                        0xF800, // Prot1 and 2
                                                    };

/// @}
