/**
 ****************************************************************************************
 *
 * @file co_bit.h
 *
 * @brief Provide bit manipulation macros
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 *
 ****************************************************************************************
 */

#ifndef _CO_BIT_H_
#define _CO_BIT_H_


/**
 ****************************************************************************************
 * @addtogroup CO_BIT
 * @ingroup COMMON
 * @brief Bit manipulation useful macro
 *
 * @{
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @brief Return value with one bit set.
 *
 * @param[in] pos Position of the bit to set.
 *
 * @return Value with one bit set.
 ****************************************************************************************
 */
#define CO_BIT(pos) (1UL<<(pos))

/** @} */
#endif // _CO_BIT_H_
