/**
 ****************************************************************************************
 *
 * @file dbg_profiling.c
 *
 * @brief Profiling configuration constant definition.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup DBG_PROF
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "dbg_profiling.h"

/*
 * GLOBAL VARIABLES
 ****************************************************************************************
 */
#if NX_PROFILING_ON
const char * const dbg_prof_conf[DBG_PROF_MAX] =
{
    #ifdef TX_IPC_IRQ_DEF
    [TX_IPC_IRQ] = "TX_IPC_IRQ",
    #endif
    #ifdef TX_MACIF_EVT_DEF
    [TX_MACIF_EVT] = "TX_MACIF_EVT",
    #endif
    #ifdef TX_DMA_IRQ_DEF
    [TX_DMA_IRQ] = "TX_DMA_IRQ",
    #endif
    #ifdef TX_NEW_TAIL_DEF
    [TX_NEW_TAIL] = "TX_NEW_TAIL",
    #endif
    #ifdef TX_MAC_IRQ_DEF
    [TX_MAC_IRQ] = "TX_MAC_IRQ",
    #endif
    #ifdef TX_HE_TRIG_IRQ_DEF
    [TX_HE_TRIG_IRQ] = "TX_HE_TRIG_IRQ",
    #endif
    #ifdef TX_BUF_FREE_DEF
    [TX_BUF_FREE]= "TX_BUF_FREE",
    #endif
    #ifdef TX_BUF_ALLOC_DEF
    [TX_BUF_ALLOC] = "TX_BUF_ALLOC",
    #endif
    #ifdef TX_PAYL_HDL_DEF
    [TX_PAYL_HDL] = "TX_PAYL_HDL",
    #endif
    #ifdef TX_CFM_EVT_DEF
    [TX_CFM_EVT] = "TX_CFM_EVT",
    #endif
    #ifdef TX_CFM_DMA_IRQ_DEF
    [TX_CFM_DMA_IRQ] = "TX_CFM_DMA_IRQ",
    #endif
    #ifdef MSG_BASIC_PROF_DEF
    [MSG_IRQ]     = "MSG_IRQ",
    [MSG_FWD]     = "MSG_FWD",
    [MSG_IPC_IND] = "MSG_IPC_IND",
    #endif
    #ifdef RX_MAC_IRQ_DEF
    [RX_MAC_IRQ] = "RX_MAC_IRQ",
    #endif
    #ifdef RX_DMA_IRQ_DEF
    [RX_DMA_IRQ] = "RX_DMA_IRQ",
    #endif
    #ifdef RX_DMA_EVT_DEF
    [RX_DMA_EVT] = "RX_DMA_EVT",
    #endif
    #ifdef RX_IPC_IND_DEF
    [RX_IPC_IND] = "RX_IPC_IND",
    #endif
    #ifdef RX_MPDU_XFER_DEF
    [RX_MPDU_XFER] = "RX_MPDU_XFER",
    #endif
    #ifdef RX_MPDU_FREE_DEF
    [RX_MPDU_FREE] = "RX_MPDU_FREE",
    #endif
    #ifdef RX_CNTRL_EVT_DEF
    [RX_CNTRL_EVT] = "RX_CNTRL_EVT",
    #endif
    #ifdef MM_HW_IDLE_DEF
    [MM_HW_IDLE] = "MM_HW_IDLE",
    #endif
    #ifdef MM_SET_CHANNEL_DEF
    [MM_SET_CHANNEL] = "MM_SET_CHANNEL",
    #endif
    #ifdef AGG_FIRST_MPDU_DWNLD_DEF
    [AGG_FIRST_MPDU_DWNLD] = "AGG_FIRST_MPDU_DWNLD",
    #endif
    #ifdef AGG_START_AMPDU_DEF
    [AGG_START_AMPDU] = "AGG_START_AMPDU",
    #endif
    #ifdef AGG_ADD_MPDU_DEF
    [AGG_ADD_MPDU] = "AGG_ADD_MPDU",
    #endif
    #ifdef AGG_SMPDU_DONETX_DEF
    [AGG_SMPDU_DONETX] = "AGG_SMPDU_DONETX",
    #endif
    #ifdef AGG_FINISH_AMPDU_DEF
    [AGG_FINISH_AMPDU] = "AGG_FINISH_AMPDU",
    #endif
    #ifdef AGG_BAR_DONETX_DEF
    [AGG_BAR_DONETX] = "AGG_BAR_DONETX",
    #endif
    #ifdef AGG_BA_RXED_DEF
    [AGG_BA_RXED] = "AGG_BA_RXED",
    #endif

    #ifdef MU_SEC_USER_IRQ_DEF
    [MU_SEC_USER_IRQ] = "MU_SEC_USER_IRQ",
    #endif
    #ifdef MU_PPDU_START_DEF
    [MU_PPDU_START] = "MU_PPDU_START",
    #endif
    #ifdef MU_MPDU_ADD_DEF
    [MU_MPDU_ADD] = "MU_MPDU_ADD",
    #endif
    #ifdef MU_PPDU_CLOSE_DEF
    [MU_PPDU_CLOSE] = "MU_PPDU_CLOSE",
    #endif
    #ifdef MU_USER_POS_DEF
    [MU_USER_POS] = "MU_USER_POS[0]",
    [MU_USER_POS + 1] = "MU_USER_POS[1]",
    #endif
    #ifdef MU_USER_POS_IRQ_DEF
    [MU_USER_POS_IRQ] = "MU_USER_POS_IRQ[0]",
    [MU_USER_POS_IRQ + 1] = "MU_USER_POS_IRQ[1]",
    #endif

    #ifdef CHAN_CTXT_CDE_EVT_PROF_DEF
    [CHAN_CTXT_CDE_EVT] = "CHAN_CTXT_CDE_EVT",
    #endif
    #ifdef CHAN_CTXT_TBTT_SWITCH_PROF_DEF
    [CHAN_CTXT_TBTT_SWITCH] = "CHAN_CTXT_TBTT_SWITCH",
    #endif
    #ifdef CHAN_CTXT_IDX_PROF_DEF
    [CHAN_CTXT_IDX_PROF]     = "CHAN_CTXT_IDX_PROF[0]",
    [CHAN_CTXT_IDX_PROF + 1] = "CHAN_CTXT_IDX_PROF[1]",
    [CHAN_CTXT_IDX_PROF + 2] = "CHAN_CTXT_IDX_PROF[2]",
    #endif
    #ifdef CHAN_CTXT_TX_DISCARD_PROF_DEF
    [CHAN_CTXT_TX_DISCARD]  = "CHAN_CTXT_TX_DISCARD",
    #endif
    #ifdef CHAN_CTXT_WAIT_END_PROF_DEF
    [CHAN_CTXT_WAIT_END]    = "CHAN_CTXT_WAIT_END",
    #endif
    #ifdef CHAN_CTXT_SWITCH_PROF_DEF
    [CHAN_CTXT_SWITCH] = "CHAN_CTXT_SWITCH",
    #endif
    #ifdef CHAN_CTXT_TBTT_PRES_PROF_DEF
    [CHAN_CTXT_TBTT_PRES] = "CHAN_CTXT_TBTT_PRES",
    #endif

    #ifdef P2P_NOA_ABS_DEF
    [P2P_NOA_0_ABS]  = "P2P_NOA_0_ABS",
    [P2P_NOA_1_ABS]  = "P2P_NOA_1_ABS",
    #endif
    #ifdef P2P_CTW_DEF
    [P2P_CTW]        = "P2P_CTW",
    #endif
    #ifdef P2P_WAIT_BCN_DEF
    [P2P_WAIT_BCN]   = "P2P_WAIT_BCN",
    #endif
    #ifdef P2P_ABSENCE_DEF
    [P2P_ABSENCE]    = "P2P_ABSENCE",
    #endif
    #ifdef P2P_PS_PAUSED_DEF
    [P2P_PS_PAUSED]  = "P2P_PS_PAUSED",
    #endif

    #ifdef RADAR_IRQ_DEF
    [RADAR_IRQ] = "RADAR_IRQ",
    #endif
    #ifdef TX_FRAME_PUSH_DEF
    [TX_FRAME_PUSH] = "TX_FRAME_PUSH",
    #endif
    #ifdef TX_FRAME_CFM_DEF
    [TX_FRAME_CFM] = "TX_FRAME_CFM",
    #endif
    #ifdef TX_AC_BG_DEF
    [TX_AC_BG]      = "TX_AC_BG[0]",
    [TX_AC_BG + 1]  = "TX_AC_BG[1]",
    #endif
    #ifdef TX_AC_IRQ_DEF
    [TX_AC_IRQ]      = "TX_AC_IRQ[0]",
    [TX_AC_IRQ + 1]  = "TX_AC_IRQ[1]",
    #endif
    #ifdef BCN_PRIM_TBTT_IRQ_DEF
    [BCN_PRIM_TBTT_IRQ] = "BCN_PRIM_TBTT_IRQ",
    #endif
    #ifdef BCN_SEC_TBTT_IRQ_DEF
    [BCN_SEC_TBTT_IRQ] = "BCN_SEC_TBTT_IRQ",
    #endif
    #ifdef HW_TBTT_EVT_DEF
    [HW_TBTT_EVT] = "HW_TBTT_EVT",
    #endif
    #ifdef AP_TBTT_DEF
    [AP_TBTT] = "AP_TBTT",
    #endif
    #ifdef STA_TBTT_DEF
    [STA_TBTT] = "STA_TBTT",
    #endif
    #ifdef TBTT_IDX_DEF
    [TBTT_IDX_PROF]     = "TBTT_IDX_PROF[0]",
    [TBTT_IDX_PROF + 1] = "TBTT_IDX_PROF[1]",
    [TBTT_IDX_PROF + 2] = "TBTT_IDX_PROF[2]",
    #endif

    #ifdef PS_SLEEP_DEF
    [PS_SLEEP]          = "PS_SLEEP",
    #endif
    #ifdef PS_PAUSE_DEF
    [PS_PAUSE]          = "PS_PAUSE",
    #endif
    #ifdef PS_DPSM_UPDATE_DEF
    [PS_DPSM_UPDATE]    = "PS_DPSM_UPDATE",
    #endif
    #ifdef PS_CHECK_RX_DEF
    [PS_CHECK_RX]       = "PS_CHECK_RX",
    #endif
    #ifdef PS_CHECK_TX_DEF
    [PS_CHECK_TX]       = "PS_CHECK_TX",
    #endif
    #ifdef PS_CHECK_BCN_DEF
    [PS_CHECK_BCN]      = "PS_CHECK_BCN",
    #endif

    #ifdef TD_CHECK_RX_DEF
    [TD_CHECK_RX]       = "TD_CHECK_RX",
    #endif
    #ifdef TD_CHECK_TX_DEF
    [TD_CHECK_TX]       = "TD_CHECK_TX",
    #endif
    #ifdef TD_CHECK_RX_PS_DEF
    [TD_CHECK_RX_PS]    = "TD_CHECK_RX_PS",
    #endif
    #ifdef TD_CHECK_TX_PS_DEF
    [TD_CHECK_TX_PS]    = "TD_CHECK_TX_PS",
    #endif
    #ifdef TD_TIMER_END_DEF
    [TD_TIMER_END]      = "TD_TIMER_END",
    #endif

    #ifdef BFR_MU_CALIB_DEF
    [BFR_MU_CALIB]      = "BFR_MU_CALIB",
    #endif //(BFR_MU_CALIB_DEF)
    #ifdef BFR_SU_CALIB_DEF
    [BFR_SU_CALIB]      = "BFR_SU_CALIB",
    #endif //(BFR_SU_CALIB_DEF)
    #ifdef BFR_RX_BFR_DEF
    [BFR_RX_BFR]        = "BFR_RX_BFR",
    #endif //(BFR_RX_BFR_DEF)
    #ifdef BFR_UPLOAD_DEF
    [BFR_UPLOAD]        = "BFR_UPLOAD",
    #endif //(BFR_UPLOAD_DEF)
    #ifdef BFR_DOWNLOAD_DEF
    [BFR_DOWNLOAD]      = "BFR_DOWNLOAD",
    #endif //(BFR_DOWNLOAD_DEF)
    #ifdef BFR_TX_IND_DEF
    [BFR_TX_IND]        = "BFR_TX_IND",
    #endif //(BFR_TX_IND_DEF)
    #ifdef BFR_TX_CFM_DEF
    [BFR_TX_CFM]        = "BFR_TX_CFM",
    #endif //(BFR_TX_CFM_DEF)
    #ifdef BFR_SMM_IDX_DEF
    [BFR_SMM_IDX_0]     = "BFR_SMM_IDX[0]",
    [BFR_SMM_IDX_1]     = "BFR_SMM_IDX[1]",
    [BFR_SMM_IDX_2]     = "BFR_SMM_IDX[2]",
    [BFR_SMM_IDX_LAST]  = "BFR_SMM_IDX[3]",
    #endif //(BFR_SMM_IDX_DEF)

    #ifdef RX_DUPLI_CHECK_DEF
    [RX_DUPLI_CHECK]      = "RX_DUPLI_CHECK",
    #endif
    #ifdef RX_DUPLI_NSTA_CHECK_DEF
    [RX_DUPLI_NSTA_CHECK] = "RX_DUPLI_NSTA_CHECK",
    #endif

    #ifdef IPCDESC_PREPARE_DEF
    [IPCDESC_PREPARE]     = "IPCDESC_PREPARE",
    #endif
    #ifdef IPCDESC_TRANSFER_DEF
    [IPCDESC_TRANSFER]    = "IPCDESC_TRANSFER",
    #endif

    #ifdef DEFRAG_CHECK_DEF
    [DEFRAG_CHECK]        = "DEFRAG_CHECK",
    #endif
    #ifdef DEFRAG_TRANSFER_DEF
    [DEFRAG_TRANSFER]     = "DEFRAG_TRANSFER",
    #endif
    #ifdef DEFRAG_UPD_LENGTH_DEF
    [DEFRAG_UPD_LENGTH]   = "DEFRAG_UPD_LENGTH",
    #endif

    #ifdef REORD_CHECK_DEF
    [REORD_CHECK]         = "REORD_CHECK",
    #endif
    #ifdef REORD_BAR_CHECK_DEF
    [REORD_BAR_CHECK]     = "REORD_BAR_CHECK",
    #endif
    #ifdef REORD_FLUSH_DEF
    [REORD_FLUSH]         = "REORD_FLUSH",
    #endif
    #ifdef REORD_FWD_DEF
    [REORD_FWD]           = "REORD_FWD",
    #endif

    #ifdef MAC2ETH_UPDATE_DEF
    [MAC2ETH_UPDATE]      = "MAC2ETH_UPDATE",
    #endif

    #ifdef PS_PEER_STATE_DEF
    [PS_PEER_STATE]       = "PS_PEER_STATE",
    #endif
    #ifdef PS_BCMC_STATE_DEF
    [PS_BCMC_STATE]       = "PS_BCMC_STATE",
    #endif
    #ifdef PS_STATE_VAL_DEF
    [PS_STATE_VAL]        = "PS_STATE_VAL[0]",
    [PS_STATE_VAL + 1]    = "PS_STATE_VAL[1]",
    #endif
    #ifdef PS_PSPOLL_RX_DEF
    [PS_PSPOLL_RX]        = "PS_PSPOLL_RX",
    #endif
    #ifdef PS_TRAFFIC_REQ_DEF
    [PS_TRAFFIC_REQ]      = "PS_TRAFFIC_REQ",
    #endif
    #ifdef BW_DROP_IRQ_DEF
    [BW_DROP_IRQ]         = "BW_DROP_IRQ",
    #endif
    #ifdef BW_DROP_STEP_DEF
    [BW_DROP_STEP]        = "BW_DROP_STEP",
    #endif
    #ifdef RC_UPD_COUNTERS_DEF
    [RC_UPD_COUNTERS]     = "RC_UPD_COUNTERS",
    #endif
    #ifdef RC_UPD_COUNTERS_TRIAL_DEF
    [RC_UPD_COUNTERS_TRIAL]     = "RC_UPD_COUNTERS_TRIAL",
    #endif
    #ifdef RC_STATS_CALC_DEF
    [RC_STATS_CALC]       = "RC_STATS_CALC",
    #endif
    #ifdef RC_UPD_RETRY_CHAIN_DEF
    [RC_UPD_RETRY_CHAIN]  = "RC_UPD_RETRY_CHAIN",
    #endif
    #ifdef RC_UPD_RETRY_CHAIN_TRIAL_DEF
    [RC_UPD_RETRY_CHAIN_TRIAL] = "RC_UPD_RETRY_CHAIN_TRIAL",
    #endif
    #ifdef RC_SET_TRIAL_BUFFER_DEF
    [RC_SET_TRIAL_BUFFER] = "RC_SET_TRIAL_BUFFER",
    #endif
    #ifdef RC_LOOKAROUND_TX_DEF
    [RC_LOOKAROUND_TX]    = "RC_LOOKAROUND_TX",
    #endif
    #ifdef RC_SW_RETRY_DEF
    [RC_SW_RETRY]         = "RC_SW_RETRY",
    #endif

    #ifdef FT_OVER_DS_REQ_DEF
    [FT_OVER_DS_REQ]      = "FT_OVER_DS_REQ",
    #endif
    #ifdef FT_REASSOC_DEF
    [FT_REASSOC]          = "FT_REASSOC",
    #endif

    #ifdef MESH_PS_ENABLE_DEF
    [MESH_PS_ENABLE]      = "MESH_PS_ENABLE",
    #endif //(MESH_PS_ENABLE_DEF)
    #ifdef MESH_PS_SP_OWNER_DEF
    [MESH_PS_SP_OWNER]    = "MESH_PS_SP_OWNER",
    #endif //(MESH_PS_SP_OWNER_DEF)
    #ifdef MESH_PS_SP_RECIP_DEF
    [MESH_PS_SP_RECIP]    = "MESH_PS_SP_RECIP",
    #endif //(MESH_PS_SP_RECIP_DEF)
    #ifdef MESH_PS_WAIT_BCMC_DEF
    [MESH_PS_WAIT_BCMC]   = "MESH_PS_WAIT_BCMC",
    #endif //(MESH_PS_WAIT_BCMC_DEF)
    #ifdef MESH_PS_WAIT_BCN_DEF
    [MESH_PS_WAIT_BCN]    = "MESH_PS_WAIT_BCN",
    #endif //(MESH_PS_WAIT_BCN_DEF)
    #ifdef MESH_PS_LOCAL_MAW_DEF
    [MESH_PS_LOCAL_MAW]   = "MESH_PS_LOCAL_MAW",
    #endif //(MESH_PS_LOCAL_MAW_DEF)
    #ifdef MESH_PS_PEER_MAW_DEF
    [MESH_PS_PEER_MAW]    = "MESH_PS_PEER_MAW",
    #endif //(MESH_PS_PEER_MAW_DEF)

    #ifdef CPU_SLEEP_DEF
    [CPU_SLEEP]           = "CPU_SLEEP",
    #endif //CPU_SLEEP_DEF
    #ifdef DEEP_SLEEP_DEF
    [DEEP_SLEEP]           = "DEEP_SLEEP",
    #endif //DEEP_SLEEP_DEF

    #ifdef TDLS_CHSW_REQ_RX_DEF
    [TDLS_RX_CHSW_REQ] = "TDLS_RX_CHSW_REQ",
    #endif
    #ifdef TDLS_CHSW_RESP_RX_DEF
    [TDLS_RX_CHSW_RESP] = "TDLS_RX_CHSW_RESP",
    #endif
    #ifdef TDLS_CHSW_REQ_TX_DEF
    [TDLS_TX_CHSW_REQ] = "TDLS_TX_CHSW_REQ",
    #endif
    #ifdef TDLS_CHSW_RESP_TX_DEF
    [TDLS_TX_CHSW_RESP] = "TDLS_TX_CHSW_RESP",
    #endif
    #ifdef TDLS_SWITCH_TO_OFFCH_DEF
    [TDLS_SWITCH_TO_OFFCH] = "TDLS_SWITCH_TO_OFFCH",
    #endif
    #ifdef TDLS_SWITCH_TO_BASECH_DEF
    [TDLS_SWITCH_TO_BASECH]= "TDLS_SWITCH_TO_BASECH",
    #endif
    #ifdef TDLS_CHSW_TIME_TIMER_DEF
    [TDLS_CHSW_TIME_TIMER]  = "TDLS_CHSW_TIME_TIMER",
    #endif
    #ifdef TDLS_CHSW_TIMEOUT_TIMER_DEF
    [TDLS_CHSW_TIMEOUT_TIMER]= "TDLS_CHSW_TIMEOUT_TIMER",
    #endif
    #ifdef TDLS_CHSW_END_TIMER_DEF
    [TDLS_CHSW_END_TIMER]= "TDLS_CHSW_END_TIMER",
    #endif
    #ifdef TDLS_CHSW_REQ_TX_TIMER_DEF
    [TDLS_CHSW_REQ_TX_TIMER]= "TDLS_CHSW_REQ_TX_TIMER",
    #endif
    #ifdef TDLS_DELAY_CHSW_DEF
    [TDLS_DELAY_CHSW]= "TDLS_DELAY_CHSW",
    #endif
    #ifdef TDLS_CHSW_NULL_FRAME_TX_DEF
    [TDLS_TX_CHSW_NULL_FRAME]= "TDLS_TX_CHSW_NULL_FRAME",
    #endif
    #ifdef RTOS_TASK_DEF
    [RTOS_TASK]     = "RTOS_TASK[0]",
    [RTOS_TASK + 1] = "RTOS_TASK[1]",
    [RTOS_TASK + 2] = "RTOS_TASK[2]",
    [RTOS_TASK + 3] = "RTOS_TASK[3]",
    #endif
    #ifdef ANT_DIV_SWITCH_DEF
    [ANT_DIV_SWITCH]= "ANT_DIV_SWITCH",
    #endif

};
#endif

/// @} end of group

