/**
 ****************************************************************************************
 *
 * @file template_task.c
 *
 * @brief Template task kernel interface declaration.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup TASK_TEMPLATE
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "template_task.h"
#include "other_task.h"

/*
 * FUNCTION DEFINITIONS
 ****************************************************************************************
 */
/**
 ****************************************************************************************
 * @brief Brief description of the message handler.
 * Long description of the message handler.
 * @param[in] msgid Id of the message received (probably unused).
 * @param[in] param Pointer to the parameters of the message.
 * @param[in] dest_id ID of the receiving task instance (probably unused).
 * @param[in] src_id ID of the sending task instance.
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
static int
template_message1_req_handler(ke_msg_id_t const msgid,
                              struct template_message1_req const *param,
                              ke_task_id_t const dest_id,
                              ke_task_id_t const src_id)
{
    // your code commented here
}

/**
 ****************************************************************************************
 * @brief Brief description of the message handler.
 * Long description of the message handler.
 * @param[in] msgid Id of the message received (probably unused).
 * @param[in] param Pointer to the parameters of the message.
 * @param[in] dest_id ID of the receiving task instance (probably unused).
 * @param[in] src_id ID of the sending task instance.
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
static int
other_message54_cfm_handler(ke_msg_id_t const msgid,
                            struct other_message54_cfm const *param,
                            ke_task_id_t const dest_id,
                            ke_task_id_t const src_id)
{
    // your code commented here
}

/**
 ****************************************************************************************
 * @brief Brief description of the message handler.
 * Long description of the message handler.
 * @param[in] msgid Id of the message received (probably unused).
 * @param[in] param Pointer to the parameters of the message.
 * @param[in] dest_id ID of the receiving task instance (probably unused).
 * @param[in] src_id ID of the sending task instance.
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
static int
template_example1_ind_handler(ke_msg_id_t const msgid,
                              struct template_example1_ind const *param,
                              ke_task_id_t const dest_id,
                              ke_task_id_t const src_id)
{
    // your code commented here
}

/**
 ****************************************************************************************
 * @brief Brief description of the message handler.
 * Long description of the message handler.
 * @param[in] msgid Id of the message received (probably unused).
 * @param[in] param Pointer to the parameters of the message.
 * @param[in] dest_id ID of the receiving task instance (probably unused).
 * @param[in] src_id ID of the sending task instance.
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
static int
template_example2_ind_handler(ke_msg_id_t const msgid,
                              struct template_example2_ind const *param,
                              ke_task_id_t const dest_id,
                              ke_task_id_t const src_id)
{
    // your code commented here
}


/*
 * MESSAGE HANDLERS
 ****************************************************************************************
 */
/// STATE1 handlers definition.
const struct ke_msg_handler template_state1[] =
{
    {TEMPLATE_MESSAGE1_REQ, (ke_msg_func_t)template_message1_req_handler},
    {OTHER_MESSAGE54_CFM, (ke_msg_func_t)other_message54_cfm_handler}
};

/// STATE2 handlers definition.
const struct ke_msg_handler template_state2[] =
{
    {TEMPLATE_MESSAGE1_REQ, (ke_msg_func_t)template_message1_req_handler},
    {TEMPLATE_EXAMPLE1_IND, (ke_msg_func_t)template_example1_ind_handler}
};

/// STATE3 handlers definition.
const struct ke_msg_handler template_state3[] =
{
    {TEMPLATE_EXAMPLE1_IND, (ke_msg_func_t)template_example1_ind_handler},
    {OTHER_MESSAGE54_CFM, (ke_msg_func_t)other_message54_cfm_handler}
};

/// DEFAULT handler definition.
const struct ke_msg_handler template_default_state[] =
{
    {TEMPLATE_EXAMPLE2_IND, (ke_msg_func_t)template_example2_ind_handler}
};

/// Specifies the message handler structure for every input state.
const struct ke_state_handler template_state_handler[TEMPLATE_STATE_MAX] =
{
    /// STATE1 State message handlers.
    [TEMPLATE_STATE1] = KE_STATE_HANDLER(template_state1),
    /// STATE2 State message handlers.
    [TEMPLATE_STATE2] = KE_STATE_HANDLER(template_state2),
    /// STATE3 State message handlers.
    [TEMPLATE_STATE3] = KE_STATE_HANDLER(template_state3)
};

/// Specifies the message handlers that are common to all states.
const struct ke_state_handler template_default_handler =
    KE_STATE_HANDLER(template_default_state);

/// Defines the placeholder for the states of all the task instances.
ke_state_t template_state[TEMPLATE_IDX_MAX];

/// @} end of addtogroup
