/**
 ****************************************************************************************
 *
 * @file arch_main.c
 *
 * @brief Main loop of the application.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup ARCH
 * @{
 ****************************************************************************************
 */

#include "rwnx.h"
#include "rwnx_platform.h"

/**
 ****************************************************************************************
 * @brief Main WiFi stack entry point.
 *
 * This function is called right after the booting process has completed.
 ****************************************************************************************
 */
int main(void)
{
    // Platform initialization
    rwnx_platform_init();

    // MAC SW initializations
    rwnxl_init();

    // Start MAC SW main loop (never return)
    rwnxl_start();

    return 0;
}

/// @}
