/**
 ****************************************************************************************
 *
 * @file boot.c
 *
 * @brief ROM startup code.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 * !!!! Warning !!!!
 * This code is the boot loader. It initializes all memory sections, including
 * stack. It MUST be compiled with optimization.
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup BOOT
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */

#include <machine/cpu.h>
#include <machine/ifs.h>
#include "interrupt.h"
#include "boot.h"
#include "ll.h"

// To force optimization O=s on this file
#pragma GCC optimize ("s")

/*
 * VECTORS TABLE
 ****************************************************************************************
 */

/** Prototypes for trap handlers.
 * By defining these as weak, we allow the user to override these in his code */
void rw_start                    (void);
void critical_error_handler      (void);
void illegal_instruction_handler (void);
void debugger_breakpoint_handler (void);
void debugger_stop_handler       (void);
void interrupt4_handler          (void) __attribute__((weak));
void interrupt5_handler          (void) __attribute__((weak));
void interrupt6_handler          (void) __attribute__((weak));
void interrupt7_handler          (void) __attribute__((weak));
void interrupt8_handler          (void) __attribute__((weak));
void interrupt9_handler          (void) __attribute__((weak));
void interrupt10_handler         (void) __attribute__((weak));
void interrupt11_handler         (void) __attribute__((weak));
void interrupt12_handler         (void) __attribute__((weak));
void interrupt13_handler         (void) __attribute__((weak));
void interrupt14_handler         (void) __attribute__((weak));
void interrupt15_handler         (void) __attribute__((weak));
void interrupt16_handler         (void) __attribute__((weak));
void interrupt17_handler         (void) __attribute__((weak));
void interrupt18_handler         (void) __attribute__((weak));
void interrupt19_handler         (void) __attribute__((weak));
void interrupt20_handler         (void) __attribute__((weak));
void interrupt21_handler         (void) __attribute__((weak));
void interrupt22_handler         (void) __attribute__((weak));
void interrupt23_handler         (void) __attribute__((weak));
void interrupt24_handler         (void) __attribute__((weak));
void interrupt25_handler         (void) __attribute__((weak));
void interrupt26_handler         (void) __attribute__((weak));
void interrupt27_handler         (void) __attribute__((weak));
void interrupt28_handler         (void) __attribute__((weak));
void interrupt29_handler         (void) __attribute__((weak));
void interrupt30_handler         (void) __attribute__((weak));
void interrupt31_handler         (void) __attribute__((weak));
void interrupt32_handler         (void) __attribute__((weak));
void interrupt33_handler         (void) __attribute__((weak));
void interrupt34_handler         (void) __attribute__((weak));
void interrupt35_handler         (void) __attribute__((weak));
void interrupt36_handler         (void) __attribute__((weak));
void interrupt37_handler         (void) __attribute__((weak));
void interrupt38_handler         (void) __attribute__((weak));
void interrupt39_handler         (void) __attribute__((weak));
void interrupt40_handler         (void) __attribute__((weak));
void interrupt41_handler         (void) __attribute__((weak));
void interrupt42_handler         (void) __attribute__((weak));
void interrupt43_handler         (void) __attribute__((weak));
void interrupt44_handler         (void) __attribute__((weak));
void interrupt45_handler         (void) __attribute__((weak));
void interrupt46_handler         (void) __attribute__((weak));
void interrupt47_handler         (void) __attribute__((weak));
void interrupt48_handler         (void) __attribute__((weak));
void interrupt49_handler         (void) __attribute__((weak));
void interrupt50_handler         (void) __attribute__((weak));
void interrupt51_handler         (void) __attribute__((weak));
void interrupt52_handler         (void) __attribute__((weak));
void interrupt53_handler         (void) __attribute__((weak));
void interrupt54_handler         (void) __attribute__((weak));
void interrupt55_handler         (void) __attribute__((weak));
void interrupt56_handler         (void) __attribute__((weak));
void interrupt57_handler         (void) __attribute__((weak));
void interrupt58_handler         (void) __attribute__((weak));
void interrupt59_handler         (void) __attribute__((weak));
void interrupt60_handler         (void) __attribute__((weak));
void interrupt61_handler         (void) __attribute__((weak));
void interrupt62_handler         (void) __attribute__((weak));
void interrupt63_handler         (void) __attribute__((weak));
void interrupt64_handler         (void) __attribute__((weak));
void interrupt65_handler         (void) __attribute__((weak));
void interrupt66_handler         (void) __attribute__((weak));
void interrupt67_handler         (void) __attribute__((weak));
void interrupt68_handler         (void) __attribute__((weak));
void interrupt69_handler         (void) __attribute__((weak));
void interrupt70_handler         (void) __attribute__((weak));
void interrupt71_handler         (void) __attribute__((weak));
void interrupt72_handler         (void) __attribute__((weak));
void interrupt73_handler         (void) __attribute__((weak));
void interrupt74_handler         (void) __attribute__((weak));
void interrupt75_handler         (void) __attribute__((weak));
void interrupt76_handler         (void) __attribute__((weak));
void interrupt77_handler         (void) __attribute__((weak));
void interrupt78_handler         (void) __attribute__((weak));
void interrupt79_handler         (void) __attribute__((weak));
void interrupt80_handler         (void) __attribute__((weak));
void interrupt81_handler         (void) __attribute__((weak));
void interrupt82_handler         (void) __attribute__((weak));
void interrupt83_handler         (void) __attribute__((weak));
void interrupt84_handler         (void) __attribute__((weak));
void interrupt85_handler         (void) __attribute__((weak));
void interrupt86_handler         (void) __attribute__((weak));
void interrupt87_handler         (void) __attribute__((weak));
void interrupt88_handler         (void) __attribute__((weak));
void interrupt89_handler         (void) __attribute__((weak));
void interrupt90_handler         (void) __attribute__((weak));
void interrupt91_handler         (void) __attribute__((weak));
void interrupt92_handler         (void) __attribute__((weak));
void interrupt93_handler         (void) __attribute__((weak));
void interrupt94_handler         (void) __attribute__((weak));
void interrupt95_handler         (void) __attribute__((weak));

/// Trap table definition
volatile trap_handler_fp trap_vectors[96] __attribute ((section (".vectors"), used)) =
{
    [0]  = rw_start,
    [1]  = critical_error_handler,
    [2]  = illegal_instruction_handler,
    [3]  = debugger_breakpoint_handler,
    [4]  = debugger_stop_handler,
    [5]  = interrupt5_handler,
    [6]  = interrupt6_handler,
    [7]  = interrupt7_handler,
    [8]  = interrupt8_handler,
    [9]  = interrupt9_handler,
    [10] = interrupt10_handler,
    [11] = interrupt11_handler,
    [12] = interrupt12_handler,
    [13] = interrupt13_handler,
    [14] = interrupt14_handler,
    [15] = interrupt15_handler,
    [16] = interrupt16_handler,
    [17] = interrupt17_handler,
    [18] = interrupt18_handler,
    [19] = interrupt19_handler,
    [20] = interrupt20_handler,
    [21] = interrupt21_handler,
    [22] = interrupt22_handler,
    [23] = interrupt23_handler,
    [24] = interrupt24_handler,
    [25] = interrupt25_handler,
    [26] = interrupt26_handler,
    [27] = interrupt27_handler,
    [28] = interrupt28_handler,
    [29] = interrupt29_handler,
    [30] = interrupt30_handler,
    [31] = interrupt31_handler,
    [32] = interrupt32_handler,
    [33] = interrupt33_handler,
    [34] = interrupt34_handler,
    [35] = interrupt35_handler,
    [36] = interrupt36_handler,
    [37] = interrupt37_handler,
    [38] = interrupt38_handler,
    [39] = interrupt39_handler,
    [40] = interrupt40_handler,
    [41] = interrupt41_handler,
    [42] = interrupt42_handler,
    [43] = interrupt43_handler,
    [44] = interrupt44_handler,
    [45] = interrupt45_handler,
    [46] = interrupt46_handler,
    [47] = interrupt47_handler,
    [48] = interrupt48_handler,
    [49] = interrupt49_handler,
    [50] = interrupt50_handler,
    [51] = interrupt51_handler,
    [52] = interrupt52_handler,
    [53] = interrupt53_handler,
    [54] = interrupt54_handler,
    [55] = interrupt55_handler,
    [56] = interrupt56_handler,
    [57] = interrupt57_handler,
    [58] = interrupt58_handler,
    [59] = interrupt59_handler,
    [60] = interrupt60_handler,
    [61] = interrupt61_handler,
    [62] = interrupt62_handler,
    [63] = interrupt63_handler,
    [64] = interrupt64_handler,
    [65] = interrupt65_handler,
    [66] = interrupt66_handler,
    [67] = interrupt67_handler,
    [68] = interrupt68_handler,
    [69] = interrupt69_handler,
    [70] = interrupt70_handler,
    [71] = interrupt71_handler,
    [72] = interrupt72_handler,
    [73] = interrupt73_handler,
    [74] = interrupt74_handler,
    [75] = interrupt75_handler,
    [76] = interrupt76_handler,
    [77] = interrupt77_handler,
    [78] = interrupt78_handler,
    [79] = interrupt79_handler,
    [80] = interrupt80_handler,
    [81] = interrupt81_handler,
    [82] = interrupt82_handler,
    [83] = interrupt83_handler,
    [84] = interrupt84_handler,
    [85] = interrupt85_handler,
    [86] = interrupt86_handler,
    [87] = interrupt87_handler,
    [88] = interrupt88_handler,
    [89] = interrupt89_handler,
    [90] = interrupt90_handler,
    [91] = interrupt91_handler,
    [92] = interrupt92_handler,
    [93] = interrupt93_handler,
    [94] = interrupt94_handler,
    [95] = interrupt95_handler,
};

/*
 * SW ENTRY POINT
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @brief SW entry point section.
 *
 * Initialize stack pointer and branch to start-up function.
 *****************************************************************************************
 */
asm (".section .init\n"
     ".global rw_start\n"
     "rw_start:\n"
     "movhi   r1, #high(__stack_top)\n"
     "add     r1, #low(__stack_top)\n"
     "call   _startup\n");

/*
 * START-UP CODE
 ****************************************************************************************
 */

extern int main(void);

/**
 ****************************************************************************************
 * @brief Start-up code.
 *
 * This code is the C entry point of SW.
 *   1. Enable debugger interrupt
 *   2. Initializes all RAM memory regions
 *   3. Call main() function
 *****************************************************************************************
 */
void _startup(void)
{
    uint32_t *dst;

    //*************************************************************
    //* 1. Enable debugger interrupt                              *
    //*************************************************************
    ic_enable_debug_irq();
    GLOBAL_INT_START();

    //*************************************************************
    //* 2. Initializes all RAM memory regions                    *
    //*************************************************************
    // Initialize .bss section (.sbss / .scommon / .bss / COMMON)
    for (dst = _bss; dst < _ebss; dst++)
        *dst = 0;

    // Initialize heap memory
    for (dst = __heap_bottom; dst < __heap_top; dst++)
        *dst = 0;

    // Initialize stack memory !!! variables should not be on the stack !!!
    for (dst = __stack_bottom; dst < __stack_top; dst++)
        *dst = STACK_INIT_PATTERN;

    //*************************************************************
    //* 3. Call main() function                                   *
    //*************************************************************
    main();
}


/*
 * MONITOR STUB FOR DEBUGGER
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @brief Monitor stub for debugger
 *
 * Define trap vectors from 1 to 4 and implement monitor stub for debugger.
 *****************************************************************************************
 */
asm (".section .text\n"
     "illegal_instruction_handler:\n"
     "   st  r2, [r0]+short(_debugger_register_save_area+2*4)\n"
     "   mov r2, #2\n"
     "   bra monitor\n"
     "debugger_breakpoint_handler:\n"
     "   st  r2, [r0]+short(_debugger_register_save_area+2*4)\n"
     "   mov r2, #3\n"
     "   bra monitor\n"
     "debugger_stop_handler:\n"
     "   st  r2, [r0]+short(_debugger_register_save_area+2*4)\n"
     "   mov r2, #0\n"
     "   bra monitor\n"
     "critical_error_handler:\n"
     "interrupt5_handler:\n"
     "interrupt6_handler:\n"
     "interrupt7_handler:\n"
     "interrupt8_handler:\n"
     "interrupt9_handler:\n"
     "interrupt10_handler:\n"
     "interrupt11_handler:\n"
     "interrupt12_handler:\n"
     "interrupt13_handler:\n"
     "interrupt14_handler:\n"
     "interrupt15_handler:\n"
     "interrupt16_handler:\n"
     "interrupt17_handler:\n"
     "interrupt18_handler:\n"
     "interrupt19_handler:\n"
     "interrupt20_handler:\n"
     "interrupt21_handler:\n"
     "interrupt22_handler:\n"
     "interrupt23_handler:\n"
     "interrupt24_handler:\n"
     "interrupt25_handler:\n"
     "interrupt26_handler:\n"
     "interrupt27_handler:\n"
     "interrupt28_handler:\n"
     "interrupt29_handler:\n"
     "interrupt30_handler:\n"
     "interrupt31_handler:\n"
     "interrupt32_handler:\n"
     "interrupt33_handler:\n"
     "interrupt34_handler:\n"
     "interrupt35_handler:\n"
     "interrupt36_handler:\n"
     "interrupt37_handler:\n"
     "interrupt39_handler:\n"
     "interrupt40_handler:\n"
     "interrupt41_handler:\n"
     "interrupt42_handler:\n"
     "interrupt43_handler:\n"
     "interrupt44_handler:\n"
     "interrupt45_handler:\n"
     "interrupt46_handler:\n"
     "interrupt47_handler:\n"
     "interrupt48_handler:\n"
     "interrupt49_handler:\n"
     "interrupt50_handler:\n"
     "interrupt51_handler:\n"
     "interrupt52_handler:\n"
     "interrupt53_handler:\n"
     "interrupt54_handler:\n"
     "interrupt55_handler:\n"
     "interrupt56_handler:\n"
     "interrupt57_handler:\n"
     "interrupt58_handler:\n"
     "interrupt59_handler:\n"
     "interrupt60_handler:\n"
     "interrupt61_handler:\n"
     "interrupt62_handler:\n"
     "interrupt63_handler:\n"
     "interrupt64_handler:\n"
     "interrupt65_handler:\n"
     "interrupt66_handler:\n"
     "interrupt67_handler:\n"
     "interrupt68_handler:\n"
     "interrupt69_handler:\n"
     "interrupt70_handler:\n"
     "interrupt71_handler:\n"
     "interrupt72_handler:\n"
     "interrupt73_handler:\n"
     "interrupt74_handler:\n"
     "interrupt75_handler:\n"
     "interrupt76_handler:\n"
     "interrupt77_handler:\n"
     "interrupt79_handler:\n"
     "interrupt80_handler:\n"
     "interrupt81_handler:\n"
     "interrupt82_handler:\n"
     "interrupt83_handler:\n"
     "interrupt84_handler:\n"
     "interrupt85_handler:\n"
     "interrupt86_handler:\n"
     "interrupt87_handler:\n"
     "interrupt88_handler:\n"
     "interrupt89_handler:\n"
     "interrupt90_handler:\n"
     "interrupt91_handler:\n"
     "interrupt92_handler:\n"
     "interrupt93_handler:\n"
     "interrupt94_handler:\n"
     "interrupt95_handler:\n"
     "uninitialized_trap_handler:\n"
     "   st  r2, [r0]+short(_debugger_register_save_area+2*4)\n"
     "   mov r2, #1\n"
     "   bra monitor\n"
     "\n"
     "; Monitor entry and exit - save and restore registers around call to monitor proper\n"
     "; save all registers\n"
     ".section .text\n"
     "monitor:\n"
     "   st  r1, [r0]+short(_debugger_register_save_area+1*4)\n"
     "   st  r3, [r0]+short(_debugger_register_save_area+3*4)\n"
     "   movhi r3, #high(0x50000000)\n"
     "; stop trace\n"
//     "   st  r0, [r3]+0x1000\n"
     "   stq r4, [r0]+short(_debugger_register_save_area+4*4)\n"
     "   stq r8, [r0]+short(_debugger_register_save_area+8*4)\n"
     "   stq r12,[r0]+short(_debugger_register_save_area+12*4)\n"
     "   mov r4, rtt\n"
     "   mov r5, psr\n"
     "   std r4, [r0]+short(_debugger_register_save_area+16*4)\n"
     "\n"
     "; Save interrupt source information\n"
     "   st  r2, [r0]+short(_debugger_register_save_area+0*4)\n"
     "; Tell debugger we have stopped\n"
     "   movhi r2, #0x1\n"
     "   st    r2, [r3]\n"
     "; Wait for debugger to tell us to go\n"
     "wait: \n"
     "   ld  r4, [r3]\n"
     "   and.cc r4, r2\n"
     "   bne  wait\n"
     "; Lets go!\n"
     "\n"
     "; Reload all registers and return\n"
     "go:\n"
     "   icache_flush\n"
     "; renable trace - this could come later but it is useful to\n"
     "; see all the values of all the registers getting reloaded\n"
     "   mov r2, #3\n"
//     "   st  r2, [r3]+0x1000\n"
     "   bra go1 ; so trace buffer decode resyncs\n"
     "go1:\n"
     "   ldd r4, [r0]+short(_debugger_register_save_area+16*4)\n"
     "   mov psr, r5\n"
     "   mov rtt, r4\n"
     "   ldq r12,[r0]+short(_debugger_register_save_area+12*4)\n"
     "   ldq r8, [r0]+short(_debugger_register_save_area+8*4)\n"
     "   ldq r4, [r0]+short(_debugger_register_save_area+4*4)\n"
     "   ldd r2, [r0]+short(_debugger_register_save_area+2*4)\n"
     "   ld  r1, [r0]+short(_debugger_register_save_area+1*4)\n"
     "   rti\n");

/// @} BOOT

#ifdef __STACK_CHECK__
#include "dbg.h"

extern uint32_t __stack_limit;
void __stack_overflow(unsigned sp, unsigned pc)
{
    uint32_t delta = __stack_limit - sp;
    GLOBAL_INT_DISABLE();
    dbg("STACK overflow of %d bytes at %08x", delta, pc);
    TRACE("STACK overflow of %d bytes at %p", delta, TR_PTR(pc));
    while(1) { ; }
    GLOBAL_INT_RESTORE();
}

#endif
