/**
 ****************************************************************************************
 *
 * @file interrupt.c
 *
 * @brief Interrupt vectors definition.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup DRIVERS
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */

#include "reg_aps_intc.h"
#include "interrupt.h"

/*
 * FUNCTION DEFINITIONS
 ****************************************************************************************
*/
void ic_set_interrupt_priority(uint8_t irq_number, enum ic_priority irq_prio)
{
    aps_ipl_setf(irq_number, irq_prio);
}

void ic_set_interrupt_enable(uint8_t irq_number, enum ic_stat irq_stat)
{
    aps_ien_setf(irq_number, irq_stat);
}

void ic_enable_debug_irq(void)
{
    // Set up interrupt controller for debug IRQ
    ic_set_interrupt_priority(IC_DEBUG_STOP_IRQ, IC_PRIO_HIGH);
    ic_set_interrupt_enable(IC_DEBUG_STOP_IRQ, IC_ENABLE);

    // Enable global interrupt
    aps_gcpl_setf(IC_PRIO_LOW);
    aps_gien_setf(IC_ENABLE);
}

enum ic_stat ic_get_global_interrupt_status(void)
{
    enum ic_stat irq_stat;

    // Reads status in interrupt controller register
    irq_stat = aps_girq_getf();

    return irq_stat;
}
