/**
 ****************************************************************************************
 *
 * @file boot.c
 *
 * @brief Define interrupt handler entry points.
 *
 * Copyright (C) RivieraWaves 2017-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup BOOT
 * @ingroup ARCH
 * @{
 * ****************************************************************************************
 */

/**
 * INCLUDES
 ****************************************************************************************
 */
#include <asm-dsp.h>
#include "intc.h"

///Null handlers to which all interrupts but RESET jump.
_dsp_asm(".PUBLIC _nmi_handler");
_dsp_asm(".PUBLIC _trape_bpi_handler");
_dsp_asm(".PUBLIC _trap_handler");
_dsp_asm(".PUBLIC _int0_handler");
_dsp_asm(".PUBLIC _int1_handler");
_dsp_asm(".PUBLIC _int2_handler");
_dsp_asm(".PUBLIC _int3_handler");
_dsp_asm(".PUBLIC _int4_handler");
_dsp_asm(".PUBLIC _trap0_handler");
_dsp_asm(".PUBLIC _trap1_handler");
_dsp_asm(".PUBLIC _trap2_handler");
_dsp_asm(".PUBLIC _trap3_handler");

_dsp_asm(".text");
_dsp_asm("_nmi_handler:");
_dsp_asm("retn");
_dsp_asm("nop");

_dsp_asm("_trape_bpi_handler:");
_dsp_asm("retb");
_dsp_asm("nop");

_dsp_asm("_trap_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_int0_handler:");
//_dsp_asm("call #INCODE _intc_irq");
_dsp_asm("brr #_intc_irq, #0x0, #0x0");
_dsp_asm("nop");

_dsp_asm("_int1_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_int2_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_int3_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_int4_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_trap0_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_trap1_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_trap2_handler:");
_dsp_asm("reti");
_dsp_asm("nop");

_dsp_asm("_trap3_handler:");
_dsp_asm("reti");
_dsp_asm("nop");
