#include <asm-dsp.h>

extern void initConfigRegs();
extern void initDataSections();
extern void initFuncVect();
extern void crt0HookPreMain();

extern void exit();

extern int  main(int, char **);


extern void trape_bpi_handler(void) __attribute__((interrupt));
extern void trap_handler(void)      __attribute__((interrupt));

extern void nmi_handler(void)       __attribute__((interrupt));
extern void int0_handler(void)      __attribute__((interrupt));
extern void int1_handler(void)      __attribute__((interrupt));
extern void int2_handler(void)      __attribute__((interrupt));
extern void int3_handler(void)      __attribute__((interrupt));
extern void int4_handler(void)      __attribute__((interrupt));
extern void trap0_handler(void)     __attribute__((interrupt));
extern void trap1_handler(void)     __attribute__((interrupt));
extern void trap2_handler(void)     __attribute__((interrupt));
extern void trap3_handler(void)     __attribute__((interrupt));
/*
 * crt0.c:
 * Composed of three parts:
 *
 * 1. The interrupt handlers table.
 * 3. Data sections for stack, heap, stdin/stdout and virtual registers
 * 4. The start() routine which calls main() and then exit(),
 */

/*
 * The interrupt handlers table.
 */

_dsp_asm(".CSECT inttbl");

/* Reset jumps to start(). */
_dsp_asm("PCU.brr #_start, #0x0, #0x0");
/* TRAPE/BI/PABP jumps to trape bpi handler  */
_dsp_asm(".org 0x20");

_dsp_asm("PCU.brr #0, #0x0, #0x0");
_dsp_asm("PCU.nop");

_dsp_asm(";;; brr #_trape_bpi_handler, #0x0, #0x0 ; temporarily taken for file-io");
/* TRAP jumps to trap handler  */
_dsp_asm(".org 0x40");
_dsp_asm("PCU.brr #_trap_handler, #0x0, #0x0");

/* NMI jumps to nmi_handler */
_dsp_asm(".org 0x60");
_dsp_asm("PCU.brr #_nmi_handler, #0x0, #0x0");

/* INT0 jumps to int0_handler */
_dsp_asm(".org 0x080");
_dsp_asm("PCU.brr #_int0_handler, #0x0, #0x0");

/* INT1 jumps to int1_handler */
_dsp_asm(".org 0x0c0");
_dsp_asm("PCU.brr #_int1_handler, #0x0, #0x0");

/* INT2 jumps to int2_handler */
_dsp_asm(".org 0x100");
_dsp_asm("PCU.brr #_int2_handler, #0x0, #0x0");

/* INT3 jumps to int3_handler */
_dsp_asm(".org 0x140");
_dsp_asm("PCU.brr #_int3_handler, #0x0, #0x0");

/* INT4 jumps to int4_handler */
_dsp_asm(".org 0x180");
_dsp_asm("PCU.brr #_int4_handler, #0x0, #0x0");

/* trap0 jumps to trap0_handler */
_dsp_asm(".org 0x200");
_dsp_asm("PCU.brr #_trap0_handler, #0x0, #0x0");

/* trap1 jumps to trap1_handler */
_dsp_asm(".org 0x240");
_dsp_asm("PCU.brr #_trap1_handler, #0x0, #0x0");

/* trap2 jumps to trap2_handler */
_dsp_asm(".org 0x280");
_dsp_asm("PCU.brr #_trap2_handler, #0x0, #0x0");

/* trap3 jumps to trap3_handler */
_dsp_asm(".org 0x2c0");
_dsp_asm("PCU.brr #_trap3_handler, #0x0, #0x0");
_dsp_asm(".org 0x300");

/* Initialize all the sections needed by the compiler, and set labels at the beginning
   of the sections that we might need later on. */

/* The malloc  segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MALLOC_SECT");
//void __malloc_sect_start__ __attribute__((section(".DSECT __MALLOC_SECT")));

/* The stack segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __STACK_SECT");

/* The mailbox segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MAILBOX_SECT");

/* The mmio segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MMIO_SECT");

//MAOR TODO
/* The Args segmnet */
_dsp_asm(".DSECT ARG_SECT");

#define NO_ARGV_SECT
#ifndef NO_ARGV_SECT
_dsp_asm("DW 0x100 DUP ?");
#endif

_dsp_asm(".DSECT ARG_SECT_END");

//_dsp_asm(".DSECT const_data");
//void __crt0_const_data_start__  __attribute__((section(".DSECT const_data")));
//_dsp_asm(".ndata");
//void __crt0_data_start__  __attribute__((section(".ndata")));
//_dsp_asm(".bss");
//void __crt0_bss_start__  __attribute__((section(".bss")));
//_dsp_asm(".no_init");
_dsp_asm(".GLOBAL ___crt0_const_data_start__");
_dsp_asm(".DSECT const_data");
_dsp_asm("___crt0_const_data_start__:");

_dsp_asm(".GLOBAL ___crt0_data_start__");
_dsp_asm(".ndata");
_dsp_asm("___crt0_data_start__:");
/* This is a dummy to make sure ___crt0_data_start__ points at the beggining
   of .data section */
_dsp_asm("DW 2");

_dsp_asm(".GLOBAL ___crt0_bss_start__");
_dsp_asm(".bss");
_dsp_asm("___crt0_bss_start__:");


_dsp_asm(".CSECT ctor_sect");
_dsp_asm(".CSECT dtor_sect");
_dsp_asm(".DSECT ctors");
_dsp_asm(".DSECT dtors");
_dsp_asm(".CSECT call_saved_store_restore_sect");
_dsp_asm(".text");
//#define TODO_X2
#ifdef TODO_X2
_dsp_asm(".GLOBAL _errno");

_dsp_asm(".GLOBAL _crt0HookPostStart");
_dsp_asm(".GLOBAL __crt0HookPostStartRetLabel__");
#endif
/*
 * The start() routine.
 * start() calls main() and then exit(),
 */
_dsp_asm("_start:");
_dsp_asm(".func_start 2 _start");
//_dsp_asm("SC0.mov #0xbcbc, r5.ui");
//_dsp_asm("SC0.mov #0x60023dbc, r6.ui");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("LS1.st r5.di, (#0+r6.ui).ds+#0 ,?pr15.b");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("nop");
_dsp_asm("nop");
/* set floating point rounding mod bit */
_dsp_asm("SC0.mov #0x80000, r0.i");
_dsp_asm("SC0.mov r0.ui, modg.ui");
/* set big-endianess bit */
#ifdef BIG_ENDIAN
#ifdef RTL_1_1_0
_dsp_asm("SC0.mov #0x8, r0.i");
_dsp_asm("SC0.mov #0x3c, r1.i");
_dsp_asm("out {dw,cpm} r0, (r1)");
#else
  _dsp_asm("SQ.lbf #0xf, begset");//auto mode
  _dsp_asm("SQ.lbf #0xa, bevset");//double word mode
#endif // RTL_1_1_0
#endif //BIG_ENDIAN
#ifdef TODO_X2
_dsp_asm("PCU.brr #_crt0HookPostStart, #0x0, #0x0");
#endif
_dsp_asm("__crt0HookPostStartRetLabel__:");


_dsp_asm("SC0.mov #__STACK_SECT.0, r2.i");
_dsp_asm("SC0.mov r2.ui, sp.ui");
_dsp_asm("nop #0x2");
_dsp_asm("SC0.add sp.ui, #SIZEOF(__STACK_SECT), sp.ui");
/* align the stack pointer */
_dsp_asm("nop #0x4");
_dsp_asm("SC0.mov sp.ui, r2.ui");
_dsp_asm("SC0.and r2.s2, #0xfffffffc, r2.s2");
_dsp_asm("SC0.mov r2.ui, sp.ui");
//_dsp_asm("SC0.mov #0xBBCCBBCC, r5.ui");
//_dsp_asm("SC0.mov #0x60023dbc, r6.ui");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("LS1.st r5.ui, (r6.ui).ds+#0 ,?pr15.b");
/* init all configuration registers. */
_dsp_asm("PCU.callr {ds1} #_initConfigRegs");
_dsp_asm("nop #0x1");
_dsp_asm("PCU.callr {ds1} #_initDataSections");
_dsp_asm("nop #0x1");
_dsp_asm("__not_needed:");
//_dsp_asm("SC0.mov #0xFFAAFFAA, r5.ui");
//_dsp_asm("SC0.mov #0x60023dbc, r6.ui");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("LS1.st r5.ui, (r6.ui).ds+#0 ,?pr15.b");
/*
 * initializations must come after globals have been copied from
 * program memory to data memory.
 */
_dsp_asm("PCU.callr {ds1} #_initFuncVect");
_dsp_asm("nop #0x1");

_dsp_asm("PCU.callr {ds1} #_crt0HookPreMain");
_dsp_asm("nop #0x1");

#ifndef NO_ARGV_SECT

/* preparing the arguments for main:
 * - [##ARG_SECT.0] holds argc.
 * - ##ARG_SECT.1 holds argv.
 */
_dsp_asm("LS0.ld (#ARG_SECT.0).ui, r0.i");
_dsp_asm("SC0.mov #ARG_SECT.4, r1.i");

#endif
//_dsp_asm("SC0.mov #0x10101010, r5.ui");
//_dsp_asm("SC0.mov #__trace_start, r6.ui");
//_dsp_asm("nop");
//_dsp_asm("nop");
//_dsp_asm("LS1.st r5.ui, (r6.ui).ds+#0 ,?pr15.b");

_dsp_asm("PCU.callr #_main");
_dsp_asm("LS1.st r0.i, (#_errno).i");
_dsp_asm("PCU.callr #_destruct_globals");
_dsp_asm("LS0.ld (#_errno).ui, r0.i");
//_dsp_asm("PCU.brr {ds1} #_exit, #0x0, #0x0");
_dsp_asm("nop #0x1");

_dsp_asm(".func_end 2 _start");
