/*************************************************************************************
*                                                                                     *
* Copyright (C) CEVA(R) Inc. All rights reserved                                      *
*                                                                                     *
*                                                                                     *
* This product or Software is made available exclusively to licensees that have       *
* received express written authorization from CEVA to download or receive the product *
* or Software and have agreed to the End User License Agreement (EULA).  If you have  *
* not received such express authorization and agreed to the CEVA EULA, you may not    *
* download, install or use this product or Software.                                  *
*                                                                                     *
* The information contained in this document is subject to change without notice and  *
* does not represent a commitment on any part of CEVA(R), Inc. CEVA(R), Inc. and its  *
* subsidiaries make no warranty of any kind with regard to this material, including,  *
* but not limited to implied warranties of merchantability and fitness for a          *
* particular purpose whether arising out of law, custom, conduct or otherwise.        *
*                                                                                     *
* While the information contained herein is assumed to be accurate, CEVA(R), Inc.     *
* assumes no responsibility for any errors or omissions contained herein, and         *
* assumes no liability for special, direct, indirect or consequential damage,         *
* losses, costs, charges, claims, demands, fees or expenses, of any nature or kind,   *
* which are incurred in connection with the furnishing, performance or use of this    *
* material.                                                                           *
*                                                                                     *
* This document contains proprietary information, which is protected by U.S. and      *
* international copyright laws. All rights reserved. No part of this document may be  *
* reproduced, photocopied, or translated into another language without the prior      *
* written consent of CEVA(R), Inc.                                                    *
*                                                                                     *
*************************************************************************************/

#include <asm-dsp.h>

extern void initConfigRegs ();
extern void initDataSections ();
extern void crt0HookPreMain ();
extern int main(int, char **);
extern void exit();
extern void initConfigRegs();
extern void initDataSections();
extern void crt0HookPreMain();
extern void initFileIo();

extern void bpi_handler(void) __attribute__((interrupt_retb));
extern void trap_handler(void) __attribute__((interrupt_retb));
extern void nmi_handler(void) __attribute__((interrupt));
extern void int0_handler(void) __attribute__((interrupt));
extern void int1_handler(void) __attribute__((interrupt));
extern void int2_handler(void) __attribute__((interrupt));
extern void int3_handler(void) __attribute__((interrupt));
#if defined (TL410) || defined (TL420)
extern void trap0_handler(void) __attribute__((interrupt));
extern void trap1_handler(void) __attribute__((interrupt));
extern void trap2_handler(void) __attribute__((interrupt));
extern void trap3_handler(void) __attribute__((interrupt));
#endif

/*
 * crt0.c:
 * Composed of three parts:
 *
 * 1. The interrupt handlers table.
 * 2. Data sections for stack, heap, stdin/stdout and virtual registers
 * 3. The start() routine which calls main() and then exit(),
 */

#ifdef BIG_ENDIAN
void big_endian_argv (int argc, char *argv[])
{
  int i;

  for (i = 0; i < argc; i++)
  {
    char h, l;
    char *p = (char *)&argv[i];

    l = *p;
    h = *(p + 1);

    *p = h;
    *(p + 1) = l;
  }
}
#endif

/*
 * The interrupt handlers table.
 */
_dsp_asm(".CSECT inttbl");

/* Reset jumps to start(). */

_dsp_asm("br _start, true");

/* TRAP/BI jumps to trap handler  */

_dsp_asm("br _trap_handler, true");

/* NMI jumps to nmi_handler */

_dsp_asm("br _nmi_handler, true");

/* INT0 jumps to int0_handler */
#ifdef CRU_PUSHPOP_CRPC
_dsp_asm("pushdw crpc");
#endif
_dsp_asm("br _int0_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifndef CRU_PUSHPOP_CRPC
_dsp_asm("nop");
_dsp_asm("nop");
#endif

/* INT1 jumps to int1_handler */

#ifdef CRU_PUSHPOP_CRPC
_dsp_asm("pushdw crpc");
#endif
_dsp_asm("br _int1_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifndef CRU_PUSHPOP_CRPC
_dsp_asm("nop");
_dsp_asm("nop");
#endif

/* INT2 jumps to int2_handler */

#ifdef CRU_PUSHPOP_CRPC
_dsp_asm("pushdw crpc");
#endif
_dsp_asm("br _int2_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifndef CRU_PUSHPOP_CRPC
_dsp_asm("nop");
_dsp_asm("nop");
#endif

/* INT3 jumps to int3_handler */

#ifdef CRU_PUSHPOP_CRPC
_dsp_asm("pushdw crpc");
#endif
_dsp_asm("br _int3_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifndef CRU_PUSHPOP_CRPC
_dsp_asm("nop");
_dsp_asm("nop");
#endif

#if defined (TL410) || defined (TL420)
/* software interrupts: */

_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");

/* TRAP0 jumps to trap0_handler */
_dsp_asm("br _trap0_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");

/* TRAP1 jumps to trap1_handler */
_dsp_asm("br _trap1_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");

/* TRAP2 jumps to trap2_handler */
_dsp_asm("br _trap2_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");

/* TRAP3 jumps to trap3_handler */
_dsp_asm("br _trap3_handler, true");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");

#endif

/* The malloc segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MALLOC_SECT");

/* The stack segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __STACK_SECT");

/* The mailbox segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MAILBOX_SECT");

/* The mmio segment can be mapped to anywhere within memory. */
_dsp_asm(".DSECT __MMIO_SECT");




volatile char _outport __attribute__((section(".DSECT __OUTPORT_SECT")));

volatile char _inport  __attribute__((section(".DSECT __INPORT_SECT")));

/* The 80 virtual registers are allocated a separate section, that are
   followed by the small memory model global variables. When using the
   small memory model, up to 256-80=176 global scalars can be used. If
   more are used, the linker will issue an error message. If more globals
   are needed in the small memory model, it is possible to reduce the
   number of virtual registers. For example, if 216 global scalars are
   needed, decrease the number 80 in the following line to 40 and instruct
   the compiler not to use these by compiling with the -mfix-zp-40-79 flag */

char _page_regs[80]   __attribute__((section(".DSECT __PAGE_REGS_SECT")));


_dsp_asm(".GLOBAL ___crt0_const_data_start__");
_dsp_asm(".DSECT const_data");
_dsp_asm("___crt0_const_data_start__:");

_dsp_asm(".GLOBAL ___crt0_data_start__");
_dsp_asm(".ndata");
_dsp_asm("___crt0_data_start__:");
/* This is a dummy to make sure ___crt0_data_start__ points at the beggining
   of .data section */
_dsp_asm("DW 2");

_dsp_asm(".GLOBAL ___crt0_bss_start__");
_dsp_asm(".bss");
_dsp_asm("___crt0_bss_start__:");

/*
 * The start() routine.
 *
 * start() calls main() and then exit(),
 */

_dsp_asm(".CSECT ctor_sect");
_dsp_asm(".CSECT dtor_sect");
_dsp_asm(".CSECT call_saved_store_restore_sect");
_dsp_asm(".text");
_dsp_asm(".GLOBAL _errno");
_dsp_asm(".GLOBAL _crt0HookPostStart");
_dsp_asm(".GLOBAL __crt0HookPostStartRetLabel__");

/* RW: add global to remove warning */
_dsp_asm(".GLOBAL _trap_handler");
_dsp_asm(".GLOBAL _nmi_handler");
_dsp_asm(".GLOBAL _int0_handler");
_dsp_asm(".GLOBAL _int1_handler");
_dsp_asm(".GLOBAL _int2_handler");
_dsp_asm(".GLOBAL _int3_handler");
_dsp_asm(".GLOBAL _trap0_handler");
_dsp_asm(".GLOBAL _trap1_handler");
_dsp_asm(".GLOBAL _trap2_handler");
_dsp_asm(".GLOBAL _trap3_handler");
_dsp_asm(".GLOBAL _initConfigRegs");
_dsp_asm(".GLOBAL _initDataSections");
_dsp_asm(".GLOBAL _crt0HookPreMain");
_dsp_asm(".GLOBAL _main");

_dsp_asm(".CSECT inttbl$crt0_start0");
_dsp_asm(".func_start 2 _start");
_dsp_asm("_start:");
_dsp_asm(".CSECT inttbl$crt0_start1");
_dsp_asm("brf{t} _start_text");
_dsp_asm(".func_end 2 _start");

_dsp_asm(".text");
_dsp_asm(".func_start 2 _start_text");
_dsp_asm("_start_text:");

/* reset tlb/tkb bits */
#if !(defined TEAKLITE4_VOICE || defined TEAKLITE4_AUDIO)
_dsp_asm("lbf 0, tlb");
_dsp_asm("nop");
_dsp_asm("lbf 0, tkb");
#endif
_dsp_asm("nop");
/* set big-endianess bit */
#if defined TL421 || defined TL420
_dsp_asm("mov 0x30c, r5");
_dsp_asm("in{cpm} (r5).dw, r4");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifdef BIG_ENDIAN
_dsp_asm("ors r4, 0x1, r4");
#else /* BIG_ENDIAN */
_dsp_asm("ands r4, 0xfffffffe, r4");
#endif /* BIG_ENDIAN */
#else /* TL421 || TL420 */
_dsp_asm("mov 0x300, r5");
_dsp_asm("in{cpm} (r5).dw, r4");
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("nop");
#ifdef BIG_ENDIAN
_dsp_asm("ors r4, 0x10000, r4");
#else /* BIG_ENDIAN */
_dsp_asm("ands r4, 0xfffeffff, r4");
#endif /* BIG_ENDIAN */
#endif /* TL421 || TL420 */
_dsp_asm("nop");
_dsp_asm("nop");
_dsp_asm("out{cpm} r4, (r5).dw");

_dsp_asm("brf _crt0HookPostStart");
_dsp_asm("__crt0HookPostStartRetLabel__:");

_dsp_asm("mov __STACK_SECT.0, r0");
_dsp_asm("adds r0, SIZEOF(__STACK_SECT)-2, r0");
_dsp_asm("mov r0, sp");

/* start_clock () */
_dsp_asm("mov    1044, r1");
_dsp_asm("in{cpm}    (r1).dw, r0");
_dsp_asm("nop 2");
_dsp_asm("andnots    r0, 1, r0");
_dsp_asm("nop 1");
_dsp_asm("out{cpm}    r0, (r1).dw");

/* init all configuration registers. */
_dsp_asm("callf _initConfigRegs");
_dsp_asm("callf _initDataSections");

_dsp_asm("__not_needed:");

/*
 * initializations must come after globals have been copied from
 * program memory to data memory.
 */
/* RW: We don't need file IO */
/* _dsp_asm("callf _initFileIo"); */
_dsp_asm("callf ctor_sect.0");
_dsp_asm("callf _crt0HookPreMain");
/* RW: We don't need to pass argument to firmware */
#define NO_ARGV_SECT
#ifndef NO_ARGV_SECT
/*
 * preparing the arguments for main:
 * - [ARG_SECT.0] holds argc.
 * - ARG_SECT.1 holds argv.
 */
#ifdef BIG_ENDIAN
/*
 * adjust the values in argv[] for big endian
 * (the program arguments are set before the beb)
 */
_dsp_asm("ld [ARG_SECT.0],a0");
_dsp_asm("mov ARG_SECT.1,a1");
_dsp_asm("callf _big_endian_argv");
#endif
_dsp_asm("ld [ARG_SECT.0],a0");
_dsp_asm("mov ARG_SECT.1,a1");
#endif
_dsp_asm("callf _main");
_dsp_asm("st a0l,[_errno]");
_dsp_asm("callf dtor_sect.0");
_dsp_asm("ld [_errno],a0");
/* RW: remove call to exit as it pull some unsed code and we never reach here */
//_dsp_asm("brf  _exit");
_dsp_asm(".func_end 2 _start_text");
