/**
 ****************************************************************************************
 *
 * @file button.c
 *
 * @brief Push button driver
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup BUTTON
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "button.h"
#include "intc.h"
#include "rwnx_config.h"
#include <stddef.h>

#if (NX_PLF_VER >= 30)
#include "reg_karst_if.h"
#endif //(NX_PLF_VER >= 30)

/*
 * GLOBAL VARIABLES
 ****************************************************************************************
 */
/// Button callback type
struct button_cb_tag
{
    /// Pointer to button callback
    button_cb cb;
    /// Pointer to button callback args
    void *env;
};

/// Button callback
struct button_cb_tag button_cb_env;

/*
 * FUNCTION DEFINITIONS
 ****************************************************************************************
 */
void button_register(button_cb cb, void* env)
{
    button_cb_env.cb = cb;
    button_cb_env.env = env;
}

void button_unregister()
{
    button_cb_env.cb = NULL;
    button_cb_env.env = NULL;
}

void button_enable()
{
    #if (NX_PLF_VER >= 30)
    karst_doorbell_int_clear_setf(1);
    karst_doorbell_int_mask_setf(1);
    #endif //(NX_PLF_VER >= 30)
}

void button_disable()
{
    #if (NX_PLF_VER >= 30)
    karst_doorbell_int_mask_setf(0);
    #endif //(NX_PLF_VER >= 30)
}

void button_isr()
{
    if (button_cb_env.cb)
        button_cb_env.cb(button_cb_env.env);
}

void button_init()
{
    button_unregister();
    button_disable();
}

/// @} BUTTON
