/**
 ****************************************************************************************
 *
 * @file button.h
 *
 * @brief Push button driver APIs
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

#ifndef _BUTTON_H_
#define _BUTTON_H_

/**
 ****************************************************************************************
 * @defgroup BUTTON BUTTON
 * @ingroup EXTINT
 * @brief Driver for physical button connected to the reference platform used for demo
 * purposes. The push button triggers the EXTINT interrupt (bit doorbell)
 * @{
 ****************************************************************************************
 */

/// Prototype definitoin for button driver callback
typedef void (*button_cb)(void*);

/*
 * FUNCTION DECLARATIONS
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @brief Register callback for push button
 *
 * @param[in] cb   Pointer to callback function
 * @param[in] env  Pointer to callback function arguments
 ****************************************************************************************
 */
void button_register(button_cb cb, void* env);

/**
 ****************************************************************************************
 * @brief Unregister push button callback
 ****************************************************************************************
 */
void button_unregister();

/**
 ****************************************************************************************
 * @brief Enable push button interrupt
 ****************************************************************************************
 */
void button_enable();

/**
 ****************************************************************************************
 * @brief Disable push button interrupt
 ****************************************************************************************
 */
void button_disable();

/**
 ****************************************************************************************
 * @brief Push button interrupt service routine
 ****************************************************************************************
 */
void button_isr();

/**
 ****************************************************************************************
 * @brief Push button initialization
 ****************************************************************************************
 */
void button_init();

/// @} BUTTON

#endif // _BUTTON_
