/**
 ****************************************************************************************
 *
 * @file crm.c
 *
 * @brief Clock and Reset Module definitions.
 *
 * Copyright (C) RivieraWaves 2018-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup CRM
 * @{
 ****************************************************************************************
 */
/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "crm.h"
#include "rwnx_config.h"
#include "reg_mac_core.h"

#ifdef CFG_VIRTEX7
#error "No support of this CRM version on Virtex7 board"
#endif

#if NX_MDM_VER >= 20
#error "This version of CRM is valid for old versions of the modem only (v1x)"
#endif

void crm_init(void)
{
    // No clocks to initialize in first version of the CRM
}

uint8_t crm_get_mac_freq(void)
{
    return (nxmac_mac_core_clk_freq_getf());
}

uint32_t crm_get_cpu_freq(void)
{
    return 105000000;
}

/// @}

