/**
 ****************************************************************************************
 *
 * @file extint.c
 *
 * @brief Driver for interrupts from interrupt set
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

#include "trace.h"
#include "button.h"
#include "extint.h"

#if (NX_PLF_VER >= 30)
#include "reg_karst_if.h"
#endif //(NX_PLF_VER >= 30)

/**
 ****************************************************************************************
 * @addtogroup EXTINT
 * @{
 ****************************************************************************************
 */

void extint_gen_handler(void)
{
    #if (NX_PLF_VER >= 30)
    uint32_t genirq_pending = karst_interrupt_status_get();

    // clear all the interrupts
    karst_interrupt_clear_set(genirq_pending);

    if (genirq_pending & KARST_DOORBELL_INT_SET_BIT)
    {
        button_isr();
    }
    #endif //(NX_PLF_VER >= 30)
}

/// @} EXTINT
