/**
 ****************************************************************************************
 *
 * @file ipc_shared.c
 *
 * @brief Definition of the shared data between both IPC modules.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "rwnx_config.h"
#include "dbg_assert.h"
#include "ipc_shared.h"
#include "compiler.h"

/// Definition of the IPC shared environment and MIB.
#if NX_EMB
// In case of embedded, a specific region is defined in linker script
struct ipc_shared_env_tag ipc_shared_env __SHAREDRAMIPC;

#else
// In case of host, the objects will probably be relocated, and the only
// way to declare them absolute is by defining them in the linker script.
// However, to declare them at the right address, we pass their size
// to the linker with the following trick:
struct ipc_shared_env_tag fake_ipc_shared_env __attribute__ ((section("fake_env")));

#endif

