/**
 ****************************************************************************************
 *
 * @file la.h
 *
 * @brief Embedded logic analyser context.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

#ifndef _LA_H_
#define _LA_H_

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "co_int.h"
#include "co_bool.h"


// forward declarations
struct dbg_debug_dump_tag;

/**
 *****************************************************************************************
 * @defgroup LA LA
 * @ingroup PLATFORM_DRIVERS
 * @brief Embedded Logic Analyzer module.
 * @{
 *****************************************************************************************
 */

/// Length of the configuration data of a logic analyzer
#define LA_CONF_LEN          10

/// Structure containing the configuration data of a logic analyzer
struct la_conf_tag
{
    /// LA configuration parameters
    uint32_t conf[LA_CONF_LEN];
    /// LA trace length
    uint32_t trace_len;
    /// Platform diag mux configuration
    uint32_t diag_conf;
};

/**
 ****************************************************************************************
 * @brief Initialize the embedded logic analyzer.
 * This function also starts the embedded LA.
 *
 ****************************************************************************************
 */
void la_init(void);

/**
 ****************************************************************************************
 * @brief Start the embedded logic analyzer.
 *
 ****************************************************************************************
 */
void la_start(void);

/**
 ****************************************************************************************
 * @brief Stop the embedded logic analyzer.
 *
 ****************************************************************************************
 */
void la_stop(void);

/**
 ****************************************************************************************
 * @brief Dump all the debug information and trace
 *
 * @param[in] dbg_dump   Pointer to host memory structure where to upload the trace
 *
 ****************************************************************************************
 */
void la_dump_trace(struct dbg_debug_dump_tag *dbg_dump);

/**
 ****************************************************************************************
 * @brief Write the current configuration of the logic analyzer to the structure passed
 * as parameter
 *
 * @param[out] conf   Pointer to LA configuration structure where to write
 *
 ****************************************************************************************
 */
void la_get_conf(struct la_conf_tag *conf);

/// @} LA

#endif // _LA_H_
