/**
 ****************************************************************************************
 *
 * @file la_mem.h
 *
 * @brief Logic analyzer memory.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

#ifndef _LA_MEM_H_
#define _LA_MEM_H_

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "co_int.h"

/*
 * DEFINES
 ****************************************************************************************
 */
/// Number of 32-bit words in each LA memory line
#define LA_MEM_WORD_COUNT  4

/// Number of line in the LA memory
#define LA_MEM_LINE_COUNT (64 * 1024)


/*
 * STRUCTS
 ****************************************************************************************
 */
/// Structure describing the format of a line of LA memory
struct la_mem_format
{
    /// Line of embedded LA memory
    uint32_t word[LA_MEM_WORD_COUNT];
};

/// Embedded LA RAM for MAC
extern struct la_mem_format la_mem_mac[LA_MEM_LINE_COUNT];

#endif // _LA_SHARED_H_

