/**
 ****************************************************************************************
 *
 * @file la_shared.h
 *
 * @brief Shared data of the LA driver.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

#ifndef _LA_SHARED_H_
#define _LA_SHARED_H_

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "dma.h"
#include "la_mem.h"

/*
 * DEFINES
 ****************************************************************************************
 */
/// Number of LA memory lines dumped in one DMA transfer
#define LA_SHARED_LINE_COUNT        32

/*
 * TYPE and STRUCT DEFINITIONS
 ****************************************************************************************
 */
/// Structure describing the information that the LA needs to store in shared RAM
struct la_shared_env_tag
{
    /// DMA descriptor for LA trace dump
    volatile struct dma_desc dma_desc;
    /// Chunk of LA memory to be uploaded
    struct la_mem_format la_buf[LA_SHARED_LINE_COUNT];
};

/// LA variable stored in shared RAM
extern struct la_shared_env_tag la_shared_env;

#endif // _LA_SHARED_H_

